<?php
/**
* userdel.php 処理概要：ユーザ削除
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"     => $o_resource->getValue("G04020L001"),
    "listTitle01"  => $o_resource->getValue("G04020L002"),
    "listTitle02"  => $o_resource->getValue("G04020L003"),
    "listTitle03"  => $o_resource->getValue("G04020L004"),
    "listTitle04"  => $o_resource->getValue("G04020L005"),
    "listTitle05"  => $o_resource->getValue("G04020L006"),
    "listTitle06"  => $o_resource->getValue("G04020L007"),
    "listTitle07"  => $o_resource->getValue("G04020L008"),
    "stsKnd00"     => $o_resource->getValue("G04020L009"),
    "stsKnd01"     => $o_resource->getValue("G04020L010"),
    "stsKnd02"     => $o_resource->getValue("G04020L011"),
    "delBtn"       => $o_resource->getValue("G04020L012"),
    "clsBtn"       => $o_resource->getValue("G04020L013")
);

// SESSION内容取得
$session_layerid   = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'])  ?$_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']  :$_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'];
$session_layername = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layername'])?$_SESSION[DIRECTORY_NAME.'_mntlayer']['layername']:$_SESSION[DIRECTORY_NAME.'_newlayer']['layername'];

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userdel", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "h_userid"      => $_POST['h_userid'],
    "s_layerid"     => $session_layerid,
    "s_layername"   => $session_layername,
    "s_userid"      => $_POST['h_userid'],
    "s_username"    => $_POST['h_username'],
    "s_mailaddress" => $_POST['h_mailaddress'],
    "s_adddatetime" => $_POST['h_adddatetime'],
    "s_statusflg"   => $_POST['h_statusflg']==KAKIKOMAP_STATUSFLG_ON?$label['stsKnd00']:
                       ($_POST['h_statusflg']==KAKIKOMAP_STATUSFLG_OFF?$label['stsKnd01']:$label['stsKnd02'])
));

$pageFlg = 0;

if (isset($_POST[run])) {
    if ($o_form->validate()) {
        if (deleteRecode($o_service) == true) {
            $pageFlg = 1;
        } else {
			exit();
        }
    }
}

if ($pageFlg == 0) {
    // 削除確認画面
    $o_form->addElement("header", "header",        $label['topTitle']);
    $o_form->addElement("hidden", "h_userid",      $label['listTitle03']);
    $o_form->addElement("static", "s_layerid",     $label['listTitle01']);
    $o_form->addElement("static", "s_layername",   $label['listTitle02']);
    $o_form->addElement("static", "s_userid",      $label['listTitle03']);
    $o_form->addElement("static", "s_username",    $label['listTitle04']);
    $o_form->addElement("static", "s_mailaddress", $label['listTitle05']);
    $o_form->addElement("static", "s_adddatetime", $label['listTitle06']);
    $o_form->addElement("static", "s_statusflg",   $label['listTitle07']);
    $o_form->addElement("submit", "run",           $label['delBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("button", "close",         $label['clsBtn'], array("onclick"=>"close_window();", "class"=>"fs12_black"));
    $tplName = DIRECTORY_NAME."/userdel.tpl";
} else {
    $tplName = "windowclose.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04020M001"));
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤーユーザ削除
* 処理詳細：レイヤーユーザテーブルより情報を削除する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function deleteRecode($o_service) {

    // SESSION内容格納
    $session_layerid = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']) 
		    					? $_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'] 
		    						: $_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'];

	// レイヤーユーザ削除処理
	$rtn = $o_service->deleteLayerUserByKey($_POST['h_userid'], $session_layerid);

    return $rtn;
}

?>
