<?php
/**
* userlist.php 処理概要：ユーザ一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/db/tabledata/LayerUserData.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

require_once("class/mail/KakikoMail.class.php");                   // メール送信クラス

// SESSIONへ情報セット
if (isset($_POST['h_layerid'])) {
    $_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'] = $_POST['h_layerid'];
    $_SESSION[DIRECTORY_NAME.'_mntlayer']['layername'] = $_POST['h_layername'];
}

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}
// POST値をURLデコード
if (isset($_POST['serchUser'])) {
    $_POST['serchUser'] = urldecode($_POST['serchUser']);
}


// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"    => $o_resource->getValue("G04017L001"),
    "topTitle2"   => $o_resource->getValue("G04017L002"),
    "colTitleA01" => $o_resource->getValue("G04017L003"),
    "colTitleB01" => $o_resource->getValue("G04017L004"),
    "colTitleB02" => $o_resource->getValue("G04017L005"),
    "colTitleB03" => $o_resource->getValue("G04017L006"),
    "colTitleB04" => $o_resource->getValue("G04017L007"),
    "colTitleB05" => $o_resource->getValue("G04017L008"),
    "colTitleC01" => $o_resource->getValue("G04017L009"),
    "colTitleC02" => $o_resource->getValue("G04017L010"),
    "colTitleC03" => $o_resource->getValue("G04017L011"),
    "colTitleC04" => $o_resource->getValue("G04017L012"),
    "stsKnd00"    => $o_resource->getValue("G04017L013"),
    "stsKnd01"    => $o_resource->getValue("G04017L014"),
    "listTitle1"  => $o_resource->getValue("G04017L015"),
    "listTitle2"  => $o_resource->getValue("G04017L016"),
    "sthBtn"      => $o_resource->getValue("G04017L017"),
    "newBtn"      => $o_resource->getValue("G04017L018"),
    "delBtn"      => $o_resource->getValue("G04017L019"),
    "athBtn"      => $o_resource->getValue("G04017L020"),
    "layerList"   => $o_resource->getValue("G04017L021"),
    "setupEnd"    => $o_resource->getValue("G04017L022")
);

// 日付クラス
$o_date = new Date();

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// 状態の変更
if (isset($_POST['chgBtn'])) {
    $rtn = changeStatus($o_service, 
    			$_POST['h_sts'] == KAKIKOMAP_STATUSFLG_ON
    				? KAKIKOMAP_STATUSFLG_OFF 
    						: KAKIKOMAP_STATUSFLG_ON);
    if ($rtn != true) {
    	exit();
    }
}
if (isset($_POST['athBtn'])) {
    $rtn = changeStatus($o_service, KAKIKOMAP_STATUSFLG_ON);
    if ($rtn != true) {
    	exit();
    }
	sendMail($o_resource);
}

// 抽出条件有無
if (isset($_POST['serchUser'])) {
    $serchUser = $_POST['serchUser'];
} else {
    $serchUser = "";
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userlist", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "serchUser"=>$serchUser
));

// 項目セット
$o_form->addElement("header", "header",    $label['topTitle']."(".$label['topTitle2'].$_SESSION[DIRECTORY_NAME.'_mntlayer']['layername'].")");
$o_form->addElement("text",   "serchUser", $label['colTitleA01'], array("size"=>30, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("submit", "search",    $label['sthBtn'],       array("class"=>"fs12_black"));

$errorMessage = "";

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // このページはチェックがありません
    }
}

// POSTで渡って来た内容を破棄
$_myPOST = $_POST;
unset($_POST['h_userid'],
      $_POST['h_sts'], 
      $_POST['h_page1'], 
      $_POST['h_page2'], 
      $_POST['chgBtn'],
      $_POST['athBtn'],
      $_POST['h_layerid'],
      $_POST['h_layername'],
      $_POST['btn_user']
      );

//-----------------------------//
//* 認証済みリストのPeger処理 *//
//-----------------------------//

if (isset($_myPOST['h_page1'])) {
    $nowpage1 = $_myPOST['h_page1'];
    $nowpage1 = $nowpage1==0?1:$nowpage1;
    $chgsts1 = TRUE;
} else {
    $nowpage1 = 1;
    $chgsts1 = FALSE;
}

// ユーザ一覧データ取得(認証済み)
$data_array = getUserListData($o_service, 0, $serchUser);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum1 = count($data_array);
$params1 = array(
    "perPage"=>USERLIST1_ROW,
    "urlVar"=>"list1",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum1,
    "prevImg"=>$o_resource->getValue("G04017L023"),
    "nextImg"=>$o_resource->getValue("G04017L024"),
    "httpMethod"=>"POST"
);

$o_page1 = Pager::factory($params1);
if ($nowpage1 > $o_page1->numPages()){
    $nowpage1 = $o_page1->numPages();
}
if ($chgsts1) {
    $navi1 = $o_page1->getlinks($nowpage1);
} else {
    $navi1 = $o_page1->getlinks();
    $nowpage1 = $o_page1->getCurrentPageID();
}
$listData1 = getListData($data_array, $o_date, ($nowpage1 - 1) * USERLIST1_ROW, USERLIST1_ROW, $rowNum1);

//-----------------------------//
//* 許可待ちリストのPeger処理 *//
//-----------------------------//

if (isset($_myPOST['h_page2'])) {
    $nowpage2 = $_myPOST['h_page2'];
    $nowpage2 = $nowpage2==0?1:$nowpage2;
    $chgsts2 = TRUE;            // ステータスを変更するボタンが押された
} else {
    $nowpage2 = 1;
    $chgsts2 = FALSE;
}

// ユーザ一覧データ取得(許可待ち)
$data_array = getUserListData($o_service, 1, $serchUser);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum2 = count($data_array);
$params2 = array(
    "perPage"=>USERLIST2_ROW,
    "urlVar"=>"list2",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum2,
    "prevImg"=>$o_resource->getValue("G04017L025"),
    "nextImg"=>$o_resource->getValue("G04017L026"),
    "httpMethod"=>"POST"
);

$o_page2 = Pager::factory($params2);
if ($nowpage2 > $o_page2->numPages()){
    $nowpage2 = $o_page2->numPages();
}
if ($chgsts2) {
    $navi2 = $o_page2->getlinks($nowpage2);
} else {
    $navi2 = $o_page2->getlinks();
    $nowpage2 = $o_page2->getCurrentPageID();
}
$listData2 = getListData($data_array, $o_date, ($nowpage2 - 1) * USERLIST2_ROW, USERLIST2_ROW, $rowNum2);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("listDatas1",   $listData1);
$o_smarty->assign("listDatas2",   $listData2);
$o_smarty->assign("labels",       $label);
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04017M001"));
$o_smarty->assign("pager1",       $navi1["all"]);
$o_smarty->assign("pager2",       $navi2["all"]);
$o_smarty->assign("nowpage1",     $nowpage1);
$o_smarty->assign("nowpage2",     $nowpage2);
$o_smarty->assign("serchUser",    $serchUser);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display(DIRECTORY_NAME."/userlist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：ユーザ一覧表示情報取得
* 処理詳細：レイヤーユーザ管理テーブルより情報を取得するクエリーをセット
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) knd			- integer 取得区分(0:認証済み,1:許可待ち)
*      ： (I) searchUser	- string  抽出条件(ユーザ名称)
* @戻値： array ユーザデータオブジェクト型配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getUserListData($o_service, $knd, $searchUser = "") {

	$data = $o_service->getUserDataList($_SESSION[DIRECTORY_NAME.'_userid'], 
				$_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'], $knd, $searchUser);

	return $data;
}

/**
* 関数概要：ユーザ一覧表示情報取得
* 処理詳細：一覧表示用データの抽出処理
*
* @引数： (I) data		- object  データオブジェクト型配列
*         (I) o_date - object  日付クラス
*         (I) start  - integer 開始抽出データ
*         (I) cnt    - integer 抽出データ数
*         (I) rowNum - integer データ件数
* @戻値： array 一覧情報(連想配列)
* @戻値： 一覧情報配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListData($data, $o_date, $start, $cnt, $rowNum) {

	$ret_array = array();

	if (count($data) <> 0) {

		for ($i = $start; $i < $start + $cnt; $i++) {
    
			if ($i == $rowNum) break;

			if (is_null($data[$i]))	break;

			$o_date->setDate($data[$i]->getAddDateTime());

			$recode_array = array(
				"userid"=>$data[$i]->getUserID(),
				"username"=>$data[$i]->getUserName(),
				"mailaddress"=>$data[$i]->getMailAddress(),
				"adddatetime"=>$o_date->format("%Y/%m/%d"),
				"statusflg"=>$data[$i]->getStatusFlg()
			);
			$ret_array[] = $recode_array;
		}
	}
	return $ret_array;
}

/**
* 関数概要：レイヤーユーザ管理テーブル状態更新
* 処理詳細：レイヤーユーザ管理テーブルの状態フラグを変更する
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) status		- integer 更新する値
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function changeStatus($o_service, $status) {

	// マップ配下のレイヤーユーザ管理テーブルデータの更新

	// 条件及びNULL等のターゲット設定
	$targetLayerUserDataObj = new LayerUserData();

	// 条件
	$targetLayerUserDataObj->setUserID(WHERE_KEY);
	$targetLayerUserDataObj->setLayerID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetLayerUserDataObj->setStatusFlg(VAL_TARGET);

	// 更新項目設定
	$valLayerUserDataObj = new LayerUserData();

	// ユーザID(キー)
	$valLayerUserDataObj->setUserID($_POST['h_userid']);
	// レイヤーID(キー)
	$valLayerUserDataObj->setLayerID($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']);
	// 状態フラグ
	$valLayerUserDataObj->setStatusFlg($status);

	// レイヤーユーザデータ更新処理
	$rtn = $o_service->updateLayerUserDataByKey($targetLayerUserDataObj, $valLayerUserDataObj);

    return $rtn;
}

/**
* 関数概要：メール送信処理
* 処理詳細：ユーザ登録者に対して許可通知メールを送信する
*
* @引数： (I) o_resource   - object リソースクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function sendMail($o_resource) {

    // -----------------------
    // メール送信用設定
    // -----------------------
    // メール種類
    $mode        = "smtp";
    // 送信先アドレス
    $toAddress   = ereg_replace("\n|\r", "", $_POST['h_mailaddress']);
    // 送信先名称
    $toName      = (($_POST['h_username']=="--")?$_POST['h_userid']:$_POST['h_username']).$o_resource->getValue("G04017M003");
    // 送信元アドレス
    $fromAddress = ereg_replace("\n|\r", "", $_SESSION['_auth'.DIRECTORY_NAME.'usersession']['data']['mailaddress']);
    // 送信元名称
    $fromName    = $o_resource->getValue("G04017M004");
    // 件名
    $subject     = $o_resource->getValue("G04017M005");
    // 本文
    $message     = (($_POST['h_username']=="--")?$_POST['h_userid']:$_POST['h_username']).$o_resource->getValue("G04017M006")."\n"
                  ."\n"
                  .$o_resource->getValue("G04017M007")."\n"
                  ."\n"
                  .$o_resource->getValue("G04017M008").$_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']."\n"
                  .$o_resource->getValue("G04017M009").$_SESSION[DIRECTORY_NAME.'_mntlayer']['layername']."\n"
                  .$o_resource->getValue("G04017M010").$_POST['h_adddatetime']."\n"
                  ."\n"
                  ."\n"
                  .$o_resource->getValue("G04017M011")."\n";

    
    // メール送信処理
    $o_email = new KakikoMail();
    $mailitems = array(
                        "ToAddress"   => $toAddress,    //送信先アドレス
                        "ToName"      => $toName,       //送信先名称
                        "FromAddress" => $fromAddress,  //送信元アドレス
                        "FromName"    => $fromName,     //送信元名称
                        "ReplyTo"     => $fromAddress,  //返信先アドレス
                        "Subject"     => $subject,      //件名
                        "Message"     => $message,      //本文
                       );
    $o_email->createMail($mailitems);
    $ret = $o_email->sendEmail($mode);
    if (PEAR::isError($ret)){
        trigger_error($ret->getMessage()."\n".$o_resource->getValue("G04017M002"), E_USER_ERROR);
        return false;
    }

    return true;

}

?>
