<?php
/**
* layerindicateseqset.php 処理概要：レイヤー表示順設定
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("./DefineDirectryName.php");                           // マップ別定数定義
require_once("function/KakikoContentsCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./layerindicateset.php");
}

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsViewService.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// リソースファイル読込みクラス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// DB接続サービス呼び出し
$o_service = new ContentsViewService(DIRECTORY_NAME);

// ＱｕｉｃｋＦｏｒｍクラス
$o_form = new HTML_QuickForm("layerindicateseqset", "POST", $_SERVER["PHP_SELF"]);

// 選択内容をセッションに格納
if (isset($_POST['rtnBtn']) || isset($_POST['setBtn'])) {
    mainte_session();
}

// 項目セット
$o_form->addElement("header",   "header",     $o_resource->getValue("G04016L001"));
$o_form->addElement("select",   "layerListL", $o_resource->getValue("G04016L002"), $_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'],  array("size"=>"5", "style"=>"width:140px;", "class"=>"fs12_black"));
$o_form->addElement("select",   "layerListR", $o_resource->getValue("G04016L002"), $_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'], array("size"=>"5", "style"=>"width:140px;", "class"=>"fs12_black"));
$o_form->addElement("button",   "LtoR",       $o_resource->getValue("G04016L006"), 
         array("onclick"=>"OptionMove(document.layerindicateseqset.layerListL, document.layerindicateseqset.layerListR)", "style"=>"width:35px;", "class"=>"fs12_black"));
$o_form->addElement("button",   "RtoL",       $o_resource->getValue("G04016L007"), 
         array("onclick"=>"OptionMove(document.layerindicateseqset.layerListR, document.layerindicateseqset.layerListL)", "style"=>"width:35px;", "class"=>"fs12_black"));
$o_form->addElement("submit",   "setBtn",     $o_resource->getValue("G04016L008"), 
         array("onclick"=>"selectOutput(document.layerindicateseqset, document.layerindicateseqset.layerListL, 'listBoxL', document.layerindicateseqset.layerListR, 'listBoxR')", "class"=>"fs12_black"));
$o_form->addElement("submit",    "rstBtn",     $o_resource->getValue("G04016L009"), 
         array("class"=>"fs12_black"));
$o_form->addElement("submit",   "rtnBtn",     $o_resource->getValue("G04016L010"), 
         array("onclick"=>"selectOutput(document.layerindicateseqset, document.layerindicateseqset.layerListL, 'listBoxL', document.layerindicateseqset.layerListR, 'listBoxR')", "class"=>"fs12_black"));

// 意味空間レイヤー表示設定画面遷移パラメータ設定
if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId'])){
	$viewMode = "";
	if(isset($_GET['viewMode'])){
		$viewMode = $_GET['viewMode'];
		$_SESSION['viewMode'] = $_GET['viewMode'];
	}elseif(isset($_SESSION['viewMode'])){
		$viewMode = $_SESSION['viewMode'];
	}
	$o_form->addElement("hidden", "viewMode", $viewMode);
	$o_form->addElement("hidden", "imiSpaceId", $_SESSION[DIRECTORY_NAME.'_imiSpaceId']);
}

$errorMessage = "";

// 戻るボタン
if (isset($_POST['rtnBtn'])) {
    // セッションへ戻る判断用項目をセット
    $_SESSION[DIRECTORY_NAME.'_layerindicateseqset'] = "";
    // 戻る(リダイレクト)
    header("location: ./layerindicateset.php");
    exit(0);
}
// 設定ボタン
if (isset($_POST['setBtn'])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // 全ての項目が設定されていない場合はエラーを表示
        if (count($_SESSION[DIRECTORY_NAME.'_layerindicateseq_right']) != 0) {
            $errorMessage = $o_resource->getValue("G04016M002");
        } else {
            // 更新処理
            if (isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                update_db($o_service);
            } else {
                update_cookie();
            }
            // セッション内容削除
            unset($_SESSION[DIRECTORY_NAME.'_layerindicate']);
            unset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_left']);
            unset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_right']);
            // マップ画面へリダイレクト（意味空間・位置空間のモード切替）
			if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId'])){
				$getString = "?viewMode=".$_SESSION['viewMode']."&imiSpaceId=".$_SESSION[DIRECTORY_NAME.'_imiSpaceId'];
				unset($_SESSION['viewMode']);
		        header("location: ./imiindex.php".$getString);
			}else{
			    header("location: ./index.php");
			}
            exit(0);
        }
    }
}
// リセットボタン
if (isset($_POST['rstBtn'])){
	//自分へリダイレクト
	header("location: ./layerindicateseqset.php");
	exit(0);
}

// ｓｍａｒｔｙクラス
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("dispLbl01",    $o_resource->getValue("G04016L003"));
$o_smarty->assign("dispLbl02",    $o_resource->getValue("G04016L004"));
$o_smarty->assign("dispLbl03",    $o_resource->getValue("G04016L005"));
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04016M001"));
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display(DIRECTORY_NAME."/layerindicateseqset.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤー表示順設定更新処理
* 処理詳細：レイヤー表示順設定の内容をＤＢへ更新
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： bool  : true(正常) false(異常)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function update_db($o_service) {

    $rtn = $o_service->setLayerIndicateOrder($_SESSION[DIRECTORY_NAME.'_userid'], $_POST['listBoxL']);
    if ($rtn != true) {
		exit();
    }
}

/**
* 関数概要：レイヤー表示順設定更新処理
* 処理詳細：レイヤー表示順設定の内容をクッキーへ更新
*
* @引数： なし
* @戻値： なし
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function update_cookie(){

    // クッキーに格納するデータの作成(「,」区切り)
    $cookie_data = "";
    $count = 0;
    foreach ($_POST['listBoxL'] as $key=>$value) {
        $cookie_data .= $value;
        $count++;
        if ($count < count($_POST['listBoxL'])) {
            $cookie_data .= ",";
        }
    }

    // クッキーにセット(有効期限：30日)
    setcookie(LAYERPRIORITY, $cookie_data, Time() + 60 * 60 * 24 * 30);

}

/**
* 関数概要：画面表示データ配列の変更処理
* 処理詳細：画面表示データ配列を入力された内容で書き換える
*
* @引数： なし
* @戻値： なし
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function mainte_session(){

    // 左側リストの内容を更新
    $layerListL = array();
    if (isset($_POST['listBoxL'])) {
        foreach ($_POST['listBoxL'] as $key=>$value) {
            if (isset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'][$value])) {
                $layerName = $_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'][$value];
            } else {
                $layerName = $_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'][$value];
            }
            $layerListL[$value] = $layerName;
        }
    }
    
    // 右側リストの内容を更新
    $layerListR = array();
    if (isset($_POST['listBoxR'])) {
        foreach ($_POST['listBoxR'] as $key=>$value) {
            if (isset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'][$value])) {
                $layerName = $_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'][$value];
            } else {
                $layerName = $_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'][$value];
            }
            $layerListR[$value] = $layerName;
        }
    }

    // セッションへ格納
    $_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'] = array();
    $_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'] = array();
    $_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'] = $layerListL;
    $_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'] = $layerListR;

}

?>
