<?php
/**
* mapcontrol.php 処理概要：メイン左フレーム表示処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 
require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み

require_once("class/db/service/ContentsViewService.class.php");
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み

require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザIDを取得
$s_UserId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memoControlForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 項目セット
$o_form->addElement("header", "header",        $o_resource->getValue("G04002L101"));
$o_form->addElement("header", "newHeader",     $o_resource->getValue("G04002L102"));
$o_form->addElement("text",   "searchNew",     $o_resource->getValue("G04002L103"), array("size"=>"6", "maxlength"=>"6", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("header", "periodHeader",  $o_resource->getValue("G04002L104"));
$o_form->addElement("date",   "searchFromDate", "", array("langage"=>$o_resource->getValue("G04002F101"), "format"=>$o_resource->getValue("G04002F102"), "minYear"=>(date("Y") - 10), "maxYear"=>(date("Y") + 10), "addEmptyOption"=>"true", "emptyOptionValue"=>"", "emptyOptionText"=>""));
$o_form->addElement("date",   "searchToDate",   "", array("langage"=>$o_resource->getValue("G04002F101"), "format"=>$o_resource->getValue("G04002F103"), "minYear"=>(date("Y") - 10), "maxYear"=>(date("Y") + 10), "addEmptyOption"=>"true", "emptyOptionValue"=>"", "emptyOptionText"=>""));
$o_form->addElement("header", "wordHeader",    $o_resource->getValue("G04002L105"));
$o_form->addElement("text",   "searchWord",    $o_resource->getValue("G04002L106"), array("size"=>"16", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("radio",  "outside",       $o_resource->getValue("G04002L107"), "", 0, array("checked"=>"checked","class"=>"fs12_black"));
$o_form->addElement("radio",  "outside",       $o_resource->getValue("G04002L108"), "", 1, array("class"=>"fs12_black"));

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "new"              => "",
    "fromDate"         => "",
    "toDate"           => "",
    "word"             => ""
));

// チェック項目はなし

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// ボタンを表示
if ($pageFlg == 0) {
    // メニュー
    $o_form->addElement("button", "reload", $o_resource->getValue("G04002L109"), array("onclick"=>"submitMemoSearchProcess()","class"=>"fs12_black"));
    $o_form->addElement("button", "find",   $o_resource->getValue("G04002L110"), array("onclick"=>"openMemoListWindow()", "class"=>"fs12_black"));
    $o_form->addElement("link",   "layerIndicateSet",  "", "./layerindicateset.php",$o_resource->getValue("G04002L111"), array("target"=>"_top","class"=>"fs12_black"));
	if($s_UserId != null){
	    $o_form->addElement("link", "layerManagement", "", "./layer/layerlist.php", $o_resource->getValue("G04002L112"), array("target"=>"_top","class"=>"fs12_black"));
	}
	
	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	$labelArray = array(
      "label01"      => $o_resource->getValue("G04002L113"),
      "label02"      => $o_resource->getValue("G04002L114"),
      "label03"      => $o_resource->getValue("G04002L115"),
      "label04"      => $o_resource->getValue("G04002L116"),
      "label05"      => $o_resource->getValue("G04002L117"),
      "label06"      => $o_resource->getValue("G04002L118")
	);
	$o_smarty->assign("labelArray", $labelArray);

	$layerMemoTypeArray = getLayerMemoTypeData($s_UserId);
	$o_smarty->assign("layerMemoTypeArray", $layerMemoTypeArray);
	
	$rssDirectory = getProtocol().$_SERVER["SERVER_NAME"].dirname($_SERVER["PHP_SELF"])."/rss/";
	$o_smarty->assign("rssDirectory", $rssDirectory);
	
}
$o_smarty->display(DIRECTORY_NAME."/mapcontrol.tpl");

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ種類データ取得
* 処理詳細：メモ種類データを取得・整形する
*
* @引数： (I) userid	- string  ユーザID
* @戻値： array メモ種類情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getLayerMemoTypeData($userid) {

	$service = new ContentsViewService(DIRECTORY_NAME);
	
	$recordData = null;
	if($userid == null){
		$recordData = $service->getMapControllDataByGuest(1);
	}else{
		$recordData = $service->getMapControllDataByUser($userid, 1);
		$layerListData = $service->getMapControllLayerByUser($userid);	
	}

	$layerMemoTypeList = array();
	$memoArrayList = array();
	$layerId = "";
	$layerName ="";
	if ($userid == null){//soma
		foreach($recordData as $data){
			// レイヤーIDごとのリストを生成する
			if($layerId != "" && $layerId != $data->getLayerID()){
				$layerArray = array(
								'layerid'  => $layerId, 
								'layername'  => $layerName,
								'userid' => $userid,
								'requestButton' => $service->getLayerUserStatus($userid, $layerId),
								'rssGetString' => "?userId=".$userid."&layerId=".$layerId,
								$memoArrayList);
				array_push($layerMemoTypeList, $layerArray);
				$memoArrayList = array();
			}
			$layerId = $data->getLayerID();
			$layerName = $data->getLayerName();
			
			// アイコンタイプでアドレス切り替え
			$iconPath = "";
			if($data->getIconType() == 0){
				$iconPath = "../../img/icon/".$data->getIcon();
			}else{
				$iconPath = "./img/icon/".$data->getIcon();
			}
			$memoArray = array(
				'typeid'   => $data->getMemoTypeID(),
				'typename' => $data->getMemoTypeName(),
				'ico'       => $iconPath,
				'ribbon'   => $data->getRibbonColor(),
				'disptype'   => $data->getListType()
			);
			array_push($memoArrayList, $memoArray);				
		}
	}else{//soma
		foreach($layerListData as $data){
			// レイヤーIDごとのリストを生成する
			if($layerId != "" && $layerId != $data->getLayerID_Layer()){
				$layerArray = array(
								'layerid'  => $layerId, 
								'layername'  => $layerName,
								'userid' => $userid,
								'requestButton' => $service->getLayerUserStatus($userid, $layerId),
								'rssGetString' => "?userId=".$userid."&layerId=".$layerId,
								$memoArrayList);
				array_push($layerMemoTypeList, $layerArray);
				$memoArrayList = array();
			}
			$layerId = $data->getLayerID_Layer();
			$layerName = $data->getLayerName_Layer();
			//メモ種類のリストから、レイヤーIDが該当するものを探し出す
			$i = 0;
			for($i = 0; $i < count($recordData); $i++){
				if ($layerId == $recordData[$i]->getLayerID()){//$recordDataは同じレイヤーID順で並んでいることが保障されている
					// アイコンタイプでアドレス切り替え
					$iconPath = "";
					if($recordData[$i]->getIconType() == 0){
						$iconPath = "../../img/icon/".$recordData[$i]->getIcon();
					}else{
						$iconPath = "./img/icon/".$recordData[$i]->getIcon();
					}
					$memoArray = array(
						'typeid'   => $recordData[$i]->getMemoTypeID(),
						'typename' => $recordData[$i]->getMemoTypeName(),
						'ico'       => $iconPath,
						'ribbon'   => $recordData[$i]->getRibbonColor(),
						'disptype'   => $recordData[$i]->getListType()
					);
					array_push($memoArrayList, $memoArray);	
				}
			}
		}
	}//soma

	if($layerId != ""){
		$layerArray = array(
						'layerid'  => $layerId, 
						'layername'  => $layerName,
						'userid' => $userid,
						'requestButton' => $service->getLayerUserStatus($userid, $layerId),
						'rssGetString' => "?userId=".$userid."&layerId=".$layerId,
					$memoArrayList);
		array_push($layerMemoTypeList, $layerArray);
	}

	// ゲストかつCookieが存在した場合はその順にレイヤーを並べ替える
    if (!isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
    // クッキーから表示するレイヤー一覧を取得
	    if (isset($_COOKIE[LAYERPRIORITY])) {
	        $layer_array = explode(",", $_COOKIE[LAYERPRIORITY]);	        
	        // テンポラリにコピー
	        $tempArrayList = $layerMemoTypeList;
			// 初期化	        
	        $layerMemoTypeList = array();
			// クッキーに設定されているレイヤー順に積みなおし
			foreach($layer_array as $cokkieLayerId){
				foreach($tempArrayList as $tempArray){
					if($tempArray['layerid'] == $cokkieLayerId){
						array_push($layerMemoTypeList, $tempArray);
					}
				}
			}
	    }
    }

	return $layerMemoTypeList;	
}
?>