<?php
/**
* G04-008
* memolist.php 処理概要：メモ・コメント削除処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

//require_once("class/db/service/ContentsAdminService.class.php");	//DBアクセスサービスクラス
require_once("class/db/service/ContentsViewService.class.php");	//DBアクセスサービスクラス

//require_once("class/db/tabledata/CommentData.class.php");			// コメント管理テーブル
require_once("class/db/tabledata/MemoDetailPositionTypeData.class.php");		// メモ詳細管理テーブル
//require_once("class/db/tabledata/MemoDetailData.class.php");		// メモ詳細管理テーブル
//require_once("class/db/tabledata/MemoPositionData.class.php");		// メモ位置情報管理テーブル

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memoDeleteForm", "POST", $_SERVER["PHP_SELF"], "_self");

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// 一時変数初期化
$errorMessage = "";
$pageFlg = 0;
$tplName = "";

$postPwd		=	"";
$postLayerId	=	"";
$postMemoId		=	"";
$postMemoType	=	"";
$postCommentId	=	"";
$postLongitude	=	"";
$postLatitude	=	"";

//POST引数取得
if ($_SERVER["REQUEST_METHOD"] == "POST"){
	if ((array_key_exists( "memoId", 		$_POST)) && 
		(array_key_exists( "commentId",		$_POST))){
		$postMemoId		=	trim($_POST["memoId"]);
		$postCommentId	=	trim($_POST["commentId"]);

		if (array_key_exists( "memoDel",		$_POST)){
			$pageFlg	=	"1";
		}
	}else{
		//アクセスエラー（引数なし）
		trigger_error($o_resource->getValue("G04008M001"), E_USER_ERROR);
    	exit(-1);
	}
}else{
	//METHODエラー
	trigger_error($o_resource->getValue("G04008M001"), E_USER_ERROR);
	exit();
}

// ボタンを表示
if ($pageFlg == 0) {

    // メモ／コメント表示画面

	$dataArray = null;
	// 詳細情報を取得
	if(empty($postCommentId)){
		$dataArray = getMemoData($postMemoId, $s_UserId);
		if ($dataArray == FALSE){
		}
	}else{
		$dataArray = getCommentData($postCommentId);
	}
	if ($dataArray == FALSE){
		trigger_error($o_resource->getValue("G04006M004"), E_USER_ERROR);
		exit();
	}

	$tplMemoArray = array(
						"header"			=> $o_resource->getValue("G04008L001"),
						"userNameLbl"		=> $o_resource->getValue("G04008L002"),
						"memoTitleLbl"		=> $o_resource->getValue("G04008L003"),
						"memoTextLbl"		=> $o_resource->getValue("G04008L004"),
						"mailAddressLbl"	=> $o_resource->getValue("G04008L005"),
						"releteUrlLbl"		=> $o_resource->getValue("G04008L006"),
						"imgFileLbl"		=> $o_resource->getValue("G04008L007"),
						"memoTypeLbl"		=> $o_resource->getValue("G04008L008"),
						"memoType"			=> $o_resource->getValue("G04008L009") 
											.  $dataArray['layerName'] 
											.  $o_resource->getValue("G04008L010"),
						"memoDel"			=> $o_resource->getValue("G04008L011"),
						"userName"			=> $dataArray['userName'],
						"memoTitle"			=> $dataArray['memoTitle'],
						"memoText"			=> explode("\n", $dataArray['memoText']),
						"mailAddress"		=> $dataArray['mailAddress'],
						"releteUrl"			=> $dataArray['releteUrl'],
						"imgFile"			=> ($dataArray['imgFile'] == "")?"":"./img/memo/".$dataArray['imgFile'],
						"memoColor"			=> "#".$dataArray['memoColor'],
						"memoIcon"			=> ($dataArray['memoIconType'] == 0)?"../../img/icon/".$dataArray['memoIcon']:"img/icon/".$dataArray['memoIcon'],
						"memoName"			=> $dataArray['typeName']
					);

    $o_smarty->assign("tplMemoArray", $tplMemoArray);

    $o_form->addElement("submit", "memoDel", 	$o_resource->getValue("G04008L011"), array("class"=>"fs12_black"));
	$o_form->addElement("hidden", "memoId",     $postMemoId);
	$o_form->addElement("hidden", "commentId",  $postCommentId);

	$o_smarty->assign("back",		$o_resource->getValue("G04008L012"),	array("class"=>"fs12_black"));


	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	$o_smarty->assign("errorMessage", $errorMessage);
 
    $tplName = DIRECTORY_NAME."/memodelete.tpl";

} else {
    // 削除処理
	$viewService	=	new ContentsViewService(DIRECTORY_NAME);

	if(empty($postCommentId)){
		if ($viewService->deleteMemoDataByKey($postMemoId) == FALSE){
			trigger_error("Memo Delete Error!!", E_USER_ERROR);
			$memoDetailTableAccess->free();
			exit();
		}
	}else{
		if ($viewService->deleteCommentDataByKey($postCommentId) == FALSE){
			trigger_error("Comment Delete Error!!", E_USER_ERROR);
			$memoDetailTableAccess->free();
			exit();
		}
	}

	//OpenerのReload
    $tplName = DIRECTORY_NAME."/memoclose.tpl";

}
$o_smarty->display($tplName);

unset($_POST);


//==========================================//
// 仮実装(function)
//------------------------------------------//
/**
* 関数概要	：メモデータ取得
* 処理詳細	：メモデータ取得
*
* @引数		：	(I) memoid	- メモID
*               (I) userId  - ユーザID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getMemoData($memoid, $userId){

	$viewService		=	new ContentsViewService(DIRECTORY_NAME);
	$memoDetailRecord	=	new MemoDetailPositionTypeData;
	$memoDetailRecord	=	$viewService->getOneMemoDetailViewDataAuth($memoid, $userId);
	
	if (is_null($memoDetailRecord)){
		trigger_error("Memo Data Invalid Error!!", E_USER_ERROR);
		return FALSE;
	}

	$memoData	=	array();

	$memoData = array(
		"typeID"		=> $memoDetailRecord->getMemoTypeID(),
		"typeName"		=> $memoDetailRecord->getMemoTypeName(),
		"memoIcon"		=> $memoDetailRecord->getIcon(),
		"memoIconType"	=> $memoDetailRecord->getIconType(),
		"memoColor"		=> $memoDetailRecord->getRibbonColor(),
		"layerName"		=> $memoDetailRecord->getLayerName(),
		"id"			=> $memoDetailRecord->getMemoID(),
		"userName"		=> $memoDetailRecord->getUserName_d(),
		"memoTitle"		=> $memoDetailRecord->getMemoTitle(),
		"memoText"		=> $memoDetailRecord->getMemoText(),
		"mailAddress"	=> $memoDetailRecord->getMailAddress_d(),
		"releteUrl"		=> $memoDetailRecord->getReleteURL_d(),
		"imgFile"		=> $memoDetailRecord->getImageFile_d(),
		"pwd"			=> $memoDetailRecord->getUpdateDeletePassword_d()
	);

	return $memoData;
}

/**
* 関数概要	：コメントデータ取得
* 処理詳細	：コメントデータ取得
*
* @引数		：	(I) commentid	- メモID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getCommentData($commentid){

	$viewService	=	new ContentsViewService(DIRECTORY_NAME);
	$commentRecord	=	new MemoDetailPositionTypeData;
	$commentRecord	=	$viewService->getOneCommentData($commentid);
	
	if (is_null($commentRecord)){
		trigger_error("Comment Data Invalid Error!!", E_USER_ERROR);
		return FALSE;
	}

	$commentData	=	array();

	$commentData = array(
		"typeID"		=> $commentRecord->getMemoTypeID(),
		"typeName"		=> $commentRecord->getMemoTypeName(),
		"memoIcon"		=> $commentRecord->getIcon(),
		"memoIconType"	=> $commentRecord->getIconType(),
		"memoColor"		=> $commentRecord->getRibbonColor(),
		"layerName"		=> $commentRecord->getLayerName(),
		"id"			=> $commentRecord->getCommentID(),
		"userName"		=> $commentRecord->getUserName_c(),
		"memoTitle"		=> $commentRecord->getCommentTitle(),
		"memoText"		=> $commentRecord->getCommentText(),
		"mailAddress"	=> $commentRecord->getMailAddress_c(),
		"releteUrl"		=> $commentRecord->getReleteURL_c(),
		"imgFile"		=> $commentRecord->getImageFile_c(),
		"pwd"			=> $commentRecord->getUpdateDeletePassword_c()
	);
					
	return $commentData;	
}

?>