<?php
/**
* G04-007
* memoregist.php 処理概要：メモ修正処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

//require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");
require_once("class/db/tabledata/MemoDetailData.class.php");
require_once("class/db/tabledata/MemoPositionData.class.php");
require_once("class/db/tabledata/CommentData.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");
require_once("class/xml/RSSController.class.php");			// RSS

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

$errorMessage	= "";
$pageFlg		= 0;
$tplName		= "";
$errorFileSize	= "";
$errorFileType	= "";
$filecheck		= TRUE;

$targetTypeId	=	"";

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

//POST引数取得
if ($_SERVER["REQUEST_METHOD"] == "POST"){
	if ((array_key_exists( "memoId",	$_POST))){
		$postMemoId		=	trim($_POST["memoId"]);

		// 詳細情報を取得
		$memoDetailRecord = new MemoDetailPositionTypeData;
		$memoDetailRecord = getMemoData($postMemoId, $s_UserId);
		if ($memoDetailRecord == FALSE){
			//対象データなし
			trigger_error($o_resource->getValue("G04007M020"), E_USER_ERROR);
			exit();
		}
	}else{
		//アクセスエラー（引数なし）
		trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
    	exit(-1);
	}
}else{
	//METHODエラー
	trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
	exit();
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memoRegistForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 項目セット
$o_form->addElement("header",   "header",    $o_resource->getValue("G04007L001"));
$o_form->addElement("text",     "name",      $o_resource->getValue("G04007L002"), array("size"=>"40", "maxlength"=>"32", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text",     "title",     $o_resource->getValue("G04007L003"), array("size"=>"40", "maxlength"=>"20", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("textarea", "text",      $o_resource->getValue("G04007L004"), array("maxlength"=>"500", "autocomplete"=>"off", "class"=>"", "cols"=>"45", "rows"=>"10"));
$o_form->addElement("text",     "mail",      $o_resource->getValue("G04007L005"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text",     "url",       $o_resource->getValue("G04007L006"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));

$o_form->addElement("file",     "imgFile",   $o_resource->getValue("G04007L007"), array("autocomplete"=>"off", "class"=>""));
$o_form->addElement("password", "updDelPwd", $o_resource->getValue("G04007L008"), array("size"=>"4", "maxlength"=>"4", "autocomplete"=>"off", "class"=>""));

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("name",      $o_resource->getValue("G04007M001"), "required");
$o_form->addRule("name",  	  $o_resource->getValue("G04007M002"), "maxlength_valid",   32);
$o_form->addRule("title",     $o_resource->getValue("G04007M003"), "required");
$o_form->addRule("title",  	  $o_resource->getValue("G04007M004"), "maxlength_valid",	20);
$o_form->addRule("text",  	  $o_resource->getValue("G04007M005"), "maxlength_valid",	500);
$o_form->addRule("mail",  	  $o_resource->getValue("G04007M006"), "email",	null);
$o_form->addRule("mail",	  $o_resource->getValue("G04007M007"), "maxlength_valid",	128);
$o_form->addRule("url",  	  $o_resource->getValue("G04007M008"), "regex",	"/^(http|https)?(:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?)/");
$o_form->addRule("url",	      $o_resource->getValue("G04007M009"), "maxlength_valid",	128);
$o_form->addRule("updDelPwd", $o_resource->getValue("G04007M010"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("updDelPwd", $o_resource->getValue("G04007M011"), "maxlength_valid",	4);

//画像ファイルへの指示用Radioボタン生成
if ($memoDetailRecord->getImageFile_d() != ""){
	$o_form->addElement("text",     "currentImg",$o_resource->getValue("G04007L012"), array("autocomplete"=>"off", "class"=>"fs12_black"));
	$radioArray	=	array(
						"nc"	=>	$o_resource->getValue("G04007L014"),
						"del"	=>	$o_resource->getValue("G04007L016"),
						"upd"	=>	$o_resource->getValue("G04007L017")
					);
}else{
	$o_form->addElement("text",     "currentImg",$o_resource->getValue("G04007L013"), array("autocomplete"=>"off", "class"=>"fs12_black"));
	$radioArray	=	array(
						"nc"	=>	$o_resource->getValue("G04007L014"),
						"ins"	=>	$o_resource->getValue("G04007L015")
						);
}

// 登録ボタン
if (array_key_exists( "memoEdit", $_POST)){

    // 妥当性チェック
	if (array_key_exists( "memoType", $_POST)) {
    	$targetTypeId	=	$_POST["memoType"];
    }else{
		//アクセスエラー（引数なし）
		trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
   		exit(-1);
    }

	//画像ファイル指示状態チェック
	switch($_POST["imgSts"]){
		case "nc":
		case "del":
			break;
		case "ins":
		case "upd":
			// アップロードファイルチェック
			if($_FILES['imgFile']['name'] != ""){
				if($_FILES['imgFile']['size'] > 204800){
					$errorFileSize = $o_resource->getValue("G04007M016");
					$filecheck = FALSE;
				}else if(in_array($_FILES['imgFile']['type'], explode(",", UPLOAD_MIME_TYPE)) == FALSE){
					$errorFileType = $o_resource->getValue("G04007M017");
					$filecheck = FALSE;
				}
		    }else{
		    	$errorFileSize = $o_resource->getValue("G04007M018");
		    	$filecheck = FALSE;
		    }
			break;
		default:
			//アクセスエラー（引数なし）
			trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
    		exit(-1);
			break;
	}

    // チェックOK
    if (($o_form->validate()) && ($filecheck)) {

		$uploadDir = "./img/memo/";
		$uploadfileName	=	"";

		switch($_POST["imgSts"]){
			//画像変更なし
			case "nc":
				$uploadfileName = $memoDetailRecord->getImageFile_d();
				break;
			//画像追加
			case "ins":
				list($msec, $sec) = explode(" ", microtime()); 
				// 軽度にファイル名を暗号化
//				$filename = str_replace("/", "_", crypt(date('YmdHis', time()).(((float)$msec)*1000000), "kakikomap"));
				$filename = date('YmdHis', time()).(((float)$msec)*1000000);

				if($_FILES['imgFile']['name'] != ""){
				    $pathArray = pathinfo($_FILES['imgFile']['name']);
					$uploadfileName = $filename.".".$pathArray['extension'];
					if(is_uploaded_file($_FILES["imgFile"]["tmp_name"])){
						if(move_uploaded_file($_FILES['imgFile']['tmp_name'], $uploadDir.$uploadfileName) == FALSE){
							print("File Upload Error!!".$uploadDir.$uploadfileName);
						}
					}else{
						trigger_error("Illegal file!!", E_USER_ERROR);
					    exit(-1);
					}
				}
				break;
			//画像変更
			case "upd":
				$uploadfileName = $memoDetailRecord->getImageFile_d();
				if (empty($uploadfileName) == FALSE){
					if (file_exists($uploadDir . $memoDetailRecord->getImageFile_d())){
						unlink($uploadDir . $memoDetailRecord->getImageFile_d());
					}

					if($_FILES['imgFile']['name'] != ""){
						if(is_uploaded_file($_FILES["imgFile"]["tmp_name"])){
							if(!move_uploaded_file($_FILES['imgFile']['tmp_name'], $uploadDir.$uploadfileName)){
								print("File Upload Error!!".$uploadDir.$uploadfileName);
							}    
						}else{
							trigger_error("Illegal file!!", E_USER_ERROR);
						    exit(-1);
						}
					}
				}
				break;
			//画像削除
			case "del":
				$uploadfileName = $memoDetailRecord->getImageFile_d();
				if (empty($uploadfileName) == FALSE){
					if (file_exists($uploadDir . $memoDetailRecord->getImageFile_d())){
						unlink($uploadDir . $memoDetailRecord->getImageFile_d());
					}
				}
				$uploadfileName = "";
				break;
			default:
				//アクセスエラー（引数なし）
				trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
	    		exit(-1);
				break;
		}

        // **************************
        // DB登録処理実装部
        // **************************

		$idArray = explode("_", $_POST["memoType"]);

		$setArray	=	array(
							"memoid"		=> $_POST["memoId"],
							"memotypeid"	=> $idArray[1],
							"name"			=> $_POST['name'],
							"title"			=> $_POST['title'],
							"memotext"		=> $_POST['text'],
							"mail"			=> $_POST['mail'],
							"url"			=> $_POST['url'],
							"filename"		=> $uploadfileName,
							"upddelpwd"		=> $_POST['updDelPwd'],
							"count"			=> $memoDetailRecord->getAccessCount_d() + 1
						);

		// UPDATE
		$viewService = new ContentsViewService(DIRECTORY_NAME);

		//更新列の設定
		// メモ詳細情報
		$targetDetail = new MemoDetailData();
		$targetDetail->setMemoID(WHERE_KEY);
		$targetDetail->setMemoTypeID(VAL_TARGET);
		$targetDetail->setUserName(VAL_TARGET);
		$targetDetail->setMemoTitle(VAL_TARGET);
		$targetDetail->setMemoText(VAL_TARGET);
		$targetDetail->setMailAddress(VAL_TARGET);
		$targetDetail->setReleteURL(VAL_TARGET);
		$targetDetail->setImageFile(VAL_TARGET);
		$targetDetail->setUpdateDeletePassword(VAL_TARGET);
		$targetDetail->setAccessCount(VAL_TARGET);
		$targetDetail->setUpdateDateTime(VAL_TARGET);

		// メモ位置情報
		$targetPosition = new MemoPositionData();
		$targetPosition->setMemoID(WHERE_KEY);
		$targetPosition->setMemoTypeID(VAL_TARGET);
		$targetPosition->setUpdateDateTime(VAL_TARGET);

		// コメント情報
		$targetComment = new CommentData();
		$targetComment->setMemoID(WHERE_KEY);
		$targetComment->setMemoTypeID(VAL_TARGET);
		$targetComment->setUpdateDateTime(VAL_TARGET);


		if ($viewService->updateMemoCommentDataByKey($targetDetail, $targetPosition, $targetComment, $setArray) == FALSE){
			trigger_error("Update Error", E_USER_ERROR);
			exit(-1);
		}

		// RSS出力
		$rss = new RSSController($idArray[0], DIRECTORY_NAME);
		if(!$rss->writeRssFile()){
			trigger_error("RSS Error!!", E_USER_ERROR);
		    exit(-1);
		}

		$pageFlg = 1;
    }
}else{

	// 入力項目のデフォルトをセット
	$o_form->setDefaults(
		array(
	    	"name"      => $memoDetailRecord->getUserName_d(),
	    	"title"     => $memoDetailRecord->getMemoTitle(),
	    	"text"      => $memoDetailRecord->getMemoText(),
	    	"mail"      => $memoDetailRecord->getMailAddress_d(),
	    	"url"       => $memoDetailRecord->getReleteURL_d(),
	    	"imgFile"   => $memoDetailRecord->getImageFile_d(),
	    	"updDelPwd" => $memoDetailRecord->getUpdateDeletePassword_d()
		)
	);

	//メモ種類の初期値設定
	$targetTypeId	=	$memoDetailRecord->getLayerID() . "_" . $memoDetailRecord->getMemoTypeID();

}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
 	$o_form->addElement("hidden", "memoId", $postMemoId);
    $o_form->addElement("submit", "memoEdit", $o_resource->getValue("G04007L010"), array("class"=>"fs12_black"));
    $o_form->addElement("button", "close",  $o_resource->getValue("G04007L011"), array("onclick"=>"window.close();", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());
	$labelArray = array(
      "label01"  => $o_resource->getValue("G04007M012"),
      "label02"  => $o_resource->getValue("G04007M013"),
      "label03"  => $o_resource->getValue("G04007M014"),
      "errorFileSize" => $errorFileSize,
      "errorFileType" => $errorFileType
	);

	$o_smarty->assign("radioArray", $radioArray);
    $o_smarty->assign("radioId", $targetTypeId);
	$o_smarty->assign("labelArray", $labelArray);
	$o_smarty->assign("errorMessage", $errorMessage);

	// メモ種類ラジオボタン取得
	$layerMemoTypeArray = getLayerMemoTypeData($s_UserId);
	$o_smarty->assign("layerMemoTypeArray", $layerMemoTypeArray);

    $tplName = DIRECTORY_NAME."/memoedit.tpl";

} else {
    // 完了画面
    $tplName = DIRECTORY_NAME."/memoclose.tpl";
}

$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ種類データ取得
* 処理詳細：メモ種類データを取得・整形する
*
* @引数： (I) userid	- string  ユーザID
* @戻値： array メモ種類情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getLayerMemoTypeData($userid) {

	$service = new ContentsViewService(DIRECTORY_NAME);
	
	$recordData = null;
	if($userid == null){
		$recordData = $service->getMapControllDataByGuest("2");
	}else{
		$recordData = $service->getMapControllDataByUser($userid, "2");
	}

	$layerMemoTypeList = array();
	$memoArrayList = array();
	$layerId = "";
	$layerName ="";
	foreach($recordData as $data){
		// レイヤーIDごとのリストを生成する
		if($layerId != "" && $layerId != $data->getLayerID()){
			$layerArray = array(
							'layerid'  => $layerId, 
							'layername'  => $layerName,
							$memoArrayList);
			array_push($layerMemoTypeList, $layerArray);
			$memoArrayList = array();
		}
		$layerId = $data->getLayerID();
		$layerName = $data->getLayerName();
		
		// アイコンタイプでアドレス切り替え
		$iconPath = "";
		if($data->getIconType() == 0){
			$iconPath = "../../img/icon/".$data->getIcon();
		}else{
			$iconPath = "./img/icon/".$data->getIcon();
		}
		$memoArray = array(
			'typeid'   => $data->getMemoTypeID(),
			'typename' => $data->getMemoTypeName(),
			'ico'       => $iconPath,
			'ribbon'   => $data->getRibbonColor()
		);
		array_push($memoArrayList, $memoArray);	
	}
	if($layerId != ""){
		$layerArray = array(
						'layerid'  => $layerId, 
						'layername'  => $layerName,
					$memoArrayList);
		array_push($layerMemoTypeList, $layerArray);
	}
	return $layerMemoTypeList;	
}

/**
* 関数概要	：メモデータ取得
* 処理詳細	：メモデータ取得
*
* @引数		：	(I) memoid	- メモID
*               (I) userId  - ユーザID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getMemoData($memoid, $userId){
 	$viewService		=	new ContentsViewService(DIRECTORY_NAME);
	$memoDetailRecord	=	new MemoDetailPositionTypeData;
	$memoDetailRecord	=	$viewService->getOneMemoDetailViewDataAuth($memoid, $userId);
	
	if (is_null($memoDetailRecord)){
		trigger_error("Memo Data Invalid Error!!", E_USER_ERROR);
		return FALSE;
	}

	return $memoDetailRecord;

}

?>