<?php
/**
* memoregist.php 処理概要：メモ投稿処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("class/xml/RSSController.class.php");			// RSS
require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memoRegistForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 入力項目のデフォルトをセット
$contributor = $o_resource->getValue("G04003L012");
if($s_UserName != null){
	$contributor = $s_UserName;
}
$o_form->setDefaults(array(
    "name"      => $contributor,
    "title"     => "",
    "text"      => "",
    "mail"      => "",
    "url"       => "",
    "imgFile"   => "",
    "updDelPwd" => ""
));

// 項目セット
$o_form->addElement("header",   "header",    $o_resource->getValue("G04003L001"));
$o_form->addElement("text",     "name",      $o_resource->getValue("G04003L002"), array("size"=>"40", "maxlength"=>"32", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text",     "title",     $o_resource->getValue("G04003L003"), array("size"=>"40", "maxlength"=>"20", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("textarea", "text",      $o_resource->getValue("G04003L004"), array("maxlength"=>"500", "autocomplete"=>"off", "class"=>"", "cols"=>"45", "rows"=>"10"));
$o_form->addElement("text",     "mail",      $o_resource->getValue("G04003L005"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text",     "url",       $o_resource->getValue("G04003L006"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("file",     "imgFile",   $o_resource->getValue("G04003L007"), array("autocomplete"=>"off", "class"=>""));
$o_form->addElement("password", "updDelPwd", $o_resource->getValue("G04003L008"), array("size"=>"4", "maxlength"=>"4", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("hidden", 	"checkedMemoType", "");

// 座標情報をhiddenへセット
if(isset($_POST['mapext'])){
	$arr = explode(" ", $_POST['mapext']);
	$controller = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);

	if(isset($_POST['area_height'])){
		$coordinates = $controller->get_changeCoordinatesFromJs($_POST['area_width'], $_POST['area_height'], $_POST['click_x'], $_POST['click_y']);

		$o_form->addElement("hidden", "updX",        $coordinates[0]);
		$o_form->addElement("hidden", "updY",        $coordinates[1]);
		$o_form->addElement("hidden", "mapext",      $_POST['mapext']);
		$o_form->addElement("hidden", "area_width",  $_POST['area_width']);
		$o_form->addElement("hidden", "area_height", $_POST['area_height']);
		$o_form->addElement("hidden", "click_x",     $_POST['click_x']);
		$o_form->addElement("hidden", "click_y",     $_POST['click_y']);
	}	
}else{
	trigger_error("Unlawful computer access!!", E_USER_ERROR);
    exit(-1);
}

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("name",      $o_resource->getValue("G04003M001"), "required");
$o_form->addRule("name",  	  $o_resource->getValue("G04003M002"), "maxlength_valid",   32);
$o_form->addRule("title",     $o_resource->getValue("G04003M003"), "required");
$o_form->addRule("title",  	  $o_resource->getValue("G04003M004"), "maxlength_valid",	20);
$o_form->addRule("text",  	  $o_resource->getValue("G04003M005"), "maxlength_valid",	500);
$o_form->addRule("mail",  	  $o_resource->getValue("G04003M006"), "email",	null);
$o_form->addRule("mail",	  $o_resource->getValue("G04003M007"), "maxlength_valid",	128);
$o_form->addRule("url",  	  $o_resource->getValue("G04003M008"), "regex",	"/^(http|https)?(:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?)/");
$o_form->addRule("url",	      $o_resource->getValue("G04003M009"), "maxlength_valid",	128);
$o_form->addRule("updDelPwd", $o_resource->getValue("G04003M010"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("updDelPwd", $o_resource->getValue("G04003M011"), "maxlength_valid",	4);

$errorMessage = "";
$pageFlg = 0;
$tplName = "";
$errorRadio = "";
$errorFileSize ="";
$errorFileType ="";
$filecheck = TRUE;
// 登録ボタン
if (isset($_POST[submit])) {

    // 妥当性チェック
    if(empty($_POST[checkedMemoType])){
    	$errorRadio = $o_resource->getValue("G04003M015");
    }

	// アップロードファイルチェック
    if($_FILES['imgFile']['name'] != ""){
		if($_FILES['imgFile']['size'] > 204800){
	    	$errorFileSize = $o_resource->getValue("G04003M016");
	    	$filecheck = FALSE;
		}else if(in_array($_FILES['imgFile']['type'], explode(",", UPLOAD_MIME_TYPE)) == FALSE){
	    	$errorFileType = $o_resource->getValue("G04003M017");
	    	$filecheck = FALSE;
		}
    }
    
    // チェックOK
    if ($o_form->validate() && !empty($_POST[checkedMemoType]) && $filecheck) {
        $pageFlg = 1;
        
		// ファイルアップロード処理
		$uploadDir = "./img/memo/";
		list($msec, $sec) = explode(" ", microtime()); 
//		$filename = str_replace("/", "_", crypt(date('YmdHis', time()).(((float)$msec)*1000000), "kakikomap"));	// 軽度にファイル名を暗号化
		$filename = date('YmdHis', time()).(((float)$msec)*1000000);
		$uploadfileName = "";

		if($_FILES['imgFile']['name'] != ""){
		    $pathArray = pathinfo($_FILES['imgFile']['name']);
			$uploadfileName = $filename.".".$pathArray['extension'];
			if(is_uploaded_file){
				if(!move_uploaded_file($_FILES['imgFile']['tmp_name'], $uploadDir.$uploadfileName)){
					print("File Upload Error!!".$uploadDir.$uploadfileName);
				}    
			}else{
				trigger_error("Illegal file!!", E_USER_ERROR);
			    exit(-1);
			}
		}

        // **************************
        // DB登録処理実装部
        // **************************
        $idArray = explode("_", $_POST['checkedMemoType']);

		// メモ位置情報
		$position = new MemoPositionData();
//		$position->setMemoID("");
		$position->setMemoTypeID($idArray[1]);
		$position->setLongitude($_POST['updX']);
		$position->setLatitude($_POST['updY']);
		$position->setDeleteFlg("0");
		$position->setAddDateTime(date('Y/m/d H:i:s'));
		$position->setUpdateDateTime(date('Y/m/d H:i:s'));
		
		// メモ詳細情報
		$detail = new MemoDetailData();
//		$detail->setMemoID("");
		$detail->setMemoTypeID($idArray[1]);
		$detail->setUserName($_POST['name']);
		$detail->setMemoTitle($_POST['title']);
		$detail->setMemoText($_POST['text']);
		$detail->setMailAddress($_POST['mail']);
		$detail->setReleteURL($_POST['url']);
		$detail->setImageFile($uploadfileName);
		$detail->setUpdateDeletePassword($_POST['updDelPwd']);
		$detail->setAccessCount("0");
		$detail->setDeleteFlg("0");
		$detail->setAddDateTime(date('Y/m/d H:i:s'));
		$detail->setUpdateDateTime(date('Y/m/d H:i:s'));

		// INSERT
		$service = new ContentsViewService(DIRECTORY_NAME);
		if(!$service->insertMemo($detail, $position)){
			trigger_error("DB Error!!", E_USER_ERROR);
		    exit(-1);
		}
		
		// RSS出力
		$rss = new RSSController($idArray[0], DIRECTORY_NAME);
		if(!$rss->writeRssFile()){
			trigger_error("RSS Error!!", E_USER_ERROR);
		    exit(-1);
		}
    }
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $o_form->addElement("submit", "submit", $o_resource->getValue("G04003L010"), array("class"=>"fs12_black"));
    $o_form->addElement("button", "close",  $o_resource->getValue("G04003L011"), array("onclick"=>"window.close();", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());
	$labelArray = array(
      "label01"  => $o_resource->getValue("G04003M012"),
      "label02"  => $o_resource->getValue("G04003M013"),
      "label03"  => $o_resource->getValue("G04003M014"),
      "errorRadio" => $errorRadio,
      "errorFileSize" => $errorFileSize,
      "errorFileType" => $errorFileType
	);
    $o_smarty->assign("radioId", $_POST[checkedMemoType]);
	$o_smarty->assign("labelArray", $labelArray);
	$o_smarty->assign("errorMessage", $errorMessage);

	// メモ種類ラジオボタン取得
	$layerMemoTypeArray = getLayerMemoTypeData($s_UserId);
	$o_smarty->assign("layerMemoTypeArray", $layerMemoTypeArray);

    $tplName = DIRECTORY_NAME."/memoregist.tpl";

} else {
    // 完了画面
    $tplName = DIRECTORY_NAME."/memoclose.tpl";
}
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ種類データ取得
* 処理詳細：メモ種類データを取得・整形する
*
* @引数： (I) userid	- string  ユーザID
* @戻値： array メモ種類情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getLayerMemoTypeData($userid) {

	$service = new ContentsViewService(DIRECTORY_NAME);
	
	$recordData = null;
	if($userid == null){
		$recordData = $service->getMapControllDataByGuest(2);
	}else{
		$recordData = $service->getMapControllDataByUser($userid, 2);
	}

	$layerMemoTypeList = array();
	$memoArrayList = array();
	$layerId = "";
	$layerName ="";
	foreach($recordData as $data){
//		if($data->getAuthorityMemoType == )
		
		// レイヤーIDごとのリストを生成する
		if($layerId != "" && $layerId != $data->getLayerID()){
			$layerArray = array(
							'layerid'  => $layerId, 
							'layername'  => $layerName,
							$memoArrayList);
			array_push($layerMemoTypeList, $layerArray);
			$memoArrayList = array();
		}
		$layerId = $data->getLayerID();
		$layerName = $data->getLayerName();
		
		// アイコンタイプでアドレス切り替え
		$iconPath = "";
		if($data->getIconType() == 0){
			$iconPath = "../../img/icon/".$data->getIcon();
		}else{
			$iconPath = "./img/icon/".$data->getIcon();
		}
		$memoArray = array(
			'typeid'   => $data->getMemoTypeID(),
			'typename' => $data->getMemoTypeName(),
			'ico'       => $iconPath,
			'ribbon'   => $data->getRibbonColor()
		);
		array_push($memoArrayList, $memoArray);	
	}
	if($layerId != ""){
		$layerArray = array(
						'layerid'  => $layerId, 
						'layername'  => $layerName,
					$memoArrayList);
		array_push($layerMemoTypeList, $layerArray);
	}
	return $layerMemoTypeList;	
}
?>