<?php
/**
* G06-010
* getmail.php 処理概要：携帯電話用添付メール取得処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("class/db/tabledata/MemoDetailData.class.php");
require_once("class/db/tabledata/CommentData.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ユーザエージェントチェック
$errorMessage = null;
$agent	=	false;

/* テスト用*/
$dmy = "a";
switch($dmy){


//switch(user_agent()){
	case "a":
		$agent	=	true;
		break;
	case "d":
	case "v":
		$linkTag	=	"";
		$labelArray = array(
			"label01"  => "Contents Name",
			"label02"  => mbConvertEncoding($o_resource->getValue("G06002M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06002M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06002M003"), "SJIS"),
			"label05"  => "",
			"label06"  => $linkTag
		);
		$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if ($agent){

	// イメージ取込判定
	// POPサーバ接続・取得
	$sockRes = fsockopen(POP_SERVER_ADDR, 110, $errNo, $errStr, 10);
	if ($sockRes == FALSE){
		trigger_error("POP Connect Error:$errStr($errNo)", E_USER_ERROR);
		exit();
	}
	
	$RetCode = fgets($sockRes, 512);
	if(substr($RetCode, 0, 3) != '+OK'){
		trigger_error("POP Get Error", E_USER_ERROR);
		exit();
	}
	
	if (popConnect($sockRes, "USER ".POP_USER) == FALSE){
		trigger_error("POP Authentication  Error", E_USER_ERROR);
		exit();
	}
	if (popConnect($sockRes, "PASS ".POP_PASS) == FALSE){
		trigger_error("POP Authentication  Error", E_USER_ERROR);
		exit();
	}
	
	//STAT -件数とサイズ取得 +OK no size
	$mailStat = popConnect($sockRes, "STAT");
	if ($mailStat == FALSE){
		trigger_error("POP STAT  Error", E_USER_ERROR);
		exit();
	}
	
	sscanf($mailStat, '+OK %d %d', $num, $size);
	if ($num == "0") {
		// 終了
		popConnect($sockRes, "QUIT");
		fclose($sockRes);
		exit;
	}
	
	//削除対象格納用
	$delNoArray = array();
	$mailArray = array();
	$idx = -1;
	
	// 件数分
	for($i=1;$i<=$num;$i++) {
		$item = popConnect($sockRes, "RETR $i");//RETR n -n番目のメッセージ取得（ヘッダ含）
	
		while (!ereg("^\.\r\n",$item)) {//EOFの.まで読む
			$item = fgets($sockRes,512);
			$mailData[$i].= $item;
		}
	
		list($head, $body) = mime_split($mailData[$i]);
		if (mailFilter($head)){
			$idx++;
			$delNoArray[$idx] = $i;
			$mailArray[$idx] = $mailData[$i];
		}
	}
	
	// 終了
	popConnect($sockRes, "QUIT");
	fclose($sockRes);

	//==============================================================
	/*
		取得メールコンバート
	*/

	$mailCnt = count($mailArray);

	for($idx=0;$idx<$mailCnt;$idx++) {
		$subject = "";
		$text = "";
		$part = "";

		list($head, $body) = mime_split($mailArray[$idx]);

		$head = ereg_replace("\r\n? ", "", $head);

		// マルチパートのみバウンダリに分割
		if (eregi("\nContent-type:.*multipart/",$head)) {
			eregi('boundary="([^"]+)"', $head, $boureg);
			$part = explode("--".$boureg[1],$body);
			if (eregi('boundary="([^"]+)"', $part[1], $boureg2)) {//multipart/altanative
				$npart = explode("--".$boureg2[1],$part[1]);
				array_splice($part, 1, 1, $npart);
			}

			foreach ($part as $multi) {
	
				list($m_head, $m_body) = mime_split($multi);

//print("**HEAD**<br>".$m_head."<br>");
//print("**BODY**<br>".$m_body."<br>");
//print("///==///<br>");
	
				$m_body = ereg_replace("\r\n\.\r\n$", "", $m_body);
				eregi("Content-type: *([^;\n]+)", $m_head, $type);
				list($main, $sub) = explode("/", $type[1]);
	
				// 本文をデコード
				if (strtolower($main) == "text") {
					$layerId	=	"";
					$memoId		=	"";
					$commentId	=	"";
					$accessKey	=	"";
	
					if (strtolower($sub) == "html" && $text != "") continue;
					if (eregi("Content-Transfer-Encoding:.*base64", $m_head)){
						$m_body = base64_decode($m_body);
					}
					if (eregi("Content-Transfer-Encoding:.*quoted-printable", $m_head)){
						$m_body = quoted_printable_decode($m_body);
					}
					$text = convert($m_body);
					if (strtolower($sub) == "html"){
						$text = strip_tags($text);
					}
	
					eregi("layerId=*([^;\n]+)", $text, $layerIdArr);
					eregi("memoId=*([^;\n]+)", $text, $memoIdArr);
					eregi("commentId=*([^;\n]+)", $text, $commentIdArr);
					eregi("accessKey=*([^;\n]+)", $text, $accessKeyArr);
	
					$layerId	=	trim($layerIdArr[1]);
					$memoId		=	trim($memoIdArr[1]);
					$commentId	=	trim($commentIdArr[1]);
					$accessKey	=	trim($accessKeyArr[1]);

					if (($memoId != "") || ($commentId != "")){
						$updMode = "";
						$putSts = FALSE;
	
						if (($commentId != "") && (is_null($commentId) == FALSE)){
							if (getCommentPermission($commentId, $accessKey)){
								$updMode = "1";
								$putSts = TRUE;
							}
						}else{
							if (getMemoPermission($memoId, $accessKey, $s_UserId)){
								$updMode = "0";
								$putSts = TRUE;
							}
						}
					}
				}
	
				// ファイル名を抽出
				if (eregi("name=\"?([^\"\n]+)\"?",$m_head, $filereg)) {
 					$oriFileName = ereg_replace("[\t\r\n]", "", $filereg[1]);
  					$fileExtension = strrchr($oriFileName, ".");
				}

				// 添付データをデコードして保存
				if (eregi("Content-Transfer-Encoding:.*base64", $m_head) && eregi(TEMP_TYPE, $sub)) {
	
					if ($putSts){
						// 軽度にファイル名を暗号化
						list($msec, $sec) = explode(" ", microtime()); 
//						$fileName = str_replace("/", "_", crypt(date('YmdHis', time()).(((float)$msec)*1000000), "kakikomap") . $fileExtension);
						$fileName = date('YmdHis', time()).(((float)$msec)*1000000) . $fileExtension;
						if ($updMode == "0"){

							if (updateMemo($memoId, $fileName)  == FALSE){
								trigger_error("Memo Modify Error", E_USER_ERROR);
								exit();
							}
						}else{
							if (updateComment($commentId, $fileName) == FALSE){
								trigger_error("Comment Modify Error", E_USER_ERROR);
								exit();
							}
						}
	
						$tmpImg = base64_decode($m_body);
						if (strlen($tmpImg) < MOBILE_MAX_SIZE){
							$openResfp = fopen(MOBILE_IMG_DIR.$fileName, "w");
							if ($openResfp){
								fputs($openResfp, $tmpImg);
								fclose($openResfp);
							}else{
								trigger_error("Mail Image Taking Error", E_USER_ERROR);
								exit();
							}
						}
					}
				}
			}
		}
	}

	// 対象データの削除
	if (count($delNoArray) > 0){

		$sockRes = fsockopen(POP_SERVER_ADDR, 110, $errNo, $errStr, 10);

		if ($sockRes == FALSE){
			trigger_error("POP Connect Error:$errStr($errNo)", E_USER_ERROR);
			exit();
		}
		
		$RetCode = fgets($sockRes, 512);
		if(substr($RetCode, 0, 3) != '+OK'){
			trigger_error("POP Get Error", E_USER_ERROR);
			exit();
		}
		
		if (popConnect($sockRes, "USER ".POP_USER) == FALSE){
			trigger_error("POP Authentication  Error", E_USER_ERROR);
			exit();
		}
		if (popConnect($sockRes, "PASS ".POP_PASS) == FALSE){
			trigger_error("POP Authentication  Error", E_USER_ERROR);
			exit();
		}
		
		//STAT -件数とサイズ取得 +OK no size
		$mailStat = popConnect($sockRes, "STAT");
		if ($mailStat == FALSE){
			trigger_error("POP STAT  Error", E_USER_ERROR);
			exit();
		}

		sscanf($mailStat, '+OK %d %d', $num, $size);
		if ($num == "0") {
			// 終了
			popConnect($sockRes, "QUIT");
			fclose($sockRes);
			exit;
		}

		for($idx = 0; $idx < count($delNoArray); $idx++){
			//DELE n n番目のメッセージ削除
			if (popConnect($sockRes, "DELE " . $delNoArray[$idx]) == FALSE){
				trigger_error("POP Delete  Error", E_USER_ERROR);
				exit();
			}
		}

		// 終了
		popConnect($sockRes, "QUIT");
		fclose($sockRes);

	}

	//正常の場合、トップページへRedirect
    header("location: ./index.php");
	exit();
}

$o_smarty->assign("errormessage", $errorMessage);
$o_smarty->assign("labelArray", $labelArray);
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要	：メモ存在チェック
* 処理詳細	：メモ存在チェック
*
* @引数		：	(I) memoid	- メモID
*               (I) upddate	- 登録日付
*               (I) userId	- ユーザID
*
* @戻値		：	bool		- TRUE	正常
*							- FALSE	異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getMemoPermission($memoid, $upddate, $userId){
 
	$returnSts		=	FALSE;
	if (is_numeric($memoid)){
		$viewService	=	new ContentsViewService(DIRECTORY_NAME);
		$memoRecord		=	$viewService->getOneMemoDetailViewDataAuth($memoid, $userId);
	
		if (is_null($memoRecord)  == FALSE){
			if ($upddate == md5(str_replace("/", "-", $memoRecord->getUpdateDateTime_d()))){ 
				$returnSts = TRUE; 
			}
		}
	}

	return $returnSts;

}

/**
* 関数概要	：コメント存在チェック
* 処理詳細	：コメント存在チェック
*
* @引数		：	(I) commentoid	- ユーザID
* 				(I) upddate		- ユーザID
*
* @戻値		：	bool		- TRUE	正常
*							- FALSE	異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getCommentPermission($commentid, $upddate){
 
	$returnSts		=	FALSE;
	if (is_numeric($commentid)){
	  	$viewService	=	new ContentsViewService(DIRECTORY_NAME);
		$commentRecord		=	$viewService->getOneCommentData($commentid);
	
		if (is_null($commentRecord)  == FALSE){
			if ($upddate == md5(str_replace("/", "-", $commentRecord->getUpdateDateTime_c()))){ 
				$returnSts = TRUE; 
			}
		}
	}

	return $returnSts;

}

/**
* 関数概要	：POP3コマンド送信
* 処理詳細	：POP3コマンド送信
*
* @引数		：	(I) resource	- ユーザID
*					cmd			- コマンド
*
* @戻値		：	string/bool		- string	正常
*								- FALSE		異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function popConnect($resource, $cmd) {
	fputs($resource, $cmd."\r\n");
	$result = fgets($resource, 512);
	if(substr($result, 0, 3) == '+OK') {
		return $result;
	}

	return false;
}

/**
* 関数概要	：対象メール選別
* 処理詳細	：画像添付メールの選別
*
* @引数		：	(I) header	- メールヘッダー
*
* @戻値		：	bool		- TRUE	正常
*							- FALSE	異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function mailFilter($header) {

	$targetSub      =       "KakikoMap Image";
	$subject        =       "";

	if (eregi("\nSubject:[ \t]*([^\r\n]+)", $header, $subArray)) {
		$subject = $subArray[1];
	}

	if ($subject == $targetSub){
		return TRUE;
	}else{
		return FALSE;
	}
}

/**
* 関数概要	：メール分割
* 処理詳細	：ヘッダと本文を分割する
*
* @引数		：	(I) header	- メールヘッダー
*
* @戻値		：	array		- ヘッダー
*							- ボディ
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function mime_split($data) {
	$part = split("\r\n\r\n", $data, 2);
	$part[1] = ereg_replace("\r\n[\t ]+", " ", $part[1]);

	return $part;
}

/**
* 関数概要	：メール分割
* 処理詳細	：ヘッダと本文を分割する
*
* @引数		：	(I) str	- 文字列
*
* @戻値		：	string/bool	- string	正常
*							- FALSE		異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
//****************************************
// 文字コードコンバートJIS→SJIS
//****************************************
function convert($str) {
	if (function_exists('mb_convert_encoding')) {
		return mb_convert_encoding($str, "SJIS", "JIS,SJIS,UTF-8");
	} elseif (function_exists('JcodeConvert')) {
		return JcodeConvert($str, 0, 2);
	}

	return TRUE;
}

/**
* 関数概要	：メモ詳細テーブル更新
* 処理詳細	：メモ詳細テーブル　ファイル名更新
*
* @引数		：	(I) userid	- ユーザID
*
* @戻値		：	bool		- TRUE	正常
*							- FALSE	異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function updateMemo($memoid, $filename){

	// UPDATE
	$viewService = new ContentsViewService(DIRECTORY_NAME);

	//更新列の設定
	// メモ詳細情報
	$target = new MemoDetailData();
	$target->setMemoID(WHERE_KEY);
	$target->setImageFile(VAL_TARGET);
	$target->setUpdateDateTime(VAL_TARGET);

	// メモ詳細情報
	$detail = new MemoDetailData();
	$detail->setMemoID($memoid);
	$detail->setImageFile($filename);
	$detail->setUpdateDateTime(date("Y-m-d H:i:s"));

	if ($viewService->updateMemoDetailDataByKey($target, $detail) == FALSE){
		trigger_error("Update Error", E_USER_ERROR);
		exit(-1);
	}

	return TRUE;
}

/**
* 関数概要	：コメントテーブル更新
* 処理詳細	：コメントテーブル　ファイル名更新
*
* @引数		：	(I) userid		- ユーザID
*				(I) filename	- ファイル名
* @戻値		：	bool			- TRUE	正常
*								- FALSE	異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function updateComment($commentid, $filename){
 
		// コメント情報
	$target = new CommentData();
	$target->setCommentID(WHERE_KEY);
	$target->setImageFile(VAL_TARGET);
	$target->setUpdateDateTime(VAL_TARGET);

	$comment = new CommentData();
	$comment->setCommentID($commentid);
	$comment->setImageFile($filename);
	$comment->setUpdateDateTime(date('Y/m/d H:i:s'));

	$viewService = new ContentsViewService(DIRECTORY_NAME);

	if ($viewService->updateCommentDataByKey($target, $comment) == FALSE){
		trigger_error("Comment Error", E_USER_ERROR);
		exit(-1);
	}

	return TRUE;
}

?>