<?php
/**
* G06-001
* index.php 処理概要：携帯電話用トップページ
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// マップ公開区分が非公開(9)の場合公開停止画面へリダイレクト
if(MAP_PUBLIC == 9){
	header("location: ".dirname($_SERVER['PHP_SELF'])."/mobileclosed.html");
	exit(-1);
}

$mobileSts = TRUE;

//携帯電話使用可能判定
if (popCheck() == FALSE){
	$labelArray = array(
		"label01"  => "Contents Name",
		"label02"  => mbConvertEncoding($o_resource->getValue("G06001M013"), "SJIS"),
		"label03"  => mbConvertEncoding($o_resource->getValue("G06001M014"), "SJIS"),
		"label04"  => "",
		"label05"  => "",
		"label06"  => $linkTag
	);

	$mobileSts = FALSE;
	$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
}

if ($mobileSts){
	// ログイン処理
	if(!isset($_SESSION['LOGINMODE'])){
		if(MAP_AUTOLOGIN == 1){
			require_once("./userauth.php");
		}
		// SESSIONに「LOGINMODE」を設定
		$_SESSION['LOGINMODE'] = MAP_AUTOLOGIN;
	}

	// ユーザエージェントチェック
	/* テスト用
	$dmy = "a";
	switch($dmy){
	*/
	switch(user_agent()){
		case "a":
			$url		=	getProtocol()
						.	$_SERVER["SERVER_NAME"]
						.	dirname($_SERVER["PHP_SELF"])
						.	"/selectlayer.php";
	
			$linkTag	=	"<a href=\""
						.	"device:gpsone" 			// 位置情報 location:簡易位置 gpsone:GPS
						.	"?url="		.	$url		// 戻り先
						.	"&ver="		.	"1"			// 通信Version
						.	"&datum="	.	"0"			// 測地系 0:WGS84 1:TOKYO 2:ITRF
						.	"&unit="	.	"1"			// 座標系 0:DMS 1:DEGREE
						.	"&acry="	.	"0"			// 位置情報精度 0:Free
						.	"&number="	.	"0"			// 要求測位回数 0:Default（1回） 1～:回数
						.	"\">"
						.	mbConvertEncoding($o_resource->getValue("G06001L001"), "SJIS")
						.	"</a>";
	
			$labelArray = array(
				"label01"  => "Contents Name",
				"label02"  => mbConvertEncoding($o_resource->getValue("G06001L001"), "SJIS"),
				"label03"  => mbConvertEncoding($o_resource->getValue("G06001L002"), "SJIS"),
				"label04"  => mbConvertEncoding($o_resource->getValue("G06001L003"), "SJIS"),
				"label05"  => mbConvertEncoding($o_resource->getValue("G06001L004"), "SJIS"),
				"label06"  => $linkTag
			);
	
			$tplName	=	DIRECTORY_NAME."/mobilelocation.tpl";
			break;
		case "d":
		case "v":
			$linkTag	=	"";
	
			$labelArray = array(
				"label01"  => "Contents Name",
				"label02"  => mbConvertEncoding($o_resource->getValue("G06001M001"), "SJIS"),
				"label03"  => mbConvertEncoding($o_resource->getValue("G06001M002"), "SJIS"),
				"label04"  => mbConvertEncoding($o_resource->getValue("G06001M003"), "SJIS"),
				"label05"  => "",
				"label06"  => $linkTag
			);
	
			$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
			break;
		default:
		    header("location: ../index.php");
		    break;
	}
}

$viewService = new ContentsViewService(DIRECTORY_NAME);
$mapData = $viewService->getContentsName();
$labelArray['label01'] = mbConvertEncoding($mapData->getContentsName(), "SJIS");

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

$o_smarty->assign("labelArray", $labelArray);
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：POP3接続判定
* 処理詳細：メール取得不可の場合、携帯電話機能を使用不可とする
*
* @引数： (I)
* @戻値： bool		- TRUE	正常
*					- FALSE	異常
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function popCheck(){

	$popSts = TRUE;

	if ((POP_SERVER_ADDR == "") || (POP_USER == "") || (POP_PASS == "")){
		return 	FALSE;
	}
		
	// POPサーバ接続・取得
	$sockRes = fsockopen(POP_SERVER_ADDR, 110, $errNo, $errStr, 10);
	if ($sockRes == FALSE){
		return 	FALSE;
	}
	
	$RetCode = fgets($sockRes, 512);
	if(substr($RetCode, 0, 3) != '+OK'){
		$popSts = FALSE;
	}
	
	if (popConnect($sockRes, "USER ".POP_USER) == FALSE){
		$popSts = FALSE;
	}
	if (popConnect($sockRes, "PASS ".POP_PASS) == FALSE){
		$popSts = FALSE;
	}

	// 終了
	popConnect($sockRes, "QUIT");
	fclose($sockRes);

	return 	$popSts;

}
/**
* 関数概要	：POP3コマンド送信
* 処理詳細	：POP3コマンド送信
*
* @引数		：	(I) resource	- ユーザID
*					cmd			- コマンド
*
* @戻値		：	string/bool		- string	正常
*								- FALSE		異常
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function popConnect($resource, $cmd) {
	fputs($resource, $cmd."\r\n");
	$result = fgets($resource, 512);
	if(substr($result, 0, 3) == '+OK') {
		return $result;
	}

	return false;
}


?>