<?php
/**
* G06-005
* memoregist.php 処理概要：携帯電話用メモ投稿処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");					//Directory(PREFIX)読み込み

//require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");	//DBアクセスサービスクラス
require_once("class/db/tabledata/MemoDetailData.class.php");
require_once("class/db/tabledata/MemoPositionData.class.php");
require_once("class/db/tabledata/CommentData.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");
require_once("class/xml/RSSController.class.php");			// RSS

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

$pageFlg		= 0;
$errorMessage	= "";
$tplName		= "";
$errorFileSize	= "";
$errorFileType	= "";
$filecheck		= TRUE;
$targetTypeId	= "";

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ユーザエージェントチェック
$agent	=	false;

/* テスト用
$dmy = "a";
switch($dmy){
*/
switch(user_agent()){
	case "a":
		$tplName	=	DIRECTORY_NAME."/mobilememoregist.tpl";
		$agent	=	true;
		break;
	case "d":
	case "v":
		// 座標情報取得

		$linkTag	=	"";

		$labelArray = array(
			"label01"  => "Contents Name",
			"label02"  => mbConvertEncoding($o_resource->getValue("G06005M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06005M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06005M003"), "SJIS")
		);
		$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

$lat		=	null;
$lon		=	null;
$layerId	=	null;

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if ($agent){
	//GET引数取得
	if ($_SERVER["REQUEST_METHOD"] == "POST"){
		$lat		= postInfo("lat");
		$lon		= postInfo("lon");
		$layerId	= postInfo("layerId");
		$name		= postInfo("name");
		$title		= postInfo("title");
		$text		= postInfo("text");
		if ($text == ""){
			$text	=	"";
		}
		$mail		= postInfo("mail");
		$url		= postInfo("url");
		$updDelPwd	= postInfo("updDelPwd");
	}else{
		if ($_SERVER["REQUEST_METHOD"] == "GET"){
			$lat		= getInfo("lat");
			$lon		= getInfo("lon");
			$layerId	= getInfo("layerId");
		}
	}
	
	if (is_null($lat) || is_null($lon) || is_null($layerId)){
		$illegalMessage = mbConvertEncoding($o_resource->getValue("G06005M018"), "SJIS");
		$labelArray = array(
			"label01"  => "Illegal Error",
			"label02"  => "",
			"label03"  => "",
			"label04"  => ""
		);
		$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
	}else{
		// レイヤー情報取得
		$layerArray	=	getLayerList($s_UserId);
		if (array_key_exists($layerId, $layerArray) == FALSE){
			$illegalMessage = mbConvertEncoding($o_resource->getValue("G06005M018"), "SJIS");
			$labelArray = array(
				"label01"  => "Illegal Error",
				"label02"  => "",
				"label03"  => "",
				"label04"  => ""
			);
			$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
		}

	}

	if ($illegalMessage == ""){
		// QuickForm インスタンス化
		$o_form = new HTML_QuickForm("memoRegistForm", "POST", $_SERVER["PHP_SELF"], "_self");
		
		// 項目セット
		$o_form->addElement("header",   "header",    mbConvertEncoding($o_resource->getValue("G06005L001"), "SJIS"));
		$o_form->addElement("text",     "name",      mbConvertEncoding($o_resource->getValue("G06005L002"), "SJIS"), array("size"=>"20", "maxlength"=>"32", "autocomplete"=>"off", "class"=>"fs16_black"));
		$o_form->addElement("text",     "title",     mbConvertEncoding($o_resource->getValue("G06005L003"), "SJIS"), array("size"=>"20", "maxlength"=>"20", "autocomplete"=>"off", "class"=>"fs16_black"));
		$o_form->addElement("textarea", "text",      mbConvertEncoding($o_resource->getValue("G06005L004"), "SJIS"), array("maxlength"=>"500", "autocomplete"=>"off", "class"=>"fs16_black", "cols"=>"20", "rows"=>"5"));
		$o_form->addElement("text",     "mail",      mbConvertEncoding($o_resource->getValue("G06005L005"), "SJIS"), array("size"=>"20", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs16_black"));
		$o_form->addElement("text",     "url",       mbConvertEncoding($o_resource->getValue("G06005L006"), "SJIS"), array("size"=>"20", "autocomplete"=>"off", "class"=>"fs16_black"));
		$o_form->addElement("password", "updDelPwd", mbConvertEncoding($o_resource->getValue("G06005L007"), "SJIS"), array("size"=>"4", "maxlength"=>"4", "format"=>"4x", "class"=>"fs14_black"));
		
		// 独自チェックルールの定義
		$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

		// チェック項目
		$o_form->addRule("name",      mbConvertEncoding($o_resource->getValue("G06005M004"), "SJIS"), "required");
		$o_form->addRule("name",  	  mbConvertEncoding($o_resource->getValue("G06005M005"), "SJIS"), "maxlength_valid",   32);
		$o_form->addRule("title",     mbConvertEncoding($o_resource->getValue("G06005M006"), "SJIS"), "required");
		$o_form->addRule("title",  	  mbConvertEncoding($o_resource->getValue("G06005M007"), "SJIS"), "maxlength_valid",	20);
		$o_form->addRule("text",  	  mbConvertEncoding($o_resource->getValue("G06005M008"), "SJIS"), "maxlength_valid",	500);
		$o_form->addRule("mail",  	  mbConvertEncoding($o_resource->getValue("G06005M009"), "SJIS"), "email",	null);
		$o_form->addRule("mail",	  mbConvertEncoding($o_resource->getValue("G06005M010"), "SJIS"), "maxlength_valid",	128);
		$o_form->addRule("url",  	  mbConvertEncoding($o_resource->getValue("G06005M011"), "SJIS"), "regex",	"/^(http|https)?(:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?)/");
		$o_form->addRule("url",	      mbConvertEncoding($o_resource->getValue("G06005M012"), "SJIS"), "maxlength_valid",	128);
		$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06005M013"), "SJIS"), "regex", "/^[a-zA-Z0-9]+$/");
		$o_form->addRule("updDelPwd", mbConvertEncoding($o_resource->getValue("G06005M014"), "SJIS"), "maxlength_valid",	4);
		
		// 登録ボタン
		if (array_key_exists( "memoRegist", $_POST)){
		
			if (array_key_exists( "memoType", $_POST)) {
	    		$targetTypeId	=	$_POST["memoType"];
		    }else{
				$errorMemoType = mbConvertEncoding($o_resource->getValue("G06005M016"), "SJIS");
		    }
		
		    // チェックOK
		    if ($o_form->validate()){
		
				$uploadfileName	=	"";

		        // **************************
		        // DB登録処理実装部
		        // **************************
		
				$idArray = explode("_", $_POST["memoType"]);
		
				$curDate = date('Y/m/d H:i:s');
	
				// メモ位置情報
				$position = new MemoPositionData();
				$position->setMemoTypeID($idArray[1]);
				$position->setLongitude($lon);
				$position->setLatitude($lat);
				$position->setDeleteFlg(KAKIKOMAP_DELETEFLG_OFF);
				$position->setAddDateTime($curDate);
				$position->setUpdateDateTime($curDate);
			
				// メモ詳細情報
				$detail = new MemoDetailData();
				$detail->setMemoTypeID($idArray[1]);
				$detail->setUserName($name);
				$detail->setMemoTitle($title);
				$detail->setMemoText($text);
				$detail->setMailAddress($mail);
				$detail->setReleteURL($url);
				$detail->setImageFile($uploadfileName);
				$detail->setUpdateDeletePassword($updDelPwd);
				$detail->setAccessCount("0");
				$detail->setDeleteFlg(KAKIKOMAP_DELETEFLG_OFF);
				$detail->setAddDateTime($curDate);
				$detail->setUpdateDateTime($curDate);
	
				// INSERT
				$viewService = new ContentsViewService(DIRECTORY_NAME);
				if(!$viewService->insertMemoMobile($detail, $position, $memoId, $updDate)){
					trigger_error("DB Error!!", E_USER_ERROR);
				    exit(-1);
				}

				// RSS出力
				$rss = new RSSController($idArray[0], DIRECTORY_NAME);
				if(!$rss->writeRssFile()){
					trigger_error("RSS Error!!", E_USER_ERROR);
				    exit(-1);
				}

				$pageFlg = 1;
		    }
		}else{
		
			// 入力項目のデフォルトをセット
			$o_form->setDefaults(
				array(
			    	"name"      => "",
			    	"title"     => "",
			    	"text"      => "",
			    	"mail"      => "",
			    	"url"       => "",
			    	"updDelPwd" => ""
				)
			);	
		}
	}

	if ($illegalMessage == ""){
		// ボタンを表示
		if ($pageFlg == 0){
		    // 登録画面
		 	$o_form->addElement("hidden", "lat", $lat);
		 	$o_form->addElement("hidden", "lon", $lon);
		 	$o_form->addElement("hidden", "layerId", $layerId);
		    $o_form->addElement("submit", "memoRegist", mbConvertEncoding($o_resource->getValue("G06005L009"), "SJIS"), array("class"=>"fs12_black"));
		
			$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
			$o_form->accept($o_renderer);
			$o_smarty->assign("form", $o_renderer->toArray());
			$labelArray = array(
		      "label01"  => mbConvertEncoding($o_resource->getValue("G06005M015"), "SJIS"),
		      "label02"  => mbConvertEncoding($o_resource->getValue("G06005M017"), "SJIS")
			);
		
		    $o_smarty->assign("radioId", $targetTypeId);
	
			// メモ種類ラジオボタン取得
			$layerMemoTypeArray = getLayerMemoTypeData($s_UserId, $layerId);
			$o_smarty->assign("layerMemoTypeArray", $layerMemoTypeArray);
			$o_smarty->assign("errorMemoType", $errorMemoType);
			$o_smarty->assign("errorMessage", $errorMessage);
		} else {
		    // 完了画面

		    $mailTo		= MOBILE_MAIL_ADDR;
		    $mailBody	= "layerId="	. $layerId		. "\n"
		    			. "memoId="		. $memoId		. "\n"
		    			. "commentId="	. $commentId	. "\n"
		    			. "accessKey="	. md5(str_replace("/", "-", $updDate))	. "\n";
		    $mailStr	= "<a href='mailto:" 
		    			. $mailTo 
		    			. "?subject=KakikoMap Image"
		    			. "&body=" . $mailBody . "'>"
		    			. mbConvertEncoding($o_resource->getValue("G06005M021"), "SJIS")
		    			. "</a>";

		    $returnStr	= "<a href='getmail.php'>"
		    			. mbConvertEncoding($o_resource->getValue("G06005M024"), "SJIS")
		    			. "</a>";

			$labelArray = array(
				"label01"  => mbConvertEncoding($o_resource->getValue("G06005M019"), "SJIS"),
				"label02"  => mbConvertEncoding($o_resource->getValue("G06005M020"), "SJIS"),
				"label03"  => $mailStr,
				"label04"  => mbConvertEncoding($o_resource->getValue("G06005M022"), "SJIS"),
				"label05"  => mbConvertEncoding($o_resource->getValue("G06005M023"), "SJIS"),
				"label06"  => $returnStr
			);
			$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
		}
	}else{
		$o_smarty->assign("errorMessage", $illegalMessage);
	}
}

$o_smarty->assign("labelArray", $labelArray);
$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要	：レイヤーデータ取得
* 処理詳細	：レイヤーデータ取得
*
* @引数		：	(I) userid	- ユーザID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getLayerList($userid){
 
  	$viewService		=	new ContentsViewService(DIRECTORY_NAME);

	if (is_null($userid)){
		$layerRecord	=	$viewService->getLayerListData_Guest();
	}else{
		$layerRecord	=	$viewService->getLayerListData($userid);
	}
	
	if (is_null($layerRecord)){
		$retArray = null;
	}else{
		$retArray = array();
		for($i=0; $i<count($layerRecord);$i++){
			$retArray[$layerRecord[$i]->getlayerID_Layer()] = 
				mbConvertEncoding($layerRecord[$i]->getlayerName_Layer(), "SJIS"); 
		}
	}

	return $retArray;

}

/**
* 関数概要：メモ種類データ取得
* 処理詳細：メモ種類データを取得・整形する
*
* @引数： (I) userid	- string  ユーザID
* @戻値： array メモ種類情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getLayerMemoTypeData($userid, $layerid) {

	$service = new ContentsViewService(DIRECTORY_NAME);
	
	$recordData = null;
	if($userid == null){
		$recordData = $service->getMapControllDataByGuest("2");
	}else{
		$recordData = $service->getMapControllDataByUser($userid, "2");
	}

	$layerMemoTypeList = array();
	$memoArrayList = array();
	$layerId = "";
	$layerName ="";
	foreach($recordData as $data){
		// レイヤーIDごとのリストを生成する
		if($layerid == $data->getLayerID()){
			if($layerId == ""){
				$layerId = mbConvertEncoding($data->getLayerID(), "SJIS");
				$layerName = mbConvertEncoding($data->getLayerName(), "SJIS");
			}
		
			// アイコンタイプでアドレス切り替え
			$iconPath = "";
			if($data->getIconType() == 0){
				$iconPath = "../../img/icon/".$data->getIcon();
			}else{
				$iconPath = "./img/icon/".$data->getIcon();
			}
			$memoArray = array(
				'typeid'   => mbConvertEncoding($data->getMemoTypeID(), "SJIS"),
				'typename' => mbConvertEncoding($data->getMemoTypeName(), "SJIS"),
				'ico'       => mbConvertEncoding($iconPath, "SJIS"),
				'ribbon'   => mbConvertEncoding($data->getRibbonColor(), "SJIS")
			);
			array_push($memoArrayList, $memoArray);	
		}
	}
	if($layerId != ""){
		$layerArray = array(
						'layerid'  => $layerId, 
						'layername'  => $layerName,
					$memoArrayList);
		array_push($layerMemoTypeList, $layerArray);
	}
	return $layerMemoTypeList;	
}

?>