<?php
/**
* G06-002
* selectlayer.php 処理概要：携帯電話用レイヤー選択
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoMobileCommon.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ユーザエージェントチェック
$agent	=	false;
/* テスト用
$dmy = "a";
switch($dmy){
*/
switch(user_agent()){
	case "a":
		$labelArray = array(
			"label01"  => "Contents Name",
			"label02"  => mbConvertEncoding($o_resource->getValue("G06002L001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06002L002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06002L003"), "SJIS")
		);
		$tplName	=	DIRECTORY_NAME."/mobileselectlayer.tpl";
		$agent	=	true;
		break;
	case "d":
	case "v":
		// 座標情報取得

		$linkTag	=	"";

		$labelArray = array(
			"label01"  => "Contents Name",
			"label02"  => mbConvertEncoding($o_resource->getValue("G06002M001"), "SJIS"),
			"label03"  => mbConvertEncoding($o_resource->getValue("G06002M002"), "SJIS"),
			"label04"  => mbConvertEncoding($o_resource->getValue("G06002M003"), "SJIS")
		);
		$tplName	=	DIRECTORY_NAME."/mobilecommon.tpl";
		break;
	default:
    	header("location: ../index.php");
	    break;
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if ($agent){
	// 座標情報取得
	$lat = null;
	$lon = null;
	$layerItem = "";

	if ($_SERVER["REQUEST_METHOD"] == "GET"){
		$lat = getInfo("lat");
		$lon = getInfo("lon");
	}else{
		$lat = postInfo("lat");
		$lon = postInfo("lon");
		$layerItem = postInfo("layerItem");
	}
	if ((is_null($lat)) || (is_null($lon))){
		$errorMessage = mbConvertEncoding($o_resource->getValue("G06002M004"), "SJIS");
	}

	// QuickForm インスタンス化
	$o_form = new HTML_QuickForm("selectForm", "post", $_SERVER['PHP_SELF'], "_self");
	$o_form->addRule("layerItem",  mbConvertEncoding($o_resource->getValue("G06002M005"), "SJIS"), "required");

	// 決定ボタン
	if (array_key_exists( "sendBtn", $_POST)){

		if ($_POST[layerItem] == ""){
			$errorMessage = mbConvertEncoding($o_resource->getValue("G06002M005"), "SJIS");
		}else{
			// Redirect
			$redireUrl = "./memoregist.php?lat=" . $lat . "&lon=" . $lon . "&layerId=" . $layerItem;
			header("location: " . $redireUrl);
			exit();
		}
	}

	// レイヤー情報取得
	$layerArray	=	getLayerList($s_UserId);

	if (is_null($layerArray)){
		$errorMessage = mbConvertEncoding($o_resource->getValue("G06002M006"), "SJIS");
	}else{
	//	$o_form = new HTML_QuickForm("selectForm", "post", $_SERVER['PHP_SELF'], "_self");
		$o_form->addElement("hidden", "lat", $lat);
		$o_form->addElement("hidden", "lon", $lon);
		$o_form->addElement("submit", "sendBtn", mbConvertEncoding($o_resource->getValue("G06002L004"), "SJIS"), array("class"=>"fs12_black"));

		$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_form->accept($o_renderer);
		$o_smarty->assign("layer_radios", $layerArray);
		$o_smarty->assign("layer_id", $layerItem);
		$o_smarty->assign("form", $o_renderer->toArray());
	}
}

$viewService = new ContentsViewService(DIRECTORY_NAME);
$mapData = $viewService->getContentsName();
$labelArray['label01'] = mbConvertEncoding($mapData->getContentsName(), "SJIS");

$o_smarty->assign("errormessage", $errorMessage);
$o_smarty->assign("labelArray", $labelArray);
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：GET引数取得
* 処理詳細：GET引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getInfo($arg){
	$returnData	=	null;
	$getData	=	null;
	if (array_key_exists($arg, $_GET)){
		$getData	=	trim($_GET[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
/*
			$getData	=	trim($_GET[$arg]);

			if (preg_match("/^\d{1,3}\.\d{1,2}\.\d{1,2}\.\d{1,2}$/", $getData)){
				$dataArray = explode(".", $getData);
				if (count($dataArray) == 4){
					$returnData = 
						$dataArray[0] + $dataArray[1]/60 + $dataArray[2]/3600 + $dataArray[3]/360000;
				}
			}
*/
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要：POSTT引数取得
* 処理詳細：POST引数を取得し、内部エンコーディングに変換して返す
*
* @引数： (I) arg	- string  パラメータ名
* @戻値： 			- string　変換後パラメータ
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function postInfo($arg){
	$returnData	=	null;
	$getData	=	null;

	if (array_key_exists($arg, $_POST)){
		$getData	=	trim($_POST[$arg]);

		if ($getData != ""){
			$returnData	=	mbConvertDecoding($getData);
		}else{
			$returnData	=	null;
		}
	}

	return 	$returnData;

}

/**
* 関数概要	：レイヤーデータ取得
* 処理詳細	：レイヤーデータ取得
*
* @引数		：	(I) userid	- ユーザID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getLayerList($userid){
 
  	$viewService		=	new ContentsViewService(DIRECTORY_NAME);

	if (is_null($userid)){
		$layerRecord	=	$viewService->getLayerListData_Guest();
	}else{
		$layerRecord	=	$viewService->getLayerListData($userid);
	}
	
	if (is_null($layerRecord)){
		$retArray = null;
	}else{
		$retArray = array();
		for($i=0; $i<count($layerRecord);$i++){
			$retArray[$layerRecord[$i]->getlayerID_Layer()] = 
				mbConvertEncoding($layerRecord[$i]->getlayerName_Layer(), "SJIS"); 
		}
	}

	return $retArray;

}

?>