<?php
/**
* G04-009
* positionedit.php 処理概要：メモ位置変更処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");								//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");
require_once("class/db/service/ContentsViewService.class.php");
require_once("class/common/MapController.class.php");
require_once("class/db/tabledata/MemoPositionData.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザIDを取得
$s_UserId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
}
// POSTされてきたらその座標で地図を表示
// それぞれの矢印にクリック後のGET文字列を生成

$mapController;	// まっぷコントロールクラスオブジェクト
$scaleString;	// スケール文字列
$mapExt;		// 現在表示されているエリアを表す配列

$requestMemoId = "";
$pageFlg = 0;

if ($_SERVER["REQUEST_METHOD"] == "POST"){
	if(isset($_POST['memoId'])){
		$requestMemoId = $_POST["memoId"];
	}
}else{
	if(isset($_GET['memoId'])){
		$requestMemoId = $_GET["memoId"];
	}
}

if(isset($_GET['scale'])){
	$scaleString = $_GET['scale'];
}else{
	if(MAP_TYPE == 0){
		// GISは「初期表示」固定
		$scaleString = "1";
	}else{
		// マップ管理者設定の初期表示マップ番号を取得
		$viewService = new ContentsViewService(DIRECTORY_NAME);
		$mapDetailData = $viewService->getMapDetailInitialImage();
		$scaleString = sprintf("%03d", $mapDetailData->getMapNumber());
	}
}

$layerTableData = null;
if(isset($_GET['mapext']) && (!isset($_GET['reset']))){
	$arr = explode(" ", $_GET['mapext']);
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}elseif((isset($_POST['mapext'])) && (isset($_POST['area_height']))){
	// 座標更新
	$arr = explode(" ", $_POST['mapext']);
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}else{
	// 初期表示座標の取得
	$arr = null;
	if($s_UserId == null && isset($_COOKIE[LAYERPRIORITY])){
		// ゲストかつクッキーが存在した場合
        $layer_array = explode(",", $_COOKIE[LAYERPRIORITY]);
        // クッキーに設定されている1番上位のレイヤーテーブル情報を取得する
        if($layer_array != null){
			$service = new ContentsViewService(DIRECTORY_NAME);
			$layerTableData = $service->getLayerOneData($layer_array[0]);
			if(MAP_TYPE == 0){
				if($layerTableData->getStartX() == null && $layerTableData->getStartY() == null
						&& $layerTableData->getEndX() == null && $layerTableData->getEndY() == null){
					// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
					$arr = explode(",", MAP_INITPOSITION);
				}else{
						$arr = array($layerTableData->getStartX(),
										$layerTableData->getStartY(),
										$layerTableData->getEndX(),
										$layerTableData->getEndY()
									);
				}
			}else{
				// レイヤー管理者設定の初期表示マップ設定を構成(スケールは座標算出後に書き換え)
				$mapDetailData = $service->getMapJoinMapDetailData($layerTableData->getCenterScale());
				$arr = getChangeInitialCoordinatesFromScaleNoGis((int)$scaleString, $mapDetailData);	
				$scaleString = sprintf("%03d", $layerTableData->getCenterScale());
			}
        }else{
			$arr = explode(",", MAP_INITPOSITION);
        }
	}else{
		// クッキーが存在しない場合
		$service = new ContentsViewService(DIRECTORY_NAME);
		$layerTableData = $service->getTopPriorityLayerData($s_UserId);
		if($layerTableData == null){
			$arr = explode(",", MAP_INITPOSITION);
		}else{
			if(MAP_TYPE == 0){
				if($layerTableData->getStartX() == null && $layerTableData->getStartY() == null
						&& $layerTableData->getEndX() == null && $layerTableData->getEndY() == null){
					// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
					$arr = explode(",", MAP_INITPOSITION);
				}else{
					$arr = array($layerTableData->getStartX(),
									$layerTableData->getStartY(),
									$layerTableData->getEndX(),
									$layerTableData->getEndY()
								);
				}
			}else{
				// レイヤー管理者設定の初期表示マップ設定を構成(スケールは座標算出後に書き換え)
				$mapDetailData = $service->getMapJoinMapDetailData($layerTableData->getCenterScale());
				$arr = getChangeInitialCoordinatesFromScaleNoGis((int)$scaleString, $mapDetailData);	
				$scaleString = sprintf("%03d", $layerTableData->getCenterScale());
			}
		}
	}
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}
$mapExt = $mapController->get_minX()." ".$mapController->get_minY()." ".$mapController->get_maxX()." ".$mapController->get_maxY();
	
// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// 座標情報をhiddenへセット
if((isset($_POST['mapext'])) && (isset($_POST['area_height']))){
	$longLat = $mapController->get_changeCoordinatesFromJs($_POST['area_width'], $_POST['area_height'], $_POST['click_x'], $_POST['click_y']);
	$pageFlg = 1;
}

if ($pageFlg == 0) {
	// リソースファイル読込みインスタンス
	$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);
	$labelArray = array(
		"windowTitle"    => $o_resource->getValue("G04009L001"),
		"rangeInMap"     => $o_resource->getValue("G04009L002")
	);

	// QuickForm インスタンス化
	$o_form = new HTML_QuickForm("kakikoPositionMap", "POST", $_SERVER["PHP_SELF"], "_self");

	// チェックボックス＆ラジオボタンの設定
	$memoDisplay = 0;
	$kakikoChecked = "";
	if(isset($_GET['memoDisplay']) && $_GET['memoDisplay'] == 1) $memoDisplay = 1;

	$o_form->setDefaults(
		array(
			'memoDisplay' => $memoDisplay
		)
	);

	$o_form->addElement("radio",    "memoDisplay", $o_resource->getValue("G04009L003"),   "", 0, array("onclick"=>"memoRegistRadioChange(0);","checked"=>"checked","class"=>"fs12_black"));
	$o_form->addElement("radio",    "memoDisplay", $o_resource->getValue("G04009L004"), "", 1, array("onclick"=>"memoRegistRadioChange(1);","class"=>"fs12_black"));
	$o_form->addElement("hidden",   "memoId",     $requestMemoId);
	$o_form->addElement("hidden",   "area_height", "");
	$o_form->addElement("hidden",   "area_width",  "");
	$o_form->addElement("hidden",   "click_x",     "");
	$o_form->addElement("hidden",   "click_y",     "");
	$o_form->addElement("hidden",   "mapext",      $mapExt);
	$o_form->addElement("hidden",   "scale",       $scaleString);

	// GET文字列の配列
	$gisCGIMode = $_SERVER["PHP_SELF"]."?mode=map";

	$getLinkArray = array(
	  "leftUp"    => $gisCGIMode."&scale=".$scaleString."&memoId=".$requestMemoId.$mapController->get_mapextLeftUpString(),
	  "up"        => $gisCGIMode."&scale=".$scaleString."&memoId=".$requestMemoId.$mapController->get_mapextUpString(),
	  "rightUp"   => $gisCGIMode."&scale=".$scaleString."&memoId=".$requestMemoId.$mapController->get_mapextRightUpString(),
	  "left"      => $gisCGIMode."&scale=".$scaleString."&memoId=".$requestMemoId.$mapController->get_mapextLeftString(),
	  "right"     => $gisCGIMode."&scale=".$scaleString."&memoId=".$requestMemoId.$mapController->get_mapextRightString(),
	  "leftDown"  => $gisCGIMode."&scale=".$scaleString."&memoId=".$requestMemoId.$mapController->get_mapextLeftDownString(),
	  "down"      => $gisCGIMode."&scale=".$scaleString."&memoId=".$requestMemoId.$mapController->get_mapextDownString(),
	  "rightDown" => $gisCGIMode."&scale=".$scaleString."&memoId=".$requestMemoId.$mapController->get_mapextRightDownString()
	);

	$getLinkImageArray = array(
	  "leftUp"    => "<img src=\"./img/left_up.gif\"    alt=\"left_up\"    border=\"0\" align=\"bottom\" >",
	  "up"        => "<img src=\"./img/up.gif\"         alt=\"up\"         border=\"0\" align=\"bottom\" >",
	  "rightUp"   => "<img src=\"./img/right_up.gif\"   alt=\"right_up\"   border=\"0\" align=\"bottom\" >",
	  "left"      => "<img src=\"./img/left.gif\"       alt=\"left\"       border=\"0\" align=\"bottom\" >",
	  "right"     => "<img src=\"./img/right.gif\"      alt=\"right\"      border=\"0\" align=\"bottom\" >",
	  "leftDown"  => "<img src=\"./img/left_down.gif\"  alt=\"left_down\"  border=\"0\" align=\"bottom\" >",
	  "down"      => "<img src=\"./img/down.gif\"       alt=\"down\"       border=\"0\" align=\"bottom\" >",
	  "rightDown" => "<img src=\"./img/right_down.gif\" alt=\"right_down\" border=\"0\" align=\"bottom\" >"
	);
	$strHref = "#";
	$o_form->addElement("link", "leftUp",    "", $strHref,  $getLinkImageArray['leftUp'],   array("onclick"=>"mapArrowLink('".$getLinkArray['leftUp']."')","class"=>"fs12_black"));
	$o_form->addElement("link", "up",        "", $strHref,  $getLinkImageArray['up'],        array("onclick"=>"mapArrowLink('".$getLinkArray['up']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "rightUp",   "", $strHref,  $getLinkImageArray['rightUp'],  array("onclick"=>"mapArrowLink('".$getLinkArray['rightUp']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "left",      "", $strHref,  $getLinkImageArray['left'],      array("onclick"=>"mapArrowLink('".$getLinkArray['left']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "right",     "", $strHref,  $getLinkImageArray['right'],     array("onclick"=>"mapArrowLink('".$getLinkArray['right']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "leftDown",  "", $strHref,  $getLinkImageArray['leftDown'], array("onclick"=>"mapArrowLink('".$getLinkArray['leftDown']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "down",      "", $strHref,  $getLinkImageArray['down'],      array("onclick"=>"mapArrowLink('".$getLinkArray['down']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "rightDown", "", $strHref,  $getLinkImageArray['rightDown'], array("onclick"=>"mapArrowLink('".$getLinkArray['rightDown']."')","class"=>"fs12_black")   );
	$o_form->addElement("button", "cansel", $o_resource->getValue("G04009L005"), array("onclick"=>"window.close();","class"=>"fs12_black")   );

	// 地図の表示サイズ
	$dispMapSize = array(
		"width"  => MAP_WIDTH,
		"height" => MAP_HEIGHT
	);

	// 地図の範囲配列
	$rangeArray = $mapController->get_mapextRangeArray($scaleString, "&memoId=".$requestMemoId);


	$getImageAddress ="";
	if(MAP_TYPE == 0){
		$getImageAddress = MAP_SERVER_ADDR . "?" . MAP_FILE_NAME . "&mode=map".$mapController->get_mapextString();

	}else{
		$getImageAddress = "./createkakikoimage.php?scale=".$scaleString.$mapController->get_mapextString();
	}

	// JSON POST文字列
	$jsonPostString = "\"&mapext=".$mapExt."&area_width=".MAP_WIDTH."&area_height=".MAP_HEIGHT."&mapType=".MAP_TYPE."\";";

	// form
	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	$o_smarty->assign("jsonPostString", $jsonPostString);
	$o_smarty->assign("rangeArray", $rangeArray);
	$o_smarty->assign("getImageAddress", $getImageAddress);
	$o_smarty->assign("dispMapSize",       $dispMapSize);
	$o_smarty->assign("labelArray", $labelArray);

	$tplName = DIRECTORY_NAME."/positionedit.tpl";
}else{
	//メモ位置情報テーブル更新処理
	$targetPosition = new MemoPositionData();
	$targetPosition->setMemoID(WHERE_KEY);
	$targetPosition->setLongitude(VAL_TARGET);
	$targetPosition->setLatitude(VAL_TARGET);
	$targetPosition->setUpdateDateTime(VAL_TARGET);

	$position = new MemoPositionData();
	$position->setMemoID($requestMemoId);
	$position->setLongitude($longLat[0]);
	$position->setLatitude($longLat[1]);
	$position->setUpdateDateTime(date('Y/m/d H:i:s'));
	
    // メモ位置情報テーブル修正処理
	$viewService	=	new ContentsViewService(DIRECTORY_NAME);

	if(empty($requestMemoId) == FALSE){
		if ($viewService->updateMemoPositionlDataByKey($targetPosition, $position) == FALSE){
			trigger_error("Memo Modify Error", E_USER_ERROR);
			exit();
		}
	}else{
		trigger_error("Memo Modify Error", E_USER_ERROR);
		exit();
	}
 
   $tplName = DIRECTORY_NAME."/memoclose.tpl";
}

$o_smarty->display($tplName);
unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################

?>
