<?php
/**
* positionmap.php 処理概要：意味空間右フレーム（閲覧モード）表示処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");
require_once("class/common/MapController.class.php");
require_once("class/db/service/ImiViewService.class.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID,ユーザ種別,意味空間IDを取得
$s_UserId = null;
$s_UserType = null;
$s_ImiSpaceId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}
if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId'])){
	$s_ImiSpaceId = $_SESSION[DIRECTORY_NAME.'_imiSpaceId'];
}else{
	trigger_error("Illegal Access!!", E_USER_ERROR);
	exit(-1);
}

$mapController;	// まっぷコントロールクラスオブジェクト
$scaleString;	// スケール文字列
$mapExt;		// 現在表示されているエリアを表す配列

if(isset($_GET['scale'])){
	$scaleString = $_GET['scale'];
}else{
	if(MAP_TYPE == 0){
		// GISは「初期表示」固定
		$scaleString = "1";
	}else{
		// マップ管理者設定の初期表示マップ番号を取得
		$viewService = new ImiViewService(DIRECTORY_NAME);
		$mapDetailData = $viewService->getMapDetailInitialImage();
		$scaleString = sprintf("%03d", $mapDetailData->getMapNumber());
	}
}

$layerTableData = null;
if(isset($_GET['mapext']) && (!isset($_GET['reset']))){
	$arr = explode(" ", $_GET['mapext']);
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}else{
	// 初期表示座標の取得
	$arr = null;

	$service = new ImiViewService(DIRECTORY_NAME);
	$layerTableData = $service->getImiTopPriorityLayerData($s_UserId, $s_ImiSpaceId);
	if($layerTableData == null){
		$arr = explode(",", MAP_INITPOSITION);
	}else{
		if(MAP_TYPE == 0){
			if($layerTableData->getStartX() == null && $layerTableData->getStartY() == null
					&& $layerTableData->getEndX() == null && $layerTableData->getEndY() == null){
				// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
				$arr = explode(",", MAP_INITPOSITION);
			}else{
				$arr = array($layerTableData->getStartX(),
								$layerTableData->getStartY(),
								$layerTableData->getEndX(),
								$layerTableData->getEndY()
							);
			}
		}else{
			// レイヤー管理者設定の初期表示マップ設定を構成(スケールは座標算出後に書き換え)
			$mapDetailData = $service->getMapJoinMapDetailData($layerTableData->getCenterScale());
			$arr = getChangeInitialCoordinatesFromScaleNoGis((int)$scaleString, $mapDetailData);		
			$scaleString = sprintf("%03d", $layerTableData->getCenterScale());
		}
	}
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}
$mapExt = $mapController->get_minX()." ".$mapController->get_minY()." ".$mapController->get_maxX()." ".$mapController->get_maxY();

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// 
$labelArray = array(
	"windowTitle"    => $o_resource->getValue("G04002L201"),
	"rangeInMap"     => $o_resource->getValue("G04002L202")
);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("kakikoFromMap", "POST", $_SERVER["PHP_SELF"], "_self");

// チェックボックス＆ラジオボタンの設定
$memoDisplay = 0;
$kakikoChecked = "";
if(isset($_GET['memoDisplay']) && $_GET['memoDisplay'] == 1) $memoDisplay = 1;
if(isset($_GET['kakiko'])) $kakikoChecked = "checked";
$o_form->setDefaults(
	array(
		'kakiko' => $kakikoChecked,
		'memoDisplay' => $memoDisplay
	)
);

$o_form->addElement("hidden",   "area_height", MAP_HEIGHT);
$o_form->addElement("hidden",   "area_width",  MAP_WIDTH);
$o_form->addElement("hidden",   "click_x",     "");
$o_form->addElement("hidden",   "click_y",     "");
$o_form->addElement("hidden",   "mapext",      $mapExt);
$o_form->addElement("hidden",   "scale",       $scaleString);

$o_form->addElement("hidden",   "searchNew",      $_GET['searchNew']);
$o_form->addElement("hidden",   "searchFromDate", $_GET['searchFromDate']);
$o_form->addElement("hidden",   "searchToDate",   $_GET['searchToDate']);
$o_form->addElement("hidden",   "searchWord",     $_GET['searchWord']);

// GET文字列の配列
$gisCGIMode = $_SERVER["PHP_SELF"]."?mode=map";
$serchGETString = "&searchNew=".$_GET['searchNew']."&searchFromDate=".$_GET['searchFromDate']."&searchToDate=".$_GET['searchToDate']."&searchWord=".urlencode($_GET['searchWord']);
$getLinkArray = array(
  "leftUp"    => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftUpString().$serchGETString,
  "up"        => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextUpString().$serchGETString,
  "rightUp"   => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightUpString().$serchGETString,
  "left"      => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftString().$serchGETString,
  "right"     => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightString().$serchGETString,
  "leftDown"  => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftDownString().$serchGETString,
  "down"      => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextDownString().$serchGETString,
  "rightDown" => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightDownString().$serchGETString
);
$getLinkImageArray = array(
  "leftUp"    => "<img src=\"./img/left_up.gif\"    alt=\"left_up\"    border=\"0\" align=\"bottom\" >",
  "up"        => "<img src=\"./img/up.gif\"         alt=\"up\"         border=\"0\" align=\"bottom\" >",
  "rightUp"   => "<img src=\"./img/right_up.gif\"   alt=\"right_up\"   border=\"0\" align=\"bottom\" >",
  "left"      => "<img src=\"./img/left.gif\"       alt=\"left\"       border=\"0\" align=\"bottom\" >",
  "right"     => "<img src=\"./img/right.gif\"      alt=\"right\"      border=\"0\" align=\"bottom\" >",
  "leftDown"  => "<img src=\"./img/left_down.gif\"  alt=\"left_down\"  border=\"0\" align=\"bottom\" >",
  "down"      => "<img src=\"./img/down.gif\"       alt=\"down\"       border=\"0\" align=\"bottom\" >",
  "rightDown" => "<img src=\"./img/right_down.gif\" alt=\"right_down\" border=\"0\" align=\"bottom\" >"
);
$strHref = "#";
$o_form->addElement("link", "leftUp",    "", $strHref,  $getLinkImageArray['leftUp'],   array("onclick"=>"mapArrowLink('".$getLinkArray['leftUp']."')","class"=>"fs12_black"));
$o_form->addElement("link", "up",        "", $strHref,  $getLinkImageArray['up'],        array("onclick"=>"mapArrowLink('".$getLinkArray['up']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "rightUp",   "", $strHref,  $getLinkImageArray['rightUp'],  array("onclick"=>"mapArrowLink('".$getLinkArray['rightUp']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "left",      "", $strHref,  $getLinkImageArray['left'],      array("onclick"=>"mapArrowLink('".$getLinkArray['left']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "right",     "", $strHref,  $getLinkImageArray['right'],     array("onclick"=>"mapArrowLink('".$getLinkArray['right']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "leftDown",  "", $strHref,  $getLinkImageArray['leftDown'], array("onclick"=>"mapArrowLink('".$getLinkArray['leftDown']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "down",      "", $strHref,  $getLinkImageArray['down'],      array("onclick"=>"mapArrowLink('".$getLinkArray['down']."')","class"=>"fs12_black")   );
$o_form->addElement("link", "rightDown", "", $strHref,  $getLinkImageArray['rightDown'], array("onclick"=>"mapArrowLink('".$getLinkArray['rightDown']."')","class"=>"fs12_black")   );

// 地図の範囲配列
$rangeArray = $mapController->get_mapextRangeArray($scaleString, $serchGETString);

// 地図の表示サイズ
$dispMapSize = array(
	"width"  => MAP_WIDTH,
	"height" => MAP_HEIGHT
);

$getImageAddress ="";
if(MAP_TYPE == 0){
	$getImageAddress = MAP_SERVER_ADDR."?".MAP_FILE_NAME."&mode=map".$mapController->get_mapextString();
}else{
	$getImageAddress = "./createkakikoimage.php?scale=".$scaleString.$mapController->get_mapextString();
}
// JSON POST文字列
$jsonPostString = "\"&mapext=".$mapExt."&area_width=".MAP_WIDTH."&area_height=".MAP_HEIGHT."&mapType=".MAP_TYPE."&searchNew=".$_GET['searchNew']."&searchFromDate=".$_GET['searchFromDate']."&searchToDate=".$_GET['searchToDate']."&searchWord=".$_GET['searchWord']."\";";

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// form
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form", $o_renderer->toArray());

$o_smarty->assign("jsonPostString",    $jsonPostString);
$o_smarty->assign("rangeArray",        $rangeArray);
$o_smarty->assign("getImageAddress",   $getImageAddress);
$o_smarty->assign("dispMapSize",       $dispMapSize);
$o_smarty->assign("labelArray",        $labelArray);

$o_smarty->display(DIRECTORY_NAME."/positionmap.tpl");

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################

?>
