<?php
/**
* userauth.php 処理概要：認証処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

if (!defined("DIRECTORY_NAME")) {
require_once("./DefineDirectryName.php");                          // マップ別定数定義
}

require_once("Auth/Auth.php");                                     // Pear:Auth
require_once("HTML/QuickForm.php");                                // Pear:HTML_QuickForm
require_once("HTML/QuickForm/Renderer/ArraySmarty.php");           // QuickForm とsmarty を連携
require_once("class/common/KakikoSmarty.class.php");               // カキコまっぷSmarty
require_once("class/common/KakikoTableName.class.php");            // マップ別テーブル名称取得クラス
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み
require_once("function/KakikoCheckCallback.php");                  // チェックコールバック
require_once("function/KakikoLog.php");	                         // ログ出力処理
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    
                                                                     // ユーザ用設定ファイル
//require_once("kakikomap/require/db/".DIRECTORY_NAME."_kakikouserinfo.php");
require_once("kakikomap/require/db/".DIRECTORY_NAME."_userinfoRead.php");
                                                                     // 一般ユーザ接続情報
require_once("kakikomap/DBColumnDef.php");                         // カキコまっぷ定数(DB)

// 出力のバッファリングを有効にする
ob_start();

// セッション開始
session_start();

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// エラーハンドラ設定
PEAR::setErrorHandling(PEAR_ERROR_CALLBACK, "errHandle");

// 認証オプション設定
$params = array(
	"dsn" => DBTYPE."://".DBUSER.":".DBPASS."@".DBHOST."/".DBNAME, 
										// PEAR::DB参照
	"table" => DIRECTORY_NAME."_usertable",  		// テーブル名
	"usernamecol" => "userid", 			// ユーザー名にあたるカラム名
	"passwordcol" => "password", 		// パスワードにあたるカラム名
	"db_fields" => "*",
	"cryptType" => "md5", 				// 暗号化(デフォルトはMD5)
	"sessionName"=>"_auth".DIRECTORY_NAME."usersession"
);
// 認証インスタンス生成
$o_auth = new Auth("DB", $params, "createLoginPage", true);

// ログイン、ログアウト、ログイン失敗の際に呼ばれる関数を設定
//$o_auth->setLoginCallback("LoginCallback");
//$o_auth->setFailedLoginCallback("FailedLoginCallback");
//$o_auth->setLogoutCallback("LogoutCallback");

// ログイン可能な時間を設定(0はデフォルトで無制限)
//$o_auth->setExpire(0);

// アイドル時間を設定(0はデフォルトで無制限)
//$o_auth->setIdle(0);


// 認証開始
$o_auth->start();

if ($o_auth->getAuthData("statusflg") == KAKIKOMAP_STATUSFLG_OFF) {

    // リソースファイル読込みインスタンス
    $o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

    // PEAR::QuickFormの作成
    $o_form = form_define($o_resource);
    $o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
    $o_form->accept($o_renderer);

    $o_smarty->assign("err", $o_resource->getValue("G04001M010"));
    $o_smarty->assign("form",$o_renderer->toArray());

    $o_smarty->display(DIRECTORY_NAME."/login.tpl");
    $o_auth->logout();
}

// 結果を判別
if ($o_auth->getAuth()){
	// 認証OK(セッション情報へIDの設定等をする)
//	print "認証OK"."<BR>";
	// ユーザID
	$_SESSION[DIRECTORY_NAME.'_userid'] = $o_auth->getUsername();
	// ユーザ名
	$_SESSION[DIRECTORY_NAME.'_username'] = $o_auth->getAuthData("username");
	// ユーザ種別
	$_SESSION[DIRECTORY_NAME.'_usertype'] = $o_auth->getAuthData("usertype");
	// テーブル名オブジェクト
	$_SESSION[DIRECTORY_NAME.'_tablename'] = serialize(new KakikoTableName("", DIRECTORY_NAME));
}else{
//	print "認証ERR"."<BR>";
	exit(0);
}
//session_regenerate_id(); // セッション偽装防止


function createLoginPage($username, $status){
	global $o_smarty;
	$err = "";

	// リソースファイル読込みインスタンス
	$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

	switch($status){
		case AUTH_IDLED :	

		case AUTH_EXPIRED :	
			$err = $o_resource->getValue("G04001M008");
			break;
		case AUTH_WRONG_LOGIN :	
			$err = $o_resource->getValue("G04001M009");
			break;
	}
    $o_smarty->assign("err", $err);	

    // PEAR::QuickFormの作成
    $o_form = form_define($o_resource);
/*
	// PEAR::QuickFormの作成
	$queryString = "";
	if($_SERVER['QUERY_STRING'] != ""){
		$queryString = "?".$_SERVER['QUERY_STRING'];
	}
	$o_form = new HTML_QuickForm("loginForm", "post", $_SERVER['PHP_SELF'].$queryString, "_self");

	// FORMエレメントの生成
    $o_form->addElement("header", "header", $o_resource->getValue("G04001L005"));
	$o_form->addElement("text", "username", $o_resource->getValue("G04001L001"),
								array("size"=>15, "maxlength"=>16));
	$o_form->addElement("password", "password", $o_resource->getValue("G04001L002"),
								array("size"=>15, "maxlength"=>20));
	$o_form->addElement("submit", "submit", $o_resource->getValue("G04001L003"));
	$o_form->addElement("reset", "reset", $o_resource->getValue("G04001L004"));
//	$o_form->setRequiredNote("");
//	$o_form->setJsWarnings("以下のエラーが発生","エラー項目を修正してください。");

	// 独自チェックルールの定義
	$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
	$o_form->registerRule('minlength_valid', 'callback', 'check_minlength_valid');
	
	// チェックルール(alphanumericは全角半角を区別しないようなので regexを使用するべき？)

//	HTML_QuickForm::registerRule('postNum2','regex','/[0-9]{3}\-[0-9]{4}/');
	$o_form->addRule("username", $o_resource->getValue("G04001M001"), "required", null, "client");
//	$o_form->addRule("username", $o_resource->getValue("G04001M002"), "maxlength", 16, "client");
//	$o_form->addRule("username", $o_resource->getValue("G04001M003"), "alphanumeric", null, "client");
	$o_form->addRule("username", $o_resource->getValue("G04001M002"), "maxlength_valid",	16);
	$o_form->addRule("username", $o_resource->getValue("G04001M003"), "regex", "/^[a-zA-Z0-9]+$/", "client");
	$o_form->addRule("password", $o_resource->getValue("G04001M004"), "required", null, "client");
//	$o_form->addRule("password", $o_resource->getValue("G04001M005"), "rangelength", array(8,20), "client");
	$o_form->addRule("password", $o_resource->getValue("G04001M005"), "minlength_valid",	8);
	$o_form->addRule("password", $o_resource->getValue("G04001M005"), "maxlength_valid",	20);
//	$o_form->addRule("password", $o_resource->getValue("G04001M006"), "alphanumeric", null, "client");
	$o_form->addRule("password", $o_resource->getValue("G04001M006"), "regex", "/^[a-zA-Z0-9,_-]+$/", "client");
*/

	// validate
	if ($o_form->validate()) {
		// FORM認証OK

		// QuickForm_Renderer の設定
		$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_form->accept($o_renderer);
		$o_smarty->assign("form",$o_renderer->toArray());
		// 表示
		$o_smarty->display(DIRECTORY_NAME."/login.tpl");

	}else{
//if (isset($_POST['submit']))
//print "FORM認証NG"."<BR>";
		// FORM認証NG（※初期表示時はFORM未検証のため以下の処理。未確認です・・・）

		// QuickForm_Renderer の設定
		$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_form->accept($o_renderer);
		$o_smarty->assign("form",$o_renderer->toArray());
		// 表示
		$o_smarty->display(DIRECTORY_NAME."/login.tpl");
	}
}

function errHandle($err){
	global $LOG;
	$LOG->err($err->getMessage);
}

/**
* 関数概要：クイックフォーム項目定義・チェックルール登録
* 処理詳細：クイックフォームの項目定義とチェックルールの登録を行う。
*
* @引数： (I) resource	- リソースオブジェクト
* @戻値：     form      - フォームオブジェクト
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function form_define($resource) {

	// PEAR::QuickFormの作成
	$queryString = "";
	if($_SERVER['QUERY_STRING'] != ""){
		$queryString = "?".$_SERVER['QUERY_STRING'];
	}
	$form = new HTML_QuickForm("loginForm", "post", $_SERVER['PHP_SELF'].$queryString, "_self");

	// FORMエレメントの生成
    $form->addElement("header", "header",   $resource->getValue("G04001L005"));
	$form->addElement("text",   "username", $resource->getValue("G04001L001"),
								array("size"=>15, "maxlength"=>16));
	$form->addElement("password", "password", $resource->getValue("G04001L002"),
								array("size"=>15, "maxlength"=>20));
	$form->addElement("submit", "submit",   $resource->getValue("G04001L003"));
	$form->addElement("reset", "reset",     $resource->getValue("G04001L004"));
//	$form->setRequiredNote("");
//	$form->setJsWarnings("以下のエラーが発生","エラー項目を修正してください。");

	// 独自チェックルールの定義
	$form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
	$form->registerRule('minlength_valid', 'callback', 'check_minlength_valid');
	
	// チェックルール(alphanumericは全角半角を区別しないようなので regexを使用するべき？)

//	HTML_QuickForm::registerRule('postNum2','regex','/[0-9]{3}\-[0-9]{4}/');
	$form->addRule("username", $resource->getValue("G04001M001"), "required", null, "client");
//	$form->addRule("username", $resource->getValue("G04001M002"), "maxlength", 16, "client");
//	$form->addRule("username", $resource->getValue("G04001M003"), "alphanumeric", null, "client");
	$form->addRule("username", $resource->getValue("G04001M002"), "maxlength_valid",	16);
	$form->addRule("username", $resource->getValue("G04001M003"), "regex", "/^[a-zA-Z0-9]+$/", "client");
	$form->addRule("password", $resource->getValue("G04001M004"), "required", null, "client");
//	$form->addRule("password", $resource->getValue("G04001M005"), "rangelength", array(8,20), "client");
	$form->addRule("password", $resource->getValue("G04001M005"), "minlength_valid",	8);
	$form->addRule("password", $resource->getValue("G04001M005"), "maxlength_valid",	20);
//	$form->addRule("password", $resource->getValue("G04001M006"), "alphanumeric", null, "client");
	$form->addRule("password", $resource->getValue("G04001M006"), "regex", "/^[a-zA-Z0-9,_-]+$/", "client");

	return $form;
}

?>
