<?php
/**
* userinfo.php 処理概要：個人情報設定処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userInfomationForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 入力項目のデフォルトをセット
$s_UserId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
}
$userArray = getUserData($s_UserId);
$o_form->setDefaults(array(
	"userId"   => $s_UserId,
    "userName" => $userArray['userName'],
    "pass1"    => "",
    "pass2"    => "",
    "mail"     => $userArray['mailAddress'])
	);

// 項目セット
$o_form->addElement("header",   "header",   $o_resource->getValue("G04013L001"));
$o_form->addElement("static",   "title",    $o_resource->getValue("G04013L002"));
$o_form->addElement("static",   "userId",   $o_resource->getValue("G04013L003"), "");
$o_form->addElement("text",     "userName", $o_resource->getValue("G04013L004"), array("size"=>"40", "maxlength"=>"32", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("password", "pass1",    $o_resource->getValue("G04013L005"), array("size"=>"20", "maxlength"=>"20", "autocomplete"=>"off", "class"=>"fs10_black"));
$o_form->addElement("password", "pass2",    $o_resource->getValue("G04013L006"), array("size"=>"20", "maxlength"=>"20", "autocomplete"=>"off", "class"=>"fs10_black"));
$o_form->addElement("text",     "mail",     $o_resource->getValue("G04013L007"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("link",     "deleteUser", "", "./deleteuser.php",  $o_resource->getValue("G04013L008"), array("target"=>"_top","class"=>"fs12_black"));

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
$o_form->registerRule('minlength_valid', 'callback', 'check_minlength_valid');

// チェック項目
$o_form->addRule("userName",  $o_resource->getValue("G04013M001"), "required");
$o_form->addRule("userName",  $o_resource->getValue("G04013M002"), "maxlength_valid",   32);
$o_form->addRule("pass1",     $o_resource->getValue("G04013M003"), "required");
$o_form->addRule("pass1",     $o_resource->getValue("G04013M004"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("pass1",     $o_resource->getValue("G04013M005"), "minlength_valid",	8);
$o_form->addRule("pass1",     $o_resource->getValue("G04013M005"), "maxlength_valid",	20);
$o_form->addRule("pass2",     $o_resource->getValue("G04013M006"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("pass2",     $o_resource->getValue("G04013M007"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("pass2",     $o_resource->getValue("G04013M008"), "minlength_valid",	8);
$o_form->addRule("pass2",     $o_resource->getValue("G04013M008"), "maxlength_valid",	20);
$o_form->addRule("mail",  	  $o_resource->getValue("G04013M009"), "required");
$o_form->addRule("mail",  	  $o_resource->getValue("G04013M010"), "email",	null);
$o_form->addRule("mail",	  $o_resource->getValue("G04013M011"), "maxlength_valid",	128);
$o_form->addRule( array("pass1","pass2"), $o_resource->getValue("G04013M012"), "compare", NULL);

$errorMessage = "";
$pageFlg = 0;
$tplName = "";
// 登録ボタン
if (isset($_POST[submit])) {

    // チェックOK
    if ($o_form->validate()) {
        $pageFlg = 1;
        
        // **************************
        // DB更新処理実装部
        // **************************
		// 更新対象列
		$targetUserData = new UserData();
		$targetUserData->setUserID(WHERE_KEY);
		$targetUserData->setUserName(VAL_TARGET);
		$targetUserData->setPassword(VAL_TARGET);
		$targetUserData->setMailAddress(VAL_TARGET);
		$targetUserData->setUpdateDateTime(VAL_TARGET);
		
		// 更新設定値
		$valueUserData = new UserData();
		$valueUserData->setUserID($s_UserId);
		$valueUserData->setUserName($_POST['userName']);
		$valueUserData->setPassword(md5($_POST['pass1']));
		$valueUserData->setMailAddress($_POST['mail']);
		$valueUserData->setUpdateDateTime(date('Y/m/d H:i:s'));

		// UPDATE
		$service = new ContentsViewService(DIRECTORY_NAME);
		if(!$service->updateUserDataByKey($targetUserData,$valueUserData)){
			trigger_error("DB Error!!", E_USER_ERROR);
		    exit(-1);
		}
		// セッションをUPDATE
		$_SESSION[DIRECTORY_NAME.'_username'] = $_POST['userName'];

    }else{
    	// パスワードエリアを初期化
    	$e_pass2 = &$o_form->getElement("pass1");
    	$e_pass2->setValue("");
    	$e_pass2 = &$o_form->getElement("pass2");
    	$e_pass2->setValue("");
    }
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
    // 設定画面
    $o_form->addElement("submit", "submit", $o_resource->getValue("G04013L009"), array("class"=>"fs12_black"));
    $o_form->addElement("reset",  "reset",  $o_resource->getValue("G04013L010"), array("class"=>"fs12_black"));
    $o_form->addElement("submit", "back",   $o_resource->getValue("G04013L011"), array("onclick"=>"this.form.action='./index.php'", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	$labelArray = array(
		"label01"  => $o_resource->getValue("G04013M013"),
		"label02"  => $o_resource->getValue("G04013M014"),
		"label03"  => $o_resource->getValue("G04013M015"),
		"label04"  => $o_resource->getValue("G04013M016"),
		"label05"  => $o_resource->getValue("G04013M017")
   	);
	$o_smarty->assign("labelArray", $labelArray);

	$o_smarty->assign("errorMessage", $errorMessage);

    $tplName = DIRECTORY_NAME."/userinfo.tpl";

} else {
    // 完了画面
	header("location: ./index.php");
}
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：ユーザデータ取得
* 処理詳細：ユーザデータを取得する
*
* @引数： (I) userId	- string  ユーザID
* @戻値： array ユーザ情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getUserData($userId){

	$service = new ContentsViewService(DIRECTORY_NAME);
	
	$data = $service->getUserDataByKey($userId);

	$userArray = array(
		"userName"	  => $data->getUserName(),
		"mailAddress" => $data->getMailAddress()
	);	
	
	return $userArray;
}
?>