<?php
/**
* G05-003
* userregistreq.php 処理概要：ユーザ登録要求
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("class/db/service/ContentsAdminService.class.php");	//DBアクセスサービスクラス
require_once("class/mail/KakikoMail.class.php");					// メール送信クラス

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
	// アクセス許可エラー
	trigger_error($o_resource->getValue("G05003M007"), E_USER_ERROR);
	exit();
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userregistreq", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(
			array(
				"mailAddress"  => "",
				"confirmMailAddress" => ""
			)
);

// 項目セット
$o_form->addElement("text", "mailAddress",			$o_resource->getValue("G05003L002"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text", "confirmMailAddress",	$o_resource->getValue("G05003L003"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
// チェック項目
$o_form->addRule("mailAddress",  $o_resource->getValue("G05003M002"), "required");
$o_form->addRule("mailAddress",  $o_resource->getValue("G05003M003"), "email");
$o_form->addRule("confirmMailAddress", $o_resource->getValue("G05003M004"), "required");
$o_form->addRule("confirmMailAddress", $o_resource->getValue("G05003M005"), "email");
$o_form->addRule( array("mailAddress","confirmMailAddress"), $o_resource->getValue("G05003M006"), "compare", NULL);

$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[sendButton])) {
	// 妥当性チェック
	if ($o_form->validate()) {
		// 管理者情報取得
		$adminService = new ContentsAdminService(DIRECTORY_NAME);
		if ($adminService->getMailUserInfo(null, $userName, $adminMailAddress, $contentsName) == FALSE){
			// 管理者情報取得エラー
			trigger_error($o_resource->getValue("G05003M013"), E_USER_ERROR);
			exit();
		}else{
			if ($adminMailAddress == ""){
				// 管理者情報取得エラー
				trigger_error($o_resource->getValue("G05003M013"), E_USER_ERROR);
				exit();
			}
		}

		$sendMode				=  "smtp";     //phpmail,sendmail,smtp

		//本登録用URL生成
		$mailUrl = getProtocol()	.	$_SERVER["SERVER_NAME"]
								.	dirname($_SERVER["PHP_SELF"])
								.	"/userregistreqfix.php?id=&key="
								.	md5($_POST["mailAddress"]);
		//処理
		$userregistreqMessage	= "\n" 
								. $_POST["mailAddress"] . $o_resource->getValue("G05003M008")
								. "\n\n" 
								. $o_resource->getValue("G05003M011")
								. "\n" 
								. $o_resource->getValue("G05003M012")
								. "\n\n" 
								. $mailUrl;
		$mailitems = array(
						'ToAddress'		=> $_POST["mailAddress"],		//送信先アドレス
						'ToName'			=> $_POST["mailAddress"] . $o_resource->getValue("G05003M008"),	//送信先名称
						'FromAddress'		=> $adminMailAddress,			//送信元アドレス
						'FromName'			=> $contentsName . $o_resource->getValue("G05003M009"),					//送信元名称
						'ReplyTo' 			=> $adminMailAddress,			//返信先アドレス
						'Subject' 			=> $o_resource->getValue("G05003M010"),		//件名
						'Message' 			=> $userregistreqMessage,		//本文
					);

		//メール送信
		$o_email = new KakikoMail();
		$o_email->createMail($mailitems);

/*
print_r($mailitems);
print("<br>");
print "送信先アドレス: ".$o_email->toAddress."<br>";
print "送信先名称: ".$o_email->toName."<br>";
print "送信元アドレス: ".$o_email->fromAddress."<br>";
print "送信元名称: ".$o_email->fromName."<br>";
print "返信先アドレス: ".$o_email->replyTo."<br>";
print "件名: ".$o_email->subject."<br>";
print "本文: ".$o_email->message."<br>";
*/

		$ret = $o_email->sendEmail($sendMode);
		if (PEAR::isError($ret)){
			trigger_error($o_resource->getValue("G05003M014"), E_USER_ERROR);
			exit();
		}

		//処理
		$pageFlg = 1;
	}
}

// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $o_form->addElement("submit",	"sendButton",	$o_resource->getValue("G05003L004"),	array("class"=>"fs12_black"));
    $o_form->addElement("reset",	"resetButton",	$o_resource->getValue("G05003L005"),	array("class"=>"fs12_black"));
    $o_form->addElement("button",	"backButton",	$o_resource->getValue("G05003L006"),	array("onclick"=>"history.back();", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
    $o_smarty->assign("header",		$o_resource->getValue("G05003L001"));
    $o_smarty->assign("messeage",		$o_resource->getValue("G05003M001"));
	$o_smarty->assign("form"        , $o_renderer->toArray());
	$o_smarty->assign("errorMessage", $errorMessage);

    $tplName = DIRECTORY_NAME . "/userregistreq.tpl";
} else {
     // 完了画面
    $o_smarty->assign("header",		$o_resource->getValue("G05004L001"));
    $o_smarty->assign("message1",	htmlspecialchars($_POST["mailAddress"]) . $o_resource->getValue("G05004M001"));
    $o_smarty->assign("message2",	$o_resource->getValue("G05004M002"));
//    $o_smarty->assign("backButton",				$o_resource->getValue("G05004L002"),	array("onclick"=>"location.href='index.php'", "class"=>"fs12_black"));
    $o_smarty->assign("backButton",	$o_resource->getValue("G05004L002"));
 
    $tplName = DIRECTORY_NAME . "/userregistreqfin.tpl";
}

$o_smarty->display($tplName);

unset($_POST);

?>
