<?php
/**
* basemapset.php 処理概要：ベースマップ設定
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}

require_once("Config.php");
require_once("class/db/KakikoDb.class.php");

require_once("function/KakikoFile.php");
require_once("class/common/KakikoImage.class.php");
require_once("class/db/service/MapAdminService.class.php");
require_once("class/xml/ReadResource.class.php");							// リソースファイル読込み

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle1"     => $o_resource->getValue("G03006L001"),
    "topTitle2"     => $o_resource->getValue("G03006L002"),
    "colTitleA01"   => $o_resource->getValue("G03006L003"),
    "colTitleA02"   => $o_resource->getValue("G03006L004"),
    "colTitleA03"   => $o_resource->getValue("G03006L005"),
    "colTitleA04"   => $o_resource->getValue("G03006L006"),
    "colTitleA05"   => $o_resource->getValue("G03006L007"),
    "colTitleB01"   => str_replace("@@UPLOAD_FILESIZE@@", ini_get("upload_max_filesize"), $o_resource->getValue("G03006L008")),
    "colTitleB02"   => str_replace("\\n", "<br>", $o_resource->getValue("G03006L009")),
    "colTitleC01"   => $o_resource->getValue("G03006L010"),
    "colTitleC02"   => $o_resource->getValue("G03006L011"),
    "colTitleC03"   => $o_resource->getValue("G03006L012"),
    "colTitleC04"   => $o_resource->getValue("G03006L013"),
    "colTitleC05"   => str_replace("\\n", "<br>", $o_resource->getValue("G03006L014")),
    "colTitleC06"   => str_replace("@@UPLOAD_FILESIZE@@", ini_get("upload_max_filesize"), $o_resource->getValue("G03006L015")),
    "colTitleC07"   => $o_resource->getValue("G03006L016"),
    "gisKnd01"      => $o_resource->getValue("G03006L017"),
    "gisKnd02"      => $o_resource->getValue("G03006L018"),
    "xcoordinate"   => $o_resource->getValue("G03006L019"),
    "ycoordinate"   => $o_resource->getValue("G03006L020"),
    "hmapsize"      => $o_resource->getValue("G03006L021"),
    "zmapsize"      => $o_resource->getValue("G03006L022"),
    "movemap01"     => $o_resource->getValue("G03006L023"),
    "movemap02"     => $o_resource->getValue("G03006L024"),
    "movemap03"     => $o_resource->getValue("G03006L025"),
    "status"        => $o_resource->getValue("G03006L026"),
    "stsKnd01"      => $o_resource->getValue("G03006L027"),
    "stsKnd02"      => $o_resource->getValue("G03006L028"),
    "stsKnd03"      => $o_resource->getValue("G03006L029"),
    "recKnd01"      => $o_resource->getValue("G03006L030"),
    "recKnd03"      => $o_resource->getValue("G03006L031"),
    "helpLink"      => $o_resource->getValue("G03006L032"),
    "refBtn"        => $o_resource->getValue("G03006L033"),
    "addBtn"        => $o_resource->getValue("G03006L034"),
    "rstBtn"        => $o_resource->getValue("G03006L035")
);


// テーブル名称取得クラス
$o_tablename = unserialize($_SESSION['_tablename']);

// DB接続サービス呼び出し
$o_service = new MapAdminService($o_tablename->get_DirectryName());

// 画像サイズ初期値(推奨値)
$mapSizeHorizontal = 600;
$mapSizeVertical = 480;

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("basemapset", "POST", $_SERVER["PHP_SELF"]);

if (!isset($_POST['usegis_group']['usegis'])) {

    // DBからマップテーブル＆マップ詳細テーブルのデータの取得
    $mapdata = selectMapRecode($o_service);
    if (is_null($mapdata) || count($mapdata) == 0) {
        exit();
    }

    $listData = getMapDetailList($mapdata);

    // GIS有無区分
    $selectusegis = $mapdata[0]->getUseGIS_BaseMap();

    // 座標変換
	list($x1, $y1, $x2, $y2) = getCoordinates(1, $mapdata[0]->getStartX_BaseMap(), $mapdata[0]->getStartY_BaseMap(), $mapdata[0]->getEndX_BaseMap(), $mapdata[0]->getEndY_BaseMap());

	if ($mapdata[0]->getMapSizeHorizontal_BaseMap() != 0){
		$mapSizeHorizontal = $mapdata[0]->getMapSizeHorizontal_BaseMap();
	}

	if ($mapdata[0]->getMapSizeVertical_BaseMap() != 0){
		$mapSizeVertical = $mapdata[0]->getMapSizeVertical_BaseMap();
	}
}

// 入力項目のデフォルトをセット
$form_def = array(
    "usegis_group"                       => isset($_POST['usegis_group']['usegis'])?$_POST['usegis_group']['usegis']:$selectusegis,
    "startx"                             => isset($_POST['startx'])?$_POST['startx']:$x1,
    "starty"                             => isset($_POST['starty'])?$_POST['starty']:$y1,
    "endx"                               => isset($_POST['endx'])?$_POST['endx']:$x2,
    "endy"                               => isset($_POST['endy'])?$_POST['endy']:$y2,
//    "mapsizehorizontal"                  => isset($_POST['mapsizehorizontal'])?$_POST['mapsizehorizontal']:$mapdata[0]->getMapSizeHorizontal_BaseMap(),
//    "mapsizevertical"                    => isset($_POST['mapsizevertical'])?$_POST['mapsizevertical']:$mapdata[0]->getMapSizeVertical_BaseMap(),
    "mapsizehorizontal"                  => isset($_POST['mapsizehorizontal'])?$_POST['mapsizehorizontal']:$mapSizeHorizontal,
    "mapsizevertical"                    => isset($_POST['mapsizevertical'])?$_POST['mapsizevertical']:$mapSizeVertical,
    "movemapsphere_group"                => isset($_POST['movemapsphere_group']['movemapsphere'])?$_POST['movemapsphere_group']['movemapsphere']:$mapdata[0]->getMoveMapSphere_BaseMap(),
    "usegis_group[usegis]"               => isset($_POST['usegis_group']['usegis'])?$_POST['usegis_group']['usegis']:$selectusegis,
    "movemapsphere_group[movemapsphere]" => isset($_POST['movemapsphere_group']['movemapsphere'])?$_POST['movemapsphere_group']['movemapsphere']:$mapdata[0]->getMoveMapSphere_BaseMap(),
    "diffx"                              => isset($_POST['diffx'])?$_POST['diffx']:$mapdata[0]->getDiffX_BaseMap(),
    "diffy"                              => isset($_POST['diffy'])?$_POST['diffy']:$mapdata[0]->getDiffY_BaseMap()
);

$o_form->setDefaults($form_def);


// 項目セット
$o_form->addElement("hidden",           "uploadmode");
$array_usegis[] =& HTML_QuickForm::createElement("radio", "usegis", null, $label['gisKnd01'], KAKIKOMAP_USEGIS_ON,  array("onclick"=>"changegismap('0')"));
$array_usegis[] =& HTML_QuickForm::createElement("radio", "usegis", null, $label['gisKnd02'], KAKIKOMAP_USEGIS_OFF, array("onclick"=>"changegismap('1')"));
$o_form->addGroup($array_usegis,        "usegis_group",        $label['colTitleA01'], "&nbsp;");
$o_form->addElement("text",             "startx",              $label['colTitleA02'], array("size"=>30, "maxlength"=>30, "class"=>"fs12_black"));
$o_form->addElement("text",             "starty",              $label['colTitleA02'], array("size"=>30, "maxlength"=>30, "class"=>"fs12_black"));
$o_form->addElement("text",             "endx",                $label['colTitleA03'], array("size"=>30, "maxlength"=>30, "class"=>"fs12_black"));
$o_form->addElement("text",             "endy",                $label['colTitleA03'], array("size"=>30, "maxlength"=>30, "class"=>"fs12_black"));
$o_form->addElement("text",             "mapsizehorizontal",   $label['colTitleA04'], array("size"=>30, "maxlength"=>30, "class"=>"fs12_black", "onchange"=>"alert('".$o_resource->getValue("G03006M038")."')"));
$o_form->addElement("text",             "mapsizevertical",     $label['colTitleA04'], array("size"=>30, "maxlength"=>30, "class"=>"fs12_black", "onchange"=>"alert('".$o_resource->getValue("G03006M038")."')"));
$array_movemapsphere[] =& HTML_QuickForm::createElement("radio", "movemapsphere", null, $label['movemap01'], KAKIKOMAP_MOVEMAPSPHERE_NORMAL);
$array_movemapsphere[] =& HTML_QuickForm::createElement("radio", "movemapsphere", null, $label['movemap02'], KAKIKOMAP_MOVEMAPSPHERE_2FLAC);
$array_movemapsphere[] =& HTML_QuickForm::createElement("radio", "movemapsphere", null, $label['movemap03'], KAKIKOMAP_MOVEMAPSPHERE_3FLAC);
$o_form->addGroup($array_movemapsphere, "movemapsphere_group", $label['colTitleA05'], "&nbsp;");

$o_form->addElement("header",           "header",              $label['topTitle1']);
$o_form->addElement("text",             "diffx",               $label['colTitleB02'], array("size"=>30, "maxlength"=>30, "class"=>"fs12_black"));
$o_form->addElement("text",             "diffy",               $label['colTitleB02'], array("size"=>30, "maxlength"=>30, "class"=>"fs12_black"));
// マップファイルの存在チェック(ファイルが無い場合はヘルプボタンを出さない)
if (mapFileCheck()) {
	$o_form->addElement("link",         "helplink",            null, "javascript:open_subwindow_nonsubmit('./gishelper.php','subwindow',700,650)", $label['helpLink']);
}
// -- GISあり項目 --
$o_form->addElement("text",   "gisfile", str_replace("\\n", "<br>", $label['colTitleB01']), array("size"=>30, "class"=>"fs12_black", "readonly"));

$status = isset($_POST['usegis_group']['usegis'])?$_POST['usegis_group']['usegis']:$selectusegis;
$o_form->addElement("reset",  "reset",   $label['rstBtn'], array("class"=>"fs12_black", "onclick"=>"changegismap($status)"));
$o_form->addElement("submit", "run",     $label['addBtn'], array("class"=>"fs12_black"));


// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
$o_form->registerRule('num_sphere_valid', 'callback', 'check_numeric_sphere_valid');

// チェック項目
$o_form->addRule("startx",            $o_resource->getValue("G03006M001"), "required", null);
$o_form->addRule("startx",            $o_resource->getValue("G03006M002"), "numeric",  null);
$o_form->addRule("startx",            $o_resource->getValue("G03006M003"), "maxlength_valid",	20);
$o_form->addRule("starty",            $o_resource->getValue("G03006M004"), "required", null);
$o_form->addRule("starty",            $o_resource->getValue("G03006M005"), "numeric",  null);
$o_form->addRule("starty",            $o_resource->getValue("G03006M006"), "maxlength_valid",	20);
$o_form->addRule("endx",              $o_resource->getValue("G03006M007"), "required", null);
$o_form->addRule("endx",              $o_resource->getValue("G03006M008"), "numeric",  null);
$o_form->addRule("endx",              $o_resource->getValue("G03006M009"), "maxlength_valid",	20);
$o_form->addRule("endy",              $o_resource->getValue("G03006M010"), "required", null);
$o_form->addRule("endy",              $o_resource->getValue("G03006M011"), "numeric",  null);
$o_form->addRule("endy",              $o_resource->getValue("G03006M012"), "maxlength_valid",	20);
$o_form->addRule("mapsizehorizontal", $o_resource->getValue("G03006M013"), "required", null);
$o_form->addRule("mapsizehorizontal", $o_resource->getValue("G03006M014"), "numeric",  null);
//$o_form->addRule("mapsizehorizontal", $o_resource->getValue("G03004M015"), "num_sphere_valid", array(1, 2000));
$o_form->addRule("mapsizevertical",   $o_resource->getValue("G03006M016"), "required", null);
$o_form->addRule("mapsizevertical",   $o_resource->getValue("G03006M017"), "numeric",  null);
$o_form->addRule("mapsizevertical",   $o_resource->getValue("G03006M018"), "num_sphere_valid", array(1, 2000));

// 地図の座標　左下・中心の大小関係
$o_form->addRule(array("startx", "endx"), $o_resource->getValue("G03006M019"), "compare", "lt");
$o_form->addRule(array("starty", "endy"), $o_resource->getValue("G03006M020"), "compare", "lt");

$usegis_on = false;

if (isset($_POST['usegis_group']['usegis'])) {
	if ($_POST['usegis_group']['usegis'] == KAKIKOMAP_USEGIS_ON) {
		$usegis_on = true;
	}
} else {
	if ($selectusegis == KAKIKOMAP_USEGIS_ON) {
		$usegis_on = true;
	}
}

// GIS有りの場合のチェック項目
if ($usegis_on) {
//	$o_form->addRule("diffx",             $o_resource->getValue("G03006M021"), "required", null);
	$o_form->addRule("diffx",             $o_resource->getValue("G03006M022"), "numeric",  null);
	$o_form->addRule("diffx",             $o_resource->getValue("G03006M023"), "maxlength_valid",	20);
//	$o_form->addRule("diffy",             $o_resource->getValue("G03006M024"), "required", null);
	$o_form->addRule("diffy",             $o_resource->getValue("G03006M025"), "numeric",  null);
	$o_form->addRule("diffy",             $o_resource->getValue("G03006M026"), "maxlength_valid",	20);
}

$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[run])) {
    // 入力されたデータ(POST値)から表示用配列を再作成
    $listData = getMapDetailListPOST();
    // 妥当性チェック
    if ($o_form->validate()) {
		if (!$usegis_on) {
			// GIS無しの場合
	        // 入力データチェック
	        $input_mapno = array();
	        $errorMessage = basemapInputCheck($o_resource, $input_mapno);
	        if ($errorMessage == "") {
	            // データ更新処理
		        if (updateRecode_GIS_Off($o_service, $o_tablename->get_DirectryName(), $input_mapno) == TRUE) {
		            $pageFlg = 2;
		        }
	        }
	    } else {
	        // GIS有りの場合
	        // データ更新処理
	        if (updateRecode_GIS_On($o_service, $o_tablename->get_DirectryName()) == TRUE) {
	            $pageFlg = 2;
	        }
	    }
    }
}
else {
    // アップロード先のフォルダ内をクリア
    kakikoDelete("../../contents/".$o_tablename->get_DirectryName()."/img/map/temp/", false);
}

// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $tplarray = array();

    $tplName = "admin_basemapset.tpl";
}
else {
    // 完了画面
    $tplarray    = array(
                          "title"         => $label['topTitle2'],
                          "infomessage"   => $o_resource->getValue("G03006M027"),
                          "tablewidth"    => "550",
                          "tdwidth"       => "150",
                          "listdatas"     => "",
                          "buttonname"    => "",
                          "buttononclick" => ""
                         );
    $tplName = "commonfin.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",              $o_renderer->toArray());
$o_smarty->assign("listDatas",         $listData);
$o_smarty->assign("label",             $label);
$o_smarty->assign("pageFlg",           $pageFlg);
$o_smarty->assign("selectusegis",      $selectusegis);
$o_smarty->assign("tplarray",          $tplarray);
$o_smarty->assign("errorMessage",      $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################

/**
* 関数概要：マップデータマップ詳細データ情報取得
* 処理詳細：マップテーブル及びマップ詳細テーブルより該当の情報を取得する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： array   DBエラーの場合はnull
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function selectMapRecode($o_service) {

	$data = $o_service->getBaseMapInfoData();

	return $data;

}

/**
* 関数概要：ベースマップ設定表示情報取得
* 処理詳細：マップ詳細管理管理テーブルより表示情報を取得
*
* @引数： (I) data        - array  マップデータマップ詳細データクラスオブジェクト配列
* @戻値： array 一覧情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getMapDetailList($data) {

    $ret_array = array();
    
    // 初期化
    for ($i = 1; $i <= 10; $i++) {
        $def_array = array(
                            "mapnumber"        => $i,
                            "initiallist"      => "0",
                            "outsidereference" => "0",
                            "listname"         => "",
                            "pixel"            => "0",
                            "dbdata"           => "0",
                            "mapimage"         => "0",
                            "delcheck"         => "0"
                           );
        $ret_array[$i] = $def_array;
    }

    if (count($data) != 0) {
        for ($i = 0; $i < count($data); $i++) {
            if (!is_null($data[$i]->getMapNumber_MapDetail())) {
                $def_array = array(
                                "mapnumber"        => $data[$i]->getMapNumber_MapDetail(),
                                "initiallist"      => $data[$i]->getInitialList_MapDetail(),
                                "outsidereference" => $data[$i]->getOutsideReference_MapDetail(),
                                "listname"         => $data[$i]->getListName_MapDetail(),
                                "pixel"            => $data[$i]->getPixel_MapDetail(),
                                "dbdata"           => "1",
                                "mapimage"         => "0",
                                "delcheck"         => "0"
                               );

                $ret_array[$data[$i]->getMapNumber_MapDetail()] = $def_array;
            }
        }
    }

    return $ret_array;

}

/**
* 関数概要：ベースマップ設定表示情報取得
* 処理詳細：POST情報より表示情報を取得
*
* @引数： なし
* @戻値： array 一覧情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getMapDetailListPOST(){

    $ret_array = array();
    
    for ($i = 1; $i <= 10 ; $i++) {
        $def_array = array(
                            "mapnumber"        => $i,
                            "initiallist"      => (isset($_POST['ini_def'])&&($_POST['ini_def']==$i))?KAKIKOMAP_SELECTED_TRUE:KAKIKOMAP_SELECTED_FALSE,
                            "outsidereference" => (isset($_POST['ex_def'])&&($_POST['ex_def']==$i))?KAKIKOMAP_SELECTED_TRUE:KAKIKOMAP_SELECTED_FALSE,
                            "listname"         => (isset($_POST['listname'][$i]))?$_POST['listname'][$i]:"",
                            "pixel"            => (isset($_POST['pixel'][$i]))?$_POST['pixel'][$i]:"0",
                            "dbdata"           => (isset($_POST['mapstatus'][$i]))?$_POST['mapstatus'][$i]:"0",
                            "mapimage"         => (isset($_POST['mapimage'][$i]))?$_POST['mapimage'][$i]:"0",
                            "delcheck"         => (isset($_POST['delcheck'][$i]))?$_POST['delcheck'][$i]:"0",
                           );
        $ret_array[$i] = $def_array;
    }

    return $ret_array;

}

/**
* 関数概要：ベースマップ設定内容更新(GIS使用無し)
* 処理詳細：入力された内容をデータベースへ更新する
*           ・ベースマップ管理テーブル
*           ・マップ詳細管理テーブル
*
* @引数： (I) o_service     - object DBサービスクラス
*         (I) input_mapno   - array  入力項目地図番号配列
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function updateRecode_GIS_Off($o_service, $curDir, $input_mapno) {

	$post_data = array();

    // 座標変換
	list($_POST['startx'], $_POST['starty'], $_POST['endx'], $_POST['endy']) = 
			getCoordinates(0, $_POST['startx'], $_POST['starty'], $_POST['endx'], $_POST['endy']);

	$post_data['P_START_X'] = $_POST['startx'];
	$post_data['P_START_Y'] = $_POST['starty'];
	$post_data['P_END_X'] = $_POST['endx'];
	$post_data['P_END_Y'] = $_POST['endy'];
	$post_data['P_USEGIS'] = $_POST['usegis_group']['usegis'];
	$post_data['P_MAPSIZE_HORIZONTAL'] = $_POST['mapsizehorizontal'];
	$post_data['P_MAPSIZE_VERTICAL'] = $_POST['mapsizevertical'];
	$post_data['P_MOVEMAP_SPHERE'] = $_POST['movemapsphere_group']['movemapsphere'];
	$post_data['P_MAPSTATUS'] = $_POST['mapstatus'];
	$post_data['P_MAPIMAGE'] = $_POST['mapimage'];
	$post_data['P_LISTNAME'] = $_POST['listname'];
	$post_data['P_INI_DEF'] = $_POST['ini_def'];
	$post_data['P_EX_DEF'] = $_POST['ex_def'];
	$post_data['P_PIXEL'] = $_POST['pixel'];
	$post_data['P_DELCHECK'] = $_POST['delcheck'];

	$rtn = $o_service->setBaseMap_GIS_Off($input_mapno, $post_data);
	if ($rtn) {
		// iniファイルへの書き出し
//		writeIniFile();
		writeIniFile($curDir, $input_mapno);
	}

    return $rtn;

}

/**
* 関数概要：ベースマップ設定内容更新(GIS使用無し)
* 処理詳細：入力された内容をデータベースへ更新する
*           ・ベースマップ管理テーブル
*           ・マップ詳細管理テーブル
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function updateRecode_GIS_On($o_service,$curDir) {

    // 座標変換
	list($_POST['startx'], $_POST['starty'], $_POST['endx'], $_POST['endy']) = 
			getCoordinates(0, $_POST['startx'], $_POST['starty'], $_POST['endx'], $_POST['endy']);

	$post_data['P_START_X'] = $_POST['startx'];
	$post_data['P_START_Y'] = $_POST['starty'];
	$post_data['P_END_X'] = $_POST['endx'];
	$post_data['P_END_Y'] = $_POST['endy'];
	$post_data['P_USEGIS'] = $_POST['usegis_group']['usegis'];
	$post_data['P_MAPSIZE_HORIZONTAL'] = $_POST['mapsizehorizontal'];
	$post_data['P_MAPSIZE_VERTICAL'] = $_POST['mapsizevertical'];
	$post_data['P_MOVEMAP_SPHERE'] = $_POST['movemapsphere_group']['movemapsphere'];
	$post_data['P_DIFF_X'] = $_POST['diffx'];
	$post_data['P_DIFF_Y'] = $_POST['diffy'];

	$rtn = $o_service->setBaseMap_GIS_On($post_data);
	if ($rtn) {
		// iniファイルへの書き出し
//		writeIniFile();
		writeIniFile($curDir, "");
	}

    return $rtn;

}

/**
* 関数概要：マップファイルの存在チェック
* 処理詳細：マップファイルが既にアップロードされているかをチェックする
*
* @引数： なし
* @戻値： boolean TRUE :マップファイル有り
*      ：         FALSE:マップファイル無し
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function mapFileCheck() {

    // 戻り値の初期化
    $return = false;

    // アップロード先パス
    $o_tblname = unserialize($_SESSION['_tablename']);
    $uploadpath = "../../contents/".$o_tblname->get_DirectryName()."/img/map/";
    $uploadpath_tmp = $uploadpath."temp/";

    // フォルダのハンドル取得
    if ($dir = opendir($uploadpath)) {
        // フォルダ内のファイルを全て取得
        while (($file = readdir($dir)) != false) {
            // 親フォルダ・自フォルダは対象外 
            if ($file != "." && $file != "..") {
                if (file_exists($uploadpath.$file)) {
					if (is_file($uploadpath.$file)) {
						if (strrchr($file, ".") == ".map") {
							$return = true;
						}
					}
				}
            }
        }
        // ハンドル開放
        closedir($dir);
    }
    return $return;

}

/**
* 関数概要：入力チェック処理
* 処理詳細：QuickForm未使用部分の入力チェックを行う
*
* @引数： o_resource : object リソースクラス
*         input_mapno: array  入力項目地図番号配列
* @戻値： string エラーメッセージ
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function basemapInputCheck($o_resource, &$input_mapno){

    // 地図番号単位で内容をチェック
    for ($i = 1; $i <= count($_POST['mapstatus']) ; $i++) {
        if ($_POST['mapstatus'][$i] == 0) {
        	// ステータスが未設定の場合
            if ($_POST['mapimage'][$i] == 2) {
            	// 新規／変更の場合

                // 表示名
                if ($_POST['listname'][$i] == "") {
                    return sprintf($o_resource->getValue("G03006M028"), $i);
                }
                // ピクセル数
                if ($_POST['pixel'][$i] == "") {
                    return sprintf($o_resource->getValue("G03006M029"), $i);
                }
                if (!ereg("^[0-9]+|(^[0-9]{1,}\.[0-9]+$)", $_POST['pixel'][$i])) {
                    return sprintf($o_resource->getValue("G03006M030"), $i);
                }
                if ((float)$_POST['pixel'][$i] <= 0) {
                    return sprintf($o_resource->getValue("G03006M029"), $i);
                }
                // アップロードファイル
                if (!isset($_POST['u_file'][$i])) {
                    return sprintf($o_resource->getValue("G03006M031"), $i);
                }
                if ($_POST['u_file'][$i] == "") {
                    return sprintf($o_resource->getValue("G03006M031"), $i);
                }
                
                array_push($input_mapno, $i);
            }
        } else {
        	// ステータスが設定済の場合
            if ($_POST['mapimage'][$i] == 0 || $_POST['mapimage'][$i] == 2) {

                // 表示名
                if ($_POST['listname'][$i] == "") {
                    return sprintf($o_resource->getValue("G03006M028"), $i);
                }
                // ピクセル数
                if ($_POST['pixel'][$i] == "") {
                    return sprintf($o_resource->getValue("G03006M029"), $i);
                }
                if (!ereg("^[0-9]+|(^[0-9]{1,}\.[0-9]+$)", $_POST['pixel'][$i])) {
                    return sprintf($o_resource->getValue("G03006M030"), $i);
                }
                if ((float)$_POST['pixel'][$i] <= 0) {
                    return sprintf($o_resource->getValue("G03006M029"), $i);
                }

				array_push($input_mapno, $i);
	        }
        }
    }

	$initial_flg = false;
	// 初期表示選択
	if (!isset($_POST['ini_def'])){
		return $o_resource->getValue("G03006M032");
	} else {
		for ($i = 0; $i < count($input_mapno); $i++) {
			if ($input_mapno[$i] == $_POST['ini_def']) {
				$initial_flg = true;
				break;
			}
		}
		if (!$initial_flg) {
			return $o_resource->getValue("G03006M033");
		}
	}

	$outsidereference_flg = false;
	// 外部参照選択
	if (!isset($_POST['ex_def'])){
		return $o_resource->getValue("G03006M034");
	} else {
		for ($i = 0; $i < count($input_mapno); $i++) {
			if ($input_mapno[$i] == $_POST['ex_def']) {
				$outsidereference_flg = true;
				break;
			}
		}
		if (!$outsidereference_flg) {
			return $o_resource->getValue("G03006M035");
		}
	}

	$delcheck_flg = false;
	// 削除選択
	if (!isset($_POST['delcheck'])) {
		// 削除項目が選択されていない状態
	} else {
		foreach ($_POST['delcheck'] as $val) {
			$delcheck_flg = false;
			for ($i = 0; $i < count($input_mapno); $i++) {
				if ($input_mapno[$i] == $val) {
					$delcheck_flg = true;
				}
			}
			if (!$delcheck_flg) {
				return $o_resource->getValue("G03006M036");
			}
		}
	}
	return "";
}

/**
* 関数概要：イニファイル項目書込み処理
* 処理詳細：コンテンツ対象のイニファイルへの項目書込み処理を行う
*
* @引数： 
* @戻値： 
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
//function writeIniFile() {
function writeIniFile($curDir, $input_mapno) {

    $o_tblname = unserialize($_SESSION['_tablename']);
    $dirname = $o_tblname->get_DirectryName();

	$dirs = split(PATH_SEPARATOR, ini_get('include_path')); 
	foreach ($dirs as $dirpath) {

	    $fpath = $dirpath.DIRECTORY_SEPARATOR."kakikomap".DIRECTORY_SEPARATOR."ini".DIRECTORY_SEPARATOR."auto".DIRECTORY_SEPARATOR.$dirname."_setting.ini";

		if(is_file($fpath)){
			$config = new Config();
			$setting = $config->parseConfig($fpath, "inicommented");
			break;
		}
	}

    // マップ種別
	$map_type =& $setting->searchPath(array("MAP_TYPE"));
	// 画面表示地図サイズ
	$map_width =& $setting->searchPath(array("MAP_WIDTH"));
	$map_height =& $setting->searchPath(array("MAP_HEIGHT"));
	// 地図の動く幅
	$map_move =& $setting->searchPath(array("MAP_MOVE"));
	// 初期表示座標
	$map_init_position =& $setting->searchPath(array("MAP_INITPOSITION"));


	// 表示名(KAKIKOエンジン)
	$kakiko_link_name = & $setting->searchPath(array("KAKIKO_LINK_NAME"));
	// ディレクトリ名(KAKIKOエンジン)
	$kakiko_dir_path = & $setting->searchPath(array("KAKIKO_DIR_PATH"));
	// １ｍ辺りのPIXEL数(KAKIKOエンジン)
	$kakiko_move_pixel = & $setting->searchPath(array("KAKIKO_MOVE_PIXEL"));

	// マップファイル名(GISエンジン)
	$map_file_name = & $setting->searchPath(array("MAP_FILE_NAME"));
	// 中心スケール(GISエンジン)
	$map_center = & $setting->searchPath(array("MAP_CENTER"));

	// 設定
	// マップ種別
	$map_type->setContent($_POST['usegis_group']['usegis']);
	// 画面表示地図サイズ
	$map_width->setContent($_POST['mapsizehorizontal']);
	$map_height->setContent($_POST['mapsizevertical']);
	// 地図の動く幅
	switch ($_POST['movemapsphere_group']['movemapsphere']) {
		case KAKIKOMAP_MOVEMAPSPHERE_NORMAL:
			$map_move->setContent(1);
			break;
		case KAKIKOMAP_MOVEMAPSPHERE_2FLAC:
			$map_move->setContent(0.5);
			break;
		case KAKIKOMAP_MOVEMAPSPHERE_3FLAC:
			$map_move->setContent(0.25);
			break;
		default:
			break;
	}
	// 初期表示座標
	$init_position = $_POST['startx'].",".$_POST['starty'].",".$_POST['endx'].",".$_POST['endy'];
	$map_init_position->setContent($init_position);

	if (is_array($input_mapno)){
		for($idx=0;$idx<count($input_mapno);$idx++){
			$j = $input_mapno[$idx];
			$dirVal = $dirVal . sprintf("%03d", $idx+1);
			$nameVal = $nameVal . $_POST['listname'][$j];
			$pixelVal = $pixelVal . $_POST['pixel'][$j];
			if ($idx != (count($input_mapno) - 1)){
				$dirVal = $dirVal . ",";
				$nameVal = $nameVal . ",";
				$pixelVal = $pixelVal . ",";
			}
		}

		// 表示名(KAKIKOエンジン)
		$kakiko_link_name->setContent($nameVal);
		// ディレクトリ名(KAKIKOエンジン)
		$kakiko_dir_path->setContent($dirVal);
		// １ｍ辺りのPIXEL数(KAKIKOエンジン)
		$kakiko_move_pixel->setContent($pixelVal);
		// マップファイル
		$map_file_name->setContent("0");
		// 中心スケール(KAKIKOエンジン ※中心表示するマップNO)
		$map_center->setContent($_POST['ex_def']);
	}else{
		// 表示名(KAKIKOエンジン)
		$kakiko_link_name->setContent("0");
		// ディレクトリ名(KAKIKOエンジン)
		$kakiko_dir_path->setContent("0");
		// マップファイル名
		if ($_POST["gisfile"] != ""){
			$map_file_name->setContent("map=../html/kakikomap/contents/{$curDir}/img/map/" . $_POST['gisfile']);
		}
		// 中心スケール
		$map_center->setContent($_POST['diffx'] . "," . $_POST['diffy']);
	}

	$rtn = $config->writeConfig($fpath, "inicommented");
	if ($rtn != true) {
		trigger_error($o_resource->getValue("G03006M037"), E_USER_ERROR);
		return;
	}

	return;
}

?>
