<?php
/**
* contentsenvset.php 処理概要：コンテンツ環境設定
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}

require_once("Config.php");
require_once("class/db/service/MapAdminService.class.php");
require_once("class/db/tabledata/MapData.class.php");
require_once("class/xml/ReadResource.class.php");							// リソースファイル読込み


// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"      => $o_resource->getValue("G03004L001"),
    "topTitle2"     => $o_resource->getValue("G03004L002"),
    "colTitle01"    => $o_resource->getValue("G03004L003"),
    "colTitle02"    => $o_resource->getValue("G03004L004"),
    "colTitle03"    => $o_resource->getValue("G03004L005"),
    "colTitle04"    => $o_resource->getValue("G03004L006"),
    "colTitle05"    => $o_resource->getValue("G03004L007"),
    "colTitle06"    => $o_resource->getValue("G03004L008"),
    "colTitle07"    => $o_resource->getValue("G03004L009"),
    "colTitle08"    => $o_resource->getValue("G03004L010"),
    "colTitle09"    => $o_resource->getValue("G03004L011"),
    "sampleColor"   => $o_resource->getValue("G03004L012"),
    "loginKnd00"    => $o_resource->getValue("G03004L013"),
    "loginKnd01"    => $o_resource->getValue("G03004L014"),
    "layerKnd00"    => $o_resource->getValue("G03004L015"),
    "layerKnd01"    => $o_resource->getValue("G03004L016"),
    "layer"         => $o_resource->getValue("G03004L017"),
    "memo"          => $o_resource->getValue("G03004L018"),
    "contentsKnd00" => $o_resource->getValue("G03004L019"),
    "contentsKnd09" => $o_resource->getValue("G03004L020"),
    "top"           => $o_resource->getValue("G03004L021"),
    "bottom"        => $o_resource->getValue("G03004L022"),
    "mark01"        => $o_resource->getValue("G03004L023"),
    "mark02"        => $o_resource->getValue("G03004L024"),
    "mark03"        => $o_resource->getValue("G03004L025"),
    "mark04"        => $o_resource->getValue("G03004L026"),
    "addBtn"        => $o_resource->getValue("G03004L027"),
    "rstBtn"        => $o_resource->getValue("G03004L028")
);

// 日付クラス
$o_date = new Date();

//セッションのテーブルオブジェクト取得
$tablename_obj = unserialize($_SESSION['_tablename']);
// DB接続サービス呼び出し
$o_service = new MapAdminService($tablename_obj->get_DirectryName());

// マップデータ型オブジェクト
$mapdata = new MapData();
// マップ情報の取得
if (selectRecode($o_service, $mapdata) == false) {
    exit();
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("contentsenvset", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "title"                    => $mapdata->getContentsName(),
    "h_publiccontents"         => $mapdata->getPublicContents(),
    "h_publiccontentsdatetime" => $mapdata->getPublicContentsDateTime(),
    "h_usertype"               => $mapdata->getUserType(),
    "autoLogin_group"          => $mapdata->getAutoLogin(),
    "addttestLayer_group"      => $mapdata->getAddAttestLayer(),
    "layerCount"               => $mapdata->getLayerCount(),
    "memotypeCount"            => $mapdata->getMemoTypeCount(),
    "publicContents_group"     => $mapdata->getPublicContents()
));

// レイヤー表示順設定情報の取得
$layerSeq1 = getLayer1($o_service);
if (is_null($layerSeq1)) {
	exit();
}
$layerSeq2 = getLayer2($o_service);
if (is_null($layerSeq2)) {
	exit();
}

// 項目セット
$o_date->setDate($mapdata->getPublicContentsDateTime());
$publiccontentsdatetime = $mapdata->getPublicContents()==KAKIKOMAP_PUBLICCONTENTS_OPEN?" (".$o_date->format("%Y/%m/%d").")":"";
$o_form->addElement("hidden", "h_publiccontents",         null);
$o_form->addElement("hidden", "h_publiccontentsdatetime", null);
$o_form->addElement("hidden", "h_usertype",               null);
$o_form->addElement("text",   "title",                   $label['colTitle01'], array("size"=>50, "maxlength"=>32, "autocomplete"=>"off", "class"=>"fs12_black"));
$array_autoLogin[]      =& HTML_QuickForm::createElement("radio", "autoLogin",      null, $label['loginKnd00'], KAKIKOMAP_AUTOLOGIN_PERMIT);
$array_autoLogin[]      =& HTML_QuickForm::createElement("radio", "autoLogin",      null, $label['loginKnd01'], KAKIKOMAP_AUTOLOGIN_NON);
$o_form->addGroup($array_autoLogin,      "autoLogin_group",      $label['colTitle05'], "&nbsp;");
$array_addttestLayer[]  =& HTML_QuickForm::createElement("radio", "addttestLayer",  null, $label['layerKnd00'], KAKIKOMAP_ADDATTESTUSER_ON);
$array_addttestLayer[]  =& HTML_QuickForm::createElement("radio", "addttestLayer",  null, $label['layerKnd01'], KAKIKOMAP_ADDATTESTUSER_OFF);
$o_form->addGroup($array_addttestLayer,  "addttestLayer_group",  $label['colTitle06'], "&nbsp;");
$o_form->addElement("text",   "layerCount",              $label['colTitle07'], array("size"=>3, "maxlength"=>3, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text",   "memotypeCount",           $label['colTitle07'], array("size"=>3, "maxlength"=>3, "autocomplete"=>"off", "class"=>"fs12_black"));
$array_publicContents[] =& HTML_QuickForm::createElement("radio", "publicContents", null, $label['contentsKnd00'].$publiccontentsdatetime, KAKIKOMAP_PUBLICCONTENTS_OPEN, array(($mapdata->getPublicContents()==KAKIKOMAP_PUBLICCONTENTS_CLOSED && $mapdata->getUserType()==KAKIKOMAP_USERTYPE_SYSTEM)?"disabled":""));
$array_publicContents[] =& HTML_QuickForm::createElement("radio", "publicContents", null, $label['contentsKnd09'], KAKIKOMAP_PUBLICCONTENTS_CLOSED, array(($mapdata->getPublicContents()==KAKIKOMAP_PUBLICCONTENTS_CLOSED && $mapdata->getUserType()==KAKIKOMAP_USERTYPE_SYSTEM)?"disabled":""));
$o_form->addGroup($array_publicContents, "publicContents_group", $label['colTitle08'], "&nbsp;");
$o_form->addElement("select", "layerSeq1",               $label['colTitle09'], $layerSeq1, array("size"=>"5", "style"=>"width:140px;", "class"=>"fs12_black"));
$o_form->addElement("select", "layerSeq2",               $label['colTitle09'], $layerSeq2, array("size"=>"5", "style"=>"width:140px;", "class"=>"fs12_black"));
$o_form->addElement("button", "moveTop",                 $label['mark03'],      array("onclick"=>"OptionMove(document.contentsenvset.layerSeq1, document.contentsenvset.layerSeq2)", "style"=>"width:35px;", "class"=>"fs12_black"));
$o_form->addElement("button", "movebtm",                 $label['mark04'],      array("onclick"=>"OptionMove(document.contentsenvset.layerSeq2, document.contentsenvset.layerSeq1)", "style"=>"width:35px;", "class"=>"fs12_black"));

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');
$o_form->registerRule('num_sphere_valid', 'callback', 'check_numeric_sphere_valid');

// チェック項目
$o_form->addRule("title",		$o_resource->getValue("G03004M001"), "required", null);
//$o_form->addRule("title",		$o_resource->getValue("G03004M002"), "maxlength_valid",	128);
$o_form->addRule("layerCount",              $o_resource->getValue("G03004M003"), "required", null);
$o_form->addRule("layerCount",				$o_resource->getValue("G03004M004"), "numeric", null);
$o_form->addRule("layerCount",				$o_resource->getValue("G03004M005"), "num_sphere_valid", array(1, 999));
$o_form->addRule("memotypeCount",           $o_resource->getValue("G03004M006"), "required", null);
$o_form->addRule("memotypeCount",			$o_resource->getValue("G03004M007"), "numeric", null);
$o_form->addRule("memotypeCount",			$o_resource->getValue("G03004M008"), "num_sphere_valid", array(1, 999));


$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
		if (updateRecode($o_service) == true) {
            $pageFlg = 1;
        }
    }
}
// リセットボタン
if (isset($_POST[reset])){
	//自分へリダイレクト
	header("location: ./contentsenvset.php");
	exit(0);
}

// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $o_form->addElement("header", "header", $label['topTitle']);
    $o_form->addElement("submit", "run",    $label['addBtn'], array("onclick"=>"addHidden(document.contentsenvset, document.contentsenvset.layerSeq1, 'listbox')", "class"=>"fs12_black"));
    $o_form->addElement("submit",  "reset",  $label['rstBtn'], array("class"=>"fs12_black"));
    $tplarray = array();
    $tplName = "admin_contentsenvset.tpl";
} else {
    // 完了画面
    $tplarray    = array(
                          "title"         => $label['topTitle2'],
                          "infomessage"   => $o_resource->getValue("G03004M010"),
                          "tablewidth"    => "550",
                          "tdwidth"       => "150",
                          "listdatas"     => "",
                          "buttonname"    => "",
                          "buttononclick" => ""
                         );
    $tplName = "commonfin.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form", $o_renderer->toArray());
$o_smarty->assign("sampleColor", $label['sampleColor']);
$o_smarty->assign("layer", $label['layer']);
$o_smarty->assign("memo", $label['memo']);
$o_smarty->assign("mark01", $label['mark01']);
$o_smarty->assign("mark02", $label['mark02']);
$o_smarty->assign("top", $label['top']);
$o_smarty->assign("bottom", $label['bottom']);
$o_smarty->assign("infoMsg01", $o_resource->getValue("G03004M009"));
$o_smarty->assign("tplarray", $tplarray);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：コンテンツ環境設定表示情報取得
* 処理詳細：マップ管理テーブルより該当のマップ管理者の情報を取得する
*
* @引数： (I)   o_service    - object DBサービスクラス
*      ： (I/O) data		 - object データオブジェクト
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function selectRecode($o_service, &$data) {

	$data = $o_service->getContentsEnvInfoData($_SESSION['_userid']);
	if (is_null($data)) {
		return false;
	}

	return true;
}

/**
* 関数概要：優先順位設定レイヤー情報取得
* 処理詳細：コンテンツレイヤー優先順位管理テーブルより表示データを取得
*
* @引数： (I)   o_service    - object DBサービスクラス
* @戻値： array 一覧情報(連想配列)
*               DBアクセス異常の場合はnull
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getLayer1($o_service) {

	$data_array = $o_service->getSettingPriorityLayerData();
	if (is_null($data_array)) {
		return null;
	} else {
		// 取得データオブジェクトセット
		$layerArray = array();
		for ($i = 0; $i < count($data_array); $i++) {
			$data = $data_array[$i];
			$layerArray[$data->getLayerID_LayerPriority()] = 
										$data->getLayerName_Layer();
		}
	}

    return $layerArray;
}

/**
* 関数概要：優先順位未設定レイヤー情報取得
* 処理詳細：レイヤー管理テーブルより表示データを取得
*
* @引数： (I)   o_service    - object DBサービスクラス
* @戻値： array 一覧情報(連想配列)
*               DBアクセス異常の場合はnull
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getLayer2($o_service) {

	$data_array = $o_service->getNoSettingPriorityLayerData();
	if (is_null($data_array)) {
		return null;
	} else {
		// 取得データオブジェクトセット
		$layerArray = array();
		for ($i = 0; $i < count($data_array); $i++) {
			$data = $data_array[$i];
			$layerArray[$data->getLayerID()] = $data->getLayerName();
		}
	}

    return $layerArray;
}

/**
* 関数概要：コンテンツ環境設定内容更新
* 処理詳細：入力された内容をデータベースへ更新する
*           ・マップ管理テーブル
*           ・コンテンツレイヤー優先順位管理テーブル
*
* @引数： (I)   o_service    - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function updateRecode($o_service) {


	// 条件及びNULL等のターゲット設定
	$targetMapDataObj = new MapData();

	// 条件
	$targetMapDataObj->setUserID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetMapDataObj->setPublicContents(VAL_TARGET);
	$targetMapDataObj->setPublicContentsDateTime(VAL_TARGET);
	$targetMapDataObj->setAddAttestLayer(VAL_TARGET);
	$targetMapDataObj->setUserType(VAL_TARGET);
	$targetMapDataObj->setContentsName(VAL_TARGET);
	$targetMapDataObj->setAutoLogin(VAL_TARGET);
	$targetMapDataObj->setLayerCount(VAL_TARGET);
	$targetMapDataObj->setMemoTypeCount(VAL_TARGET);
	$targetMapDataObj->setUpdateDateTime(VAL_TARGET);

	// 更新項目設定
	$valMapDataObj = new MapData();

	// ユーザID(キー)
	$valMapDataObj->setUserID($_SESSION['_userid']);
	// コンテンツ公開区分
	if (isset($_POST['publicContents_group']['publicContents'])) {
	    $valMapDataObj->setPublicContents($_POST['publicContents_group']['publicContents']);
		// ユーザ種別
		$valMapDataObj->setUserType(KAKIKOMAP_USERTYPE_MAP);
	} else {
	    $valMapDataObj->setPublicContents($_POST['h_publiccontents']);
		// ユーザ種別
		$valMapDataObj->setUserType($_POST['h_usertype']);
	}
	// コンテンツ公開日付
	if ($_POST['h_publiccontents'] == $_POST['publicContents_group']['publicContents']) {
		if ($_POST['publicContents_group']['publicContents'] == KAKIKOMAP_PUBLICCONTENTS_OPEN) {
	    	$valMapDataObj->setPublicContentsDateTime($_POST['h_publiccontentsdatetime']);
	    } elseif ($_POST['publicContents_group']['publicContents'] == KAKIKOMAP_PUBLICCONTENTS_CLOSED) {
	    	$valMapDataObj->setPublicContentsDateTime(NULL_CHAR);
	    }
	} else {
		if ($_POST['publicContents_group']['publicContents'] == KAKIKOMAP_PUBLICCONTENTS_OPEN) {
	    	$valMapDataObj->setPublicContentsDateTime(date('Y/m/d H:i:s'));
	    } elseif ($_POST['publicContents_group']['publicContents'] == KAKIKOMAP_PUBLICCONTENTS_CLOSED) {
	    	$valMapDataObj->setPublicContentsDateTime(NULL_CHAR);
	    }
	}
	// レイヤー登録認証区分
	$valMapDataObj->setAddAttestLayer($_POST['addttestLayer_group']['addttestLayer']);
	// コンテンツ名称
	$valMapDataObj->setContentsName($_POST['title']);
	// 自動ログイン区分
	$valMapDataObj->setAutoLogin($_POST['autoLogin_group']['autoLogin']);
	// レイヤー数
	$valMapDataObj->setLayerCount($_POST['layerCount']);
	// メモ種類数
	$valMapDataObj->setMemoTypeCount($_POST['memotypeCount']);
	// 更新日時
	$valMapDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

	$rtn = $o_service->setContentsEnv($targetMapDataObj, $valMapDataObj, $_POST['listbox']);
	if ($rtn) {
		// iniファイルへの書き出し
		writeIniFile();
	}

	return $rtn;
}

/**
* 関数概要：イニファイル項目書込み処理
* 処理詳細：コンテンツ対象のイニファイルへの項目書込み処理を行う
*
* @引数： 
* @戻値： 
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function writeIniFile() {

    $o_tblname = unserialize($_SESSION['_tablename']);
    $dirname = $o_tblname->get_DirectryName();

	$dirs = split(PATH_SEPARATOR, ini_get('include_path')); 
	foreach ($dirs as $dirpath) {

	    $fpath = $dirpath.DIRECTORY_SEPARATOR."kakikomap".DIRECTORY_SEPARATOR."ini".DIRECTORY_SEPARATOR."auto".DIRECTORY_SEPARATOR.$dirname."_setting.ini";

		if(is_file($fpath)){
			$config = new Config();
			$setting = $config->parseConfig($fpath, "inicommented");
			break;
		}
	}

    // 自動ログイン区分
	$map_autologin =& $setting->searchPath(array("MAP_AUTOLOGIN"));
	// マップ公開区分
	$map_public =& $setting->searchPath(array("MAP_PUBLIC"));

	// 設定
	// 自動ログイン区分
	$map_autologin->setContent($_POST['autoLogin_group']['autoLogin']);
	// マップ公開区分
	if (isset($_POST['publicContents_group']['publicContents'])) {
	    $map_public->setContent($_POST['publicContents_group']['publicContents']);
	} else {
	    $map_public->setContent($_POST['h_publiccontents']);
	}

	$rtn = $config->writeConfig($fpath, "inicommented");
	if ($rtn != true) {
		trigger_error($o_resource->getValue("G03004M011"), E_USER_ERROR);
		return;
	}

	return;
}

?>
