<?php
/**
* contentsstatelist.php 処理概要：コンテンツ状態一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}

require_once("Config.php");
require_once("class/db/dbaccess/DataObject.php");
require_once("class/db/service/SystemAdminService.class.php");
require_once("class/db/tabledata/MapData.class.php");
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"=>$o_resource->getValue("G02007L001"),
    "listTitle01"=>$o_resource->getValue("G02007L002"),
    "listTitle02"=>$o_resource->getValue("G02007L003"),
    "listTitle03"=>$o_resource->getValue("G02007L004"),
    "listTitle04"=>$o_resource->getValue("G02007L005"),
    "listTitle05"=>$o_resource->getValue("G02007L006"),
    "sts0"=>$o_resource->getValue("G02007L007"),
    "sts9"=>$o_resource->getValue("G02007L008"),
    "stsBtn0"=>$o_resource->getValue("G02007L009"),
    "stsBtn9"=>$o_resource->getValue("G02007L010"),
    "updBtn"=>$o_resource->getValue("G02007L011")
);

// 日付クラス
$o_date = new Date();

// DB接続サービス呼び出し
$o_service = new SystemAdminService($_POST['h_dir']);

// 状態の変更
if($_POST['submitKnd']=="1"){
    $rtn = chengeRecord($o_service);
    if ($rtn != true) {
    	exit();
    }
}

// コンテンツ状態情報一覧データの取得
$classdata = $o_service->getContentsStatusInfoDataList();
if (is_null($classdata)) {
	exit();
}

if ($_POST['submitKnd']=="1") {
    $perPage = $_POST['h_perpage'];
    $nowpage = $_POST['h_page'];
    $chgsts = TRUE;
} else {
    $nowpage = 0;
    $chgsts = FALSE;
}

// Pager
$rowNum = count($classdata);
$params = array(
    "perPage"=>CONTENTSSTATELIST_ROW,
    "mode"=>"Jumping",
    "totalItems"=>$rowNum,
    "prevImg"=>$o_resource->getValue("G02007L012"),
    "nextImg"=>$o_resource->getValue("G02007L013"),
    "httpMethod"=>"POST"
);

// POSTで渡って来た内容を破棄
unset($_POST['h_userid'], 
      $_POST['h_dir'], 
      $_POST['h_sts'], 
      $_POST['h_page'], 
      $_POST['submitKnd']
      );

$o_page = Pager::factory($params);
if ($nowpage > $o_page->numPages()){
    $nowpage = $o_page->numPages();
}
if ($chgsts) {
    $navi = $o_page->getlinks($nowpage);
} else {
    $navi = $o_page->getlinks();
    $nowpage = $o_page->getCurrentPageID();
}

// 一覧データ作成
$list = createList($classdata, $o_date, ($nowpage - 1) * CONTENTSSTATELIST_ROW, CONTENTSSTATELIST_ROW, $rowNum);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_smarty->assign("labels", $label);
$o_smarty->assign("listdatas", $list);
$o_smarty->assign("pager", $navi["all"]);
$o_smarty->assign("nowpage", $nowpage);
$o_smarty->assign("chkmsg", $o_resource->getValue("G02007M001"));

$o_smarty->display("admin_contentsstatelist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：コンテンツ状態一覧表示情報取得
* 処理詳細：管理者ユーザテーブルより情報を取得する
*
* @引数： (I) data		- object  データオブジェクト
*         (I) o_date 	- object  日付クラス
*         (I) start  	- integer 開始抽出データ
*         (I) cnt    	- integer 抽出データ数
*         (I) rowNum 	- integer データ件数
* @戻値： object レコードセット
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function createList($data, $o_date, $start, $cnt, $rowNum){

    $array_user = array();

    for ($i = $start; $i < $start + $cnt; $i++) {

        if ($i == $rowNum) break;
        
		if (is_null($data[$i]))	break;

		$o_date->setDate($data[$i]->getAddDateTime_AdminUser());

		$o_user = array(
			"userID"=>$data[$i]->getUserID_AdminUser(),
            "userName"=>$data[$i]->getUserName_AdminUser(),
            "publicContents"=>$data[$i]->getPublicContents_Map(),
            "contentsName"=>$data[$i]->getContentsName_Map(),
            "directoryName"=>$data[$i]->getDirectryName_Map(),
            "addDateTime"=>$o_date->format("%Y/%m/%d")
		);
		$array_user[] = $o_user;
    }
    return $array_user;
}

/**
* 関数概要：マップテーブル状態更新
* 処理詳細：マップテーブルの状態フラグを変更する
*
* @引数： (I) o_service    - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function chengeRecord($o_service) {

	// マップ管理テーブルデータの更新

	// 条件及びNULL等のターゲット設定
	$targetMapDataObj = new MapData();

	// 条件
	$targetMapDataObj->setUserID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetMapDataObj->setPublicContents(VAL_TARGET);
	$targetMapDataObj->setUserType(VAL_TARGET);
	$targetMapDataObj->setUpdateDateTime(VAL_TARGET);

	// 更新項目設定
	$valMapDataObj = new MapData();

	// ユーザID(キー)
	$valMapDataObj->setUserID($_POST['h_userid']);
	// コンテンツ公開区分
	$valMapDataObj->setPublicContents(
				$_POST['h_sts'] == KAKIKOMAP_PUBLICCONTENTS_OPEN 
					? KAKIKOMAP_PUBLICCONTENTS_CLOSED : KAKIKOMAP_PUBLICCONTENTS_OPEN
				);
	// コンテンツ公開日付
	if ($valMapDataObj->getPublicContents() == KAKIKOMAP_PUBLICCONTENTS_OPEN) {
		$targetMapDataObj->setPublicContentsDateTime(VAL_TARGET);
		$valMapDataObj->setPublicContentsDateTime(date('Y/m/d H:i:s'));
	}
	// ユーザ種別
	$valMapDataObj->setUserType(KAKIKOMAP_USERTYPE_SYSTEM);
	// 更新日時
	$valMapDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

	// マップデータ更新処理
	$rtn = $o_service->updateMapDataByKey($targetMapDataObj, $valMapDataObj);
	if ($rtn) {
		// iniファイルへの書き出し
		writeIniFile();
	}

    return $rtn;
}

/**
* 関数概要：イニファイル項目書込み処理
* 処理詳細：コンテンツ対象のイニファイルへの項目書込み処理を行う
*
* @引数： 
* @戻値： 
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function writeIniFile() {

    $dirname = $_POST['h_dir'];

	$dirs = split(PATH_SEPARATOR, ini_get('include_path')); 
	foreach ($dirs as $dirpath) {

	    $fpath = $dirpath.DIRECTORY_SEPARATOR."kakikomap".DIRECTORY_SEPARATOR."ini".DIRECTORY_SEPARATOR."auto".DIRECTORY_SEPARATOR.$dirname."_setting.ini";

		if(is_file($fpath)){
			$config = new Config();
			$setting = $config->parseConfig($fpath, "inicommented");
			break;
		}
	}

	// マップ公開区分
	$map_public =& $setting->searchPath(array("MAP_PUBLIC"));

	// 設定
	// マップ公開区分
    $map_public->setContent($_POST['h_sts'] == KAKIKOMAP_PUBLICCONTENTS_OPEN 
					? KAKIKOMAP_PUBLICCONTENTS_CLOSED : KAKIKOMAP_PUBLICCONTENTS_OPEN);

	$rtn = $config->writeConfig($fpath, "inicommented");
	if ($rtn != true) {
		trigger_error($o_resource->getValue("G02007M002"), E_USER_ERROR);
		return;
	}

	return;
}

?>
