<?php
/**
* mapadmindel.php 処理概要：マップ管理者削除
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}

require_once("class/db/service/SystemAdminService.class.php");
require_once("class/xml/ReadResource.class.php");						// リソースファイル読込み

require_once("function/KakikoFile.php");

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"=>$o_resource->getValue("G02005L001"),
    "topTitle2"=>$o_resource->getValue("G02005L002"),
    "listTitle01"=>$o_resource->getValue("G02005L003"),
    "listTitle02"=>$o_resource->getValue("G02005L004"),
    "listTitle03"=>$o_resource->getValue("G02005L005"),
    "listTitle04"=>$o_resource->getValue("G02005L006"),
    "listTitle05"=>$o_resource->getValue("G02005L007"),
    "delBtn"=>$o_resource->getValue("G02005L008"),
    "lstBtn"=>$o_resource->getValue("G02005L009"),
    "rtnBtn"=>$o_resource->getValue("G02005L010")
);

// DB接続サービス呼び出し
$o_service = new SystemAdminService($_POST['h_dir']);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("mapadmindel", "POST", $_SERVER["PHP_SELF"]);

$pageFlg = 0;

if (isset($_POST[run])) {
    if ($o_form->validate()) {
        if ($_POST['delchk'] == 1) {
            if (deleteRecord($o_service) == true) {
                $pageFlg = 1;
            }
        } else {
            $errorMessage = $o_resource->getValue("G02005M006");
        }
    }
}

if ($pageFlg == 0) {
    // 削除確認画面
    $o_form->addElement("header",   "header",         $label['topTitle']);
    $o_form->addElement("hidden",   "h_userid",       $_POST['h_userid']);
    $o_form->addElement("hidden",   "h_username",     $_POST['h_username']);
    $o_form->addElement("hidden",   "h_contentsname", $_POST['h_contentsname']);
    $o_form->addElement("hidden",   "h_mail",         $_POST['h_mail']);
    $o_form->addElement("hidden",   "h_dir",          $_POST['h_dir']);
    $o_form->addElement("checkbox", "delchk",         null, $o_resource->getValue("G02005M005"));
    $o_form->addElement("submit",   "run",            $label['delBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("button",   "return",         $label['rtnBtn'], array("onclick"=>"location.href='./mapadminlist.php'", "class"=>"fs12_black"));
    $tplarray = array();
    $tplName = "admin_mapadmindel.tpl";
} else {
    // 完了画面
    $tplarray    = array(
                          "title"         => $label['topTitle2'],
                          "infomessage"   => $o_resource->getValue("G02005M002"),
                          "tablewidth"    => "550",
                          "tdwidth"       => "150",
                          "listdatas"     => "",
                          "buttonname"    => $label['lstBtn'],
                          "buttononclick" => "location.href='mapadminlist.php'"
                         );
    $tplName = "commonfin.tpl";
}

// 項目名の配列
$delDataLabel = array(
    "userID"=>$label['listTitle01'],
    "userName"=>$label['listTitle02'],
    "contentsName"=>$label['listTitle03'],
    "mail"=>$label['listTitle04'],
    "dir"=>$label['listTitle05']
);

// 削除する内容を配列へ
$delData = array(
    "userID"=>$_POST['h_userid'],
    "userName"=>$_POST['h_username'],
    "contentsName"=>$_POST['h_contentsname'],
    "mail"=>$_POST['h_mail'],
    "dir"=>$_POST['h_dir'],
);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form", $o_renderer->toArray());
$o_smarty->assign("delData", $delData);
$o_smarty->assign("delDataLabel", $delDataLabel);
$o_smarty->assign("infoMsg01", $o_resource->getValue("G02005M001"));
$o_smarty->assign("tplarray", $tplarray);
$o_smarty->assign("delchk1", $o_resource->getValue("G02005M003"));
$o_smarty->assign("delchk2", $o_resource->getValue("G02005M004"));
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：マップ管理者削除
* 処理詳細：管理者ユーザテーブルより情報を削除する
*
* @引数： (I) o_service    - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function deleteRecord($o_service) {

	// マップ管理者削除処理
	$rtn = $o_service->deleteMapAdminUser($_POST['h_userid']);

    return $rtn;
}

?>
