<?php
/**
* mapadminregist.php 処理概要：マップ管理者登録
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");

// POST情報更新
if (isset($_POST['directry'])) {
    // ディレクトリ名は小文字のみ
    $_POST['directry'] = strtolower($_POST['directry']);
}
// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}

require_once("class/common/KakikoPassword.class.php");
require_once("class/mail/KakikoMail.class.php");                     // メール送信クラス
require_once("class/db/service/SystemAdminService.class.php");
require_once("class/db/tabledata/UserData.class.php");
require_once("class/db/tabledata/MapData.class.php");
require_once("class/db/tabledata/BaseMapData.class.php");
require_once("class/xml/ReadResource.class.php");                    // リソースファイル読込み

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"=>$o_resource->getValue("G02003L001"),
    "topTitle2"=>$o_resource->getValue("G02003L002"),
    "colTitle01"=>$o_resource->getValue("G02003L003"),
    "colTitle02"=>$o_resource->getValue("G02003L004"),
    "colTitle03"=>$o_resource->getValue("G02003L005"),
    "colTitle04"=>$o_resource->getValue("G02003L006"),
    "addBtn"=>$o_resource->getValue("G02003L007"),
    "rstBtn"=>$o_resource->getValue("G02003L008"),
    "lstBtn"=>$o_resource->getValue("G02003L009"),
    "rtnBtn"=>$o_resource->getValue("G02003L010")
);

// DB接続サービス呼び出し
$o_service = new SystemAdminService($_POST['directry']);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("mapadminregist", "POST", $_SERVER["PHP_SELF"]);

// 項目セット
$o_form->addElement("text", "userID",       $label['colTitle01'], array("size"=>16, "maxlength"=>16,  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text", "mailAddress1", $label['colTitle02'], array("size"=>40, "maxlength"=>128, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text", "mailAddress2", $label['colTitle03'], array("size"=>40, "maxlength"=>128, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text", "directry",     $label['colTitle04'], array("size"=>16, "maxlength"=>16, "autocomplete"=>"off", "class"=>"fs12_black"));

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("userID",			$o_resource->getValue("G02003M001"), "required",		null);
$o_form->addRule("userID",			$o_resource->getValue("G02003M002"), "regex", 			"/^[a-zA-Z0-9]+$/");
$o_form->addRule("userID",			$o_resource->getValue("G02003M003"), "maxlength_valid",	16);
$o_form->addRule("mailAddress1",	$o_resource->getValue("G02003M004"), "required",		null);
$o_form->addRule("mailAddress1",	$o_resource->getValue("G02003M005"), "email",			null);
$o_form->addRule("mailAddress1",	$o_resource->getValue("G02003M006"), "maxlength_valid",	128);
$o_form->addRule("mailAddress2",	$o_resource->getValue("G02003M007"), "required",		null);
$o_form->addRule("mailAddress2",	$o_resource->getValue("G02003M008"), "email",			null);
$o_form->addRule("mailAddress2",	$o_resource->getValue("G02003M009"), "maxlength_valid",	128);
$o_form->addRule( array("mailAddress1","mailAddress2"), $o_resource->getValue("G02003M010"), "compare", NULL);
$o_form->addRule("directry",		$o_resource->getValue("G02003M011"), "required",		null);
$o_form->addRule("directry",		$o_resource->getValue("G02003M012"), "regex", 			"/^[a-zA-Z0-9]+$/");
$o_form->addRule("directry",		$o_resource->getValue("G02003M013"), "maxlength_valid",	16);


$errorMessage = "";
$pageFlg = 0;
$provpass = "";

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // 入力データの存在チェック
        if (checkRecord_UserID($o_service) == true) {
            if (checkRecord_Directry($o_service) == true) {
                if (insertRecord($o_service) == true) {
                    sendMail($o_resource);
                    $pageFlg = 1;
                }
            } else {
            	$errorMessage = $o_resource->getValue("G02003M018");
            }
        } else {
        	$errorMessage = $o_resource->getValue("G02003M014");
        }
    }
}

// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $o_form->addElement("header", "header", $label['topTitle']);
    $o_form->addElement("submit", "run",    $label['addBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("reset",  "reset",  $label['rstBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("button", "return", $label['rtnBtn'], array("onclick"=>"location.href='mapadminlist.php'", "class"=>"fs12_black"));
    $tplarray = array();
    $tplName = "admin_mapadminregist.tpl";
} else {
    // 完了画面
    $listdatas = array();
    $listdatas[] = array("rowname" => $label['colTitle01'], "rowdata" => $_POST['userID']);
    $listdatas[] = array("rowname" => $label['colTitle02'], "rowdata" => $_POST['mailAddress1']);
    $listdatas[] = array("rowname" => $label['colTitle04'], "rowdata" => $_POST['directry']);
    $tplarray    = array(
                          "title"         => $label['topTitle2'],
                          "infomessage"   => $o_resource->getValue("G02003M017"),
                          "tablewidth"    => "550",
                          "tdwidth"       => "150",
                          "listdatas"     => $listdatas,
                          "buttonname"    => $label['lstBtn'],
                          "buttononclick" => "location.href='mapadminlist.php'"
                         );
    $tplName = "commonfin.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form", $o_renderer->toArray());
$o_smarty->assign("infoMsg01", $o_resource->getValue("G02003M015"));
$o_smarty->assign("infoMsg02", $o_resource->getValue("G02003M016"));
$o_smarty->assign("tplarray", $tplarray);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：管理者ユーザ管理テーブル存在チェック
* 処理詳細：管理者ユーザ管理テーブルに登録するデータが既に存在しているかチェックする
*
* @引数： (I) o_service    - object DBサービスクラス
* @戻値： boolean true :重複データなし
*      ：         false:重複データあり
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function checkRecord_UserID($o_service) {

	$rtn = $o_service->checkAdminUserDataByKey($_POST['userID']);

    return $rtn;
}

/**
* 関数概要：マップテーブル存在チェック
* 処理詳細：マップテーブルに登録するデータが既に存在しているかチェックする
*
* @引数： (I) o_service    - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function checkRecord_Directry($o_service) {

	//jsはjavascriptフォルダなので予約語として指定している
	if ($_POST['directry'] == "js"){
		return false;
	}
	$rtn = $o_service->checkMapDataByDirectryName($_POST['directry']);

    return $rtn;
}

/**
* 関数概要：マップ管理者登録処理
* 処理詳細：マップ管理者を新規に登録する
*
* @引数： (I) o_service    - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function insertRecord($o_service) {

    global $provpass;        // 仮パスワード

	//マップデータ作成
	$mapdata = new MapData();

	$mapdata->setUserID($_POST['userID']);
	$mapdata->setDirectryName($_POST['directry']);
	$mapdata->setPublicContents(KAKIKOMAP_PUBLICCONTENTS_CLOSED);
	$mapdata->setPublicContentsDateTime(null);
	$mapdata->setAddAttestLayer(KAKIKOMAP_ADDATTESTLAYER_ON);
	$mapdata->setUserType(KAKIKOMAP_USERTYPE_MAP);
	$mapdata->setContentsName("--");
	$mapdata->setAutoLogin(KAKIKOMAP_AUTOLOGIN_NON);
	$mapdata->setLayerCount(10);
	$mapdata->setMemoTypeCount(10);
	$mapdata->setAddDateTime(date('Y/m/d H:i:s'));
	$mapdata->setUpdateDateTime(date('Y/m/d H:i:s'));

	//ベースマップデータ作成
	$basemapdata = new BaseMapData();

	$basemapdata->setDirectryName($_POST['directry']);
	$basemapdata->setUseGIS(KAKIKOMAP_USEGIS_ON);
	$basemapdata->setStartX(0);
	$basemapdata->setStartY(0);
	$basemapdata->setEndX(0);
	$basemapdata->setEndY(0);
	$basemapdata->setMapSizeHorizontal(0);
	$basemapdata->setMapSizeVertical(0);
	$basemapdata->setDiffX(null);
	$basemapdata->setDiffY(null);
	$basemapdata->setMoveMapSphere(KAKIKOMAP_MOVEMAPSPHERE_NORMAL);
	$basemapdata->setAddDateTime(date('Y/m/d H:i:s'));
	$basemapdata->setUpdateDateTime(date('Y/m/d H:i:s'));

	//仮パスワード発行処理
    $p_obj = new KakikoPassword();
    $p_obj->extension_array = array(".", "_", "-");
    $p_obj->publicate(7, KAKIKO_PASSWORD_NUMBER);

	//ユーザデータ作成
	$userdata = new UserData();

	$userdata->setUserID($_POST['userID']);
	$userdata->setUserType(KAKIKOMAP_USERTYPE_MAP);
	$userdata->setMailAddress($_POST['mailAddress1']);
//パスワードをとりあえずユーザ名称に出力しておく
	$userdata->setUserName("--");
//	$userdata->setUserName("パスワードは".$p_obj->out_string);
	$provpass = $p_obj->out_string;
	$userdata->setPassword(md5($p_obj->out_string));
	$userdata->setStatusFlg(KAKIKOMAP_STATUSFLG_ON);
	$userdata->setAddDateTime(date('Y/m/d H:i:s'));
	$userdata->setUpdateDateTime(date('Y/m/d H:i:s'));

	// マップ管理者登録処理
	$rtn = $o_service->insertMapAdminUser($mapdata, $basemapdata, $userdata);

    return $rtn;
}

/**
* 関数概要：メール送信処理
* 処理詳細：マップ管理者に対して登録完了メールを送信する
*
* @引数： (I) o_resource   - object リソースクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function sendMail($o_resource) {

    global $provpass;        // 仮パスワード

    // -----------------------
    // メール送信用設定
    // -----------------------
    // メール種類
    $mode        = "smtp";
    // 送信先アドレス
    $toAddress   = $_POST['mailAddress1'];
    // 送信先名称
    $toName      = $_POST['userID'].$o_resource->getValue("G02003M020");
    // 送信元アドレス
    $fromAddress = $_SESSION['_authadminsession']['data']['mailaddress'];
    // 送信元名称
    $fromName    = $o_resource->getValue("G02003M021");
    // 件名
    $subject     = $o_resource->getValue("G02003M022");
    // 本文
    $message     = $_POST['userID'].$o_resource->getValue("G02003M023")."\n"
                  ."\n"
                  .$o_resource->getValue("G02003M024")."\n"
                  .$o_resource->getValue("G02003M025")."\n"
                  ."\n"
                  .$o_resource->getValue("G02003M026").$_POST['userID']."\n"
                  .$o_resource->getValue("G02003M027").$provpass."\n"
                  .$o_resource->getValue("G02003M028").$_POST['mailAddress1']."\n"
                  ."\n"
                  .$o_resource->getValue("G02003M029")."\n"
                  .$o_resource->getValue("G02003M030")."\n"
                  .getProtocol().$_SERVER["SERVER_NAME"].dirname(dirname($_SERVER["PHP_SELF"]))."/index.php\n"
                  .$o_resource->getValue("G02003M031")."\n"
                  ."\n"
                  .$o_resource->getValue("G02003M032")."\n"
                  .getProtocol().$_SERVER["SERVER_NAME"].dirname(dirname(dirname($_SERVER["PHP_SELF"])))."/contents/".$_POST['directry']."/index.php\n"
                  ."\n"
                  ."\n"
                  .$o_resource->getValue("G02003M033")."\n";

    
    // メール送信処理
    $o_email = new KakikoMail();
    $mailitems = array(
                        "ToAddress"   => $toAddress,    //送信先アドレス
                        "ToName"      => $toName,       //送信先名称
                        "FromAddress" => $fromAddress,  //送信元アドレス
                        "FromName"    => $fromName,     //送信元名称
                        "ReplyTo"     => $fromAddress,  //返信先アドレス
                        "Subject"     => $subject,      //件名
                        "Message"     => $message,      //本文
                       );
    $o_email->createMail($mailitems);
    $ret = $o_email->sendEmail($mode);
    if (PEAR::isError($ret)){
        trigger_error($ret->getMessage()."\n".$o_resource->getValue("G02003M019"), E_USER_ERROR);
        return false;
    }

    return true;

}

?>
