/**
* 処理概要：マップ画面動作スクリプト
* @パッケージ：-
* @作者：
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

var pageLoadedStatus = false;	// 読み込み完了ステータス

/**
 * 関数概要：まっぷコンソール読み込み完了ステータス設定
 * 処理詳細：まっぷコンソールの読み込み完了ステータスを設定します。
 *
 * @引数： (I) sts - ステータス(true/false)
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function setLoadedStatus(sts){

	pageLoadedStatus = sts;
	
}

/**
 * 関数概要：まっぷコンソールレイヤー表示切替処理
 * 処理詳細：まっぷコンソールでのレイヤー表示切替（表示・非表示）
 *
 * @引数： (I) id     - divタグのid
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function foldLayer(id)
{
	var oj = document.getElementById(id);

	if(oj.style.display == 'none'){
		oj.style.display = 'inline';
	}else{
		oj.style.display = 'none';
	}
}

/**
 * 関数概要：ラジオボタン一括切替処理
 * 処理詳細：レイヤー単位でラジオボタンの表示切替（リボン・ピン・非表示）を行う
 *
 * @引数： (I) layerid - divタグのid(layerid)
 * @引数： (I) val     - ラジオボタンインデックス
 *                       (0:リボン 1:ピン 2:非表示)
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function radioLayerSetting(leyerid, val) { 
	var oj = document.getElementById(leyerid);
    var arrInput = oj.getElementsByTagName('input'); 
    var hashRadio = new Array; 
    var i; 
    var key; 
    
    for (i=0; i<arrInput.length; i++) { 
        if (arrInput[i].type == 'radio') { 
            hashRadio[arrInput[i].name] = 1; 
        } 
    } 

    for (key in hashRadio) { 
		if(key.indexOf(leyerid) != -1){
			document.getElementsByName(key)[val].checked = true; 
			document.getElementsByName(key)[val].click(); 
		}
    } 
}

/**
 * 関数概要：ラジオボタン一括切替処理(意味空間専用ロジック)
 * 処理詳細：カラー単位でラジオボタンの表示切替（リボン・ピン・非表示）を行う
 *
 * @引数： (I) val     - ラジオボタンインデックス
 *                       (0:リボン 1:ピン 2:非表示)
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function radioColorCategorySetting(val) { 
	var oj = document.getElementById('categoryColor');
    var arrInput = oj.getElementsByTagName('input'); 
    var hashRadio = new Array; 
    var i; 
    var key; 
    
    for (i=0; i<arrInput.length; i++) { 
        if (arrInput[i].type == 'radio') { 
            hashRadio[arrInput[i].name] = 1; 
        } 
    } 

    for (key in hashRadio) { 
		if(key.indexOf('categoryColor_') != -1){
			document.getElementsByName(key)[val].checked = true; 
			document.getElementsByName(key)[val].click(); 
		}
    } 
}

/**
 * 関数概要：メモ表示切替処理
 * 処理詳細：メモ表示切替を行う（まっぷ画面のロード時にコールされるイベント）
 *
 * @引数： (I) divid  - レイヤー表示DIVのID
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function raiseRadioClickEvent(divid) { 
	var oj = document.getElementById(divid);
//alert(oj.innerHTML);
    var arrInput = oj.getElementsByTagName('input'); 
    var hashRadio = new Array; 
    var i; 
    var key; 
    
    for (i=0; i<arrInput.length; i++) { 
        if (arrInput[i].type == 'radio') { 
            hashRadio[arrInput[i].name] = 1; 
        } 
    } 

    for (key in hashRadio) {
		for(var i=0; i< document.getElementsByName(key).length; i++){
			if(document.getElementsByName(key)[i].checked == true){
				document.getElementsByName(key)[i].click(); 
			}
		}
    } 
}

/**
 * 関数概要：レイヤー登録画面遷移処理
 * 処理詳細：レイヤー登録画面への遷移処理を行う
 *
 * @引数： (I) action  - フォームのaction先
 * @引数： (I) layerid - レイヤーID
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function submitRequestProcess(action, layerId){

	document.requestProcessForm.layerID.value = layerId;
	document.requestProcessForm.action = action;
	document.requestProcessForm.submit();
}


/**
 * 関数概要：メモ検索条件送信処理
 * 処理詳細：メイン画面へメモ検索条件の送信処理を行う
 *
 * @引数： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function submitMemoSearchProcess(){

	top.map.document.kakikoFromMap.method = "GET";
	top.map.document.kakikoFromMap.searchNew.value = document.memoControlForm.searchNew.value;
	top.map.document.kakikoFromMap.searchFromDate.value = document.memoControlForm.elements['searchFromDate[Y]'].value
															+ "-" + document.memoControlForm.elements['searchFromDate[m]'].value
															+ "-" + document.memoControlForm.elements['searchFromDate[d]'].value;
	top.map.document.kakikoFromMap.searchToDate.value = document.memoControlForm.elements['searchToDate[Y]'].value
															+ "-" + document.memoControlForm.elements['searchToDate[m]'].value
															+ "-" + document.memoControlForm.elements['searchToDate[d]'].value;
	top.map.document.kakikoFromMap.searchWord.value = document.memoControlForm.searchWord.value;

	top.map.document.kakikoFromMap.submit();

}

/**
 * 関数概要：メモ一覧ウィンドウ表示処理
 * 処理詳細：メモ一覧ウィンドウを開き、メモ検索条件送信する処理を行う
 *
 * @引数： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function openMemoListWindow(){
//alert(top.map.document.kakikoFromMap.mapext.value );
	// 検索条件を追加
	var getString =	'?searchNew=' + document.memoControlForm.searchNew.value
					+'&searchFromDate=' + document.memoControlForm.elements['searchFromDate[Y]'].value
										+ "-" + document.memoControlForm.elements['searchFromDate[m]'].value
										+ "-" + document.memoControlForm.elements['searchFromDate[d]'].value
					+'&searchToDate=' + document.memoControlForm.elements['searchToDate[Y]'].value
										+ "-" + document.memoControlForm.elements['searchToDate[m]'].value
										+ "-" + document.memoControlForm.elements['searchToDate[d]'].value
					+'&searchWord=' + encodeURIComponent(document.memoControlForm.searchWord.value);
	if(document.memoControlForm.outside[1].checked){
		getString = getString + '&mapext=' + top.map.document.kakikoFromMap.mapext.value;
	}

	top.map.subWindow = window.open('./memolist.php' + getString, 'memoWindow', 'width=690, height=640, scrollbars=yes');

}

/**
 * 関数概要：ラジオボタンチェック状態取得処理(意味空間専用ロジック)
 * 処理詳細：色分けラジオボタンチェック状態を取得（リボン・ピン・非表示）
 *
 * @引数： (I) colorId     - ラジオボタンNAME
 * @戻値： -1:エラー それ以外:ラジオボタンインデックス (0:リボン 1:ピン 2:非表示)
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function getCheckdRadioIndexColorCategory(colorId) { 
	var oj = document.getElementById('categoryColor');
    var arrInput = oj.getElementsByTagName('input'); 
    var hashRadio = new Array; 
    var i; 
    var key; 

    for (i=0; i<arrInput.length; i++) { 
        if (arrInput[i].type == 'radio') { 
            hashRadio[arrInput[i].name] = 1; 
        } 
    } 

    for (key in hashRadio) { 
		if(key.indexOf('categoryColor_'+ colorId) != -1){
			for(i=0; i<3; i++){
				if(document.getElementsByName(key)[i].checked){
					return i;
				}
			}
		}
    }
    
    return -1;
}

/**
 * 関数概要：カテゴリ名更新処理(意味空間専用ロジック)
 * 処理詳細：hiddenに設定されているカテゴリ名から変更されていれば更新処理を行う（AJAX）
 *
 * @引数： (I) colorId      - カラーID
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function updateCategoryName(colorId){

	hiddenValue = document.getElementsByName('categoryName_hidden_' + colorId)[0].value;
	updateValue = document.getElementsByName('categoryName_' + colorId)[0].value;

//alert('updateValue : ' + updateValue + '  hiddenValue : ' + hiddenValue);

	// update
	if(updateValue != hiddenValue){
		//postする値の設定
		postval = '&colorId=' + colorId + "&categoryName=" + updateValue;
		
		//リクエストの送信
		sendRequest(onUpdated, postval, 'POST', './imicolorinfotableupdate.php', true, true);

		// 更新値を hidden に設定
		document.getElementsByName('categoryName_hidden_' + colorId)[0].value = updateValue;
	}

	//サブファンクション（リクエストの結果受信）
	function onUpdated(res){}
}

