/**
* 処理概要：マップへのメモ表示処理
* @パッケージ：-
* @作者：
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

// グローバルオブジェクト
var memoLayerArray=[];
var zcount = 0;
// 付箋表示状態
var fusen = "hidden";
// 付箋の表示位置修正
var xSpace = 5;
var ySpace = -11;

/**
* 関数概要：マップへのメモ表示処理
* 処理詳細：メモオブジェクトの生成
*
* @引数： (I) id - string DIVオブジェクトのID
*      ： (I) x - float メモのX座標 
*      ： (I) y - float メモのY座標
*      ： (I) layerId - string レイヤーID
*      ： (I) memoId  - string メモID
* @戻値： object DIVオブジェクト
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function memoLayer(id, x, y, layerId, memoTypeId, memoId, colorId)
{
		// 同一レイヤー存在チェック
    if(!!memoLayerArray[id]) return document.getElementById(id)

		// DIVオブジェクト作成
    this.mkDiv = function (id) 
    {

        var div   = document.getElementById('mapArea').appendChild(document.createElement("DIV")); //DIV要素を生成
			// DIV属性へ値をそれぞれ設定
			div.setAttribute("id", id);
			div.style.position = "absolute";
			div.style.left     = x + "px";
			div.style.top      = y + "px";
			div.innerHTML      = "";
			
            div.beforeBackgroundColor = "";  // 編集前のBackgroundColor待避変数
            div.beforeColor =  "";           // 編集前のColor待避変数
            div.selectingFlag = false;       // DIVの選択状態を持つフラグ

            div.memoID = memoId;     // メモID
            div.memoTypeID = memoTypeId;     // メモ種類ID
            div.layerID = layerId;    // レイヤーID
            // 意味空間専用プロパティ
			if(typeof(colorId) != 'undefined'){
	            div.colorID = colorId;	// カラーID
	            div.radioColor    = 0;	// 色分けラジオボタンの初期状態(0:リボン)
	            div.radioMemoType = 0;	// レイヤー＆メモ種別ラジオボタンの初期状態(0:表示)
	        }
            
            div.DispMode = 0;	// メモ表示モード(0:リボン, 1：ピン, 2：非表示)
            
//alert("memoID:" + div.memoID + " memoTypeID:" + div.memoTypeID + " layerID:" +  div.layerID ) ;           
			div.onmousedown = function (e)
			{
//				alert("x座標：" + x + " " + "y座標：" +y + " メモID：" + memoId);
				if(typeof(colorId) == 'undefined'){
					subWindow = window.open('./memodetail.php?memoId=' + memoId, 'memoDetail', 'width=690, height=640, scrollbars=yes');
				}else{
					subWindow = window.open('./memodetail.php?memoId=' + memoId + '&mode=readonly', 'memoDetail', 'width=690, height=640, scrollbars=yes');
				}

				return false;
			}

			div.onmouseover = function (e){ 
// 2006/05/17 レイヤー順表示の観点からコメントアウト
//					div.style.zIndex = zcount++;
				return false;
			}				
						
		// オブジェクトの登録
		memoLayerArray[div.id] = div.id;
		div.index++;
		return div;
    }

	return this.mkDiv(id);
		
}

/**
* 関数概要：マップ上のメモ表示切り替え処理
* 処理詳細：メモオブジェクトの表示切り替え
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function switchContributionLayer()
{

	var divDummyLayer;
	if(!divDummyLayer){
		divDummyLayer = new Object(); 
	}
	divDummyLayer = document.getElementById('mapArea').appendChild(document.createElement("DIV"));
    divDummyLayer.setAttribute("id",'DummyLayer');

	divDummyLayer.style.position = "absolute";
	divDummyLayer.style.left = 0 + "px";
	divDummyLayer.style.top = 0 + "px";
	divDummyLayer.style.width = document.getElementById('mapArea').style.width;
	divDummyLayer.style.height = document.getElementById('mapArea').style.height;

//	divDummyLayer.style.backgroundColor = "#FFFFCC";
//	divDummyLayer.style.color = "#000000";
	divDummyLayer.style.padding ="0px";
	divDummyLayer.style.fontSize = "10px";
	divDummyLayer.style.whiteSpace = "nowrap";
	divDummyLayer.style.zIndex = zcount++;

	// IEで透明レイヤーだと下のレイヤーのイベントを拾ってしまう
	if(navigator.userAgent.toUpperCase().indexOf("WIN") >= 0){
		// メモ表示切り替えラジオボタン表示
		document.getElementById("memoAddCheck").style.display = "inline";
		if(document.all){	
			// IE
			divDummyLayer.style.backgroundColor = "#FFFFFF";
			divDummyLayer.style.filter = "alpha(opacity=0);";
		}else if ( (document.layers || document.getElementById) && !document.all) {
			// NN7,Safari,Firefox
		}
	}else if(navigator.userAgent.toUpperCase().indexOf("MAC") >= 0){
		if(document.all){
			// IE
			memoDisplaySwitch(2);
// MacIEはAlphaに対応していない模様のためメモ非表示が必須
//			divDummyLayer.style.backgroundColor = "#FFFFFF";
//			divDummyLayer.style.filter = "alpha(opacity=0);";
		}else if ( (document.layers || document.getElementById) && !document.all) {
			// NN7,Safari,Firefox
			// メモ表示切り替えラジオボタン表示
			document.getElementById("memoAddCheck").style.display = "inline";
		}
	}else{
        alert("This OS is not supported!!");

	}

	divDummyLayer.onmouseover = function (e)
	{
		ch(fusen);
	}
	divDummyLayer.onmousemove = function (e)
	{
		ch(fusen);
	}
	divDummyLayer.onmouseout = function (e)
	{
		ch('hidden');
	}

}

/**
* 関数概要：メモ投稿付箋の状態設定
* 処理詳細：onLoadイベント後にメモ投稿付箋の状態設定をする
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function onLoadSetting(){
//	fusen = "hidden";

	// NowLoading対応
	document.getElementById('nowLoading').style.visibility='hidden';
	document.getElementById('contentsBody').style.visibility='visible';
	
}

/**
* 関数概要：付箋表示設定（Netscape/Firefox）
* 処理詳細：Netscape/Firefoxの付箋表示設定をする
*
* @引数： e:イベントオブジェクト
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function chN(e) {
	if ( (document.layers || document.getElementById) && !document.all) {
		// NN7,FireFox,Safari
		var x = e.pageX - document.getElementById('mapParent').offsetLeft + xSpace;
		var y = e.pageY - document.getElementById('mapParent').offsetTop + ySpace;

		document.getElementById('icon').style.left = x;
		document.getElementById('icon').style.top = y;
		
		if(e.type == "mousemove" || e.type == "mouseover"){
			document.getElementById('icon').style.visibility = fusen;
		}else if(e.type == "mouseout"){
			document.getElementById('icon').style.visibility = "hidden";
		}
	}
}

/**
* 関数概要：付箋表示設定（Internet Explorer）
* 処理詳細：Internet Explorerの付箋表示設定をする
*
* @引数： b：付箋表示状態
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function ch(b) {
	if( document.all ) {
		var x = event.x + xSpace;
		var y = event.y + ySpace;
		
		// MacIEの座標補正
		if (navigator.userAgent.toUpperCase().indexOf("MAC") != -1) {
//			x += document.body.scrollLeft;
//			y += document.body.scrollTop;
			x = x + document.body.scrollLeft - document.getElementById('mapParent').offsetLeft;
			y = y + document.body.scrollTop - document.getElementById('mapParent').offsetTop;

		}
		document.getElementById('icon').style.pixelLeft  = x;
		document.getElementById('icon').style.pixelTop   = y;
		document.getElementById('icon').style.visibility = b;
	}
}

/**
* 関数概要：メモ投稿開始処理
* 処理詳細：メモ投稿処理を開始する
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function statOfKakiko(){

	if(document.kakikoFromMap.kakiko.checked){
		fusen = "visible";
		
		// 投稿レイヤーへ切り替え
		switchContributionLayer();

		if(document.all){	
			// IE
			document.getElementById('DummyLayer').onmousedown = function (e)
			{
				var offsetX = event.x;
				var offsetY = event.y;

				// MacIEの座標補正
				if (navigator.userAgent.toUpperCase().indexOf("MAC") != -1) {
//					offsetX += document.body.scrollLeft;
//					offsetY += document.body.scrollTop;
					offsetX = offsetX + document.body.scrollLeft - document.getElementById('mapParent').offsetLeft;
					offsetY = offsetY + document.body.scrollTop - document.getElementById('mapParent').offsetTop;
				}
				operationMemoWindow(offsetX, offsetY);
			}
		}else if ( (document.layers || document.getElementById) && !document.all) {
			// NN7,Safari,Firefox
			document.getElementById('DummyLayer').onmousedown= function (e){
				var offsetX = e.pageX - document.getElementById('mapParent').offsetLeft;
				var offsetY = e.pageY - document.getElementById('mapParent').offsetTop;

				operationMemoWindow(offsetX, offsetY);
			}
		}
	}else{
		fusen = "hidden";
		document.getElementById("memoAddCheck").style.display = "none";
		document.getElementsByName("memoDisplay")[0].checked = true;
		document.getElementsByName("memoDisplay")[0].click();

		memoDisplaySwitch(0);
		if(document.getElementById('DummyLayer')){
			document.getElementById('mapArea').removeChild(document.getElementById('DummyLayer'));
		}
	}

}

/**
* 関数概要：表示・非表示切り替え処理（メモの投稿）
* 処理詳細：メモの投稿処理のラジオボタンで全メモの表示状態を切り替える
*           ※但し、表示を選択してもメモ種類の表示状態が非表示設定の場合表示されません。
*
* @引数： mode - int (0:表示 1:非表示)
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function memoRegistRadioChange(mode){

	switch(mode){
		case 0:	// 表示
			for(i in memoLayerArray){ 
				var oj = document.getElementById(memoLayerArray[i]) ;
				if(oj.DispMode == 2) continue; // メモの表示状態が非表示の場合は表示しない。
				oj.style.display = "inline";
			}
			break;
		case 1:	// 非表示
			for(i in memoLayerArray){ 
				var oj = document.getElementById(memoLayerArray[i]) ;
				oj.style.display = "none";
			}
			break;
		dafault:
			alert("error!!");
	}

}

/**
* 関数概要：メモ表示切り替え処理
* 処理詳細：渡された表示モードへメモ表示を変更する
*
* @引数： mode - int (0:リボン 1:ピン 2:非表示)
* @引数： layerId    - string レイヤーID
* @引数： memoTypeId - string メモ種類ID
* @引数： categoryId - ※改良予定
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function memoDisplaySwitch(mode, layerId, memoTypeId){

	switch(mode){
		case 0:	// リボン
			for(i in memoLayerArray){ 
				var oj = document.getElementById(memoLayerArray[i]) ;
				if(oj.layerID != layerId) continue;
				if(oj.memoTypeID != memoTypeId) continue;
//				if(fusen != "visible"){
				if(fusen != "visible" || (fusen == "visible" && document.getElementsByName('memoDisplay').item(0).checked)){
					oj.style.display = "inline";
				}
				oj.style.borderWidth = "1px";
				oj.style.borderStyle = "outset";
				oj.DispMode = 0;
				oj.style.backgroundColor = oj.beforeBackgroundColor;
				oj.getElementsByTagName("span")[0].style.display = "inline";
			}
			break;
		case 1:	// ピン
			for(i in memoLayerArray){ 
				var oj = document.getElementById(memoLayerArray[i]) ;
				if(oj.layerID != layerId) continue;
				if(oj.memoTypeID != memoTypeId) continue;
//				if(fusen != "visible"){
				if(fusen != "visible" || (fusen == "visible" && document.getElementsByName('memoDisplay').item(0).checked)){
					oj.style.display = "inline";
				}
				oj.style.borderWidth = "0px";
				oj.style.borderStyle = "none";
				oj.DispMode = 1;
				oj.style.backgroundColor = ""
				oj.getElementsByTagName("span")[0].style.display = "none";
			}
			break;
		case 2:	// 非表示
			for(i in memoLayerArray){ 
				var oj = document.getElementById(memoLayerArray[i]) ;
				if(oj.layerID != layerId) continue;
				if(oj.memoTypeID != memoTypeId) continue;
				oj.style.display = "none";
				oj.DispMode = 2;
			}
			break;
		dafault:
			alert("error!!");
	}

}

/**
* 関数概要：メモ投稿ウィンドウ表示処理
* 処理詳細：メモ投稿ウィンドウへメモ投稿画面を表示する
*
* @引数： x - int クリックされたX座標
* @引数： y - int クリックされたY座標
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function operationMemoWindow(x,y){
	if(fusen == "visible"){

		window.open('./memoregist.php', 'memoRegist', 'width=590, height=640, scrollbars=yes');

		document.kakikoFromMap.action = "./memoregist.php";
		document.kakikoFromMap.target = "memoRegist";
		document.kakikoFromMap.method = "post";
		
		document.kakikoFromMap.area_width.value = document.getElementById('mapArea').style.width;
		document.kakikoFromMap.area_height.value = document.getElementById('mapArea').style.height;
		document.kakikoFromMap.click_x.value = x;
		document.kakikoFromMap.click_y.value = y;

		document.kakikoFromMap.submit();

		return false;
	}
}

/**
* 関数概要：メモ位置変更開始処理
* 処理詳細：メモ位置変更処理を開始する
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function statOfPosition(){

	fusen = "visible";

	document.getElementById("memoAddCheck").style.display = "inline";
	document.getElementsByName("memoDisplay")[0].checked = true;
	document.getElementsByName("memoDisplay")[0].click();

	memoDisplaySwitch(0);
	if(document.getElementById('DummyLayer')){
		document.getElementById('mapArea').removeChild(document.getElementById('DummyLayer'));
	}

		
	// 投稿レイヤーへ切り替え
	switchContributionLayer();

	if(document.all){	
		// IE
		document.getElementById('DummyLayer').onmousedown = function (e)
		{
			var offsetX = event.x;
			var offsetY = event.y;

			// MacIEの座標補正
			if (navigator.userAgent.toUpperCase().indexOf("MAC") != -1) {
				offsetX = offsetX + document.body.scrollLeft - document.getElementById('mapParent').offsetLeft;
				offsetY = offsetY + document.body.scrollTop - document.getElementById('mapParent').offsetTop;
			}
			memoPositionMove(offsetX, offsetY);
		}
	}else if ( (document.layers || document.getElementById) && !document.all) {
		// NN7,Safari,Firefox
		document.getElementById('DummyLayer').onmousedown= function (e){
			var offsetX = e.pageX - document.getElementById('mapParent').offsetLeft;
			var offsetY = e.pageY - document.getElementById('mapParent').offsetTop;

			memoPositionMove(offsetX, offsetY);
		}
	}
}

/**
* 関数概要：メモ位置移動処理
* 処理詳細：メモ位置移動後の位置を修正する
*
* @引数： x - int クリックされたX座標
* @引数： y - int クリックされたY座標
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function memoPositionMove(x,y){
	if(fusen == "visible"){

		document.kakikoPositionMap.area_width.value = document.getElementById('mapArea').style.width;
		document.kakikoPositionMap.area_height.value = document.getElementById('mapArea').style.height;
		document.kakikoPositionMap.click_x.value = x;
		document.kakikoPositionMap.click_y.value = y;

		document.kakikoPositionMap.submit();

		return false;
	}
}

/**
* 関数概要：意味空間メモ表示切り替え処理(意味空間専用ロジック)
* 処理詳細：渡された表示モードへメモ表示を変更する
*
* @引数： mode - int (0:リボン 1:ピン 2:非表示)
* @引数： radioType - int (0:色分けラジオボタン 1:メモ種別ラジオボタン)
* @引数： layerId    - レイヤーID
* @引数： memoTypeId - メモ種類ID
* @引数： colorId    - カラーID
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function imiDisplaySwitch(mode, radioType, layerId, memoTypeId, colorId){
	// ラジオボタン状態をメモのプロパティへ設定
	if(radioType == 0){
		for(i in memoLayerArray){
			var oj = document.getElementById(memoLayerArray[i]);
			if(oj.colorID == colorId){
				oj.radioColor = mode;
			}
		}
	}else{
		for(i in memoLayerArray){
			var oj = document.getElementById(memoLayerArray[i]);
			if(oj.layerID == layerId && oj.memoTypeID == memoTypeId){
				oj.radioMemoType = mode;
			}
		}
	}

	// メモの表示形式を決定
	for(i in memoLayerArray){ 
		var oj = document.getElementById(memoLayerArray[i]) ;
		if(oj.radioColor == 2 || oj.radioMemoType == 2){
			// 非表示
			if(layerId != ""    && oj.layerID != layerId) continue;
			if(memoTypeId != "" && oj.memoTypeID != memoTypeId) continue;
			if(colorId != ""    && oj.colorID != colorId) continue;
			oj.style.display = "none";
			oj.DispMode = 2;
		}else if(oj.radioColor == 0 && oj.radioMemoType != 2){
			// リボン
			if(layerId != ""    && oj.layerID != layerId) continue;
			if(memoTypeId != "" && oj.memoTypeID != memoTypeId) continue;
			if(colorId != ""    && oj.colorID != colorId) continue;
			oj.style.display = "inline";
			oj.style.borderWidth = "1px";
			oj.style.borderStyle = "outset";
			oj.DispMode = 0;
			oj.style.backgroundColor = oj.beforeBackgroundColor;
			oj.getElementsByTagName("span")[0].style.display = "inline";
		}else if(oj.radioColor == 1 && oj.radioMemoType != 2){
			// ピン
			if(layerId != ""    && oj.layerID != layerId) continue;
			if(memoTypeId != "" && oj.memoTypeID != memoTypeId) continue;
			if(colorId != ""    && oj.colorID != colorId) continue;
			oj.style.display = "inline";
			oj.style.borderWidth = "0px";
			oj.style.borderStyle = "none";
			oj.DispMode = 1;
			oj.style.backgroundColor = ""
			oj.getElementsByTagName("span")[0].style.display = "none";
		}
	}

}