<?php
/**
* KakikoPassword.class.php 処理概要：ランダム文字列発行クラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)skazu
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
* 
* @メソッド一覧
* 	KakikoPassword()
* 	createCharArray($start_char, $end_char, &$array)
* 	makeSeed()
* 	joinArray($array)
* 	shuffleArray()
* 	publicate($type, $number)
* 
* @使用方法
* 	$o_db = new KakikoPassword();
* 	$o_db->extension_array = array(".", "-", "_");
*	※半角英数以外で利用したい要素があれば,
*	　上記のように拡張配列に利用する文字を指定してください。
* 	$o_db->publicate(文字種類, 桁数)
*	※文字種類は以下の合計値(0～7)で指定してください。
*	　1: 整数, 2: 大文字アルファベット, 4: 小文字アルファベット
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

class KakikoPassword {

	//インスタンス変数
	var $small_array;
	var $large_array;
	var $num_array;
	var $extension_array;
	var $temp_array;
	var $out_string;

	//コンストラクタ
	function KakikoPassword() {
		$small_array = array();			//小文字用配列
		$large_array = array();			//大文字用配列
		$num_array = array();			//整数用配列
		$extension_array = array();		//拡張用配列
		$temp_array = array();			//結合用バッファ配列
		$out_string = "";				//出力用文字列
	}

	//文字の配列作成
	function createCharArray($start_char, $end_char, &$array) {

		//ASCIIコードの取得
		$start = ord($start_char);
		$end = ord($end_char);

		for ($i = $start; $i <= $end; $i++) {
			$array[] = chr($i);
			//アスキーコード(10進：33～126以外のチェック)
			if($i > 126 || $i < 33) {
				exit();
			}
		}
	}

	//SEED作成
	function makeSeed() {
//		list($usec, $sec) = explode(' ', microtime());
//		return (float) $sec + ((float) $usec * 100000);
		return (double)microtime() * 1000000;
	}
	
	//配列のマージ
	function joinArray($array) {
		$this->temp_array = array_merge($this->temp_array, $array);
	}

	//シャッフル処理
	function shuffleArray() {
		mt_srand($this->makeSeed());
		shuffle($this->temp_array);
	}

	//発行処理
	function publicate($type, $number) {

		if($type < 1) {
			return false;
		}
		//小文字アルファベットのマージ
		if($type > 3) {
			$this->createCharArray("a", "z", $this->small_array);
			$this->joinArray($this->small_array);
		}
		//大文字アルファベットのマージ
		if($type > 5 || $type < 4 && $type > 1){
			$this->createCharArray("A", "Z", $this->large_array);
			$this->joinArray($this->large_array);
		}
		//整数文字のマージ
		if($type == 7 || $type == 5 || $type == 3 || $type === 1){
			$this->createCharArray("0", "9", $this->num_array);
			$this->joinArray($this->num_array);
		}
		//拡張文字のマージ
		if(count($this->extension_array) > 0){
			$this->joinArray($this->extension_array);
		}

		//配列のシャッフル
		$this->shuffleArray();

		while($number){
			//指定桁数チェック
			if($number < 0) {
				break;
			}
			$number --;
			$this->out_string .= $this->temp_array[$number];
		}
		return true;
	}
}
?>