<?php
/**
* KakikoTableName.class.php マップ管理者別管理テーブル名取得クラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("class/db/KakikoDb.class.php");
require_once("kakikomap/require/common/adminRead.php");
require_once("function/KakikoErrorHandler.php");

require_once("class/db/dbaccess/MapTableAccess.class.php");

define("UserTable",	           "usertable");
define("LayerUserTable",       "layerusertable");
define("LayerPriorityTable",   "layerprioritytable");
define("LayerTable",           "layertable");
define("MemoTypeTable",        "memotypetable");
define("MemoPositionTable",    "memopositiontable");
define("MemoDetailTable",      "memodetailtable");
define("CommentTable",         "commenttable");
define("UserPersonalInfoTable","userpersonalinfotable");

class KakikoTableName {

    var $_UserTable;				// ユーザ管理テーブル
    var $_LayerUserTable;			// レイヤーユーザ管理テーブル
    var $_LayerPriorityTable;		// コンテンツレイヤー優先順位管理テーブル
    var $_LayerTable;				// レイヤー管理テーブル
    var $_MemoTypeTable;			// メモ種類管理テーブル
    var $_MemoPositionTable;		// メモ位置情報管理テーブル
    var $_MemoDetailTable;			// メモ詳細管理テーブル
    var $_CommentTable;				// コメント管理テーブル
    var $_UserPersonalInfoTable;	// 一般ユーザ個人情報管理テーブル

	var $_DirectryName;				// ディレクトリ名称

    /**
     * コンストラクタ
     */
    function KakikoTableName($userid="", $dir="") {

        // 引数確認
        if (empty($userid) && empty($dir)) {
            trigger_error("引数不足", E_USER_ERROR);
            exit();
        }
        
        // 引数に[$userid]が渡された場合はディレクトリ名を求める
        if (!empty($userid)) {
	        // DB インスタンス化
	        $o_db = new KakikoDb(DBHOST, DBNAME, DBUSER, DBPASS, DBTYPE);

			$map_dbaccess = new MapTableAccess();
			$rtn = $map_dbaccess->selectFindByKeyData($o_db, $userid);
			if ($rtn != true) {
				trigger_error("マップデータ取得に失敗しました。", E_USER_ERROR);
				$o_db->disconnect();
				return;
			}

			$mapdata_array = $map_dbaccess->getDataList();
/*
	        // ディレクトリ名を取得するクエリーを生成
	        $o_rs = $o_db->executeQuery("SELECT directryname FROM maptable WHERE userid = '".$userid."'");
	        if (DB::isError($o_rs)) {
	            trigger_error($o_rs->getMessage()."\nデータ取得クエリーの生成に失敗", E_USER_ERROR);
	        }

	        // クエリーを実行
	        $o_row = $o_rs->fetchRow(DB_FETCHMODE_ASSOC);
	        if (DB::isError($o_row)) {
	            trigger_error($o_row->getMessage()."\nデータ取得クエリーの実行に失敗", E_USER_ERROR);
	        }
	        if ($o_row == null) {
	            trigger_error("該当のデータが見つかりませんでした。", E_USER_ERROR);
	        }
*/

	        // ディレクトリ名
//	        $this->_DirectryName = $o_row['directryname'];
//			$o_rs->free();
			if (count($mapdata_array) == 1) {
				$mapdata = $mapdata_array[0];
				$this->_DirectryName = $mapdata->getDirectryName();
			} else {
				trigger_error("取得マップデータ件数が不正です。", E_USER_ERROR);
				$map_dbaccess->free();
				$o_db->disconnect();
				return;
			}
			$map_dbaccess->free();
	        $o_db->disconnect();
	    } else {
	        // ディレクトリ名
	        $this->_DirectryName = $dir;
	    }

        // マップ管理別テーブル名を生成
        $this->_UserTable = $this->_DirectryName."_".UserTable;
        $this->_LayerUserTable = $this->_DirectryName."_".LayerUserTable;
        $this->_LayerPriorityTable = $this->_DirectryName."_".LayerPriorityTable;
        $this->_LayerTable = $this->_DirectryName."_".LayerTable;
        $this->_MemoTypeTable = $this->_DirectryName."_".MemoTypeTable;
        $this->_MemoPositionTable = $this->_DirectryName."_".MemoPositionTable;
        $this->_MemoDetailTable = $this->_DirectryName."_".MemoDetailTable;
        $this->_CommentTable = $this->_DirectryName."_".CommentTable;
        $this->_UserPersonalInfoTable = $this->_DirectryName."_".UserPersonalInfoTable;

    }

    /**
    * 関数概要：ユーザ管理テーブル名取得
    * 処理詳細：ユーザ管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  ユーザ管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_UserTable(){
        return $this->_UserTable;
    }

    /**
    * 関数概要：レイヤーユーザ管理テーブル名取得
    * 処理詳細：レイヤーユーザ管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  レイヤーユーザ管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_LayerUserTable(){
        return $this->_LayerUserTable;
    }

    /**
    * 関数概要：コンテンツレイヤー優先順位管理テーブル名取得
    * 処理詳細：コンテンツレイヤー優先順位管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  コンテンツレイヤー優先順位管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_LayerPriorityTable(){
        return $this->_LayerPriorityTable;
    }

    /**
    * 関数概要：レイヤー管理テーブル名取得
    * 処理詳細：レイヤー管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  レイヤー管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_LayerTable(){
        return $this->_LayerTable;
    }

    /**
    * 関数概要：メモ種類管理テーブル名取得
    * 処理詳細：メモ種類管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  メモ種類管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_MemoTypeTable(){
        return $this->_MemoTypeTable;
    }

    /**
    * 関数概要：メモ位置情報管理テーブル名取得
    * 処理詳細：メモ位置情報管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  メモ位置情報管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_MemoPositionTable(){
        return $this->_MemoPositionTable;
    }

    /**
    * 関数概要：メモ詳細管理テーブル名取得
    * 処理詳細：メモ詳細管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  メモ詳細管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_MemoDetailTable(){
        return $this->_MemoDetailTable;
    }

    /**
    * 関数概要：コメント管理テーブル名取得
    * 処理詳細：コメント管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  コメント管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_CommentTable(){
        return $this->_CommentTable;
    }

    /**
    * 関数概要：一般ユーザ個人情報管理テーブル名取得
    * 処理詳細：一般ユーザ個人情報管理テーブル名の取得を行う
    *
    * @引数： 
    * @戻値： string  一般ユーザ個人情報管理テーブル名
    * @作成日/作成者：2006/09/01 (IIS)h.keta
    * @更新日/更新者：
    * @更新内容：
    */
    function get_UserPersonalInfoTable(){
        return $this->_UserPersonalInfoTable;
    }

    /**
    * 関数概要：ディレクトリ名取得
    * 処理詳細：ディレクトリ名の取得を行う
    *
    * @引数： 
    * @戻値： string  ディレクトリ名
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    * @更新内容：
    */
	function get_DirectryName() {
		return $this->_DirectryName;
	}

}
?>