<?php
/**
* BaseMapTableAccess.class.php basemaptableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/BaseMapData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class BaseMapTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */


	/**
	 *	コンストラクタ
	 */
    function BaseMapTableAccess() {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName("basemaptable");
    	$this->setRecordSet(null);
    }

    /**
     * 関数概要：ベースマップテーブルデータ全件取得クエリ発行
     * 処理詳細：ベースマップテーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D3_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：ベースマップテーブルキー指定データ取得クエリ発行
     * 処理詳細：ベースマップテーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ディレクトリ名称)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($key));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D3_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：ベースマップテーブルデータ挿入
     * 処理詳細：ベースマップテーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object ベースマップデータオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == BASEMAP_DATAOBJ) {

			// ディレクトリ名称
			$dataobj->setDirectryName(
				$dba->query_str_convert($dataobj->getDirectryName()));
			// GIS有無区分
			$dataobj->setUseGIS(
				$dba->query_str_convert($dataobj->getUseGIS()));
			// 始点X
			$dataobj->setStartX($dataobj->getStartX());
			// 始点Y
			$dataobj->setStartY($dataobj->getStartY());
			// 終点X
			$dataobj->setEndX($dataobj->getEndX());
			// 終点Y
			$dataobj->setEndY($dataobj->getEndY());
			// 地図サイズ横
			$dataobj->setMapSizeHorizontal($dataobj->getMapSizeHorizontal());
			// 地図サイズ縦
			$dataobj->setMapSizeVertical($dataobj->getMapSizeVertical());
			// 差分X
			$dataobj->setDiffX($dataobj->getDiffX());
			// 差分Y
			$dataobj->setDiffY($dataobj->getDiffY());
			// 地図移動範囲
			$dataobj->setMoveMapSphere(
				$dba->query_str_convert($dataobj->getMoveMapSphere()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D3_003_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D3_003_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：ベースマップテーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == BASEMAP_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == BASEMAP_DATAOBJ)) {

			// 条件および更新内容指定

			// ディレクトリ名称
			if ($targetDataobj->getDirectryName() === WHERE_KEY) {
				$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($valDataobj->getDirectryName()));
				$whereflg = true;
			} elseif ($targetDataobj->getDirectryName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"directryname = "
							.$dba->query_str_convert($valDataobj->getDirectryName()));
			}
			// GIS有無区分
			if ($targetDataobj->getUseGIS() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"usegis = "
							.$dba->query_str_convert($valDataobj->getUseGIS()));
			}
			// 始点X
			if ($targetDataobj->getStartX() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"startx = ".$valDataobj->getStartX());
			}
			// 始点Y
			if ($targetDataobj->getStartY() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"starty = ".$valDataobj->getStartY());
			}
			// 終点X
			if ($targetDataobj->getEndX() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"endx = ".$valDataobj->getEndX());
			}
			// 終点Y
			if ($targetDataobj->getEndY() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"endy = ".$valDataobj->getEndY());
			}
			// 地図サイズ横
			if ($targetDataobj->getMapSizeHorizontal() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"mapsizehorizontal = ".$valDataobj->getMapSizeHorizontal());
			}
			// 地図サイズ縦
			if ($targetDataobj->getMapSizeVertical() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"mapsizevertical = ".$valDataobj->getMapSizeVertical());
			}
			// 差分X
			if ($targetDataobj->getDiffX() === VAL_TARGET) {
				if ($valDataobj->getDiffX() === NULL_CHAR) {
					$dba->dba_updateAdd("diffx = null");
				} else {
					$dba->dba_updateAdd(
							"diffx = "
								.$valDataobj->getDiffX());
				}
			}
			// 差分Y
			if ($targetDataobj->getDiffY() === VAL_TARGET) {
				if ($valDataobj->getDiffY() === NULL_CHAR) {
					$dba->dba_updateAdd("diffy = null");
				} else {
					$dba->dba_updateAdd(
							"diffy = "
								.$valDataobj->getDiffY());
				}
			}
			// 地図移動範囲
			if ($targetDataobj->getMoveMapSphere() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"movemapsphere = "
							.$dba->query_str_convert($valDataobj->getMoveMapSphere()));
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}
			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D3_004_01"), E_USER_ERROR);
				return false;
			}

			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D3_004_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D3_004_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
     * 関数概要：ベースマップテーブルキー指定データ削除
     * 処理詳細：ベースマップテーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ディレクトリ名称)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($key));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D3_005_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、ベースマップリストを生成する
     *
     * @引数： 
     * @戻値： array   ベースマップリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$basemap_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$basemapdata = new BaseMapData();

			$basemapdata->setDirectryName(isset($row['directryname'])?$row['directryname']:null);
			$basemapdata->setUseGIS(isset($row['usegis'])?$row['usegis']:null);
			$basemapdata->setStartX(isset($row['startx'])?$row['startx']:null);
			$basemapdata->setStartY(isset($row['starty'])?$row['starty']:null);
			$basemapdata->setEndX(isset($row['endx'])?$row['endx']:null);
			$basemapdata->setEndY(isset($row['endy'])?$row['endy']:null);
			$basemapdata->setMapSizeHorizontal(isset($row['mapsizehorizontal'])?$row['mapsizehorizontal']:null);
			$basemapdata->setMapSizeVertical(isset($row['mapsizevertical'])?$row['mapsizevertical']:null);
			$basemapdata->setDiffX(isset($row['diffx'])?$row['diffx']:null);
			$basemapdata->setDiffY(isset($row['diffy'])?$row['diffy']:null);
			$basemapdata->setMoveMapSphere(isset($row['movemapsphere'])?$row['movemapsphere']:null);
			$basemapdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$basemapdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($basemap_array, $basemapdata);
		}
 		return $basemap_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のベースマップデータを生成する
     *
     * @引数： 
     * @戻値： array   ベースマップデータ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$basemapdata = new BaseMapData();

		$basemapdata->setDirectryName(isset($row['directryname'])?$row['directryname']:null);
		$basemapdata->setUseGIS(isset($row['usegis'])?$row['usegis']:null);
		$basemapdata->setStartX(isset($row['startx'])?$row['startx']:null);
		$basemapdata->setStartY(isset($row['starty'])?$row['starty']:null);
		$basemapdata->setEndX(isset($row['endx'])?$row['endx']:null);
		$basemapdata->setEndY(isset($row['endy'])?$row['endy']:null);
		$basemapdata->setMapSizeHorizontal(isset($row['mapsizehorizontal'])?$row['mapsizehorizontal']:null);
		$basemapdata->setMapSizeVertical(isset($row['mapsizevertical'])?$row['mapsizevertical']:null);
		$basemapdata->setDiffX(isset($row['diffx'])?$row['diffx']:null);
		$basemapdata->setDiffY(isset($row['diffy'])?$row['diffy']:null);
		$basemapdata->setMoveMapSphere(isset($row['movemapsphere'])?$row['movemapsphere']:null);
		$basemapdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$basemapdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $basemapdata;
    }

    /**
     * 関数概要：ベースマップテーブルキー指定重複チェック
     * 処理詳細：ベースマップテーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ディレクトリ名称)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>