<?php
/**
* DropTableAccess.class.php 処理概要：テーブル削除DBアクセス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/
// エラートラップ
require_once("function/KakikoErrorHandler.php");

class DropTableAccess {

	var $filebuffer;		//ファイルコンテンツ

	/**
	 * コンストラクタ
	 * @引数： (I) file     - string ファイル名
	 */
    function DropTableAccess($file) {

	    //ファイルオープン
	    $fp = fopen($file, "rb");
	    //ファイル読込み
	    $this->filebuffer = fread($fp, filesize($file));
	    //ファイルクローズ
	    fclose($fp);
    }

    /**
     * 関数概要：テーブル削除
     * 処理詳細：DBからテーブルの削除を行う
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) directry - string ディレクトリ名称
     * @戻値： boolean true :正常
     *      ：         false:異常 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function DropTableContents($db, $directry) {

	    //テーブルプレフィックスのリプレイス
	    $droptable_sql = str_replace("xxxxxxxx", $directry, $this->filebuffer);
	    $rs = & $db->executeQuery($droptable_sql);
	    if (DB::isError($rs)) {
	        return false;
	    }
		return true;
	}
}
?>