<?php
/**
* ImiBaseInfoTableAccess.class.php 処理概要 ImiBaseInfoTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 (IIS)N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiBaseInfoData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiBaseInfoTableAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiBaseInfoTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_imibaseinfotable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

   /**
    * 関数名：意味基本情報テーブルデータ全件取得
    * @引数：(I) $db    - DBオブジェクト
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D23_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味基本情報テーブルキー指定データ取得
    * @引数：(I) $db	- DBオブジェクト
    * @引数：(I) $key	- キー内容(空間ID)    
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($key));
		

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D23_001_02"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味基本情報テーブルキー指定データ取得（一般ユーザ用）
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $userId	- ユーザID（一般）
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @注意事項：一般ユーザの場合は所有空間と他人作成閲覧可能空間を取得
    */
/*	function selectFindByKeyDataNormalMember($db, $userId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		//一覧取得用ＳＱＬ（一般ユーザ用）
		$sql = " (SELECT ".$this->prefix."_imibaseinfotable.imispacename, username,".$this->prefix."_imibaseinfotable.userid,"
				." memochangeflg,memodeletewarnflg, imispaceid"
				." FROM ".$this->prefix."_imibaseinfotable, ".$this->prefix."_usertable"
				." WHERE ".$this->prefix."_imibaseinfotable.userid = ".$this->prefix."_usertable.userid"
				." AND ".$this->prefix."_imibaseinfotable.userid = '".$userId."'"
				." ORDER BY ".$this->prefix."_imibaseinfotable.imispaceid)"
				." UNION ALL "
				." (SELECT ".$this->prefix."_imibaseinfotable.imispacename, username, ".$this->prefix."_imibaseinfotable.userid"
				.",memochangeflg,memodeletewarnflg, imispaceid"
				." FROM ".$this->prefix."_imibaseinfotable, ".$this->prefix."_usertable"
				." WHERE ".$this->prefix."_imibaseinfotable.userid = ".$this->prefix."_usertable.userid"
				."  AND ".$this->prefix."_imibaseinfotable.publicdivision = '".KAKIKOMAP_IMIPUBLIC_ON."'" 
				."  AND ".$this->prefix."_imibaseinfotable.userid <> '".$userId."'"
				." ORDER BY ".$this->prefix."_imibaseinfotable.imispaceid)";
		$ret = $dba->dba_executeQuery($sql);
		if ($ret != true) {
			trigger_error($this->o_resource->getValue("D23_001_03"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}
*/
   /**
    * 関数名：意味基本情報テーブルキー指定データ取得（マップ管理ユーザ用）
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $userId	- ユーザID(マップ管理者)
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @注意事項：マップ管理者の場合は所有空間と他人作成全空間を取得
    */
/*	function selectFindByKeyDataMapAdmin($db, $userId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());


		//一覧取得用ＳＱＬ（マップ管理者用）
		$sql = " (SELECT ".$this->prefix."_imibaseinfotable.imispacename, username,".$this->prefix."_imibaseinfotable.userid,"
				." memochangeflg,memodeletewarnflg, imispaceid"
				." FROM ".$this->prefix."_imibaseinfotable, ".$this->prefix."_usertable"
				." WHERE ".$this->prefix."_imibaseinfotable.userid = ".$this->prefix."_usertable.userid"
				." AND ".$this->prefix."_imibaseinfotable.userid = '".$userId."'"
				." ORDER BY ".$this->prefix."_imibaseinfotable.imispaceid)"
				." UNION ALL "
				." (SELECT ".$this->prefix."_imibaseinfotable.imispacename, username, ".$this->prefix."_imibaseinfotable.userid"
				.",memochangeflg,memodeletewarnflg, imispaceid"
				." FROM ".$this->prefix."_imibaseinfotable, ".$this->prefix."_usertable"
				." WHERE ".$this->prefix."_imibaseinfotable.userid = ".$this->prefix."_usertable.userid"
				."  AND ".$this->prefix."_imibaseinfotable.userid <> '".$userId."'"
				." ORDER BY ".$this->prefix."_imibaseinfotable.imispaceid)";
		$ret = $dba->dba_executeQuery($sql);
		if ($ret != true) {
			trigger_error($this->o_resource->getValue("D23_001_04"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}
*/

   /**
    * 関数名：意味基本情報テーブルデータ挿入
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $dataobj	- データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == IMIBASEINFO_DATAOBJ) {

			// 空間ID
			$dataobj->setImiSpaceID('default');
				
			// 空間名称
			$dataobj->setImiSpaceName(
				$dba->query_str_convert($dataobj->getImiSpaceName()));
			// ユーザID
			$dataobj->setUserID(
				$dba->query_str_convert($dataobj->getUserID()));
			// 公開区分ID
			$dataobj->setPublicDivision(
				$dba->query_str_convert($dataobj->getPublicDivision()));
			// 表示モード
			$dataobj->setViewMode(
				$dba->query_str_convert($dataobj->getViewMode()));
			// メモ変更フラグ
			$dataobj->setMemoChangeFlg(
				$dba->query_str_convert($dataobj->getMemoChangeFlg()));			
			// メモ削除警告フラグ
			$dataobj->setMemoDeleteWarnFlg(
				$dba->query_str_convert($dataobj->getMemoDeleteWarnFlg()));			
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// メモ取り込み日時
			$dataobj->setTakememoDatetime(
				$dba->query_str_convert($dataobj->getTakememoDatetime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D23_001_05"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error("データの型を確認してください。", E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味基本情報テーブルキー指定データ更新
    * @引数：(I) $db		- DBオブジェクト
    *        (I) $targetDataobj	- 対象列(条件列/更新列)指定用データオブジェクト
    *        (I) $valDataobj	- 設定値(条件値/更新値)指定用データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	*            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
    *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
    *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
    */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {
		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == IMIBASEINFO_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == IMIBASEINFO_DATAOBJ)){

			// 条件および更新内容指定
			// 空間ID
			if ($targetDataobj->getImiSpaceID() === WHERE_KEY){
				$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($valDataobj->getImiSpaceID()));
				$whereflg = true;
			}elseif ($targetDataobj->getImiSpaceID() === VAL_TARGET){
//				$dba->dba_updateAdd("imispaceid = ".$dba->query_str_convert($valDataobj->getImiSpaceID()));	
			}
			// 空間名称
			if ($targetDataobj->getImiSpaceName() === VAL_TARGET){
				$dba->dba_updateAdd("imispacename = ".$dba->query_str_convert($valDataobj->getImiSpaceName()));	
			}
			// ユーザID
			if ($targetDataobj->getUserID() === VAL_TARGET){
					$dba->dba_updateAdd("userid = ".$dba->query_str_convert($valDataobj->getUserID()));			
			}
			// 公開区分ID
			if ($targetDataobj->getPublicDivision() === VAL_TARGET){
				$dba->dba_updateAdd("publicdivision = ".$dba->query_str_convert($valDataobj->getPublicDivision()));			
			}
			// 表示モード
			if ($targetDataobj->getViewMode() === VAL_TARGET){
				$dba->dba_updateAdd("viewmode = ".$dba->query_str_convert($valDataobj->getViewMode()));			
			}
			// メモ変更フラグ
			if ($targetDataobj->getMemoChangeFlg() === VAL_TARGET){
				$dba->dba_updateAdd("memochangeflg = ".$dba->query_str_convert($valDataobj->getMemoChangeFlg()));
			}
			// メモ削除警告フラグ
			if ($targetDataobj->getMemoDeleteWarnFlg() === VAL_TARGET){
				$dba->dba_updateAdd("memodeletewarnflg = ".$dba->query_str_convert($valDataobj->getMemoDeleteWarnFlg()));
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET){
				$dba->dba_updateAdd("adddatetime = ".$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// メモ取り込み日時
			if ($targetDataobj->getTakememoDatetime() === VAL_TARGET){
				$dba->dba_updateAdd("takememodatetime = ".$dba->query_str_convert($valDataobj->getTakememoDatetime()));					
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET){
				$dba->dba_updateAdd("updatedatetime = ".$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}
			
			// 条件指定確認
			if ($whereflg == false){
				trigger_error($this->o_resource->getValue("D23_001_06"), E_USER_ERROR);
				return false;
			
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D23_001_07"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D23_001_08"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味基本情報テーブル 更新警告フラグ一括更新
    * 処理概要：指定された複数の意味空間に対し、更新警告フラグを一括で更新します。
    *           どのフラグを立てるかはモードで指定します。
    * @引数：(I) $db				- DBオブジェクト
    *        (I) $imiSpaceIdList[]	- 対象意味空間ID（配列）
    *        (I) $updateValue		- フラグの更新値
    *        (I) $flgType			- フラグの種類(1:メモ増加フラグ、2:メモ削除変更フラグ)
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function updateWarnFlgLump($db, $imiSpaceIdList, $updateValue, $flgType) {
		$dba = new KakikoDBAccess($db, $this->getTablename());
		//フラグの種類を設定
		if ($flgType == 1){
			$dba->dba_updateAdd("memochangeflg = ".$dba->query_str_convert($updateValue));		
		}elseif ($flgType == 2){
			$dba->dba_updateAdd("memodeletewarnflg = ".$dba->query_str_convert($updateValue));			
		}else{
			return false;
		}
		
		if (is_array($imiSpaceIdList)) {
			$buf = $this->prefix."_imibaseinfotable.imispaceid IN (";
			for ($i = 0; $i < count($imiSpaceIdList); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($imiSpaceIdList[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		//SQL実行
		if ($dba -> dba_update() != true) {
			trigger_error($this->o_resource->getValue("D23_001_09"), E_USER_ERROR);
			return false;
		}
		// 解放
		$dba->dba_free();
		
		return true;
	}


   /**
    * 関数名：意味基本情報テーブル全データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function deleteAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D23_001_10"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味基本情報テーブルキー指定データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $key		- キー内容(空間ID)
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "imispaceid = ".$key);

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D23_001_11"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：レコードセットより、意味基本情報リストを生成する。
    * @戻値：意味基本情報リスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imibaseinfo_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imibaseinfodata = new ImiBaseInfoData();

			$imibaseinfodata->setImiSpaceID($row['imispaceid']);
			$imibaseinfodata->setImiSpaceName($row['imispacename']);
			$imibaseinfodata->setUserID($row['userid']);
			$imibaseinfodata->setPublicDivision($row['publicdivision']);
			$imibaseinfodata->setViewMode($row['viewmode']);
			$imibaseinfodata->setMemoChangeFlg($row['memochangeflg']);
			$imibaseinfodata->setMemoDeleteWarnFlg($row['memodeletewarnflg']);
			$imibaseinfodata->setAddDateTime($row['adddatetime']);
			$imibaseinfodata->setTakememoDatetime($row['takememodatetime']);
			$imibaseinfodata->setUpdateDateTime($row['updatedatetime']);


			array_push($imibaseinfo_array, $imibaseinfodata);
		}
 		return $imibaseinfo_array;
    }

   /**
    * 関数名：レコードセットより、一件の意味基本情報データを生成する。
    * @戻値：意味基本情報データ型オブジェクト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
     function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imibaseinfodata = new ImiBaseInfoData();

			$imibaseinfodata->setImiSpaceID($row['imispaceid']);
			$imibaseinfodata->setImiSpaceName($row['imispacename']);
			$imibaseinfodata->setUserID($row['userid']);
			$imibaseinfodata->setPublicDivision($row['publicdivision']);
			$imibaseinfodata->setViewMode($row['viewmode']);
			$imibaseinfodata->setMemoChangeFlg($row['memochangeflg']);
			$imibaseinfodata->setMemoDeleteWarnFlg($row['memodeletewarnflg']);
			$imibaseinfodata->setAddDateTime($row['adddatetime']);
			$imibaseinfodata->setTakememoDatetime($row['takememodatetime']);
			$imibaseinfodata->setUpdateDateTime($row['updatedatetime']);


 		return $imibaseinfodata;
    }
}
?>