<?php
/**
* ImiMemoPositionTableAccess.class.php 処理概要 ImiMemoPositionTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiCalcMemoPositionData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiCalcMemoPositionAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiCalcMemoPositionAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_layertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }




   /**
    * 関数名：意味メモ位置テーブル最大最小座標取得
    * @引数：(I) $db	- DBオブジェクト
    *        (I) $imiSpaceId	- 対象意味空間ID
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 	 
/*	function selectMaxMinPosition($db, $imiSpaceId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定		
		$dba->dba_fieldAdd("max(coordinatex) as maxx");	//最大X座標
		$dba->dba_fieldAdd("max(coordinatey) as maxy");	//最大Y座標
		$dba->dba_fieldAdd("min(coordinatex) as minx");	//最小X座標
		$dba->dba_fieldAdd("min(coordinatey) as minx");	//最小X座標
		
		// 条件指定
		$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($imiSpaceId));

		if ($dba -> dba_select() != true) {
			trigger_error(
				"ImiMemoPositionTableAccess-selectMaxMinPositionでエラーが発生しました。
				\n確認してください。", 
				E_CORE_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}
*/
    /**
    * 関数名：指定ユーザ閲覧可能全メモの最大最小XY座標取得（管理者・一般用）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $userid 	- ユーザID
    *        (I) $statusflg - レイヤー状態フラグ(配列)	
    *        (I) $targetLayerId - 取得したいレイヤーID（意味レイヤークラス配列。nullの時は全レイヤー）
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function selectMaxMinMemoPosition($db, $userId, $statusflg, $targetLayerId) {
	
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd("max(longitude) as maxx");	//最大X座標
		$dba->dba_fieldAdd("max(latitude) as maxy");	//最大Y座標
		$dba->dba_fieldAdd("min(longitude) as minx");	//最小X座標
		$dba->dba_fieldAdd("min(latitude) as miny");	//最小X座標

		// 条件指定
		$dba->dba_whereAdd("", "((".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.publicmemotype = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'))");		

		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userId."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
//				$buf .= "'".$statusflg[$i]."'";
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");
		//条件指定（メモ種類公開の設定）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype <> '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is null )");		
		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");
		
		//レイヤー指定がある場合
		if (is_array($targetLayerId) == true){
			$buf = $this->prefix."_layertable.layerid IN (";
			for ($i = 0; $i < count($targetLayerId); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= "'".$targetLayerId[$i]->getLayerID()."'";
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}

		
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_memotypetable.layerid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memodetailtable ON "
				.$this->prefix."_memotypetable.memotypeid = "
				.$this->prefix."_memodetailtable.memotypeid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memopositiontable ON "
				.$this->prefix."_memodetailtable.memoid = "
				.$this->prefix."_memopositiontable.memoid"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);
		
		if ($dba->dba_select() != true) {
			trigger_error($this->o_resource->getValue("D24_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}



   /**
    * 関数名：レコードセットより、意味空間座標算出基礎データリストを生成する。
    * @戻値：意味メモ位置リスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imimemoposition_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imimemoposition = new ImiCalcMemoPositionData();
			
			$imimemoposition->setMaxX(isset($row['maxx'])?$row['maxx']:null);
			$imimemoposition->setMaxY(isset($row['maxy'])?$row['maxy']:null);
			$imimemoposition->setMinX(isset($row['minx'])?$row['minx']:null);
			$imimemoposition->setMinY(isset($row['miny'])?$row['miny']:null);
			
			array_push($imimemoposition_array, $imimemoposition);
		}
 		return $imimemoposition_array;
    }

   /**
    * 関数名：レコードセットより、一件の意味空間座標算出基礎データを生成する。
    * @戻値：意味メモ位置データ型オブジェクト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imimemoposition = new ImiCalcMemoPositionData();

		$imimemoposition->setMaxX(isset($row['maxx'])?$row['maxx']:null);
		$imimemoposition->setMaxY(isset($row['maxy'])?$row['maxy']:null);
		$imimemoposition->setMinX(isset($row['minx'])?$row['minx']:null);
		$imimemoposition->setMinY(isset($row['miny'])?$row['miny']:null);

 		return $imimemoposition;
    }
}
?>