<?php
/**
* ImiColorInfoTableAccess.class.php 処理概要 ImiColorInfoTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiColorInfo_MasterData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiColorInfoJoinMasterTableAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiColorInfoJoinMasterTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_imicolorinfotable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }


   /**
    * 関数名：意味色情報・マスタデータキー指定データ取得
    * @引数：(I) $db	- DBオブジェクト
    *        (I) $keyImispaceID	- キー内容(空間ID)   
    *        (I) $keyColorID	- キー内容(色ID) 
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @注意事項：色コード"000"は初期特殊設定値により、結果からは除かれます。
    */	 
	function selectFindByKeyViewData($db, $keyImispaceID = "", $keyColorID = "") {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		if(( $keyImispaceID == "") && ( $keyColorID == "")) {
			$this->getAllData();
		}elseif(	( $keyImispaceID != "") && ( $keyColorID != "")){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));
			$dba->dba_whereAdd("AND", "colorid = ".$dba->query_str_convert($keyColorID));
		}elseif	( $keyImispaceID != ""){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));				
		}elseif	( $keyColorID != ""){
			$dba->dba_whereAdd("", "colorid = ".$dba->query_str_convert($keyColorID));
		}
//		//特殊データ除外
//		$dba->dba_whereAdd("AND", "imicolormaster.colorid <> '000'");
		// サブクエリ指定(INNER JOIN/色マスタ)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				"imicolormaster ON "
				.$this->prefix."_imicolorinfotable.colorid = "
				."imicolormaster.colorid"
				);

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_imicolorinfotable.colorid");

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D25_001_01"), E_USER_ERROR);				
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}


   /**
    * 関数名：レコードセットより、色情報・マスタリストを生成する。
    * @戻値：色情報リスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imicolorinfo_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$viewfodata = new ImiColorInfo_MasterData();

			$viewfodata->setImiSpaceID($row['imispaceid']);
			$viewfodata->setColorID($row['colorid']);
			$viewfodata->setCategoryName($row['categoryname']);
			$viewfodata->setAddDateTime($row['adddatetime']);
			$viewfodata->setUpdateDateTime($row['updatedatetime']);

			$viewfodata->setColorNumber($row['colornumber']);
			$viewfodata->setColorName($row['colorname']);
			$viewfodata->setPinIconName($row['piniconname']);

			array_push($imicolorinfo_array, $viewfodata);
		}
 		return $imicolorinfo_array;
    }

   /**
    * 関数名：レコードセットより、色情報・マスタデータを生成する。
    * @戻値：色情報データ
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$viewfodata = new ImiColorInfo_MasterData();

			$viewfodata->setImiSpaceID($row['imispaceid']);
			$viewfodata->setColorID($row['colorid']);
			$viewfodata->setCategoryName($row['categoryname']);
			$viewfodata->setAddDateTime($row['adddatetime']);
			$viewfodata->setUpdateDateTime($row['updatedatetime']);

			$viewfodata->setColorNumber($row['colornumber']);
			$viewfodata->setColorName($row['colorname']);
			$viewfodata->setPinIconName($row['piniconname']);

 		return $viewfodata;
    }
}
?>