<?php
/**
* ImiColorInfoTableAccess.class.php 処理概要 ImiColorInfoTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiColorInfoData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiColorInfoTableAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiColorInfoTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_imicolorinfotable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

   /**
    * 関数名：色情報テーブルデータ全件取得
    * @引数：(I) $db    - DBオブジェクト
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	 
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D26_001_01"), E_USER_ERROR);				
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味色情報テーブルキー指定データ取得
    * @引数：(I) $db	- DBオブジェクト
    *        (I) $keyImispaceID	- キー内容(空間ID)   
    *        (I) $keyColorID	- キー内容(色ID) 
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function selectFindByKeyData($db, $keyImispaceID = "", $keyColorID = "") {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		if(( $keyImispaceID == "") && ( $keyColorID == "")) {
			$this->getAllData();
		}elseif(	( $keyImispaceID != "") && ( $keyColorID != "")){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));
			$dba->dba_whereAdd("and", "colorid = ".$dba->query_str_convert($keyColorID));
		}elseif	( $keyImispaceID != ""){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));				
		}elseif	( $keyColorID != ""){
			$dba->dba_whereAdd("", "colorid = ".$dba->query_str_convert($keyColorID));
		}

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D26_001_02"), E_USER_ERROR);				
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：色情報テーブルデータ挿入
    * @引数：(I) $db		- DBオブジェクト
    *        (I) $dataobj	- データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == IMICOLORINFO_DATAOBJ) {

			// 空間ID
			$dataobj->setImiSpaceID(
				$dba->query_str_convert($dataobj->getImiSpaceID()));			
			// 色ID
			$dataobj->setImiColorID(
				$dba->query_str_convert($dataobj->getImiColorID()));
			// カテゴリ名称
			$dataobj->setCategoryName(
				$dba->query_str_convert($dataobj->getUserID()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D26_001_03"), E_USER_ERROR);				
				return false;
			}
		} else {
			trigger_error("データの型を確認してください。", E_CORE_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：色情報情報テーブルキー指定データ更新
    * @引数：(I) $db		- DBオブジェクト
    *        (I) $targetDataobj	- 対象列(条件列/更新列)指定用データオブジェクト
    *        (I) $valDataobj	- 設定値(条件値/更新値)指定用データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	*            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
    *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
    *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
    */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {
		$whereflg = false;	
		$andstr = "";				
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == IMICOLORINFO_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == IMICOLORINFO_DATAOBJ)){

			// 条件および更新内容指定
			// 空間ID			
			if ($targetDataobj->getImiSpaceID() === WHERE_KEY){
				$dba->dba_whereAdd($andstr, "imispaceid = ".$dba->query_str_convert($valDataobj->getImiSpaceID()));
				$whereflg = true;
				$andstr = "and";				
			}elseif ($targetDataobj->getImiSpaceID() === VAL_TARGET){
				$dba->dba_updateAdd("imispaceid = ".$dba->query_str_convert($valDataobj->getImiSpaceID()));	
			}
			// 色ID			
			if ($targetDataobj->getColorID() === WHERE_KEY){
				$dba->dba_whereAdd($andstr, "colorid = ".$dba->query_str_convert($valDataobj->getColorID()));
				$whereflg = true;
				$andstr = "and";					
			}elseif ($targetDataobj->getColorID() === VAL_TARGET){
				$dba->dba_updateAdd("colorid = ".$dba->query_str_convert($valDataobj->getColorID()));	
			}
			// カテゴリ名称
			if ($targetDataobj->getCategoryName() === VAL_TARGET){
				if ($valDataobj->getCategoryName() === NULL_CHAR){
					$dba->dba_updateAdd("categoryname = null");
				}else{
					$dba->dba_updateAdd("categoryname = ".$dba->query_str_convert($valDataobj->getCategoryName()));			
				}	
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET){
				$dba->dba_updateAdd("adddatetime = ".$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET){
				$dba->dba_updateAdd("updatedatetime = ".$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}
			
			// 条件指定確認
			if ($whereflg == false){
				trigger_error($this->o_resource->getValue("D26_001_04"), E_USER_ERROR);				
				return false;
			
			}

			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D26_001_05"), E_USER_ERROR);				
				return false;
			}
		} else {
			trigger_error("データの型を確認してください。", E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：色情報情報テーブル全データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */ 
	function deleteAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D26_001_06"), E_USER_ERROR);				
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味基本情報テーブルキー指定データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $key		- キー内容(空間ID)
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @注意事項：色情報テーブルは空間IDと色IDがキーであるが、削除は空間ID指定しか存在しない
    */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "imispaceid = ".$key);

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D26_001_07"), E_USER_ERROR);				
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：レコードセットより、色情報リストを生成する。
    * @戻値：色情報リスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imicolorinfo_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imicolorinfodata = new ImiColorInfoData();

			$imicolorinfodata->setImiSpaceID($row['imispaceid']);
			$imicolorinfodata->setColorID($row['colorid']);
			$imicolorinfodata->setCategoryName($row['categoryname']);
			$imicolorinfodata->setAddDateTime($row['adddatetime']);
			$imicolorinfodata->setUpdateDateTime($row['updatedatetime']);

			array_push($imicolorinfo_array, $imicolorinfodata);
		}
 		return $imicolorinfo_array;
    }

   /**
    * 関数名：レコードセットより、色情報データを生成する。
    * @戻値：色情報データ
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imicolorinfodata = new ImiColorInfoData();

			$imicolorinfodata->setImiSpaceID($row['imispaceid']);
			$imicolorinfodata->setColorID($row['colorid']);
			$imicolorinfodata->setCategoryName($row['categoryname']);
			$imicolorinfodata->setAddDateTime($row['adddatetime']);
			$imicolorinfodata->setUpdateDateTime($row['updatedatetime']);

 		return $imicolorinfodata;
    }
}
?>