<?php
/**
* ImiColorMasterTableAccess.class.php 処理概要 ImiColorMasterDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/
//データクラス
require_once("class/db/tabledata/ImiColorMasterData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiColorMasterTableAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	なし
	 */
    function ImiColorMasterTableAccess() {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName("imicolormaster");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = "";
    }

   /**
    * 関数名：色マスタテーブルデータ全件取得
    * @引数：(I) $db    - DBオブジェクト
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D27_001_01"), E_USER_ERROR);				
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：色マスタテーブルキー指定データ取得
    * @引数：(I) $db	- DBオブジェクト
    *        (I) $key	キー内容(色ID)   
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "colorid = ".$dba->query_str_convert($key));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D27_001_02"), E_USER_ERROR);				
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
	*	色マスタテーブルデータ挿入
	* @引数：(I) $db		- DBオブジェクト
    *        (I) $dataobj	- データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == IMICOLORMASTER_DATAOBJ) {

			// 色ID
			$dataobj->setImiColorID(
				$dba->query_str_convert($dataobj->getImiColorID()));
			// 色番号
			$dataobj->setColorNumber(
				$dba->query_str_convert($dataobj->getColorNumber()));
			// 色名
			$dataobj->setColorName(
				$dba->query_str_convert($dataobj->getColorName()));
			// ピンアイコン名
			$dataobj->setPinIconName(
				$dba->query_str_convert($dataobj->getPinIconName()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D27_001_03"), E_USER_ERROR);				
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D27_001_04"), E_USER_ERROR);				
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：色マスタテーブルキー指定データ更新
    * @引数：(I) $db		- DBオブジェクト
    *        (I) $targetDataobj	- 対象列(条件列/更新列)指定用データオブジェクト
    *        (I) $valDataobj	- 設定値(条件値/更新値)指定用データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	*            (プライマリキー以外にWHERE_KEYを指定しても無視されます。２種類以上の条件はand比較します)
    *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
    *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
    */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {
		$whereflg = false;
		$andstr = "";						
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == IMICOLORMASTER_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == IMICOLORMASTER_DATAOBJ)){

			// 条件および更新内容指定
			// 色ID			
			if ($targetDataobj->getColorID() === WHERE_KEY){
				$dba->dba_whereAdd("", "colorid = ".$dba->query_str_convert($valDataobj->getColorID()));
				$whereflg = true;
				$andstr = "and";
			}elseif ($targetDataobj->getColorID() === VAL_TARGET){
				$dba->dba_updateAdd("colorid = ".$dba->query_str_convert($valDataobj->getColorID()));	
			}
			// 色番号
			if ($targetDataobj->getColorNumber() === VAL_TARGET){
				$dba->dba_updateAdd("colornumber = ".$dba->query_str_convert($valDataobj->getColorNumber()));
			}
			// 色名
			if ($targetDataobj->getColorName() === VAL_TARGET){
				if ($valDataobj->getColorName() === NULL_CHAR){
					$dba->dba_updateAdd("colorname = null");
				}else{
					$dba->dba_updateAdd("colorname = ".$dba->query_str_convert($valDataobj->getColorName()));
				}				
			}
			// ピンアイコン名
			if ($targetDataobj->getPinIconName() === VAL_TARGET){
				$dba->dba_updateAdd("piniconname = ".$dba->query_str_convert($valDataobj->getPinIconName()));
			}
			
			// 条件指定確認
			if ($whereflg == false){
				trigger_error($this->o_resource->getValue("D27_001_05"), E_USER_ERROR);				
				return false;
			
			}
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D27_001_06"), E_USER_ERROR);				
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D27_001_07"), E_USER_ERROR);				
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：色マスタテーブル全データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function deleteAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D27_001_08"), E_USER_ERROR);				
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
    * 関数名：色マスタテーブルキー指定データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $key		- キー内容(空間ID)
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "colorid = ".$key);

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D27_001_09"), E_USER_ERROR);				
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：レコードセットより、色マスタリストを生成する。
    * @戻値：色マスタリスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imicolormaster_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imicolormasterdata = new ImiColorMasterData();

			$imicolormasterdata->setColorID($row['imicolorid']);
			$imicolormasterdata->setColorNumber($row['colornumber']);
			$imicolormasterdata->setColorName($row['colorname']);
			$imicolormasterdata->setPinIconName($row['piniconname']);

			array_push($imicolormaster_array, $imicolormasterdata);
		}
 		return $imicolormaster_array;
    }

   /**
    * 関数名：レコードセットより、一件の色マスタデータを生成する。
    * @戻値：色マスタデータ型オブジェクト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imicolormasterdata = new ImiColorMasterData();

			$imicolormasterdata->setColorID($row['imicolorid']);
			$imicolormasterdata->setColorNumber($row['colornumber']);
			$imicolormasterdata->setColorName($row['colorname']);
			$imicolormasterdata->setPinIconName($row['piniconname']);

 		return $imicolormasterdata;
    }
}
?>