<?php
/**
* ImiLayerTableAccess.class.php 処理概要 ImiLayerTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiLayerJoinLayerData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiLayerJoinLayerTableAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiLayerJoinLayerTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_imilayertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

   /**
    * 関数名：意味レイヤーjoinレイヤーデータ全件取得
    * @引数：(I) $db    - DBオブジェクト
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());
		$dba->dba_whereAdd("", $this->setTableName.".layerid = ".$this->prefix."_layertable".".layerid");
		
		// テーブル指定追加
		$dba->dba_tableAdd($this->prefix."_layertable");

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D28_001_01"), E_USER_ERROR);				
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味レイヤーjoinレイヤーテーブルキー指定データ取得
    * @引数：(I) $db	- DBオブジェクト
    *        (I) $keyImispaceID	キー内容(色ID)
    *        (I) $keyLayerID	キー内容(レイヤーID)
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
	* @注意事項： キーは２つあるが、片方は省略可
    */	 
	function selectFindByKeyData($db, $keyImispaceID = "", $keyLayerID ="") {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", $this->prefix."_imilayertable.layerid = ".$this->prefix."_layertable.layerid");
		if(( $keyImispaceID == "") && ( $keyLayerID == "")) {
			$this->getAllData();
		}elseif(	( $keyImispaceID != "") && ( $keyLayerID != "")){
			$dba->dba_whereAdd("AND", $this->prefix."_imilayertable.imispaceid = ".$dba->query_str_convert($keyImispaceID));
			$dba->dba_whereAdd("AND", $this->prefix."_imilayertable.layerid = ".$dba->query_str_convert($keyLayerID));
		}elseif	( $keyImispaceID != ""){
			$dba->dba_whereAdd("AND", $this->prefix."_imilayertable.imispaceid = ".$dba->query_str_convert($keyImispaceID));				
		}elseif	( $keyLayerID != ""){
			$dba->dba_whereAdd("AND", $this->prefix."_imilayertable.layerid = ".$dba->query_str_convert($keyLayerID));
		}
		
		
		// テーブル指定追加
		$dba->dba_tableAdd($this->prefix."_layertable");
		
		
		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D28_001_02"), E_USER_ERROR);				
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：レコードセットより、意味レイヤーjoinレイヤーリストを生成する。
    * @戻値：意味レイヤーリスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imiLayer_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imilayerjoinlayer = new ImiLayerJoinLayerData();

			$imilayerjoinlayer->setImiSpaceID($row['imispaceid']);
			$imilayerjoinlayer->setLayerID($row['layerid']);
			$imilayerjoinlayer->setAddDateTime($row['adddatetime']);
			$imilayerjoinlayer->setUpdateDateTime($row['updatedatetime']);
			$imilayerjoinlayer->setLayerName($row['layername']);

			array_push($imiLayer_array, $imilayerjoinlayer);
		}
 		return $imiLayer_array;
    }

   /**
    * 関数名：レコードセットより、一件の意味レイヤーjoinレイヤーデータを生成する。
    * @戻値：意味レイヤーデータ型オブジェクト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imilayerjoinlayer = new ImiLayerJoinLayerData();

			$imilayerjoinlayer->setImiSpaceID($row['imispaceid']);
			$imilayerjoinlayer->setLayerID($row['layerid']);
			$imilayerjoinlayer->setAddDateTime($row['adddatetime']);
			$imilayerjoinlayer->setUpdateDateTime($row['updatedatetime']);
			$imilayerjoinlayer->setLayerName($row['layername']);

 		return $imilayerjoinlayer;
    }
}
?>