<?php
/**
* KakikoDbAccess.class.php 処理概要：DBアクセス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：
* @作成日/作成者：2006/09/01 (IIS)k.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

// PEAR::DB
//require_once("DB.php");
// カキコまっぷDBクラス
require_once("class/db/KakikoDb.class.php");
// リソースファイル読込み
require_once("class/xml/ReadResource.class.php");
// エラートラップ
require_once("function/KakikoErrorHandler.php");
// システム設定ファイル
require_once("kakikomap/require/common/adminRead.php");

//定義値
define("KAKIKO_DBA_INNER", 	"INNER");	// サブクエリタイプ(INNER)
define("KAKIKO_DBA_LEFT", 	"LEFT");	// サブクエリタイプ(LEFT)
define("KAKIKO_DBA_RIGHT", 	"RIGHT");	// サブクエリタイプ(RIGHT)
define("KAKIKO_DBA_WHERE", 	"WHERE");	// サブクエリタイプ(WHERE)
define("KAKIKO_DBA_HAVING", "HAVING");	// サブクエリタイプ(HAVING)

//define("KAKIKO_DBA_PROCTYPE0",	0);    // クエリ文字列コンバート処理０
//define("KAKIKO_DBA_PROCTYPE1",	1);    // クエリ文字列コンバート処理１

class KakikoDBAccess {

	/**
	 *	クラス変数
	 */
	var $db;			// DBオブジェクト
	var $sql;			// SQL
	var $rs;			// レコードセット
	var $tableName;		// テーブル名
	var $field;			// カラムフィールド名
	var $update;		// 更新内容
	var $where;			// 条件文
	var $order;			// ソート文
	var $group;			// 集約文
	var $having;		// 集計条件文
	var $subQuery;		// サブクエリ配列
	var $distinct;		// 重複行集約
	var $o_resource;	// リソースオブジェクト
	var $limit;			// 上位件数指定

    /**
     * コンストラクタ
     * @引数： (I) db         - object DBオブジェクト
     *      ： (I) tableName  - string テーブル名
     */
	function KakikoDBAccess($db, $tableName) {

		// リソースファイル読込みインスタンス
		$this->o_resource = new ReadResource(RESOURCE_SYSTEM);

		$this->db = $db;
		$this->sql = null;
		$this->rs = null;
		$this->tableName = $tableName;
		$this->field = null;
		$this->update = null;
		$this->where = null;
		$this->order = null;
		$this->group = null;
		$this->having = null;
		$this->subQuery = array(
								KAKIKO_DBA_INNER =>	array(),
								KAKIKO_DBA_LEFT =>	array(),
								KAKIKO_DBA_RIGHT =>	array(),
								KAKIKO_DBA_WHERE =>	'',
								KAKIKO_DBA_HAVING =>''
								);
		$this->distinct = false;
		if (strlen($tableName) == 0) {
			trigger_error($this->o_resource->getValue("D0_001_01"), E_USER_ERROR);
			return;
		}
		$this->limit = null;
	}

    /**
     * 関数概要：データ抽出処理
     * 処理詳細：クエリを生成しデータ抽出を行う
     *
     * @引数： 
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：簡素なクエリの作成に対応しています。
	 *            複雑化されたクエリで抽出命令を出すときには
	 *            以下のメソッドは使用せず、直接クエリを実行すること。
     */
	function dba_select() {

		// データ抽出カラムフィールド
		if (is_null($this->field)) {
			$this->field = " * ";
		}
		
		// データ抽出テーブル
		if (is_null($this->tableName) || strlen($this->tableName) == 0) {
			trigger_error($this->o_resource->getValue("D0_002_01"), E_USER_ERROR);
			return false;
		} else {
			if ($this->distinct == true) {
				$this->sql = 
						"SELECT DISTINCT ".$this->field
							." FROM ".$this->tableName;
			} else {
				$this->sql = 
						"SELECT ".$this->field
							." FROM ".$this->tableName;
			}
		}
		
		// サブクエリ(INNER JOIN, LEFT JOIN, RIGHT JOIN)
		// ※サブクエリの優先度は、1:INNER JOIN、2:LEFT JOIN、3:RIGHT JOINとなっております。
		// 　LEFT、INNER、LEFTとなるようなクエリには対応しきれていませんので
		// 　注意してください。
		if (count($this->subQuery[KAKIKO_DBA_INNER]) != 0) {
			for ($i = 0; $i < count($this->subQuery[KAKIKO_DBA_INNER]); $i++) {
				$this->sql .= 
						" INNER JOIN "
							.$this->subQuery[KAKIKO_DBA_INNER][$i];
			}
		}
		if (count($this->subQuery[KAKIKO_DBA_LEFT]) != 0) {
			for ($i = 0; $i < count($this->subQuery[KAKIKO_DBA_LEFT]); $i++) {
				$this->sql .= 
						" LEFT JOIN "
							.$this->subQuery[KAKIKO_DBA_LEFT][$i];
			}
		}
		if (count($this->subQuery[KAKIKO_DBA_RIGHT]) != 0) {
			for ($i = 0; $i < count($this->subQuery[KAKIKO_DBA_RIGHT]); $i++) {
				$this->sql .= 
						" RIGHT JOIN "
							.$this->subQuery[KAKIKO_DBA_RIGHT][$i];
			}
		}

		// 条件文
		if (!is_null($this->where)) {
			$this->sql .= 
					" WHERE ".$this->where;
		}

		// サブクエリ(WHERE)
		if (strlen($this->subQuery[KAKIKO_DBA_WHERE]) != 0) {
			$this->sql .= 
					" WHERE "
						.$this->subQuery[KAKIKO_DBA_WHERE];
		}

		// 集約文(GROUP BY)
		if (!is_null($this->group)) {
			$this->sql .= 
					" GROUP BY ".$this->group;
		}

		// 集計条件(HAVING)
		if (!is_null($this->having)) {
			$this->sql .= 
					" HAVING ".$this->having;
		}

		// サブクエリ(HAVING)
		if (strlen($this->subQuery[KAKIKO_DBA_HAVING]) != 0) {
			$this->sql .= 
					" HAVING "
						.$this->subQuery[KAKIKO_DBA_HAVING];
		}

		// ソート文
		if (!is_null($this->order)) {
			$this->sql .= 
					" ORDER BY ".$this->order;
		}

		// 上位件数取得
		if (!is_null($this->limit)) {
			$this->sql .= 
					" LIMIT ".$this->limit;
		}
		
//print "SELECT-SQL:".$this->sql."<br>";
		// クエリ実行
		$this->rs = $this->db->executeQuery($this->sql);
		if (DB::isError($this->rs)) {
			trigger_error($this->rs->getMessage().$this->o_resource->getValue("D0_002_02"), E_USER_ERROR);
			return false;
		}
		return true;
	}

    /**
     * 関数概要：データ挿入処理
     * 処理詳細：クエリを生成しデータ挿入を行う
     *
     * @引数： (I) dataclass   - object データクラスオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_insert($dataclass) {

		// テーブル名
		if (is_null($this->tableName) || strlen($this->tableName) == 0) {
			trigger_error($this->o_resource->getValue("D0_003_01"), E_USER_ERROR);
			return false;
		} 
//		else {
//			$this->sql = 
//					"INSERT INTO ".$this->tableName." VALUES (";
//		}
		else {
			$this->sql = 
					"INSERT INTO ".$this->tableName;
		}

		// データクラスオブジェクトプロパティを配列に置き換え
		$object_array = get_object_vars($dataclass);

		if (is_array($object_array)) {
			$i = 0;
			$keys_sql = " (";
			$vals_sql = " VALUES (";
			for (reset($object_array); $key = key($object_array); next($object_array)) {

				if ($i != 0) {
//					$this->sql .= ", ";
					$keys_sql .= ", ";
					$vals_sql .= ", "; 
				}
				$keys_sql .= strtolower($key);
				
				if (is_null($object_array[$key])) {
//					$this->sql .= 'null';
					$vals_sql .= 'null';
				} else {
//					$this->sql .= $object_array[$key];
					$vals_sql .= $object_array[$key];
				}
				$i++;
			}
//			$this->sql .= ")";
			$keys_sql .= ")";
			$vals_sql .= ")";

			$this->sql .= $keys_sql;
			$this->sql .= $vals_sql;
		}
		
//print "INSERT-SQL:".$this->sql."<br>";
		// クエリ実行
		$this->rs = $this->db->executeQuery($this->sql);
		if (DB::isError($this->rs)) {
			trigger_error($this->rs->getMessage().$this->o_resource->getValue("D0_003_02"), E_USER_ERROR);
			return false;
		}
		return true;
	}

    /**
     * 関数概要：データ更新処理
     * 処理詳細：クエリを生成しデータ更新を行う
     *
     * @引数： 
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_update() {

		// テーブル名
		if (is_null($this->tableName) || strlen($this->tableName) == 0) {
			trigger_error($this->o_resource->getValue("D0_004_01"), E_USER_ERROR);
			return false;
		} else {
			$this->sql = 
					"UPDATE ".$this->tableName;
		}

		// フィールド
		if (is_null($this->update)) {
			trigger_error($this->o_resource->getValue("D0_004_02"), E_USER_ERROR);
			return false;
		} else {
			$this->sql .= " SET ".$this->update;
		}

		// 条件
		if (!is_null($this->where)) {
			$this->sql .= 
					" WHERE ".$this->where;
		}
//print "UPDATE-SQL:".$this->sql."<br>";
		// クエリ実行
		$this->rs = $this->db->executeQuery($this->sql);
		if (DB::isError($this->rs)) {
			trigger_error($this->rs->getMessage().$this->o_resource->getValue("D0_004_03"), E_USER_ERROR);
			return false;
		}

		return true;
	}

    /**
     * 関数概要：データ削除処理
     * 処理詳細：クエリを生成しデータ削除を行う
     *
     * @引数： 
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_delete() {

		// テーブル名
		if (is_null($this->tableName) || strlen($this->tableName) == 0) {
			trigger_error($this->o_resource->getValue("D0_005_01"), E_USER_ERROR);
			return false;
		} else {
			$this->sql = 
					"DELETE FROM ".$this->tableName;
		}

		// 条件
		if (!is_null($this->where)) {
			$this->sql .= 
					" WHERE ".$this->where;
		}
//print "DELETE-SQL:".$this->sql."<br>";
		// クエリ実行
		$this->rs = $this->db->executeQuery($this->sql);
		if (DB::isError($this->rs)) {
			trigger_error($this->rs->getMessage().$this->o_resource->getValue("D0_005_02"), E_USER_ERROR);
			return false;
		}

		return true;
	}


    /**
     * 関数概要：重複行除去設定
     * 処理詳細：クエリ文にDISTINCT(重複行除去)を指定するかを設定する
     *
     * @引数： (I) bool  - boolean true :指定する
     *      ：                     false:指定しない
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_distinct($bool) {
		$this->distinct = $bool;
	}

    /**
     * 関数概要：カラムフィールド設定
     * 処理詳細：クエリーのSELECT文のSELECTフィールドを追加する
     *
     * @引数： (I) field - string フィールド名
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_fieldAdd($field) {
		if (is_null($this->field)) {
			$this->field = $field;
		} else {
			$this->field .= ", ".$field;
		}
	}

    /**
     * 関数概要：更新文設定
     * 処理詳細：クエリーのUPDATE文のUPDATE内容を追加する
     *
     * @引数： (I) update - string 更新内容
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_updateAdd($update) {
		
		if (is_null($this->update)) {
			$this->update = $update;
		} else {
			$this->update .= ", ".$update;
		}
	}

    /**
     * 関数概要：テーブル追加設定
     * 処理詳細：クエリーのFROM句のテーブル指定を追加する
     *
     * @引数： (I) table - string 追加テーブル名
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_tableAdd($table) {
		$this->tableName .= ", ".$table;
	}

    /**
     * 関数概要：条件文設定
     * 処理詳細：クエリーのWHERE句の条件指定を追加する
     *
     * @引数： (I) option - string 連結句(AND/OR)
     *      ： (I) where  - string 追加条件内容
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_whereAdd($option, $where) {
		if (is_null($this->where)) {
			$this->where = $where;
		} else {
			$this->where .= " ".$option." ".$where;
		}
	}

    /**
     * 関数概要：集約文設定
     * 処理詳細：クエリーのGROUP句の集約指定を追加する
     *
     * @引数： (I) group - string 追加集約内容
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_groupAdd($group) {
		if (is_null($this->group)) {
			$this->group = $group;
		} else {
			$this->group .= ", ".$group;
		}
	}

    /**
     * 関数概要：ソート順設定
     * 処理詳細：クエリーのORDER BY句のソート指定を追加する
     *
     * @引数： (I) order - string 追加ソート内容
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_orderAdd($order) {
		if (is_null($this->order)) {
			$this->order = $order;
		} else {
			$this->order .= ", ".$order;
		}
	}

    /**
     * 関数概要：上位指定件数順設定
     * 処理詳細：クエリーのLIMIT句の上位指定件数順を設定する
     *
     * @引数： (I) limit - string 抽出上位件数
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_limit($limit) {
		if (is_null($this->limit)) {
			$this->limit = $limit;
		}
	}

    /**
     * 関数概要：サブクエリ設定
     * 処理詳細：サブクエリ(副文)を設定する
     *
     * @引数： (I) type  - string サブクエリ種別(INNER/LEFT/RIGHT/WHERE/HAVING)
     *      ： (I) query - string サブクエリ内容
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_subQueryAdd($type, $query) {
		
		switch ($type) {
			case KAKIKO_DBA_INNER:
				array_push($this->subQuery[KAKIKO_DBA_INNER], $query);
				break;
			case KAKIKO_DBA_LEFT:
				array_push($this->subQuery[KAKIKO_DBA_LEFT], $query);
				break;
			case KAKIKO_DBA_RIGHT:
				array_push($this->subQuery[KAKIKO_DBA_RIGHT], $query);
				break;
			case KAKIKO_DBA_WHERE:
				$this->subQuery[KAKIKO_DBA_WHERE] = $query;
				break;
			case KAKIKO_DBA_HAVING:
				$this->subQuery[KAKIKO_DBA_HAVING] = $query;
				break;
			default:
				trigger_error($this->o_resource->getValue("D0_006_01"), E_USER_ERROR);
				break;
		}

//print "SUB-QUERY-INNER:".$this->subQuery['INNER']."<br>";
//print "SUB-QUERY-LEFT:".$this->subQuery['LEFT']."<br>";
//print "SUB-QUERY-RIGHT:".$this->subQuery['RIGHT']."<br>";
//print "SUB-QUERY-WHERE:".$this->subQuery['WHERE']."<br>";
//print "SUB-QUERY-HAVING:".$this->subQuery['HAVING']."<br>";
	}

    /**
     * 関数概要：サブクエリ設定
     * 処理詳細：サブクエリ(副文)を設定する
     *
     * @引数： (I) str   - string 文字列
     * @戻値： string    クォート済み文字列
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function query_str_convert($str) {

		$temp_str = $str;
		$temp_str = $this->db->quoteSQL($temp_str);

		return $temp_str;
	}

    /**
     * 関数概要：SQLダイレクト実行
     * 処理詳細：パラメータで渡されたクエリをそのまま実行する
     *
     * @引数： (I) sql   - string 実行するSQL文
     * @戻値： boolean true :正常
     *      ：         false:異常 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_executeQuery($sql) {
		if (isset($sql) == false){
			return false;
		}
		$this->dba_setQuery($sql);

		// クエリ実行
		$this->rs = $this->db->executeQuery($this->sql);
		if (DB::isError($this->rs)) {
			trigger_error($this->rs->getMessage().$this->o_resource->getValue("D0_007_01"), E_USER_ERROR);
			return false;
		}
		return true;
	}

	// GETEER
    /**
     * 関数概要：クエリ取得
     * 処理詳細：指定されているクエリの取得を行う
     *
     * @引数： 
     * @戻値： string    クエリ文字列
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_getQuery() {
		return $this->sql;
	}

    /**
     * 関数概要：レコードセット取得
     * 処理詳細：レコードセットの取得を行う
     *
     * @引数： 
     * @戻値： object    レコードセット
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_getRecordSet() {
		return $this->rs;
	}

	// SETTER
    /**
     * 関数概要：クエリ設定
     * 処理詳細：クエリの設定を行う
     *
     * @引数： (I) sql      - string クエリ文字列
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：(使用することは無いでしょう)
     */
	function dba_setQuery($sql) {
		$this->sql = $sql;
	}

    /**
     * 関数概要：レコードセット設定
     * 処理詳細：レコードセットの設定を行う
     *
     * @引数： (I) rs       - object レコードセット
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：(使用することは無いでしょう)
     */
	function dba_setRecordSet($rs) {
		$this->rs = $rs;
	}

    /**
     * 関数概要：解放処理
     * 処理詳細：クラス変数のメモリ解放を行う
     *
     * @引数： 
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     * @注意事項：
     */
	function dba_free() {
		if (!is_null($this->rs)) {
			$this->rs->free;
		}
	}
}

?>