<?php
/**
* LayerJoinUserAndLayerPriorityTableAccess.class.php layer_join_user_layerprioritytableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/Layer_User_LayerPriorityData.class.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class LayerJoinUserAndLayerPriorityTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス

	/**
	 * コンストラクタ
	 * @引数： (I) directryname  - string ディレクトリ名称
	 */
    function LayerJoinUserAndLayerPriorityTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

		// メインテーブル名を設定
    	$this->setTableName($directryname."_layertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：レイヤー表示設定一覧データ取得クエリ発行
     * 処理詳細：レイヤー表示設定一覧データの取得クエリを生成する
     *
     * @引数： (I) db          - object DBオブジェクト
     *      ： (I) publiclayer - array  レイヤー公開区分(配列)
     *      ： (I) statusflg   - array  状態フラグ(配列)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectLayerListData($db, $publiclayer, $statusflg) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layertable.publiclayer");
		$dba->dba_fieldAdd($this->prefix."_layertable.adddatetime as adddatetime_l");
		$dba->dba_fieldAdd($this->prefix."_usertable.username");

		// 条件指定
		if (is_array($publiclayer)) {
			$buf = $this->prefix."_layertable.publiclayer IN (";
			for ($i = 0; $i < count($publiclayer); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($publiclayer[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("", $buf);
		}

		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");

		// サブクエリ指定(INNER JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D5_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、レイヤーリンクユーザリンクレイヤー優先順位リストを生成する
     *
     * @引数： 
     * @戻値： array   レイヤーリンクユーザリンクレイヤー優先順位リスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {

		$join_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$joindata = new Layer_User_LayerPriorityData();

			// カラム名が同名のためadddatetime、updatedatetimeを
			// レイヤーテーブルの上記カラム名をadddatetime_l、updatedatetime_l、
			// ユーザテーブルの上記カラム名をadddatetime_u、updatedatetime_uで使用すること。
			// レイヤー優先順位テーブルの上記カラム名をadddatetime_p、updatedatetime_p、 

			$joindata->setUserID_Layer(isset($row['userid'])?$row['userid']:null);
			$joindata->setLayerID_Layer(isset($row['layerid'])?$row['layerid']:null);
			$joindata->setLayerName_Layer(isset($row['layername'])?$row['layername']:null);
			$joindata->setLayerNote_Layer(isset($row['layernote'])?$row['layernote']:null);
			$joindata->setPublicLayer_Layer(isset($row['publiclayer'])?$row['publiclayer']:null);
			$joindata->setReceiptLayer_Layer(isset($row['receiptlayer'])?$row['receiptlayer']:null);
			$joindata->setAddAttestUser_Layer(isset($row['addattestuser'])?$row['addattestuser']:null);
			$joindata->setDirectLink_Layer(isset($row['directlink'])?$row['directlink']:null);
			$joindata->setInitScale_Layer(isset($row['initscale'])?$row['initscale']:0);
			$joindata->setStartX_Layer(isset($row['startx'])?$row['startx']:0.0);
			$joindata->setStartY_Layer(isset($row['starty'])?$row['starty']:0.0);
			$joindata->setEndX_Layer(isset($row['endx'])?$row['endx']:0.0);
			$joindata->setEndY_Layer(isset($row['endy'])?$row['endy']:0.0);
			$joindata->setCenterScale_Layer(isset($row['centerscale'])?$row['centerscale']:0);
			$joindata->setDiffX_Layer(isset($row['diffx'])?$row['diffx']:0.0);
			$joindata->setDiffY_Layer(isset($row['diffy'])?$row['diffy']:0.0);
			$joindata->setRssFileName_Layer(isset($row['rssfilename'])?$row['rssfilename']:null);
			$joindata->setStatusFlg_Layer(isset($row['statusflg'])?$row['statusflg']:null);
			$joindata->setAddDateTime_Layer(isset($row['adddatetime_l'])?$row['adddatetime_l']:null);
			$joindata->setUpdateDateTime_Layer(isset($row['updatedatetime_l'])?$row['updatedatetime_l']:null);

			$joindata->setUserType_User(isset($row['usertype'])?$row['usertype']:null);
			$joindata->setMailAddress_User(isset($row['mailaddress'])?$row['mailaddress']:null);
			$joindata->setUserName_User(isset($row['username'])?$row['username']:null);
			$joindata->setPassword_User(isset($row['password'])?$row['password']:null);
			$joindata->setStatusFlg_User(isset($row['statusflg'])?$row['statusflg']:null);
			$joindata->setAddDateTime_User(isset($row['adddatetime_u'])?$row['adddatetime_u']:null);
			$joindata->setUpdateDateTime_User(isset($row['updatedatetime_u'])?$row['updatedatetime_u']:null);

			$joindata->setPriorityOrder_LayerPriority(isset($row['priorityorder'])?$row['priorityorder']:null);
			$joindata->setAddDateTime_LayerPriority(isset($row['adddatetime_p'])?$row['adddatetime_p']:null);
			$joindata->setUpdateDateTime_LayerPriority(isset($row['updatedatetime_p'])?$row['updatedatetime_p']:null);

			array_push($join_array, $joindata);
		}
 		return $join_array;
    }

}
?>