<?php
/**
* LayerPriorityJoinLayerTableAccess.class.php layerpriority_join_layertableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/LayerPriority_LayerData.class.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class LayerPriorityJoinLayerTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス

	/**
	 * コンストラクタ
	 * @引数： (I) directryname  - string ディレクトリ名称
	 */
    function LayerPriorityJoinLayerTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

		// メインテーブル名を設定
    	$this->setTableName($directryname."_layerprioritytable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：レイヤー優先順位一覧データ取得クエリ発行
     * 処理詳細：レイヤー優先順位一覧データの取得クエリを生成する
     *
     * @引数： (I) db          - object  DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectLayerExistLayerPriorityListData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");

		// 条件指定

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layertable ON "
				.$this->prefix."_layerprioritytable.layerid = "
				.$this->prefix."_layertable.layerid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D7_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、レイヤー優先順位リンクレイヤーリストを生成する
     *
     * @引数： 
     * @戻値： array   レイヤー優先順位リンクレイヤーリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$layerprioritylayer_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$layerprioritylayerdata = new LayerPriority_LayerData();

			// カラム名が同名のためadddatetime、updatedatetimeを
			// レイヤー優先順位テーブルの上記カラム名をadddatetime_p、updatedatetime_p、
			// レイヤーテーブルの上記カラム名をadddatetime_l、updatedatetime_lで使用すること。 

			$layerprioritylayerdata->setPriorityOrder_LayerPriority(isset($row['priorityorder'])?$row['priorityorder']:null);
			$layerprioritylayerdata->setLayerID_LayerPriority(isset($row['layerid'])?$row['layerid']:null);
			$layerprioritylayerdata->setAddDateTime_LayerPriority(isset($row['adddatetime_p'])?$row['adddatetime_p']:null);
			$layerprioritylayerdata->setUpdateDateTime_LayerPriority(isset($row['updatedatetime_p'])?$row['updatedatetime_p']:null);

			$layerprioritylayerdata->setUserID_Layer(isset($row['userid'])?$row['userid']:null);
			$layerprioritylayerdata->setLayerName_Layer(isset($row['layername'])?$row['layername']:null);
			$layerprioritylayerdata->setLayerNote_Layer(isset($row['layernote'])?$row['layernote']:null);
			$layerprioritylayerdata->setPublicLayer_Layer(isset($row['publiclayer'])?$row['publiclayer']:null);
			$layerprioritylayerdata->setReceiptLayer_Layer(isset($row['receiptlayer'])?$row['receiptlayer']:null);
			$layerprioritylayerdata->setAddAttestUser_Layer(isset($row['addattestuser'])?$row['addattestuser']:null);
			$layerprioritylayerdata->setDirectLink_Layer(isset($row['directlink'])?$row['directlink']:null);
			$layerprioritylayerdata->setInitScale_Layer(isset($row['initscale'])?$row['initscale']:null);
			$layerprioritylayerdata->setStartX_Layer(isset($row['startx'])?$row['startx']:null);
			$layerprioritylayerdata->setStartY_Layer(isset($row['starty'])?$row['starty']:null);
			$layerprioritylayerdata->setEndX_Layer(isset($row['endx'])?$row['endx']:null);
			$layerprioritylayerdata->setEndY_Layer(isset($row['endy'])?$row['endy']:null);
			$layerprioritylayerdata->setCenterScale_Layer(isset($row['centerscale'])?$row['centerscale']:null);
			$layerprioritylayerdata->setDiffX_Layer(isset($row['diffx'])?$row['diffx']:null);
			$layerprioritylayerdata->setDiffY_Layer(isset($row['diffy'])?$row['diffy']:null);
			$layerprioritylayerdata->setRssFileName_Layer(isset($row['rssfilename'])?$row['rssfilename']:null);
			$layerprioritylayerdata->setStatusFlg_Layer(isset($row['statusflg'])?$row['statusflg']:null);
			$layerprioritylayerdata->setAddDateTime_Layer(isset($row['adddatetime_l'])?$row['adddatetime_l']:null);
			$layerprioritylayerdata->setUpdateDateTime_Layer(isset($row['updatedatetime_l'])?$row['updatedatetime_l']:null);

			array_push($layerprioritylayer_array, $layerprioritylayerdata);
		}
 		return $layerprioritylayer_array;
    }
}
?>