<?php
/**
* LayerTableAccess.class.php layertableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/LayerData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class LayerTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 * コンストラクタ
	 * @引数： (I) directryname  - string ディレクトリ名称
	 */
    function LayerTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_layertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：レイヤーテーブルデータ全件取得クエリ発行
     * 処理詳細：レイヤーテーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D9_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤーテーブルキー指定データ取得クエリ発行
     * 処理詳細：レイヤーテーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key1     - string キー内容(ユーザID)
     *      ： (I) key2     - string キー内容(レイヤーID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key1, $key2) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key1));
		$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($key2));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D9_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤーテーブルキー指定(レイヤーID)データ取得クエリ発行
     * 処理詳細：レイヤーテーブルキー指定(レイヤーID)データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(レイヤーID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectLayerIDKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($key));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D9_003_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤーテーブル優先順位未設定データ取得クエリ発行
     * 処理詳細：レイヤーテーブル優先順位未設定データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectLayerNotExistLayerPriorityListData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd('layerid');
		$dba->dba_fieldAdd('layername');

		// サブクエリ指定(WHERE)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_WHERE, 
				"NOT EXISTS (SELECT ".$this->prefix."_layerprioritytable.layerid FROM "
				.$this->prefix."_layerprioritytable"
				." WHERE ".$this->prefix."_layerprioritytable.layerid = "
				.$this->prefix."_layertable.layerid)"
				);

		// ソート指定
		$dba->dba_orderAdd("layerid");

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D9_004_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：ユーザデータ付加レイヤー一覧データ取得クエリ発行
     * 処理詳細：ユーザデータ付加レイヤー一覧データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) userid   - string ユーザID
     *      ： (I) usertype - array  ユーザ種別(配列)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectLayerDataInUserData($db, $userid, $usertype) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layertable.layernote");
		$dba->dba_fieldAdd($this->prefix."_layertable.adddatetime");
		$dba->dba_fieldAdd($this->prefix."_layertable.statusflg");

		// 付加テーブル指定
		$dba->dba_tableAdd($this->prefix."_usertable");

		// 条件指定
		$dba->dba_whereAdd("", 
					$this->prefix."_layertable.userid = "
						.$this->prefix."_usertable.userid");
		$dba->dba_whereAdd("AND", $this->prefix."_usertable.userid = ".$dba->query_str_convert($userid));
//		if (is_array($usertype)) {
//
//			$buf = $this->prefix."_usertable.usertype IN (";
//			for ($i = 0; $i < count($usertype); $i++) {
//				if ($i != 0) {
//					$buf .= ",";
//				} 
//				$buf .= $dba->query_str_convert($usertype[$i]);
//			}
//			$buf .= ")";
//			$dba->dba_whereAdd("AND", $buf);
//		}

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D9_005_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤー表示順データ取得クエリ発行
     * 処理詳細：レイヤー表示順データの取得クエリを生成する
     *
     * @引数： (I) db              - object DBオブジェクト
     *      ： (I) userid          - string ユーザID
     *      ： (I) layerliststate  - array  レイヤー表示状態区分(配列)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectLayerIndicateData($db, $userid, $layerliststate) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerliststate");
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");

		// 付加テーブル指定
		$dba->dba_tableAdd($this->prefix."_userpersonalinfotable");

		// 条件指定
		$dba->dba_whereAdd("", 
					$this->prefix."_layertable.layerid = "
						.$this->prefix."_userpersonalinfotable.layerid");
		$dba->dba_whereAdd("AND", $this->prefix."_userpersonalinfotable.userid = ".$dba->query_str_convert($userid));
		if (is_array($layerliststate)) {

			$buf = $this->prefix."_userpersonalinfotable.layerliststate IN (";
			for ($i = 0; $i < count($layerliststate); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($layerliststate[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D9_006_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}


   /**
    * 関数名：最優先表示レイヤー情報取得（管理者/一般・ゲスト）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $userid 	- ユーザID
    *        (I) $statusflg - 状態フラグ(配列)	
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @概要：指定されたユーザで最上位に表示されるレイヤーの座標情報を取得する
    */
	function selectViewLayerPriority($db, $userid, $statusflg) {
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.*");

		if (is_null($userid) == false){
			//管理者・一般の時

			// 条件指定
/*			$dba->dba_whereAdd("AND", "((".$this->prefix."_layertable.publiclayer = '0'");
			$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.publicmemotype = '0'");
			$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.publicmemotype = '1'");
			$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg = '0'");
			$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userid."'))");		
*/
			$dba->dba_whereAdd("", "((".$this->prefix."_layertable.publiclayer = '0')");
			$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
			$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
			$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
			$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
			$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userid."')");
			if (is_array($statusflg)) {
				$buf = $this->prefix."_layertable.statusflg IN (";
				for ($i = 0; $i < count($statusflg); $i++) {
					if ($i != 0) {
						$buf .= ",";
					} 
					$buf .= $dba->query_str_convert($statusflg[$i]);
				}
				$buf .= ")";
				$dba->dba_whereAdd("AND", $buf);
			}
			//条件指定（個人ごとのレイヤー表示設定）
			$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
			$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");					
			// サブクエリ指定(LEFT JOIN/ユーザレイヤー)
			$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
					$this->prefix."_layerusertable ON "
					.$this->prefix."_layertable.layerid = "
					.$this->prefix."_layerusertable.layerid"
					." AND ".$this->prefix."_layerusertable.userid = "
					."'".$userid."'"
					);
			// サブクエリ指定(LEFT JOIN/個人情報)
			$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
					$this->prefix."_userpersonalinfotable ON "
					.$this->prefix."_layertable.layerid = "
					.$this->prefix."_userpersonalinfotable.layerid"
					." AND ".$this->prefix."_userpersonalinfotable.userid = "
					."'".$userid."'"
					);
			// サブクエリ指定(LEFT JOIN/コンテンツレイヤー)
			$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
					$this->prefix."_layerprioritytable ON "
					.$this->prefix."_layertable.layerid = "
					.$this->prefix."_layerprioritytable.layerid"
					);
			// ソート指定
			$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
			$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
			$dba->dba_orderAdd($this->prefix."_layertable.layerid");

		}else{
			//ゲストの時		

			// 条件指定
			$dba->dba_whereAdd("", $this->prefix."_layertable.publiclayer = '0'");
			if (is_array($statusflg)) {
				$buf = $this->prefix."_layertable.statusflg IN (";
				for ($i = 0; $i < count($statusflg); $i++) {
					if ($i != 0) {
						$buf .= ",";
					} 
					$buf .= $dba->query_str_convert($statusflg[$i]);
				}
				$buf .= ")";
				$dba->dba_whereAdd("AND", $buf);
			}
			// サブクエリ指定(LEFT JOIN/コンテンツレイヤー)
			$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
					$this->prefix."_layerprioritytable ON "
					.$this->prefix."_layertable.layerid = "
					.$this->prefix."_layerprioritytable.layerid"
					);			
			// ソート指定
			$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
			$dba->dba_orderAdd($this->prefix."_layertable.layerid");			
		}
		
		//クエリ実行
		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D9_011_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
    * 関数名：意味空間用指定ユーザ閲覧可能レイヤー取得
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $userid 	- ログインユーザID
    *        (I) $imiSpaceId - 意味空間ID	    
    *        (I) $statusflg - レイヤー状態フラグ(配列)	
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：指定されたユーザが閲覧できる意味空間のレイヤーを取得する
    *        
    */
	function selectImiMapControllLayerList($db, $userId, $imiSpaceId, $statusflg) {
	
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.*");

		// 条件指定
		$dba->dba_whereAdd("", "((".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.publicmemotype = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg = '0'");		
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'))");		
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userId."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");
		//条件指定（メモ種類公開の設定）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype <> '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is null )");		
		//条件指定（意味空間で使用されているメモの設定）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.memotypeid IN (SELECT distinct memotypeid FROM "
								.$this->prefix."_imimemopositiontable WHERE imispaceid = ".$imiSpaceId.")");
		//条件指定（意味空間で使用されているレイヤーの設定）
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.layerid IN (SELECT layerid FROM "
								.$this->prefix."_imilayertable WHERE imispaceid = ".$imiSpaceId.")");
		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");

		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_memotypetable.layerid"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);
		
		// ソート指定
		$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_orderAdd($this->prefix."_layertable.publiclayer");		
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");
		$dba->dba_orderAdd($this->prefix."_memotypetable.memotypeid");


		if ($dba->dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_07"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;

	}




    /**
     * 関数概要：レイヤーテーブルデータ挿入
     * 処理詳細：レイヤーテーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object ベースマップデータオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == LAYER_DATAOBJ) {

			// ユーザID
			$dataobj->setUserID(
				$dba->query_str_convert($dataobj->getUserID()));
			// レイヤーID
			$dataobj->setLayerID(
				$dba->query_str_convert($dataobj->getLayerID()));
			// レイヤー名称
			$dataobj->setLayerName(
				$dba->query_str_convert($dataobj->getLayerName()));
			// レイヤーの説明
			if (is_null($dataobj->getLayerNote()) != true) {
				$dataobj->setLayerNote(
					$dba->query_str_convert($dataobj->getLayerNote()));
			}
			// レイヤー公開区分
			$dataobj->setPublicLayer(
				$dba->query_str_convert($dataobj->getPublicLayer()));
			// レイヤー受付区分
			$dataobj->setReceiptLayer(
				$dba->query_str_convert($dataobj->getReceiptLayer()));
			// レイヤー登録認証区分
			$dataobj->setAddAttestUser(
				$dba->query_str_convert($dataobj->getAddAttestUser()));
			// ダイレクトリンク区分
			$dataobj->setDirectLink(
				$dba->query_str_convert($dataobj->getDirectLink()));
			// 初期スケール
			$dataobj->setInitScale($dataobj->getInitScale());
			// 始点X
			$dataobj->setStartX($dataobj->getStartX());
			// 始点Y
			$dataobj->setStartY($dataobj->getStartY());
			// 終点X
			$dataobj->setEndX($dataobj->getEndX());
			// 終点Y
			$dataobj->setEndY($dataobj->getEndY());
			// 中心スケール
			$dataobj->setCenterScale($dataobj->getCenterScale());
			// 差分X
			$dataobj->setDiffX($dataobj->getDiffX());
			// 差分Y
			$dataobj->setDiffY($dataobj->getDiffY());
			// RSSファイル名
			$dataobj->setRssFileName(
				$dba->query_str_convert($dataobj->getRssFileName()));
			// 状態フラグ
			$dataobj->setStatusFlg(
				$dba->query_str_convert($dataobj->getStatusFlg()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D9_007_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D9_007_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：レイヤーテーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == LAYER_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == LAYER_DATAOBJ)) {

			// 条件および更新内容指定

			// ユーザID
			if ($targetDataobj->getUserID() === WHERE_KEY) {
				$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($valDataobj->getUserID()));
				$whereflg = true;
			} elseif ($targetDataobj->getUserID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"userid = "
							.$dba->query_str_convert($valDataobj->getUserID()));
			}
			// レイヤーID
			if ($targetDataobj->getLayerID() === WHERE_KEY) {
				if ($whereflg) {
					$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));
				} else {
					$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));
				}
				$whereflg = true;
			} elseif ($targetDataobj->getLayerID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"layerid = "
							.$dba->query_str_convert($valDataobj->getLayerID()));
			}
			// レイヤー名称
			if ($targetDataobj->getLayerName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"layername = "
							.$dba->query_str_convert($valDataobj->getLayerName()));
			}
			// レイヤーの説明
			if ($targetDataobj->getLayerNote() === VAL_TARGET) {
				if ($valDataobj->getLayerNote() === NULL_CHAR) {
					$dba->dba_updateAdd("layernote = null");
				} else {
					$dba->dba_updateAdd(
							"layernote = "
								.$dba->query_str_convert($valDataobj->getLayerNote()));
				}
			}
			// レイヤー公開区分
			if ($targetDataobj->getPublicLayer() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"publiclayer = "
							.$dba->query_str_convert($valDataobj->getPublicLayer()));
			}
			// レイヤー受付区分
			if ($targetDataobj->getReceiptLayer() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"receiptlayer = "
							.$dba->query_str_convert($valDataobj->getReceiptLayer()));
			}
			// ユーザ登録認証区分
			if ($targetDataobj->getAddAttestUser() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"addattestuser = "
							.$dba->query_str_convert($valDataobj->getAddAttestUser()));
			}
			// ダイレクトリンク区分
			if ($targetDataobj->getDirectLink() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"directlink = "
							.$dba->query_str_convert($valDataobj->getDirectLink()));
			}
			// 初期スケール
			if ($targetDataobj->getInitScale() === VAL_TARGET) {
				if ($valDataobj->getInitScale() === NULL_CHAR) {
					$dba->dba_updateAdd("initscale = null");
				} else {
					$dba->dba_updateAdd(
							"initscale = "
								.$valDataobj->getInitScale());
				}
			}
			// 始点X
			if ($targetDataobj->getStartX() === VAL_TARGET) {
				if ($valDataobj->getStartX() === NULL_CHAR) {
					$dba->dba_updateAdd("startx = null");
				} else {
					$dba->dba_updateAdd(
							"startx = "
								.$valDataobj->getStartX());
				}
			}
			// 始点Y
			if ($targetDataobj->getStartY() === VAL_TARGET) {
				if ($valDataobj->getStartY() === NULL_CHAR) {
					$dba->dba_updateAdd("starty = null");
				} else {
					$dba->dba_updateAdd(
							"starty = "
								.$valDataobj->getStartY());
				}
			}
			// 終点X
			if ($targetDataobj->getEndX() === VAL_TARGET) {
				if ($valDataobj->getEndX() === NULL_CHAR) {
					$dba->dba_updateAdd("endx = null");
				} else {
					$dba->dba_updateAdd(
							"endx = "
								.$valDataobj->getEndX());
				}
			}
			// 終点Y
			if ($targetDataobj->getEndY() === VAL_TARGET) {
				if ($valDataobj->getEndY() === NULL_CHAR) {
					$dba->dba_updateAdd("endy = null");
				} else {
					$dba->dba_updateAdd(
							"endy = "
								.$valDataobj->getEndY());
				}
			}
			// 中心スケール
			if ($targetDataobj->getCenterScale() === VAL_TARGET) {
				if ($valDataobj->getCenterScale() === NULL_CHAR) {
					$dba->dba_updateAdd("centerscale = null");
				} else {
					$dba->dba_updateAdd(
							"centerscale = "
								.$valDataobj->getCenterScale());
				}
			}
			// 差分X
			if ($targetDataobj->getDiffX() === VAL_TARGET) {
				if ($valDataobj->getDiffX() === NULL_CHAR) {
					$dba->dba_updateAdd("diffx = null");
				} else {
					$dba->dba_updateAdd(
							"diffx = "
								.$valDataobj->getDiffX());
				}
			}
			// 差分Y
			if ($targetDataobj->getDiffY() === VAL_TARGET) {
				if ($valDataobj->getDiffY() === NULL_CHAR) {
					$dba->dba_updateAdd("diffy = null");
				} else {
					$dba->dba_updateAdd(
							"diffy = "
								.$valDataobj->getDiffY());
				}
			}
			// RSSファイル名
			if ($targetDataobj->getRssFileName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"rssfilename = "
							.$dba->query_str_convert($valDataobj->getRssFileName()));
			}
			// 状態フラグ
			if ($targetDataobj->getStatusFlg() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"statusflg = "
							.$dba->query_str_convert($valDataobj->getStatusFlg()));
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}

			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D9_008_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D9_008_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D9_008_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
     * 関数概要：レイヤーテーブルキー指定データ削除
     * 処理詳細：レイヤーテーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key1     - string キー内容(ユーザID)
     *      ： (I) key2     - string キー内容(レイヤーID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key1, $key2) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key1));
		$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($key2));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D9_009_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤーテーブルレイヤーID指定データ削除
     * 処理詳細：レイヤーテーブルレイヤーID指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(レイヤーID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteLayerIDKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($key));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D9_010_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、レイヤーリストを生成する
     *
     * @引数： 
     * @戻値： array   レイヤーリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$layer_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$layerdata = new LayerData();

			$layerdata->setUserID(isset($row['userid'])?$row['userid']:null);
			$layerdata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
			$layerdata->setLayerName(isset($row['layername'])?$row['layername']:null);
			$layerdata->setLayerNote(isset($row['layernote'])?$row['layernote']:null);
			$layerdata->setPublicLayer(isset($row['publiclayer'])?$row['publiclayer']:null);
			$layerdata->setReceiptLayer(isset($row['receiptlayer'])?$row['receiptlayer']:null);
			$layerdata->setAddAttestUser(isset($row['addattestuser'])?$row['addattestuser']:null);
			$layerdata->setDirectLink(isset($row['directlink'])?$row['directlink']:null);
			$layerdata->setInitScale(isset($row['initscale'])?$row['initscale']:null);
			$layerdata->setStartX(isset($row['startx'])?$row['startx']:null);
			$layerdata->setStartY(isset($row['starty'])?$row['starty']:null);
			$layerdata->setEndX(isset($row['endx'])?$row['endx']:null);
			$layerdata->setEndY(isset($row['endy'])?$row['endy']:null);
			$layerdata->setCenterScale(isset($row['centerscale'])?$row['centerscale']:null);
			$layerdata->setDiffX(isset($row['diffx'])?$row['diffx']:null);
			$layerdata->setDiffY(isset($row['diffy'])?$row['diffy']:null);
			$layerdata->setRssFileName(isset($row['rssfilename'])?$row['rssfilename']:null);
			$layerdata->setStatusFlg(isset($row['statusflg'])?$row['statusflg']:null);
			$layerdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$layerdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($layer_array, $layerdata);
		}
 		return $layer_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のレイヤーデータを生成する
     *
     * @引数： 
     * @戻値： array   レイヤーデータ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$layerdata = new LayerData();

		$layerdata->setUserID(isset($row['userid'])?$row['userid']:null);
		$layerdata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
		$layerdata->setLayerName(isset($row['layername'])?$row['layername']:null);
		$layerdata->setLayerNote(isset($row['layernote'])?$row['layernote']:null);
		$layerdata->setPublicLayer(isset($row['publiclayer'])?$row['publiclayer']:null);
		$layerdata->setReceiptLayer(isset($row['receiptlayer'])?$row['receiptlayer']:null);
		$layerdata->setAddAttestUser(isset($row['addattestuser'])?$row['addattestuser']:null);
		$layerdata->setDirectLink(isset($row['directlink'])?$row['directlink']:null);
		$layerdata->setInitScale(isset($row['initscale'])?$row['initscale']:null);
		$layerdata->setStartX(isset($row['startx'])?$row['startx']:null);
		$layerdata->setStartY(isset($row['starty'])?$row['starty']:null);
		$layerdata->setEndX(isset($row['endx'])?$row['endx']:null);
		$layerdata->setEndY(isset($row['endy'])?$row['endy']:null);
		$layerdata->setCenterScale(isset($row['centerscale'])?$row['centerscale']:null);
		$layerdata->setDiffX(isset($row['diffx'])?$row['diffx']:null);
		$layerdata->setDiffY(isset($row['diffy'])?$row['diffy']:null);
		$layerdata->setRssFileName(isset($row['rssfilename'])?$row['rssfilename']:null);
		$layerdata->setStatusFlg(isset($row['statusflg'])?$row['statusflg']:null);
		$layerdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$layerdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $layerdata;
    }

    /**
     * 関数概要：レイヤーテーブルキー指定重複チェック
     * 処理詳細：レイヤーテーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(レイヤーID)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key) {

		$rtn = true;

		// キー指定データの取得
		$this->selectLayerIDKeyData($db, $key);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>