<?php
/**
* LayerUserTableAccess.class.php layerusertableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/LayerUserData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class LayerUserTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


    /**
     * コンストラクタ
     * @引数： (I) directryname  - string ディレクトリ名称
     */
    function LayerUserTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_layerusertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：レイヤーユーザテーブルデータ全件取得クエリ発行
     * 処理詳細：レイヤーユーザテーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D10_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤーユーザテーブルキー指定データ取得クエリ発行
     * 処理詳細：レイヤーユーザテーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key1     - string キー内容(ユーザID)
     *      ： (I) key2     - string キー内容(レイヤーID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key1, $key2) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key1));
		$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($key2));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D10_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤーユーザテーブルデータ挿入
     * 処理詳細：レイヤーユーザテーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object レイヤーユーザデータオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == LAYERUSER_DATAOBJ) {

			// ユーザID
			$dataobj->setUserID(
				$dba->query_str_convert($dataobj->getUserID()));
			// レイヤーID
			$dataobj->setLayerID(
				$dba->query_str_convert($dataobj->getLayerID()));
			// 状態フラグ
			$dataobj->setStatusFlg(
				$dba->query_str_convert($dataobj->getStatusFlg()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D10_003_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D10_003_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：レイヤーユーザテーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == LAYERUSER_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == LAYERUSER_DATAOBJ)) {

			// 条件および更新内容指定

			// ユーザID
			if ($targetDataobj->getUserID() === WHERE_KEY) {
				$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($valDataobj->getUserID()));
				$whereflg = true;
			} elseif ($targetDataobj->getUserID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"userid = "
							.$dba->query_str_convert($valDataobj->getUserID()));
			}
			// レイヤーID
			if ($targetDataobj->getLayerID() === WHERE_KEY) {
				if ($whereflg) {
					$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));
				} else {
					$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));
				}
				$whereflg = true;
			} elseif ($targetDataobj->getLayerID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"layerid = "
							.$dba->query_str_convert($valDataobj->getLayerID()));
			}
			// 状態フラグ
			if ($targetDataobj->getStatusFlg() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"statusflg = "
							.$dba->query_str_convert($valDataobj->getStatusFlg()));
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}

			// 条件指定確認
			if ($whereflg == false){
				trigger_error($this->o_resource->getValue("D10_004_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D10_004_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D10_004_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤーユーザテーブルキー指定データ削除
     * 処理詳細：レイヤーユーザテーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key1     - string キー内容(ユーザID)
     *      ： (I) key2     - string キー内容(レイヤーID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key1, $key2) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key1));
		$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($key2));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D10_005_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、レイヤーユーザリストを生成する
     *
     * @引数： 
     * @戻値： array   レイヤーユーザリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$layeruser_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$layeruserdata = new LayerUserData();

			$layeruserdata->setUserID(isset($row['userid'])?$row['userid']:null);
			$layeruserdata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
			$layeruserdata->setStatusFlg(isset($row['statusflg'])?$row['statusflg']:null);
			$layeruserdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);

			array_push($layeruser_array, $layeruserdata);
		}
 		return $layeruser_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のレイヤーユーザデータを生成する
     *
     * @引数： 
     * @戻値： array   レイヤーユーザデータ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$layeruserdata = new LayerUserData();

		$layeruserdata->setUserID(isset($row['userid'])?$row['userid']:null);
		$layeruserdata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
		$layeruserdata->setStatusFlg(isset($row['statusflg'])?$row['statusflg']:null);
		$layeruserdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);

 		return $layeruserdata;
    }

    /**
     * 関数概要：レイヤーユーザテーブルキー指定重複チェック
     * 処理詳細：ベースマップテーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key1     - string キー内容(ユーザID)
     *      ： (I) key2     - string キー内容(レイヤーID)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key1, $key2) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key1, $key2);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>