<?php
/**
* MapDetailTableAccess.class.php mapdetailtableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/MapDetailData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class MapDetailTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */


    /**
     * コンストラクタ
     */
    function MapDetailTableAccess() {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName("mapdetailtable");
    	$this->setRecordSet(null);
    }

    /**
     * 関数概要：マップ詳細テーブルデータ全件取得クエリ発行
     * 処理詳細：マップ詳細テーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D11_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブルキー指定データ取得クエリ発行
     * 処理詳細：マップ詳細テーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key1     - string  キー内容(ディレクトリ名称)
     *      ： (I) key2     - integer キー内容(地図番号)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key1, $key2) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($key1));
//		$dba->dba_whereAdd("AND", "mapnumber = ".$key2);
		if (is_null($key2) == FALSE){
			$dba->dba_whereAdd("AND", "mapnumber = ".$key2);
		}

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D11_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブルデータ挿入
     * 処理詳細：マップ詳細テーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object マップ詳細データオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == MAPDETAIL_DATAOBJ) {

			// ディレクトリ名称
			$dataobj->setDirectryName(
				$dba->query_str_convert($dataobj->getDirectryName()));
			// 地図番号
			$dataobj->setMapNumber($dataobj->getMapNumber());
			// 表示名
			$dataobj->setListName(
				$dba->query_str_convert($dataobj->getListName()));
			// 初期表示
			if (is_null($dataobj->getInitialList()) != true) {
				$dataobj->setInitialList(
					$dba->query_str_convert($dataobj->getInitialList()));
			}
			// 外部参照
			if (is_null($dataobj->getOutsideReference()) != true) {
				$dataobj->setOutsideReference(
					$dba->query_str_convert($dataobj->getOutsideReference()));
			}
			// ピクセル数
			$dataobj->setPixel($dataobj->getPixel());
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D11_003_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D11_003_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：マップ詳細テーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == MAPDETAIL_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == MAPDETAIL_DATAOBJ)) {

			// 条件および更新内容指定

			// ディレクトリ名称
			if ($targetDataobj->getDirectryName() === WHERE_KEY) {
				$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($valDataobj->getDirectryName()));
				$whereflg = true;
			} elseif ($targetDataobj->getDirectryName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"directryname = "
							.$dba->query_str_convert($valDataobj->getDirectryName()));
			}
			// 地図番号
			if ($targetDataobj->getMapNumber() === WHERE_KEY) {
				if ($whereflg) {
					$dba->dba_whereAdd("AND", "mapnumber = ".$valDataobj->getMapNumber());
				} else {
					$dba->dba_whereAdd("", "mapnumber = ".$valDataobj->getMapNumber());
				}
				$whereflg = true;
			} elseif ($targetDataobj->getMapNumber() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"mapnumber = "
							.$valDataobj->getMapNumber());
			}
			// 表示名
			if ($targetDataobj->getListName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"listname = "
							.$dba->query_str_convert($valDataobj->getListName()));
			}
			// 初期表示
			if ($targetDataobj->getInitialList() === VAL_TARGET) {
				if ($valDataobj->getInitialList() === NULL_CHAR) {
					$dba->dba_updateAdd("initiallist = null");
				} else {
					$dba->dba_updateAdd(
							"initiallist = "
								.$dba->query_str_convert($valDataobj->getInitialList()));
				}
			}
			// 外部参照
			if ($targetDataobj->getOutsideReference() === VAL_TARGET) {
				if ($valDataobj->getOutsideReference() === NULL_CHAR) {
					$dba->dba_updateAdd("outsidereference = null");
				} else {
					$dba->dba_updateAdd(
							"outsidereference = "
								.$dba->query_str_convert($valDataobj->getOutsideReference()));
				}
			}
			// ピクセル数
			if ($targetDataobj->getPixel() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"pixel = "
							.$valDataobj->getPixel());
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}

			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D11_004_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D11_004_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D11_004_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブルキー指定データ削除
     * 処理詳細：マップ詳細テーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key1     - string  キー内容(ディレクトリ名称)
     *      ： (I) key2     - integer キー内容(地図番号)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key1, $key2) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($key1));
		$dba->dba_whereAdd("AND", "mapnumber = ".$key2);

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D11_005_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブル初期表示選択データ取得クエリ発行
     * 処理詳細：マップ詳細テーブル初期表示選択データの取得クエリを生成する
     *
     * @引数： (I) db            - object DBオブジェクト
     *      ： (I) directryname  - string ディレクトリ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindBySelectInitialListData($db, $directryname) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($directryname));
		$dba->dba_whereAdd("AND", "initiallist != ".$dba->query_str_convert(KAKIKOMAP_SELECTED_FALSE));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D11_006_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブル外部参照選択データ取得クエリ発行
     * 処理詳細：マップ詳細テーブル外部参照選択データの取得クエリを生成する
     *
     * @引数： (I) db            - object DBオブジェクト
     *      ： (I) directryname  - string ディレクトリ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindBySelectOutsideReferenceData($db, $directryname) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($directryname));
		$dba->dba_whereAdd("AND", "outsidereference != ".$dba->query_str_convert(KAKIKOMAP_SELECTED_FALSE));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D11_007_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブル初期表示更新クエリ発行
     * 処理詳細：マップ詳細テーブル初期表示の更新クエリを生成する
     *
     * @引数： (I) db            - object DBオブジェクト
     *      ： (I) directryname  - string ディレクトリ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function updateInitialList($db, $directryname) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// サブクエリ
		$sub_query = "(SELECT MAX(mapnumber) FROM ".$this->getTableName()
						." WHERE directryname = ".$dba->query_str_convert($directryname).")";
		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($directryname));
		$dba->dba_whereAdd("AND", "mapnumber = ".$sub_query);

		// 更新項目
		$dba->dba_updateAdd(
				"initiallist = "
					.$dba->query_str_convert(KAKIKOMAP_SELECTED_TRUE));

		// SQL実行
		if ($dba -> dba_update() != true) {
			trigger_error($this->o_resource->getValue("D11_008_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブル外部参照更新クエリ発行
     * 処理詳細：マップ詳細テーブル外部参照の更新クエリを生成する
     *
     * @引数： (I) db            - object DBオブジェクト
     *      ： (I) directryname  - string ディレクトリ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function updateOutsideReference($db, $directryname) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// サブクエリ
		$sub_query = "(SELECT MAX(mapnumber) FROM ".$this->getTableName()
						." WHERE directryname = ".$dba->query_str_convert($directryname).")";
		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($directryname));
		$dba->dba_whereAdd("AND", "mapnumber = ".$sub_query);

		// 更新項目
		$dba->dba_updateAdd(
				"outsidereference = "
					.$dba->query_str_convert(KAKIKOMAP_SELECTED_TRUE));

		// SQL実行
		if ($dba -> dba_update() != true) {
			trigger_error($this->o_resource->getValue("D11_009_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブル地図番号振替え更新クエリ発行
     * 処理詳細：マップ詳細テーブル地図番号振替えの更新クエリを生成する
     *
     * @引数： (I) db            - object  DBオブジェクト
     *      ： (I) directryname  - string  ディレクトリ名称
     *      ： (I) mapnumber     - integer 地図番号
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function updateChangeMapNumber($db, $directryname, $mapnumber) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($directryname));
		$dba->dba_whereAdd("AND", "mapnumber > ".$mapnumber);

		// 更新項目
		$dba->dba_updateAdd("mapnumber = mapnumber - 1");

		// SQL実行
		if ($dba -> dba_update() != true) {
			trigger_error($this->o_resource->getValue("D11_010_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ詳細テーブルディレクトリ名称指定データ削除
     * 処理詳細：マップ詳細テーブルディレクトリ名称指定データの削除クエリを生成する
     *
     * @引数： (I) db           - object DBオブジェクト
     *      ： (I) directryname - string ディレクトリ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByDirectryNameData($db, $directryname) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($directryname));
		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D11_011_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、マップ詳細リストを生成する
     *
     * @引数： 
     * @戻値： array   マップ詳細リスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$mapdetail_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$mapdetaildata = new MapDetailData();

			$mapdetaildata->setDirectryName(isset($row['directryname'])?$row['directryname']:null);
			$mapdetaildata->setMapNumber(isset($row['mapnumber'])?$row['mapnumber']:null);
			$mapdetaildata->setListName(isset($row['listname'])?$row['listname']:null);
			$mapdetaildata->setInitialList(isset($row['initiallist'])?$row['initiallist']:null);
			$mapdetaildata->setOutsideReference(isset($row['outsidereference'])?$row['outsidereference']:null);
			$mapdetaildata->setPixel(isset($row['pixel'])?$row['pixel']:null);
			$mapdetaildata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$mapdetaildata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($mapdetail_array, $mapdetaildata);
		}
 		return $mapdetail_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のマップ詳細データを生成する
     *
     * @引数： 
     * @戻値： array   マップ詳細データ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$mapdetaildata = new MapDetailData();

		$mapdetaildata->setDirectryName(isset($row['directryname'])?$row['directryname']:null);
		$mapdetaildata->setMapNumber(isset($row['mapnumber'])?$row['mapnumber']:null);
		$mapdetaildata->setListName(isset($row['listname'])?$row['listname']:null);
		$mapdetaildata->setInitialList(isset($row['initiallist'])?$row['initiallist']:null);
		$mapdetaildata->setOutsideReference(isset($row['outsidereference'])?$row['outsidereference']:null);
		$mapdetaildata->setPixel(isset($row['pixel'])?$row['pixel']:null);
		$mapdetaildata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$mapdetaildata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $mapdetaildata;
    }

    /**
     * 関数概要：マップ詳細テーブルキー指定重複チェック
     * 処理詳細：マップ詳細テーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key1     - string  キー内容(ディレクトリ名称)
     *      ： (I) key2     - integer キー内容(地図番号)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key1, $key2) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key1, $key2);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}

    /**
     * 関数概要：マップ詳細テーブル初期表示選択データ有無チェック
     * 処理詳細：マップ詳細テーブル初期表示選択データの有無チェック
     *
     * @引数： (I) db           - object  DBオブジェクト
     *      ： (I) directryname - string  ディレクトリ名称
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkInitialListDataExist($db, $directryname) {

		$rtn = true;

		// 初期表示選択データの取得
		$this->selectFindBySelectInitialListData($db, $directryname);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}

    /**
     * 関数概要：マップ詳細テーブル外部参照選択データ有無チェック
     * 処理詳細：マップ詳細テーブル外部参照選択データの有無チェック
     *
     * @引数： (I) db           - object  DBオブジェクト
     *      ： (I) directryname - string  ディレクトリ名称
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkOutsideReferenceDataExist($db, $directryname) {

		$rtn = true;

		// 外部参照選択データの取得
		$this->selectFindBySelectOutsideReferenceData($db, $directryname);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>