<?php
/**
* MemoCommentTreeAccess.class.php 
* 							メモ・コメントツリーデータDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：N.Soma
* @作成日/作成者：2006/09/01 K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/TreeDataController.class.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class MemoCommentTreeAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス

    /**
    * 関数名：コンストラクタ
    * @引数：(I) $directryname    - ディレクトリ名称
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */	 
    function MemoCommentTreeAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

		// メインテーブル名を設定
    	$this->setTableName($directryname."_memodetailtable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
    * 関数名：メモ・コメントツリーデータ取得
    * @引数：(I) $db    	- DBオブジェクト
    *        (I) $userId 	- ログインユーザ
    *        (I) $searchKey				-　検索条件
    *              $searchKey['from']	- 対象期間（from）
    *              $searchKey['to']		- 対象期間（to）
    *              $searchKey['word']	- 語句
    *              $searchKey['minx']	- 範囲座標（X緯度最小）
    *              $searchKey['maxx']	- 範囲座標（X緯度最大）
    *              $searchKey['miny']	- 範囲座標（Y経度最小）
    *              $searchKey['maxy']	- 範囲座標（Y経度最大）
    * 
	* @戻値：true/false
	* @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @注意事項：ログインユーザの有無により、データの取得方法がかわります。
    */	 
	function selectMemoCommentTreeData($db, $userId, $searchKey) {
		if (isset($userId) == false){ 
			//ゲストの時
			//↓メモの部分は、コメントIDをゼロに設定して抽出
			$sql = "SELECT * FROM("
						."(SELECT type.memotypeid, type.publicmemotype as publicmemo, layer.layerid as layerid,"
						."  layer.userid as layermaker,layer.publiclayer, type.icon as icon,type.ribboncolor as ribbon,type.authoritymemotype,type.icontype,"
						."  dt.memoid as memoid, dt.memotitle as memotitle, dt.username as username_m,dt.adddatetime as adddatetime_m,"
						."  com.commentid, com.commenttitle, com.username as username_c, com.adddatetime as adddatetime_c, com.highercommentid " 
						." FROM ".$this->prefix."_layertable layer INNER JOIN ".$this->prefix."_usertable ON layer.userid = ".$this->prefix."_usertable.userid"
						." INNER JOIN ".$this->prefix."_memotypetable type ON layer.layerid = type.layerid"
						." INNER JOIN ".$this->prefix."_memodetailtable dt ON type.memotypeid = dt.memotypeid"
						." INNER JOIN ".$this->prefix."_memopositiontable po ON dt.memoid = po.memoid"
						." INNER JOIN ".$this->prefix."_commenttable com ON dt.memoid = com.memoid"
						." LEFT JOIN ".$this->prefix."_layerprioritytable lp ON layer.layerid = lp.layerid"
						." WHERE layer.publiclayer = '0' AND layer.statusflg IN ('0') AND type.publicmemotype = '0' AND type.deleteflg = '0'" 
						." AND dt.deleteflg = '0' AND po.deleteflg = '0' AND com.deleteflg = '0'";
						// 検索条件指定
						if (is_null($searchKey) == false){
							if (is_null($searchKey['from']) == false){
								//投稿日fromを追加する
								$sql .= " AND dt.adddatetime >= '".$searchKey['from']." 00:00:00'";
							}
							if (is_null($searchKey['to']) == false){
								//投稿日toを追加する
								$sql .= " AND dt.adddatetime <= '".$searchKey['to']." 23:59:59'";
							}
							if (is_null($searchKey['word']) == false){
								//語句を追加する
								$sql .= " AND ( dt.memotitle like '%".$searchKey['word']."%'";
								$sql .= " OR dt.memotext like '%".$searchKey['word']."%' )";
							}							
							if (is_null($searchKey['minx']) == false){
								//緯度最小を追加する
								$sql .= " AND po.longitude >=".$searchKey['minx'];
							}
							if (is_null($searchKey['maxx']) == false){
								//緯度最大を追加する
								$sql .= " AND po.longitude <=".$searchKey['maxx'];
							}
							if (is_null($searchKey['miny']) == false){
								//経度最小を追加する
								$sql .= " AND po.latitude >=".$searchKey['miny'];
							}
							if (is_null($searchKey['maxy']) == false){
								//経度最大を追加する
								$sql .= " AND po.latitude <=".$searchKey['maxy'];
							}
						}
			$sql .=      " AND ( type.effectiveterm >= '".date('Y-m-d H:i:s')."' OR type.effectiveterm is null))"
						." UNION ALL"
						." (SELECT type.memotypeid, type.publicmemotype as publicmemo, layer.layerid as layerid, layer.userid as layermaker,"
						." layer.publiclayer, type.icon as icon,type.ribboncolor as ribbon,type.authoritymemotype, type.icontype,dt.memoid as memoid, dt.memotitle as memotitle,"
						." dt.username as username_m, dt.adddatetime as adddatetime_m,"
						." 0 as commentid, null as commenttitle, null as username_c, null as adddatetime_c, null as highercommentid"
						." FROM ".$this->prefix."_layertable layer INNER JOIN ".$this->prefix."_usertable ON layer.userid = ".$this->prefix."_usertable.userid"
						." INNER JOIN ".$this->prefix."_memotypetable type ON layer.layerid = type.layerid"
						." INNER JOIN ".$this->prefix."_memodetailtable dt ON type.memotypeid = dt.memotypeid"
						." INNER JOIN ".$this->prefix."_memopositiontable po ON dt.memoid = po.memoid"
						." LEFT JOIN ".$this->prefix."_layerprioritytable lp ON layer.layerid = lp.layerid"
						." WHERE layer.publiclayer = '0' AND layer.statusflg IN ('0') AND type.publicmemotype = '0' AND type.deleteflg = '0'" 
						." AND dt.deleteflg = '0' AND po.deleteflg = '0'";
						// 検索条件指定
						if (is_null($searchKey) == false){
							if (is_null($searchKey['from']) == false){
								//投稿日fromを追加する
								$sql .= " AND dt.adddatetime >= '".$searchKey['from']." 00:00:00'";
							}
							if (is_null($searchKey['to']) == false){
								//投稿日toを追加する
								$sql .= " AND dt.adddatetime <= '".$searchKey['to']." 23:59:59'";
							}
							if (is_null($searchKey['word']) == false){
								//語句を追加する
								$sql .= " AND ( dt.memotitle like '%".$searchKey['word']."%'";
								$sql .= " OR dt.memotext like '%".$searchKey['word']."%' )";
							}							
							if (is_null($searchKey['minx']) == false){
								//緯度最小を追加する
								$sql .= " AND po.longitude >= ".$searchKey['minx'];
							}
							if (is_null($searchKey['maxx']) == false){
								//緯度最大を追加する
								$sql .= " AND po.longitude <= ".$searchKey['maxx'];
							}
							if (is_null($searchKey['miny']) == false){
								//経度最小を追加する
								$sql .= " AND po.latitude >= ".$searchKey['miny'];
							}
							if (is_null($searchKey['maxy']) == false){
								//経度最大を追加する
								$sql .= " AND po.latitude <= ".$searchKey['maxy'];
							}
						}
						
			$sql .=      " AND ( type.effectiveterm >= '".date('Y-m-d H:i:s')."' OR type.effectiveterm is null))"
					.")as memocomment";
					if (is_null($searchKey) == false){
						if (is_null($searchKey['limit']) == false){
							//最新件数
							$sql .= " ORDER BY adddatetime_m desc , commentid";
						}else{
							$sql .= " ORDER BY memoid, commentid";						
						}
					}else{
						$sql .= " ORDER BY memoid, commentid";
					}
				
					
			$this->setRecordSet($db->executeQuery($sql));
	
		}else{
			//管理者・一般ユーザでログインの場合(メモ取得部のコメント項目は、ダミーデータを投入している)

			$sql = "SELECT * FROM("
						."(SELECT type.memotypeid, type.publicmemotype as publicmemo, layer.layerid as layerid,"
						."  layer.userid as layermaker,layer.publiclayer, type.icon as icon,type.ribboncolor as ribbon, type.authoritymemotype,type.icontype,"
						."  dt.memoid as memoid, dt.memotitle as memotitle, dt.username as username_m,dt.adddatetime as adddatetime_m,"
						."  com.commentid, com.commenttitle, com.username as username_c, com.adddatetime as adddatetime_c, com.highercommentid " 
						." FROM ".$this->prefix."_layertable layer INNER JOIN ".$this->prefix."_usertable usr ON layer.userid = usr.userid "
						." INNER JOIN ".$this->prefix."_memotypetable type ON layer.layerid = type.layerid "
						." INNER JOIN ".$this->prefix."_memodetailtable dt ON type.memotypeid = dt.memotypeid "
						." INNER JOIN ".$this->prefix."_memopositiontable po ON  dt.memoid = po.memoid "
						." INNER JOIN ".$this->prefix."_commenttable com ON dt.memoid = com.memoid "
						." LEFT JOIN ".$this->prefix."_layerusertable lu ON layer.layerid = lu.layerid AND lu.userid = '".$userId."'"
						." LEFT JOIN ".$this->prefix."_userpersonalinfotable up ON layer.layerid = up.layerid AND up.userid = '".$userId."'"
						." LEFT JOIN ".$this->prefix."_layerprioritytable lp ON layer.layerid = lp.layerid "
						." WHERE ((layer.publiclayer = '0' AND (type.publicmemotype = '0' OR type.publicmemotype = '1' AND lu.statusflg = '0' OR layer.userid = '".$userId."')) OR (layer.publiclayer = '1' AND lu.userid is not null AND lu.statusflg = '0') OR layer.publiclayer = '9' AND layer.userid = '".$userId."') "
						." AND layer.statusflg IN ('0') AND (up.layerliststate ='0' OR up.layerliststate is null)"
						." AND (layer.userid <> '".$userId."' AND type.publicmemotype <> '9' AND lu.userid = '".$userId."' OR layer.userid = '".$userId."' OR layer.userid <> '".$userId."' AND type.publicmemotype = '0' AND lu.userid is null )"						
						." AND type.deleteflg = '0' AND dt.deleteflg = '0' AND po.deleteflg = '0' AND com.deleteflg = '0'";
						// 検索条件指定
						if (is_null($searchKey) == false){
							if (is_null($searchKey['from']) == false){
								//投稿日fromを追加する
								$sql .= " AND dt.adddatetime >= '".$searchKey['from']." 00:00:00'";
							}
							if (is_null($searchKey['to']) == false){
								//投稿日toを追加する
								$sql .= " AND dt.adddatetime <= '".$searchKey['to']." 23:59:59'";
							}
							if (is_null($searchKey['word']) == false){
								//語句を追加する
								$sql .= " AND ( dt.memotitle like '%".$searchKey['word']."%'";
								$sql .= " OR dt.memotext like '%".$searchKey['word']."%' )";
							}							
							if (is_null($searchKey['minx']) == false){
								//緯度最小を追加する
								$sql .= " AND po.longitude >= ".$searchKey['minx'];
							}
							if (is_null($searchKey['maxx']) == false){
								//緯度最大を追加する
								$sql .= " AND po.longitude <= ".$searchKey['maxx'];
							}
							if (is_null($searchKey['miny']) == false){
								//経度最小を追加する
								$sql .= " AND po.latitude >= ".$searchKey['miny'];
							}
							if (is_null($searchKey['maxy']) == false){
								//経度最大を追加する
								$sql .= " AND po.latitude <= ".$searchKey['maxy'];
							}
						}				
			$sql .=		" AND ( type.effectiveterm >= '".date('Y-m-d H:i:s')."' OR type.effectiveterm is null))"
						." UNION ALL"
						." (SELECT type.memotypeid, type.publicmemotype as publicmemo, layer.layerid as layerid,"
						." layer.userid as layermaker,layer.publiclayer, type.icon as icon,type.ribboncolor as ribbon, type.authoritymemotype,type.icontype,"
						." dt.memoid as memoid, dt.memotitle as memotitle, dt.username as username_m, dt.adddatetime as adddatetime_m,"
						." 0 as commentid, null as commenttitle, null as username_c, null as adddatetime_c, null as highercommentid"
						." FROM ".$this->prefix."_layertable layer INNER JOIN ".$this->prefix."_usertable usr ON layer.userid = usr.userid "
						." INNER JOIN ".$this->prefix."_memotypetable type ON layer.layerid = type.layerid "
						." INNER JOIN ".$this->prefix."_memodetailtable dt ON type.memotypeid = dt.memotypeid "
						." INNER JOIN ".$this->prefix."_memopositiontable po ON  dt.memoid = po.memoid "
						." LEFT JOIN ".$this->prefix."_layerusertable lu ON layer.layerid = lu.layerid AND lu.userid = '".$userId."'"
						." LEFT JOIN ".$this->prefix."_userpersonalinfotable up ON layer.layerid = up.layerid AND up.userid = '".$userId."'"
						." LEFT JOIN ".$this->prefix."_layerprioritytable lp ON layer.layerid = lp.layerid "
						." WHERE ((layer.publiclayer = '0' AND (type.publicmemotype = '0' OR type.publicmemotype = '1' AND lu.statusflg = '0' OR layer.userid = '".$userId."')) OR (layer.publiclayer = '1' AND lu.userid is not null AND lu.statusflg = '0') OR layer.publiclayer = '9' AND layer.userid = '".$userId."') "
						." AND layer.statusflg IN ('0') AND (up.layerliststate ='0' OR up.layerliststate is null)"
						." AND (layer.userid <> '".$userId."' AND type.publicmemotype <> '9' AND lu.userid = '".$userId."' OR layer.userid = '".$userId."' OR layer.userid <> '".$userId."' AND type.publicmemotype = '0' AND lu.userid is null )"
						." AND type.deleteflg = '0' AND dt.deleteflg = '0' AND po.deleteflg = '0'";
						// 検索条件指定
						if (is_null($searchKey) == false){
							if (is_null($searchKey['from']) == false){
								//投稿日fromを追加する
								$sql .= " AND dt.adddatetime >= '".$searchKey['from']." 00:00:00'";
							}
							if (is_null($searchKey['to']) == false){
								//投稿日toを追加する
								$sql .= " AND dt.adddatetime <= '".$searchKey['to']." 23:59:59'";
							}
							if (is_null($searchKey['word']) == false){
								//語句を追加する
								$sql .= " AND ( dt.memotitle like '%".$searchKey['word']."%'";
								$sql .= " OR dt.memotext like '%".$searchKey['word']."%' )";
							}							
							if (is_null($searchKey['minx']) == false){
								//緯度最小を追加する
								$sql .= " AND po.longitude >=".$searchKey['minx'];
							}
							if (is_null($searchKey['maxx']) == false){
								//緯度最大を追加する
								$sql .= " AND po.longitude <=".$searchKey['maxx'];
							}
							if (is_null($searchKey['miny']) == false){
								//経度最小を追加する
								$sql .= " AND po.latitude >=".$searchKey['miny'];
							}
							if (is_null($searchKey['maxy']) == false){
								//経度最大を追加する
								$sql .= " AND po.latitude <=".$searchKey['maxy'];
							}
						}					
			$sql .=		" AND ( type.effectiveterm >= '".date('Y-m-d H:i:s')."' OR type.effectiveterm is null))"
					.")as memocomment";
					if (is_null($searchKey) == false){
						if (is_null($searchKey['limit']) == false){
							//最新件数
							$sql .= " ORDER BY adddatetime_m desc , commentid";
						}else{
							$sql .= " ORDER BY memoid, commentid";						
						}
					}else{
						$sql .= " ORDER BY memoid, commentid";
					}					
		}
			$this->setRecordSet($db->executeQuery($sql));
		
		return true;
	}

    /**
    * 関数名：キー指定メモ・コメントツリーデータ取得
    * @引数：(I) $db    	- DBオブジェクト
    *        (I) $memoId 	- メモID
	* @戻値：true/false
	* @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */	 
	function selectMemoCommentTreeDataByKey($db, $memoId) {

		if (isset($memoId) == false){
			trigger_error($this->o_resource->getValue("D31_001_01"), E_USER_ERROR);
				
			return false;
		}else{ 
			//↓メモの部分は、コメントIDをゼロに設定して抽出
			$sql = "SELECT * FROM("
						."(SELECT type.memotypeid, type.icon as icon,type.ribboncolor as ribbon,type.authoritymemotype,type.icontype,dt.memoid as memoid,"
						."   dt.memotitle as memotitle, dt.username as username_m,dt.adddatetime as adddatetime_m,"
 						."    com.commentid,com.commenttitle, com.username as username_c, com.adddatetime as adddatetime_c,com.highercommentid "
 						." FROM ".$this->prefix."_memotypetable type "
 						." INNER JOIN ".$this->prefix."_memodetailtable dt ON type.memotypeid = dt.memotypeid"
						." INNER JOIN ".$this->prefix."_memopositiontable po ON dt.memoid = po.memoid AND dt.memotypeid = type.memotypeid"
						." INNER JOIN ".$this->prefix."_commenttable com ON dt.memoid = com.memoid AND po.memoid = com.memoid"
						." WHERE po.deleteflg = '0' AND dt.deleteflg = '0' AND com.deleteflg = '0'"
						." AND po.memoid = ".$memoId
						." )"
						." UNION ALL "
						."(SELECT type.memotypeid, type.icon as icon,type.ribboncolor as ribbon,type.authoritymemotype,type.icontype,dt.memoid as memoid,"
						."   dt.memotitle as memotitle, dt.username as username_m,dt.adddatetime as adddatetime_m,"
						."   0 as commentid, null as commenttitle, null as username_c, null as adddatetime_c, null as highercommentid"
 						." FROM ".$this->prefix."_memotypetable type "
 						." INNER JOIN ".$this->prefix."_memodetailtable dt ON type.memotypeid = dt.memotypeid"
						." INNER JOIN ".$this->prefix."_memopositiontable po ON dt.memoid = po.memoid AND dt.memotypeid = type.memotypeid"
						." WHERE po.deleteflg = '0' AND dt.deleteflg = '0'"
						." AND po.memoid = ".$memoId
						." )"
						.")as memocomment"
						." ORDER BY memoid, commentid";
			$this->setRecordSet($db->executeQuery($sql));

		}
		
		return true;
	}





   /**
    * 関数名：レコードセットより、ツリーコントロールを生成する。
    * @引数：なし
	* @戻値：TreeDataContollerデータ
	* @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */	 
    function getAllMemoTreeData() {
        $rowcount = 1;
		$rscur = $this->getRecordSet();
		if ($this->getRecordCount() == 0){
			return null;
		}
		$treeControl = new TreeDataController();
		while($row = $rscur->fetchrow(DB_FETCHMODE_ASSOC)) {
			$treenodedata = new TreeNodeData();
			
			$treenodedata->setTreeNodeKey($rowcount);
			if ($row['commentid'] == 0){
				//メモの場合
				$treenodedata->setNodeType(TREE_NODE_TYPE_MEMO);		//メモ
				$treenodedata->setTitle($row['memotitle']);			
				$treenodedata->setUserName($row['username_m']);		//メモ投稿者
				$treenodedata->setAddDatetime($row['adddatetime_m']);	
			}else{
				//コメントの場合
				$treenodedata->setNodeType(TREE_NODE_TYPE_COMMENT);		//コメント
				$treenodedata->setTitle($row['commenttitle']);		
				$treenodedata->setUserName($row['username_c']);	
				$treenodedata->setAddDatetime($row['adddatetime_c']);	
				$treenodedata->setCommentID($row['commentid']);
				$treenodedata->setHigherCommentID($row['highercommentid']);
			}
			$treenodedata->setMemoTypeID($row['memotypeid']);
			$treenodedata->setMemoID($row['memoid']);
			$treenodedata->setRibboncolor($row['ribbon']);
			$treenodedata->setIconType($row['icontype']);
			$treenodedata->setIcon($row['icon']);
			$treenodedata->setAuthorityMemoType($row['authoritymemotype']);

			//ツリーデータコントローラにノードを追加
			$treeControl->createNode($treenodedata);
			$rowcount++;
						

		}
 		return $treeControl;
    }
    
//#################################################################################################
//                                        以下、ファンクション
//#################################################################################################    
   /**
    * 関数名：ツリー表示データ取得
    * @引数：(I) $allNodeList 	- 全ノードリスト
    *        (I) $searchKey 	- 検索条件（limitのみ対象）
    * @戻値：TreeNodeData配列
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getTreeViewData($allNodeList, $searchKey){
		$array_data = array();
		foreach($allNodeList as $current){
			
			if ($current->getNodeType() == TREE_NODE_TYPE_MEMO){
				$current->setNodeLevel(1);	//最上位は１
				array_push($array_data, $current);
				$this->setTreeLevel($allNodeList,$current,$array_data);
			}
		}
		//上位X件指定の精査
		if (is_null($searchKey) == false){
			if (is_null($searchKey['limit']) == false){
				//上位X件がゼロ指定だったら、何もない配列を返す
				if ($searchKey['limit'] == 0){
					return array();
				}				
				//結果リストよりも上位X件のほうが多い時はそのまま返す
				if (count($array_data) < $searchKey['limit']){
					return $array_data;
				}
				//上位指定は「メモ」に対するX件出力とし、その配下は全件出力
				$limit_array_data = array();
				$memocount = 1;
				$arraycount = 0;
				$prememoid = null;
				while($memocount <= $searchKey['limit']){
					//最初だけpremodidをセット
					if (is_null($prememoid) == true){
						$prememoid = $array_data[$arraycount]->getMemoID();
					}
					array_push($limit_array_data,$array_data[$arraycount]);
					$arraycount++;//次のレコードを先読みするためにカウントアップ
					//この時点でツリーデータの配列よりも最新件数が上回ったら元の結果を返す
					if (count($array_data) <= $arraycount){
						return $array_data;
					}
					if ($prememoid != $array_data[$arraycount]->getMemoID()){
						$memocount++;//メモIDが切り替わった時点でカウント
					}
					$prememoid = $array_data[$arraycount]->getMemoID();
				}

				return $limit_array_data;
			}			
		}
			return $array_data;		
	}

   /**
    * 関数名：ツリー階層設定
    * @引数：(I) $allnodelist 	- 全ノードリスト
    *        (I) $treeNode 		- ツリーノードデータ
    *        (I/O) $array_data 	- 再構成用TreeNodeData配列
    * @戻値：TreeNodeData配列
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function setTreeLevel($allnodelist, $treeNode, &$array_data){
		foreach($treeNode->getChildNodeList() as $current){
			
			//自分からからルートまでの長さを見る
			$tmpnode = $current;		
			while($tmpnode != null){
				if (is_null($tmpnode->getPreNode()) == false){
					if (empty($level) == true){
						$level = 2;	//コメントはレベル２から
					}else{
						 $level++;
					}
					$tmpnode = $tmpnode->getPreNode();
					$tmpnode = $allnodelist[$tmpnode->getTreeNodeKey() -1];
				}else{
					$tmpnode = null;
				}
			}

			//データからarrayに設定
			$current->setNodeLevel($level);
			array_push($array_data,$current);	
			$level = 0;
			//再帰呼び出し
 			$this->setTreeLevel($allnodelist,$allnodelist[$current->getTreeNodeKey()-1],$array_data);
		}
	}

}
?>