<?php
/**
* MemoDetailTableAccess.class.php memodetailtableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/MemoDetailData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class MemoDetailTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


    /**
     * コンストラクタ
     * @引数： (I) directryname  - string ディレクトリ名称
     */
    function MemoDetailTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_memodetailtable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：メモ詳細データ全件取得クエリ発行
     * 処理詳細：メモ詳細テーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D15_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：メモ詳細キー指定データ取得クエリ発行
     * 処理詳細：メモ詳細テーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key      - integer キー内容(メモID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "memoid = ".$key);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D15_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：メモ詳細メモ種類ID指定データ取得クエリ発行
     * 処理詳細：メモ詳細テーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db         - object  DBオブジェクト
     *      ： (I) memotypeid - integer メモ種類ID
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByMemoTypeIDData($db, $memotypeid) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "memotypeid = ".$memotypeid);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D15_003_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：メモ詳細データ挿入
     * 処理詳細：メモ詳細テーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object メモ詳細データオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == MEMODETAIL_DATAOBJ) {

			// メモID
			$dataobj->setMemoID($dataobj->getMemoID());
			// メモ種類ID
			$dataobj->setMemoTypeID($dataobj->getMemoTypeID());
			// ユーザ名称
			$dataobj->setUserName(
				$dba->query_str_convert($dataobj->getUserName()));
			// メモタイトル
			$dataobj->setMemoTitle(
				$dba->query_str_convert($dataobj->getMemoTitle()));
			// 本文
			$dataobj->setMemoText(
				$dba->query_str_convert($dataobj->getMemoText()));
			// メールアドレス
			if (is_null($dataobj->getMailAddress()) != true) {
				$dataobj->setMailAddress(
					$dba->query_str_convert($dataobj->getMailAddress()));
			}
			// 関連URL
			if (is_null($dataobj->getReleteURL()) != true) {
				$dataobj->setReleteURL(
					$dba->query_str_convert($dataobj->getReleteURL()));
			}
			// 画像ファイル
			if (is_null($dataobj->getImageFile()) != true) {
				$dataobj->setImageFile(
					$dba->query_str_convert($dataobj->getImageFile()));
			}
			// 修正・削除用パスワード
			if (is_null($dataobj->getUpdateDeletePassword()) != true) {
				$dataobj->setUpdateDeletePassword(
					$dba->query_str_convert($dataobj->getUpdateDeletePassword()));
			}
			// アクセス回数
			$dataobj->setAccessCount($dataobj->getAccessCount());
			// 削除フラグ
			if (is_null($dataobj->getDeleteFlg()) != true) {
				$dataobj->setDeleteFlg(
					$dba->query_str_convert($dataobj->getDeleteFlg()));
			}
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D15_004_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D15_004_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：メモ詳細テーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == MEMODETAIL_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == MEMODETAIL_DATAOBJ)) {

			// 条件および更新内容指定

			// メモID
			if ($targetDataobj->getMemoID() === WHERE_KEY) {
				$dba->dba_whereAdd("", "memoid = ".$valDataobj->getMemoID());
				$whereflg = true;
			} elseif ($targetDataobj->getMemoID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"memoid = "
							.$valDataobj->getMemoID());
			}
			// メモ種類ID
			if ($targetDataobj->getMemoTypeID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"memotypeid = "
							.$valDataobj->getMemoTypeID());
			}
			// ユーザ名称
			if ($targetDataobj->getUserName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"username = "
							.$dba->query_str_convert($valDataobj->getUserName()));
			}
			// メモタイトル
			if ($targetDataobj->getMemoTitle() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"memotitle = "
							.$dba->query_str_convert($valDataobj->getMemoTitle()));
			}
			// 本文
			if ($targetDataobj->getMemoText() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"memotext = "
							.$dba->query_str_convert($valDataobj->getMemoText()));
			}
			// メールアドレス
			if ($targetDataobj->getMailAddress() === VAL_TARGET) {
				if ($valDataobj->getMailAddress() === NULL_CHAR) {
					$dba->dba_updateAdd("mailaddress = null");
				} else {
					$dba->dba_updateAdd(
							"mailaddress = "
								.$dba->query_str_convert($valDataobj->getMailAddress()));
				}
			}
			// 関連URL
			if ($targetDataobj->getReleteURL() === VAL_TARGET) {
				if ($valDataobj->getReleteURL() === NULL_CHAR) {
					$dba->dba_updateAdd("releteurl = null");
				} else {
					$dba->dba_updateAdd(
							"releteurl = "
								.$dba->query_str_convert($valDataobj->getReleteURL()));
				}
			}
			// 画像ファイル
			if ($targetDataobj->getImageFile() === VAL_TARGET) {
				if ($valDataobj->getImageFile() === NULL_CHAR) {
					$dba->dba_updateAdd("imagefile = null");
				} else {
					$dba->dba_updateAdd(
							"imagefile = "
								.$dba->query_str_convert($valDataobj->getImageFile()));
				}
			}
			// 修正・削除用パスワード
			if ($targetDataobj->getUpdateDeletePassword() === VAL_TARGET) {
				if ($valDataobj->getUpdateDeletePassword() === NULL_CHAR) {
					$dba->dba_updateAdd("updatedeletepassword = null");
				} else {
					$dba->dba_updateAdd(
							"updatedeletepassword = "
								.$dba->query_str_convert($valDataobj->getUpdateDeletePassword()));
				}
			}
			// アクセス回数
			if ($targetDataobj->getAccessCount() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"accesscount = "
							.$valDataobj->getAccessCount());
			}
			// 削除フラグ
			if ($targetDataobj->getDeleteFlg() === VAL_TARGET) {
					$dba->dba_updateAdd(
							"deleteflg = "
								.$dba->query_str_convert($valDataobj->getDeleteFlg()));
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}
			
			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D15_005_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D15_005_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D15_005_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
     * 関数概要：メモ詳細キー指定データ削除
     * 処理詳細：メモ詳細テーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key      - integer キー内容(メモID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "memoid = ".$key);

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D15_006_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、メモ詳細リストを生成する
     *
     * @引数： 
     * @戻値： array   メモ詳細リスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$memodetail_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$memodetaildata = new MemoDetailData();

			$memodetaildata->setMemoID(isset($row['memoid'])?$row['memoid']:null);
			$memodetaildata->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
			$memodetaildata->setUserName(isset($row['username'])?$row['username']:null);
			$memodetaildata->setMemoTitle(isset($row['memotitle'])?$row['memotitle']:null);
			$memodetaildata->setMemoText(isset($row['memotext'])?$row['memotext']:null);
			$memodetaildata->setMailAddress(isset($row['mailaddress'])?$row['mailaddress']:null);
			$memodetaildata->setReleteURL(isset($row['releteurl'])?$row['releteurl']:null);
			$memodetaildata->setImageFile(isset($row['imagefile'])?$row['imagefile']:null);
			$memodetaildata->setUpdateDeletePassword(isset($row['updatedeletepassword'])?$row['updatedeletepassword']:null);
			$memodetaildata->setAccessCount(isset($row['accesscount'])?$row['accesscount']:null);
			$memodetaildata->setDeleteFlg(isset($row['deleteflg'])?$row['deleteflg']:null);
			$memodetaildata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$memodetaildata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($memodetail_array, $memodetaildata);
		}
 		return $memodetail_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のメモ詳細データを生成する
     *
     * @引数： 
     * @戻値： array   メモ詳細データ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$memodetaildata = new MemoDetailData();

		$memodetaildata->setMemoID(isset($row['memoid'])?$row['memoid']:null);
		$memodetaildata->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
		$memodetaildata->setUserName(isset($row['username'])?$row['username']:null);
		$memodetaildata->setMemoTitle(isset($row['memotitle'])?$row['memotitle']:null);
		$memodetaildata->setMemoText(isset($row['memotext'])?$row['memotext']:null);
		$memodetaildata->setMailAddress(isset($row['mailaddress'])?$row['mailaddress']:null);
		$memodetaildata->setReleteURL(isset($row['releteurl'])?$row['releteurl']:null);
		$memodetaildata->setImageFile(isset($row['imagefile'])?$row['imagefile']:null);
		$memodetaildata->setUpdateDeletePassword(isset($row['updatedeletepassword'])?$row['updatedeletepassword']:null);
		$memodetaildata->setAccessCount(isset($row['accesscount'])?$row['accesscount']:null);
		$memodetaildata->setDeleteFlg(isset($row['deleteflg'])?$row['deleteflg']:null);
		$memodetaildata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$memodetaildata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $memodetaildata;
    }

    /**
     * 関数概要：メモ詳細テーブルキー指定重複チェック
     * 処理詳細：メモ詳細テーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key      - integer キー内容(メモID)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}

    /**
     * 関数概要：メモ詳細テーブルメモ種類ID指定重複チェック
     * 処理詳細：メモ詳細テーブルデータをメモ種類ID指定で重複しているかをチェック
     *
     * @引数： (I) db         - object  DBオブジェクト
     *      ： (I) memotypeid - integer メモ種類ID
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByMemoTypeIDData($db, $memotypeid) {

		$rtn = true;

		// メモ種類指定データの取得
		$this->selectFindByMemoTypeIDData($db, $memotypeid);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>