<?php
/**
* UserPersonalInfoTableAccess.class.php userpersonalinfotableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/UserPersonalInfoData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class UserPersonalInfoTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


    /**
     * コンストラクタ
     * @引数： (I) directryname  - string ディレクトリ名称
     */
    function UserPersonalInfoTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_userpersonalinfotable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：一般ユーザ個人情報テーブルデータ全件取得クエリ発行
     * 処理詳細：一般ユーザ個人情報テーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D20_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一般ユーザ個人情報テーブルキー指定データ取得クエリ発行
     * 処理詳細：一般ユーザ個人情報テーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key1     - string キー内容(ユーザID)
     *      ： (I) key2     - string キー内容(レイヤーID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key1, $key2) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key1));
		$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($key2));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D20_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一般ユーザ個人情報テーブルデータ挿入
     * 処理詳細：一般ユーザ個人情報テーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object 一般ユーザ個人情報データオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == USERPERSONALINFO_DATAOBJ) {

			// ユーザID
			$dataobj->setUserID(
				$dba->query_str_convert($dataobj->getUserID()));
			// レイヤーID
			$dataobj->setLayerID(
				$dba->query_str_convert($dataobj->getLayerID()));
			// レイヤー表示状態区分
			$dataobj->setLayerListState(
				$dba->query_str_convert($dataobj->getLayerListState()));
			// レイヤー優先順位
			if (is_null($dataobj->getLayerPriorityOrder()) != true) {
				$dataobj->setLayerPriorityOrder($dataobj->getLayerPriorityOrder());
			}
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D20_003_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D20_003_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：一般ユーザ個人情報テーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == USERPERSONALINFO_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == USERPERSONALINFO_DATAOBJ)) {

			// 条件および更新内容指定
			// ユーザID
			if ($targetDataobj->getUserID() === WHERE_KEY) {
				$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($valDataobj->getUserID()));
				$whereflg = true;
			} elseif ($targetDataobj->getUserID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"userid = "
							.$dba->query_str_convert($valDataobj->getUserID()));
			}
			// レイヤーID
			if ($targetDataobj->getLayerID() === WHERE_KEY) {
				if ($whereflg) {
					$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));
				} else {
					$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));
				}
				$whereflg = true;
			} elseif ($targetDataobj->getLayerID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"layerid = "
							.$dba->query_str_convert($valDataobj->getLayerID()));
			}
			// レイヤー表示状態区分
			if ($targetDataobj->getLayerListState() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"layerliststate = "
							.$dba->query_str_convert($valDataobj->getLayerListState()));
			}
			// レイヤー優先順位
			if ($targetDataobj->getLayerPriorityOrder() === VAL_TARGET) {
				if ($valDataobj->getLayerPriorityOrder() === NULL_CHAR) {
					$dba->dba_updateAdd("layerpriorityorder = null");
				} else {
					$dba->dba_updateAdd(
							"layerpriorityorder = "
								.$valDataobj->getLayerPriorityOrder());
				}
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}
			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D20_004_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D20_004_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D20_004_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
     * 関数概要：一般ユーザ個人情報テーブルキー指定データ削除
     * 処理詳細：一般ユーザ個人情報テーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key1     - string キー内容(ユーザID)
     *      ： (I) key2     - string キー内容(レイヤーID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key1, $key2) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key1));
		$dba->dba_whereAdd("AND", "layerid = ".$dba->query_str_convert($key2));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D20_005_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一般ユーザ個人情報テーブルユーザID指定データ削除
     * 処理詳細：一般ユーザ個人情報テーブルユーザIDキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) userid   - string ユーザID
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByUserID($db, $userid) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($userid));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D20_006_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、一般ユーザ個人情報リストを生成する
     *
     * @引数： 
     * @戻値： array   一般ユーザ個人情報リスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$userpersonalinfo_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$userpersonalinfodata = new UserPersonalInfoData();

			$userpersonalinfodata->setUserID(isset($row['userid'])?$row['userid']:null);
			$userpersonalinfodata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
			$userpersonalinfodata->setLayerListState(isset($row['layerliststate'])?$row['layerliststate']:null);
			$userpersonalinfodata->setLayerPriorityOrder(isset($row['layerpriorityorder'])?$row['layerpriorityorder']:null);
			$userpersonalinfodata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$userpersonalinfodata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($userpersonalinfo_array, $userpersonalinfodata);
		}
 		return $userpersonalinfo_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件の一般ユーザ個人情報データを生成する
     *
     * @引数： 
     * @戻値： array   一般ユーザ個人情報データ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

			$userpersonalinfodata = new UserPersonalInfoData();

			$userpersonalinfodata->setUserID(isset($row['userid'])?$row['userid']:null);
			$userpersonalinfodata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
			$userpersonalinfodata->setLayerListState(isset($row['layerliststate'])?$row['layerliststate']:null);
			$userpersonalinfodata->setLayerPriorityOrder(isset($row['layerpriorityorder'])?$row['layerpriorityorder']:null);
			$userpersonalinfodata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$userpersonalinfodata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $userpersonalinfodata;
    }

    /**
     * 関数概要：一般ユーザ個人情報テーブルキー指定重複チェック
     * 処理詳細：一般ユーザ個人情報テーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key1     - string キー内容(ユーザID)
     *      ： (I) key2     - string キー内容(レイヤーID)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key1, $key2) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key1, $key2);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>