<?php
/**
* ContentsViewService.php 意味空間管理系DBアクセスサービス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("Date.php");
require_once("kakikomap/ImiDef.php");                 // 意味空間定数
//require_once("kakikomap/DBColumnDef.php");
//require_once("class/db/dbaccess/KakikoDBAccess.class.php");
require_once("class/db/service/KakikoService.class.php");
require_once("class/db/dbaccess/ImiLayerJoinLayerTableAccess.class.php");
require_once("class/db/dbaccess/ImiBaseInfoTableAccess.class.php");
require_once("class/db/dbaccess/ImiBaseInfoJoinUserTableAccess.class.php");
require_once("class/db/dbaccess/LayerTableAccess.class.php");
require_once("class/db/dbaccess/LayerJoinUserAndLayerUserAndPersonalAndPriorityTableAccess.class.php");
require_once("class/db/dbaccess/ImiLayerTableAccess.class.php");
require_once("class/db/dbaccess/ImiColorInfoTableAccess.class.php");
require_once("class/db/dbaccess/MemoDetailJoinPositionJoinTypeTableAccess.class.php");
require_once("class/db/dbaccess/ImiMemoPositionTableAccess.class.php");
require_once("class/common/ImiCalcPosition.class.php");


class ImiAdminService extends KakikoService {

	/**
	 *	コンストラクタ
	 */
    function ImiAdminService($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->KakikoService($directryname);
		// DB接続情報の設定
		$this->setDBConnectInfo();

    }

   /**
    * 関数名：意味空間使用レイヤー表示用リスト取得
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    * @戻値：ImiLayerJoinLayerData
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getImiLayerViewListData($imiSpaceId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// 意味空間レイヤー表示用テーブルDBアクセス
		$table_access = new ImiLayerJoinLayerTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->selectFindByKeyData($this->o_db, $imiSpaceId,null);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_01"), E_USER_ERROR);
			return null;
		}

		// データオブジェクトの取得
		$datalist = $table_access->getDataList();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $datalist;
	
	}

   /**
    * 関数名：意味空間使用可能レイヤーリスト取得
    * @引数：(I) $userId 	- ユーザID
    * @戻値：ImiLayerJoinLayerData
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：ユーザが意味空間で選択可能なレイヤーを取得します。
    */
	function getLayerDataListPossibleToUse($userId){
	
		// DBオブジェクトの生成
		$this->createDBObject();
		
        // レイヤー・ユーザ・レイヤー優先順位・個人情報ジョインテーブルDBアクセス
		$table_access = new LayerJoinUserAndLayerUserAndPersonalAndPriorityTableAccess($this->directryname);

        // レイヤー状態フラグ（通常のみ）
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);

        // クエリー発行
		$rtn = $table_access->selectViewLayerListData($this->o_db, $userId, $status_array);
		
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_02"), E_USER_ERROR);
			return null;
		}

		// データオブジェクトの取得
		$datalist = $table_access->getDataList();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $datalist;
	
	}



   /**
    * 関数名：意味空間一覧取得
    * @引数：(I) $userId 	- ログインユーザID
    * @戻値：ImiBaseInfoData
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getImiBaseInfoDataList($userId) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// 意味空間基本・ユーザテーブルDBアクセス
		$table_access = new ImiBaseInfoJoinUserTableAccess($this->directryname);

		//ユーザ種別取得
		if ($_SESSION[$this->directryname."_usertype"] == 1){
			//マップ管理者用クエリ発行
			$rtn =  $table_access->selectFindByKeyDataMapAdmin($this->o_db, $userId);
		}else{
			//一般ユーザ用クエリ発行
			$rtn =  $table_access->selectFindByKeyDataNormalMember($this->o_db, $userId);			
		}
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_03"), E_USER_ERROR);
			return null;
		}

		// データオブジェクトの取得
		$datalist = $table_access->getDataList();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $datalist;
	
	}

   /**
    * 関数名：意味空間情報取得
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    * @戻値：ImiBaseInfo_UserData
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getImiBaseInfoData($imiSpaceId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// 意味空間基本情報・ユーザテーブルDBアクセス
		$table_access = new ImiBaseInfoJoinUserTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->selectFindByKeyData($this->o_db, $imiSpaceId);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_04"), E_USER_ERROR);
			return null;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}

		// データオブジェクトの取得
		$data = $table_access->getOneData();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data;
	
	}

   /**
    * 関数名：意味空間情報削除
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
	* @注意事項：空間内の各種情報はトリガー側で削除します。
    */
	function deleteImiBaseInfoData($imiSpaceId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// 意味空間基本情報テーブルDBアクセス
		$table_access = new ImiBaseInfoTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->deleteByKeyData($this->o_db, $imiSpaceId);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_05"), E_USER_ERROR);
			return false;
		}
		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return true;
	
	}

   /**
    * 関数名：意味空間新規登録
    * @引数：(I) $imiBaseInfoData   	- 意味空間基本データオブジェクト
    *        (I) $imiLayerDataList[]	- 意味空間使用レイヤーデータオブジェクト配列
    *        (I) $userId				- ユーザID(空間作成者)
    *        (I) $positionMode  		- メモ配置モード(0:地図座標比率計算,1：整列) 
    * 
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function insertImiSpace($imiBaseInfoData, $imiLayerDataList, $userId, $positionMode) {
		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// -----------------------------------------------
		// 意味空間基本テーブルへ新規にレコードを追加
		// -----------------------------------------------
		$imibase_access = new ImiBaseInfoTableAccess($this->directryname);
		// データ追加
		$rtn = $imibase_access->insertData($this->o_db, $imiBaseInfoData);
		if ($rtn != true) {
			$this->o_db->rollback();
			$imibase_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_06"), E_USER_ERROR);
			return false;
		}
		$imibase_access->free();

		// -----------------------------------------------
		// 発行した意味空間IDをシーケンスから取得
		// -----------------------------------------------
		//select currval('xxxxxx_imibaseinfotable_imispaceid_seq') as imispaceid_seq
		$dba = new KakikoDBAccess($this->o_db, 'dummy');
		$dba->dba_executeQuery("select currval('".$this->directryname."_imibaseinfotable_imispaceid_seq') as imispaceid_seq");		
		while($row = $dba->rs->fetchrow(DB_FETCHMODE_ASSOC)) {
			$newImiSpaceId = isset($row['imispaceid_seq'])?$row['imispaceid_seq']:null;
		}

		// -----------------------------------------------
		// 意味レイヤーテーブルへ新規にレコードを追加
		// -----------------------------------------------
		$imilayer_access = new ImiLayerTableAccess($this->directryname);
		foreach($imiLayerDataList as $curImilayerdata){
			$curImilayerdata->setImiSpaceID($newImiSpaceId);
			// データ追加
			$rtn = $imilayer_access->insertData($this->o_db, $curImilayerdata);
			if ($rtn != true) {
				$this->o_db->rollback();
				$imilayer_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S5_001_07"), E_USER_ERROR);
				return false;
			}
		}
		$imilayer_access->free();


		// -----------------------------------------------
		// 色情報本テーブルへ新規にレコードを追加
		// -----------------------------------------------
//		$datetmp = date("Y-m-d H:i:s");
		$sql = "insert into ".$this->directryname."_imicolorinfotable (imispaceid,colorid,categoryname,adddatetime,updatedatetime)"
			." (select ".$newImiSpaceId." as imispaceid, colorid, null, '".$imiBaseInfoData->getAddDatetime()."' as adddatetime, '"
			 .$imiBaseInfoData->getAddDatetime()."' as updatedatetime from imicolormaster )";
		$rtn = $dba->dba_executeQuery($sql);		
		if ($rtn != true) {
			$this->o_db->rollback();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_08"), E_USER_ERROR);
			return false;
		}
		//コード000番は「NO SETTINGS」
		$sql ="update ".$this->directryname."_imicolorinfotable set categoryname = 'NO SETTINGS' where colorid = '000' and imispaceid = ".$newImiSpaceId;
		$rtn = $dba->dba_executeQuery($sql);		
		if ($rtn != true) {
			$this->o_db->rollback();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_08"), E_USER_ERROR);
			return false;
		}

		// -----------------------------------------------
		// 対象となるメモデータを取得して空間メモ位置情報テーブルへ新規にレコードを追加
		// -----------------------------------------------
		$memodetailpositiontype_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);
		// レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);
		//対象データselect
		$rtn = $memodetailpositiontype_access->selectViewMemoDetailPositionTypeDataByUser($this->o_db, $userId, $status_array,$imiLayerDataList,null,2,null);
		if ($rtn != true) {
			$this->o_db->rollback();
			$memodetailpositiontype_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_09"), E_USER_ERROR);
			return false;
		}
		$memodatalist = $memodetailpositiontype_access->getDataList();
		//投入データ設定
		$imimemodatalist = array();
		if (count($memodatalist) > 0){
			$imimemodatalist = $this->makeImiMemoData($memodatalist, $imiBaseInfoData->getAddDatetime()
													,$userId,$imiLayerDataList,$positionMode);			
		}		
		$imimemoposition_access	= new ImiMemoPositionTableAccess($this->directryname);
		foreach($imimemodatalist as $current){
			$current->setImiSpaceID($newImiSpaceId);
			$rtn = $imimemoposition_access->insertData($this->o_db, $current);
			if ($rtn != true) {
				$this->o_db->rollback();
				$imimemoposition_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S5_001_10"), E_USER_ERROR);
				return false;
			}			
		}
		$imimemoposition_access->free();
		
		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();

		return true;


	}

   /**
    * 関数名：意味空間設定情報更新
    * @引数：(I) $targetImiBaseInfoDataobj   - 対象列(条件列/更新列)指定用意味空間データオブジェクト
    *        (I) $valImiBaseInfoDataobj	    - 設定値(条件値/更新値)指定用意味空間データオブジェクト
    *        (I) $imiLayerDataList	    		- 使用レイヤーデータ(ImiLayerData)オブジェクト配列
    *        (I) $userId	    		- ユーザID
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @注意事項：使用レイヤーが増えた時だけ、全ての選択レイヤー配下メモの取り込み・更新を行う
    *            登録される日時のデータは、$valImiBaseInfoDataobjのupdatedatetimeの値を使用する
    */
	function updateImiBaseInfo($targetImiBaseInfoDataobj, $valImiBaseInfoDataobj, $imiLayerData, $userId) {
		// -----------------------------------------------
		// 現在使用されているレイヤーを取得し、増分のレイヤーをリスト保持
		// -----------------------------------------------

		$useLayerList = $this->getImiLayerViewListData($valImiBaseInfoDataobj->getImiSpaceID());
		$addLayerList = array();
		$useflg = false;
		foreach($imiLayerData as $tmpimilayer){
			foreach($useLayerList as $tmpUseimilayer){
				if ($tmpimilayer->getLayerID() === $tmpUseimilayer->getLayerID()){
					$useflg = true;//選択したレイヤーは現在使用中
				}
			}
			if ($useflg == false){
				//選択したレイヤーが現在使用されていないとき
				array_push($addLayerList, $tmpimilayer);//増分だけのレイヤー
			}
			$useflg = false;
		}

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// -----------------------------------------------
		// 意味空間のメモの最終取り込み日を取得
		// -----------------------------------------------
		$baseinfo_access = new ImiBaseInfoTableAccess($this->directryname);
		$rtn = $baseinfo_access->selectFindByKeyData($this->o_db, $valImiBaseInfoDataobj->getImiSpaceID());
		if ($rtn != true) {
			$this->o_db->rollback();
			$baseinfo_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_11"), E_USER_ERROR);
			return false;
		}
		$basedata =$baseinfo_access->getOneData();
		$lastupdatetime = $basedata->getTakememoDatetime();

		// -----------------------------------------------
		// 意味空間基本情報を更新
		// -----------------------------------------------
		if (count($addLayerList) > 0){
			//増分レイヤーがあるときだけメモ取り込み時を更新・メモ増加警告フラグ・更新削除フラグもおろす
			$targetImiBaseInfoDataobj->setTakememoDatetime(VAL_TARGET);
			$targetImiBaseInfoDataobj->setMemoChangeFlg(VAL_TARGET);
			$targetImiBaseInfoDataobj->setMemoDeleteWarnFlg(VAL_TARGET);
			$valImiBaseInfoDataobj->setTakememoDatetime($valImiBaseInfoDataobj->getUpdateDateTime());
			$valImiBaseInfoDataobj->setMemoChangeFlg(KAKIKOMAP_IMIBASE_CHANGE_OFF);
			$valImiBaseInfoDataobj->setMemoDeleteWarnFlg(KAKIKOMAP_IMIBASE_CHANGE_OFF);
		}
		$rtn = $baseinfo_access->updateByKeyData($this->o_db, $targetImiBaseInfoDataobj,$valImiBaseInfoDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$baseinfo_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_12"), E_USER_ERROR);
			return false;
		}
		$baseinfo_access->free();

		//増分のレイヤーがあるときだけ
		if (count($addLayerList) > 0){
			// -----------------------------------------------
			// 現在使用されているレイヤーの中で、最終取り込み日以降の更新日を持つ閲覧可能なメモを取得
			// -----------------------------------------------
			$memodetailpositiontype_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);
        	$status_array = array(KAKIKOMAP_STATUSFLG_ON);// レイヤー状態フラグ
			$rtn = $memodetailpositiontype_access->selectViewMemoDetailPositionTypeDataByUser($this->o_db,
																$userId,$status_array,$useLayerList,$lastupdatetime,2,null);
			if ($rtn != true) {
				$this->o_db->rollback();
				$memodetailpositiontype_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S5_001_13"), E_USER_ERROR);
				return false;
			}
			$memolist = $memodetailpositiontype_access->getDataList();
															
			// -----------------------------------------------
			// 取得したメモが意味空間メモに存在するかチェック
			// -----------------------------------------------
			$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);
			$targetImiMemoPositionobj = new ImiMemoPositionData();
			$valImiMemoPositionobj = new ImiMemoPositionData();
			$ycount = IMI_CALC_MARGIN;//整列時の余白。ImiCalcPositionに定義
			foreach ($memolist as $tmpmemo){		
				$rtn = $imimemoposition_access->selectFindByKeyData($this->o_db,
													 				$valImiBaseInfoDataobj->getImiSpaceID(),
													  				$tmpmemo->getMemoID());
				if ($rtn != true) {
					$this->o_db->rollback();
					$imimemoposition_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S5_001_14"), E_USER_ERROR);
					return false;
				}
				if ($imimemoposition_access->getRecordCount() > 0){
					// -----------------------------------------------
					// 意味空間メモ情報１件を更新(実際にはここは通らないはず)
					// -----------------------------------------------
					$targetImiMemoPositionobj->setImiSpaceID(WHERE_KEY);
					$targetImiMemoPositionobj->setMemoID(WHERE_KEY);
					$targetImiMemoPositionobj->setLayerID(VAL_TARGET);
					$targetImiMemoPositionobj->setMemoTypeID(VAL_TARGET);
					$targetImiMemoPositionobj->setUpdateDatetime(VAL_TARGET);
					$valImiMemoPositionobj->setImiSpaceID($valImiBaseInfoDataobj->getImiSpaceID());
					$valImiMemoPositionobj->setMemoID($tmpmemo->getMemoID());
					$valImiMemoPositionobj->setLayerID($tmpmemo->getLayerID());
					$valImiMemoPositionobj->setMemoTypeID($tmpmemo->getMemoTypeID());
					$valImiMemoPositionobj->setUpdateDatetime($valImiBaseInfoDataobj->getUpdateDateTime());
					$imimemoposition_access->updateByKeyData($this->o_db,$targetImiMemoPositionobj,$valImiMemoPositionobj);
				}else{
					// -----------------------------------------------
					// 意味空間メモ情報１件を追加
					// -----------------------------------------------
					$valImiMemoPositionobj->setImiSpaceID($valImiBaseInfoDataobj->getImiSpaceID());
					$valImiMemoPositionobj->setMemoID($tmpmemo->getMemoID());
					$valImiMemoPositionobj->setLayerID($tmpmemo->getLayerID());
					$valImiMemoPositionobj->setMemoTypeID($tmpmemo->getMemoTypeID());
					$valImiMemoPositionobj->setColorID("000");
					$valImiMemoPositionobj->setAddDatetime($valImiBaseInfoDataobj->getUpdateDateTime());
					$valImiMemoPositionobj->setUpdateDatetime($valImiBaseInfoDataobj->getUpdateDateTime());
					$valImiMemoPositionobj->setCoordinateX(IMI_CALC_MARGIN);//整列時の余白。ImiCalcPositionに定義
					$valImiMemoPositionobj->setCoordinateY($ycount);
					//Y軸カウント増加
					$ycount = $ycount + IMI_CALC_LINE_MARGIN;	//整列の際のマージン。					
					$imimemoposition_access->insertData($this->o_db, $valImiMemoPositionobj);
				}
			}
		
			// -----------------------------------------------
			// 意味空間レイヤー情報を更新
			// -----------------------------------------------
			$imilayer_access = new ImiLayerTableAccess($this->directryname);
			foreach ($addLayerList as $tmpaddlayer){
				$rtn = $imilayer_access->insertData($this->o_db, $tmpaddlayer);
				if ($rtn != true) {
					$this->o_db->rollback();
					$imilayer_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S5_001_15"), E_USER_ERROR);
					return false;
				}
			}
			// -----------------------------------------------
			// 増分レイヤー内のメモデータを取得して空間メモ位置情報テーブルへ新規にレコードを追加
			// -----------------------------------------------
//			$memodetailpositiontype_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);
//			$layer_array = array();
//			foreach ($addLayerList as $tmplayer){
//				array_push($layer_array, $tmplayer);
//			}
			//対象データselect
			$rtn = $memodetailpositiontype_access->selectViewMemoDetailPositionTypeDataByUser($this->o_db, $userId,
																						 $status_array,$addLayerList,null,2,null);
			if ($rtn != true) {
				$this->o_db->rollback();
				$memodetailpositiontype_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S5_001_13"), E_USER_ERROR);
				return false;
			}
			$memodatalist = $memodetailpositiontype_access->getDataList();
			//メモ位置は固定で投入データを作成
			$imimemodatalist = array();
			if (count($memodatalist) > 0){
				$imimemodatalist = $this->makeImiMemoData($memodatalist, $valImiBaseInfoDataobj->getUpdateDateTime(),
															$userId, $addLayerList,1);				
			}
			
			foreach($imimemodatalist as $current){
				$current->setImiSpaceID($valImiBaseInfoDataobj->getImiSpaceID());
				$rtn = $imimemoposition_access->insertData($this->o_db, $current);
				if ($rtn != true) {
					$this->o_db->rollback();
					$imimemoposition_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S5_001_17"), E_USER_ERROR);
					return false;
				}			

			}
			$imimemoposition_access->free();
		}		
		//増分のレイヤーがない時は、メモ情報は更新しない

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return true;
	}

   /**
    * 関数名：意味空間メモの差分取り込み
    * @引数：(I) $imiSpaceId   				- 対象意味空間ID
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @注意事項：現在使用されているレイヤー内の閲覧可能メモ増分だけを意味空間に取り込む
    */
	function updateImiAdditionMemo($imiSpaceId) {
		//現在時刻の保持
		$datetmp = date("Y-m-d H:i:s");
	
		// DBオブジェクトの生成
		$this->createDBObject();
		// -----------------------------------------------
		// 意味空間基本情報取得
		// -----------------------------------------------
		$baseinfo_access = new ImiBaseInfoTableAccess($this->directryname);
		$rtn = $baseinfo_access->selectFindByKeyData($this->o_db, $imiSpaceId);
		if ($rtn != true) {
			$this->o_db->rollback();
			$baseinfo_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_19"), E_USER_ERROR);
			return false;
		}
		$basedata = $baseinfo_access->getOneData();
		// -----------------------------------------------
		// 現在使用レイヤー取得	
		// -----------------------------------------------
		$imilayer_access = new ImiLayerTableAccess($this->directryname);
		$rtn = $imilayer_access->selectFindByKeyData($this->o_db, $imiSpaceId, null);
		if ($rtn != true) {
			$this->o_db->rollback();
			$imilayer_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_20"), E_USER_ERROR);
			return false;
		}
		$imilayerlist = $imilayer_access->getDataList();
		// -----------------------------------------------
		// 最終取り込み日以降の更新日を持つ閲覧可能なメモを取得
		// -----------------------------------------------
		$memodetailpositiontype_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);
    	$status_array = array(KAKIKOMAP_STATUSFLG_ON);// レイヤー状態フラグ
		$rtn = $memodetailpositiontype_access->selectViewMemoDetailPositionTypeDataByUser($this->o_db,
															$basedata->getUserID(),$status_array,
															$imilayerlist,$basedata->getTakememoDatetime(),2,null);
		if ($rtn != true) {
			$this->o_db->rollback();
			$memodetailpositiontype_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_21"), E_USER_ERROR);
			return false;
		}
		$memolist = $memodetailpositiontype_access->getDataList();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// -----------------------------------------------
		// 取得したメモが意味空間メモに存在するかチェック
		// -----------------------------------------------
		$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);
		$targetImiMemoPositionobj = new ImiMemoPositionData();
		$valImiMemoPositionobj = new ImiMemoPositionData();
		$ycount = IMI_CALC_MARGIN;//整列時の余白。ImiCalcPositionに定義		
		foreach ($memolist as $tmpmemo){		
			$rtn = $imimemoposition_access->selectFindByKeyData($this->o_db,
												 				$basedata->getImiSpaceID(),
												  				$tmpmemo->getMemoID());
			if ($rtn != true) {
				$this->o_db->rollback();
				$imimemoposition_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S5_001_22"), E_USER_ERROR);
				return false;
			}
			if ($imimemoposition_access->getRecordCount() > 0){
				// -----------------------------------------------
				// 意味空間メモ情報１件を更新
				// -----------------------------------------------
				$targetImiMemoPositionobj->setImiSpaceID(WHERE_KEY);
				$targetImiMemoPositionobj->setMemoID(WHERE_KEY);
				$targetImiMemoPositionobj->setLayerID(VAL_TARGET);
				$targetImiMemoPositionobj->setMemoTypeID(VAL_TARGET);
				$targetImiMemoPositionobj->setUpdateDatetime(VAL_TARGET);
				$valImiMemoPositionobj->setImiSpaceID($basedata->getImiSpaceID());
				$valImiMemoPositionobj->setMemoID($tmpmemo->getMemoID());
				$valImiMemoPositionobj->setLayerID($tmpmemo->getLayerID());
				$valImiMemoPositionobj->setMemoTypeID($tmpmemo->getMemoTypeID());
				$valImiMemoPositionobj->setUpdateDatetime($datetmp);
				$imimemoposition_access->updateByKeyData($this->o_db,$targetImiMemoPositionobj,$valImiMemoPositionobj);
			}else{
				// -----------------------------------------------
				// 意味空間メモ情報１件を追加
				// -----------------------------------------------
				$valImiMemoPositionobj->setImiSpaceID($basedata->getImiSpaceID());
				$valImiMemoPositionobj->setMemoID($tmpmemo->getMemoID());
				$valImiMemoPositionobj->setLayerID($tmpmemo->getLayerID());
				$valImiMemoPositionobj->setMemoTypeID($tmpmemo->getMemoTypeID());
				$valImiMemoPositionobj->setColorID("000");
				$valImiMemoPositionobj->setAddDatetime($datetmp);
				$valImiMemoPositionobj->setUpdateDatetime($datetmp);
				$valImiMemoPositionobj->setCoordinateX(IMI_CALC_MARGIN);//整列時の余白。ImiCalcPositionに定義
				$valImiMemoPositionobj->setCoordinateY($ycount);
				//Y軸カウント増加
				$ycount = $ycount + IMI_CALC_LINE_MARGIN;	//整列の際のマージン。					
				$imimemoposition_access->insertData($this->o_db, $valImiMemoPositionobj);
			}
		}
		$imimemoposition_access->free();

		// -----------------------------------------------
		// 意味空間基本情報を更新(メモ取り込み日・メモ変更フラグ・警告フラグもおろす)
		// -----------------------------------------------
		$targetImiBaseInfoDataobj = new ImiBaseInfoData();
		$valImiBaseInfoDataobj = new ImiBaseInfoData();
		$targetImiBaseInfoDataobj->setImiSpaceID(WHERE_KEY);
		$targetImiBaseInfoDataobj->setTakememoDatetime(VAL_TARGET);
		$targetImiBaseInfoDataobj->setMemoChangeFlg(VAL_TARGET);
		$targetImiBaseInfoDataobj->setMemoDeleteWarnFlg(VAL_TARGET);
		$valImiBaseInfoDataobj->setImiSpaceID($imiSpaceId);
		$valImiBaseInfoDataobj->setTakememoDatetime($datetmp);
		$valImiBaseInfoDataobj->setMemoChangeFlg(KAKIKOMAP_IMIBASE_CHANGE_OFF);
		$valImiBaseInfoDataobj->setMemoDeleteWarnFlg(KAKIKOMAP_IMIBASE_CHANGE_OFF);
		$rtn = $baseinfo_access->updateByKeyData($this->o_db, $targetImiBaseInfoDataobj,$valImiBaseInfoDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$baseinfo_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_23"), E_USER_ERROR);
			return false;
		}
		$baseinfo_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();

		return true;

	}

/*	function test($imilayerarray){
		
		// DBオブジェクトの生成
		$this->createDBObject();
		
		$memodetailpositiontype_access = new MemoDetailJoinPositionJoinTypeTableAccess("somatest");
 	  	$status_array = array(KAKIKOMAP_STATUSFLG_ON);// レイヤー状態フラグ
		$rtn = $memodetailpositiontype_access->selectViewMemoDetailPositionTypeDataByUser($this->o_db,
															"001",$status_array,
															$imilayerarray,null,null);
		$retdatalist = $memodetailpositiontype_access->getDataList();

		$calc = new ImiCalcPosition($this->directryname);
		$calc->initCalcBaseInfo($this->o_db, "001", $imilayerarray);
		
		$count = 1;
		foreach($retdatalist as $current){
//			 $calc->calcImiMemoPosition(50, 80);
			 $calc->calcImiMemoPosition($current->getLongitude(), $current->getLatitude());
			print "MEMO:".$count."　　　".$calc->getImiMemoPositionX()."　".$calc->getImiMemoPositionY()."\n";
			$count++;
		}

		// DB接続の切断
		$this->disconnectDB();

	}
*/	
	
//#################################################################################################
//                                        以下、サービス内使用関数定義
//#################################################################################################

   /**
    * 関数名：意味空間メモデータ作成
    * @引数：(I) $memoDataList   	- MemoDetailPositionTypeData[]型リスト
    *        (I) $datetimetmp   	- 登録用日付（フォーマットずみ） 
    *        (I) $userId  			- 作成ユーザID
    *        (I) $targetLayerList	- 対象ImiLayerData[]リスト    
    *        (I) $positionMode  	- メモ配置モード(0:地図座標比率計算,1：整列) 
    * @戻値：意味メモ位置データ /false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @注意事項：DBのコネクト情報は、呼び出し元で確保しておきます。
    */
	function makeImiMemoData($memoDataList, $datetimetmp,$userId, $targetLayerList, $positionMode) {
//		$datetmp = date("Y-m-d H:i:s");
		$ycount = IMI_CALC_MARGIN;//整列時の余白。ImiCalcPositionに定義
		$xcount = IMI_CALC_MARGIN;//X方向
		$memocount =1;
		
		//意味空間座標算出クラス作成
		$imicalc = new ImiCalcPosition($this->directryname);
	 	$rtn = $imicalc->initCalcBaseInfo($this->o_db, $userId, $targetLayerList);
		if ($rtn != true) {
			$this->o_db->rollback();
			$imicalc->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S5_001_26"), E_USER_ERROR);
			return false;
		}
		
		//取得したデータから、意味空間用のデータを作成
		$imimemodata_array = array();
		
		foreach($memoDataList as $tmplist){
			$imimemodata = new ImiMemoPositionData();
			$imimemodata->setMemoID($tmplist->getMemoID());
			if ($positionMode == 0){
				//意味空間メモ位置算出
				$imicalc->calcImiMemoPosition($tmplist->getLongitude(),$tmplist->getLatitude());
				$imimemodata->setCoordinateX($imicalc->getImiMemoPositionX());
				$imimemodata->setCoordinateY($imicalc->getImiMemoPositionY());
			}elseif ($positionMode == 1){
				//配置できる最大数を考慮し、入りきらなくなったら、X方向をずらす
				if ($memocount <= $imicalc->getMaxRibbonNumForY()){
					//固定ピクセルずつ増加
					$imimemodata->setCoordinateX($xcount);
					$imimemodata->setCoordinateY($ycount);
					$memocount++;
					//Y軸カウント増加
					$ycount = $ycount + IMI_CALC_LINE_MARGIN;	//整列の際のマージン。			
				}else{
					//Y方向に入りきらなくなった時
					$ycount = IMI_CALC_MARGIN;	//Y方向初期化					
					$xcount = $xcount + IMI_CALC_LINE_MARGIN;	//X軸カウント増加			
					$memocount = 1;
					$imimemodata->setCoordinateX($xcount);
					$imimemodata->setCoordinateY($ycount);
				}
			}			
			$imimemodata->setColorID("000");//初期色を設定
			$imimemodata->setLayerID($tmplist->getLayerID());
			$imimemodata->setMemoTypeID($tmplist->getMemoTypeID());
			$imimemodata->setAddDatetime($datetimetmp);
			$imimemodata->setUpdateDatetime($datetimetmp);

			array_push($imimemodata_array, $imimemodata);
		}
		return $imimemodata_array;
	}
}
?>
