<?php
/**
* ImiViewService.php 意味空間表示系DBアクセスサービス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("Date.php");
require_once("class/db/service/KakikoService.class.php");
require_once("class/db/dbaccess/ImiColorInfoJoinMasterTableAccess.class.php");
require_once("class/db/dbaccess/ImiColorInfoTableAccess.class.php");
require_once("class/db/dbaccess/ImiBaseInfoTableAccess.class.php");
require_once("class/db/dbaccess/ImiMemoPositionTableAccess.class.php");
require_once("class/db/dbaccess/MemoDetailJoinPositionJoinTypeTableAccess.class.php");
require_once("class/db/dbaccess/ImiMemoViewAccess.class.php");
require_once("class/db/dbaccess/ImiBaseInfoJoinUserTableAccess.class.php");
require_once("class/db/dbaccess/BaseMapJoinMapDetailTableAccess.class.php");
require_once("class/db/dbaccess/LayerTableAccess.class.php");
require_once("class/db/dbaccess/MapDetailTableAccess.class.php");

class ImiViewService extends KakikoService {

	/**
	 *	コンストラクタ
	 */
    function ImiViewService($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->KakikoService($directryname);
		// DB接続情報の設定
		$this->setDBConnectInfo();

    }

   /**
    * 関数名：色分け・カテゴリ情報取得
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    * @戻値：ImiColorInfoData[]
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getImiColorViewData($imiSpaceId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// 色情報テーブルDBアクセス
		$table_access = new ImiColorInfoJoinMasterTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->selectFindByKeyViewData($this->o_db, $imiSpaceId,null);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S6_001_01"), E_USER_ERROR);
			return false;
		}

		// データオブジェクトの取得
		$datalist = $table_access->getDataList();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $datalist;
	
	}

   /**
    * 関数名：カテゴリ名更新
    * @引数：(I) $colorInfoData 	- 色情報データクラス。配列も可
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @注意事項：引数の色情報データクラスは、複数同時更新の時は配列にすること
    *          ：NULLで更新する時は、「NULL_CHAR」を指定すること
    */
	function updateCategory($colorInfoData) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// 色情報テーブルDBアクセス
		$table_access = new ImiColorInfoTableAccess($this->directryname);
		// トランザクション開始
		$this->o_db->autoCommit(false);

		$targetImiColorInfoData = new ImiColorInfoData();
		$targetImiColorInfoData->setImiSpaceID(WHERE_KEY);
		$targetImiColorInfoData->setColorID(WHERE_KEY);
		$targetImiColorInfoData->setCategoryName(VAL_TARGET);
		$targetImiColorInfoData->setUpdateDatetime(VAL_TARGET);
	
		if (is_array($colorInfoData) == true){
			//データの件数だけ更新処理を行う			
			foreach($colorInfoData as $currentdata){
				$rtn = $table_access->updateByKeyData($this->o_db,$targetImiColorInfoData, $currentdata);
				if ($rtn != true) {
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S6_001_02"), E_USER_ERROR);
					return false;
				}
				//メモ更新削除警告表示フラグをおろす
				$rtn = $this->updateMemoDeleteFlgInit($currentdata->getImiSpaceID());
				if ($rtn != true) {
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S6_001_09"), E_USER_ERROR);
					return false;
				}
			}
		}else{
			//１件だけ更新処理を行う
			$rtn = $table_access->updateByKeyData($this->o_db,$targetImiColorInfoData, $colorInfoData);
			if ($rtn != true) {
					trigger_error($this->o_resource->getValue("S6_001_02"), E_USER_ERROR);
				$table_access->free();
				$this->disconnectDB();
				return false;
			}
			//メモ更新削除警告表示フラグをおろす
			$rtn = $this->updateMemoDeleteFlgInit($colorInfoData->getImiSpaceID());
			if ($rtn != true) {
				$table_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S6_001_09"), E_USER_ERROR);
				return false;
			}

		}
		
		
		// トランザクションコミット
		$this->o_db->commit();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();
				
		return true;
	}
	
   /**
    * 関数名：意味空間表示モードの取得
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    * @戻値：KAKIKOMAP_IMIVIEW_MAP:0	- 地図反映モード
	*      ：KAKIKOMAP_IMIVIEW_EDIT:1	- 空間編集モード    
	*      ：NULL						- データなし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getImiViewMode($imiSpaceId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// 意味空間基本情報テーブルDBアクセス
		$table_access = new ImiBaseInfoTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->selectFindByKeyData($this->o_db, $imiSpaceId);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S6_001_03"), E_USER_ERROR);
			return null;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}

		// データオブジェクトの取得
		$data = $table_access->getOneData();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data->getViewMode();
	
	}


   /**
    * 関数名：意味空間表示モードの更新
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    *      ：(I) $viewMode 		- 表示モード
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function updateImiViewMode($imiSpaceId, $viewMode) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// 意味空間基本情報テーブルDBアクセス
		$table_access = new ImiBaseInfoTableAccess($this->directryname);
		
		$targetImiBaseInfo = new ImiBaseInfoData();
		$valImiBaseInfo = new ImiBaseInfoData();
		$targetImiBaseInfo->setImiSpaceID(WHERE_KEY);
		$targetImiBaseInfo->setViewMode(VAL_TARGET);
		$valImiBaseInfo->setImiSpaceID($imiSpaceId);
		$valImiBaseInfo->setViewMode($viewMode);
				
		// クエリー発行
		$rtn =  $table_access->updateByKeyData($this->o_db, $targetImiBaseInfo, $valImiBaseInfo);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S6_001_04"), E_USER_ERROR);
			return false;
		}

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return true;
	}
	
   /**
    * 関数名：メモ色・座標一括更新
    * @引数：(I) $targetImiMemoPositionData 	- 意味メモ位置データ(対象列(条件列/更新列)指定用)
    *      ：(I) $valImiMemoPositionData[] 		- 意味メモ位置データ配列(設定値(条件値/更新値)指定用)
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
	* @注意事項：引数には更新対象として、ColorIdまたはCoordinateX,CoordinateYの何れかを最低限設定する。
    */
	function updateMemoColorAndPostion($targetImiMemoPositionData,$valImiMemoPositionData) {

		if (is_array($valImiMemoPositionData) == false){
			return false;
		}

		// DBオブジェクトの生成
		$this->createDBObject();

		// 意味空間メモ位置テーブルDBアクセス
		$table_access = new ImiMemoPositionTableAccess($this->directryname);

		// トランザクション開始
		$this->o_db->autoCommit(false);
		
		for ($i = 0; $i < count($valImiMemoPositionData); $i++){
			$rtn = $table_access->updateByKeyData($this->o_db, $targetImiMemoPositionData, $valImiMemoPositionData[$i]);
			if ($rtn != true) {
				$table_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S6_001_05"), E_USER_ERROR);
				return false;
			}
			//メモ更新削除警告表示フラグをおろす(1回だけ)
			if ($i == 0){
				$rtn = $this->updateMemoDeleteFlgInit($valImiMemoPositionData[$i]->getImiSpaceID());
				if ($rtn != true) {
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S6_001_09"), E_USER_ERROR);
					return false;
				}
			}
			
		}		
		
		
		// トランザクションコミット
		$this->o_db->commit();
		
		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();
		
		return true;
	}

   /**
    * 関数名：表示可能レイヤー・メモ種類データ取得(マップコントロール)
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    *      ：(I) $userId 		- ログインユーザID
    * @戻値：MemoDetailPositionTypeData[]/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
	* @注意事項：MemoDetailPositionTypeDataクラスに結果を格納しているが、全ての列を設定しているわけではなく
	*          ：必要部分だけ設定している。その列はselect処理で確認すること。
    */
	function getImiMapControllLayerMemotypeData($imiSpaceId,$userId) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// メモ種類レイヤーDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);
		// レイヤー状態フラグ（通常のみ）
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);
		
		//取得したレイヤー・メモからレイヤー閲覧情報取得ＳＱＬを作成し実行する
		$rtn = $table_access->selectImiMapControllLayerMemotypeData($this->o_db, $userId, $imiSpaceId, $status_array);	
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S6_001_06"), E_USER_ERROR);
			return false;
		}

		// データオブジェクトの取得
		$datalist = $table_access->getDataList();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $datalist;
	}
	
   /**
    * 関数名：表示可能メモデータ取得(右フレーム)
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    *      ：(I) $userId 		- ログインユーザID
    *        (I) $searchKey				-　検索条件
    *              $searchKey['limit']	- 最新取得件数
    *              $searchKey['from']	- 対象期間（from）
    *              $searchKey['to']		- 対象期間（to）
    *              $searchKey['word']	- 語句        
    * @戻値：imiMemoViewData[]/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
	* @注意事項：imiMemoViewDataクラスに結果を格納しているが、全ての列を設定しているわけではなく
	*          ：必要部分だけ設定している。その列はselect処理で確認すること。
    */
	function getImiMemoViewData($imiSpaceId,$userId,$searchKey) {
		// DBオブジェクトの生成
		$this->createDBObject();

		// メモ種類レイヤーDBアクセス
		$table_access = new ImiMemoViewAccess($this->directryname);
		// レイヤー状態フラグ（通常のみ）
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);
		
		//取得したレイヤー・メモからレイヤー閲覧情報取得ＳＱＬを作成し実行する
		$rtn = $table_access->selectImiMemoViewData($this->o_db, $userId, $imiSpaceId, $status_array,$searchKey);	
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S6_001_07"), E_USER_ERROR);
			return false;
		}

		// データオブジェクトの取得
		$datalist = $table_access->getDataList();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $datalist;
	
	}
   /**
    * 関数名：意味空間情報取得
    * @引数：(I) $imiSpaceId 	- 意味空間ID
    * @戻値：ImiBaseInfo_UserData
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getImiBaseInfoData($imiSpaceId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// 意味空間基本情報・ユーザテーブルDBアクセス
		$table_access = new ImiBaseInfoJoinUserTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->selectFindByKeyData($this->o_db, $imiSpaceId);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S6_001_08"), E_USER_ERROR);
			return null;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}

		// データオブジェクトの取得
		$data = $table_access->getOneData();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data;
	
	}
	
   /**
    * 関数名：マップ・マップ詳細情報取得
    * @引数：$mapnumber - マップ番号（null指定可）
    * @戻値：Map_MapDetailData	- マップ情報
    *      ：null			- データが存在しない場合
    *      ：false			- 異常終了
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @概要：マップテーブル・マップ詳細テーブルからディレクトリ名でデータを取得する
    */
    function getMapJoinMapDetailData($mapnumber){
		// DBオブジェクトの生成
		$this->createDBObject();
		// マップ・マップ詳細情報を取得
		$table_access = new BaseMapJoinMapDetailTableAccess();
		if (is_null($mapnumber) == true){
			$rtn = $table_access->selectMapLinkMapDetailListData($this->o_db, $this->directryname);
		}else{
			$rtn = $table_access->selectMapLinkMapDetailOneData($this->o_db, $this->directryname, $mapnumber);
		}

		if ($table_access->getRecordCount() == 0){
			return null;
		}
		if (is_null($mapnumber) == true){
			//mapnumberがないのであれば全データ
			$mapdata = $table_access->getDataList();	
		}else{
			//mapnumberが指定されていれば１データ
			$mapdata = $table_access->getOneData();
		}

		$table_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $mapdata;
    }
	
   /**
    * 関数名：意味空間用最優先表示レイヤー情報取得
    * @引数：(I) $userId 	- ユーザID
    *        (I) $imiSpaceId - 意味空間ID
    * @戻値：LayerTableData	- レイヤーデータ
    *      ：null			- データが存在しない場合
    *      ：false			- 異常終了
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @概要：ユーザごとの意味空間のレイヤー表示順を考慮して最上位のレイヤーを取得します。
    */
    function getImiTopPriorityLayerData($userId, $imiSpaceId){
		// DBオブジェクトの生成
		$this->createDBObject();
		
        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);
		
		// 最優先レイヤー情報を取得
		$table_access = new LayerTableAccess($this->directryname);
    	$rtn = $table_access->selectImiMapControllLayerList($this->o_db, $userId, $imiSpaceId, $status_array);
 		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S6_001_10"), E_USER_ERROR);
			return false;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}
		$layerdata = $table_access->getOneData();

		$table_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $layerdata;
    }
   /**
    * 関数名：マップ詳細情報初期表示用イメージ取得
    * @引数：(I) 
    * @戻値：マップ詳細データ /false
    * @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
    * @更新日/更新者：
    */
	function getMapDetailInitialImage() {
		// DBオブジェクトの生成
		$this->createDBObject();

		// マップ詳細情報を取得
		$map_access = new MapDetailTableAccess();
		$rtn = $map_access->selectFindBySelectInitialListData($this->o_db, $this->directryname);
		if ($rtn != true) {
			$map_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S6_001_11"), E_USER_ERROR);
			return false;
		}
		if ($map_access->getRecordCount() == 0){
			return null;
		}
		$mapdata = $map_access->getOneData();

		$map_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $mapdata;
	}    
    
	
//#################################################################################################
//                                        以下、サービス内使用関数定義
//#################################################################################################
   /**
    * 関数名：メモ更新/削除警告フラグおろし
    * @引数：(I) $imiSpaceId   	- 意味空間ID
    * @戻値：true/false
    * @作成日/作成者：2006/09/017 (IIS) N.Soma
    * @更新日/更新者：
    * @注意事項：DBのコネクト情報は、呼び出し元で確保しておきます。
    * @          基本情報の更新日は更新しません。
    */
	function updateMemoDeleteFlgInit($imiSpaceId) {

		// 意味空間基本情報テーブルDBアクセス
		$table_access = new ImiBaseInfoTableAccess($this->directryname);

		//更新必要かチェック
		$rtn =  $table_access->selectFindByKeyData($this->o_db, $imiSpaceId);		
		if ($rtn != true) {
			$table_access->free();
			trigger_error($this->o_resource->getValue("S6_001_09"), E_USER_ERROR);
			return false;
		}
		if ($table_access->getRecordCount() == 0){
			$table_access->free();
			return false;
		}
		$basedata = $table_access->getOneData();
		if ($basedata->getMemoDeleteWarnFlg() == KAKIKOMAP_IMIBASE_WARN_OFF){
			//すでにフラグがおりていれば何もしない
			$table_access->free();
			return true;
		}

		//フラグの更新		
		$targetImiBaseInfo = new ImiBaseInfoData();
		$valImiBaseInfo = new ImiBaseInfoData();
		$targetImiBaseInfo->setImiSpaceID(WHERE_KEY);
		$targetImiBaseInfo->setMemoDeleteWarnFlg(VAL_TARGET);
		$valImiBaseInfo->setImiSpaceID($imiSpaceId);
		$valImiBaseInfo->setMemoDeleteWarnFlg(KAKIKOMAP_IMIBASE_WARN_OFF);
				
		// クエリー発行
		$rtn =  $table_access->updateByKeyData($this->o_db, $targetImiBaseInfo, $valImiBaseInfo);
		if ($rtn != true) {
			$table_access->free();
			trigger_error($this->o_resource->getValue("S6_001_09"), E_USER_ERROR);
			return false;
		}
		return true;
	}
}
?>
