<?php
/**
* KakikoService.class.php 基本サービス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("class/db/KakikoDb.class.php");       // カキコまっぷDBクラス
require_once("class/xml/ReadResource.class.php");  // リソースファイル読込み
require_once("function/KakikoErrorHandler.php");   // エラートラップ
require_once("kakikomap/DBColumnDef.php");         // カキコまっぷ定数(DB)

class KakikoService {

	/**
	 *	クラス変数
	 */
	var $o_db;				// DBオブジェクト
	var $o_resource;		// リソースオブジェクト
	var $directryname;		// ディレクトリ名称
	var $dbhost;			// 接続先ホスト
	var $dbname;			// データベース名
	var $dbuser;			// ユーザ名
	var $dbpass;			// パスワード
	var $dbtype;			// 使用するデータベースの種類


    /**
     * コンストラクタ
     * @引数： (I) directryname  - string ディレクトリ名称
     */
    function KakikoService($directryname) {

		$this->o_db = null;
		$this->dbhost = null;
		$this->dbname = null;
		$this->dbuser = null;
		$this->dbpass = null;
		$this->dbtype = null;
		$this->directryname = $directryname;

		// リソースファイル読込みインスタンス
		$this->o_resource = new ReadResource(RESOURCE_SYSTEM);

    }

    /**
     * 関数概要：対象DB接続情報の設定
     * 処理詳細：ユーザの状態やユーザの種別によってDBに接続する
     *         ：接続情報を設定する
     *
     * @引数： 
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function setDBConnectInfo() {

		$filepath = "";

		// セッションスタート
		session_start();

		// セッションの中身をチェック
		if (isset($_SESSION["_userid"])) {
			// 管理系ログイン
			if (isset($_SESSION["_usertype"])) {
				if ($_SESSION["_usertype"] == 0) {
					// 対象ユーザはシステム管理者
					$filepath = "kakikomap/require/db/systemadmininfoRead.php";
				} elseif ($_SESSION["_usertype"] == 1) {
					// 対象ユーザはマップ管理者
					$filepath = "kakikomap/require/db/".$this->directryname."_mapadmininfoRead.php";
				}
			} else {
				// ユーザIDがセットされていてユーザ種別がないということはありえないと思う
				// failed to set db connect info occur system error
				trigger_error($this->o_resource->getValue("S0_001_01"), E_USER_ERROR);
			}
		} else {
			// フロント系ログイン
			if (isset($_SESSION[$this->directryname."_userid"])) {
				// セッションにユーザIDが存在する
				if (isset($_SESSION[$this->directryname."_usertype"])) {
					if ($_SESSION[$this->directryname."_usertype"] == 0) {
						// 対象ユーザはシステム管理者
						$filepath = "kakikomap/require/db/systemadmininfo.php";
					} elseif ($_SESSION[$this->directryname."_usertype"] == 1) {
						// 対象ユーザはマップ管理者
						$filepath = "kakikomap/require/db/".$this->directryname."_mapadmininfoRead.php";
					} else {
						// 対象ユーザは一般ユーザ
						$filepath = "kakikomap/require/db/".$this->directryname."_userinfoRead.php";
					}
				} else {
					// ユーザIDがセットされていてユーザ種別がないということは
					// ありえないと思うが、なった場合はゲスト状態
					$filepath = "kakikomap/require/db/".$this->directryname."_userinfoRead.php";
				}
			} else {
				// セッションにユーザIDが存在しない→ゲスト状態
				$filepath = "kakikomap/require/db/".$this->directryname."_userinfoRead.php";
			}
		}
//print "FILEPATH:".$filepath."<br>";
		require_once($filepath);

		$this->dbhost = DBHOST;
		$this->dbname = DBNAME;
		$this->dbuser = DBUSER;
		$this->dbpass = DBPASS;
		$this->dbtype = DBTYPE;

	}

    /**
     * 関数概要：DBオブジェクトインスタンスの生成
     * 処理詳細：KakikoDBのインスタンス生成を行う
     *
     * @引数： 
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function createDBObject() {

		if (!is_null($this->dbhost) && !is_null($this->dbhost) 
			&& !is_null($this->dbhost) && !is_null($this->dbhost) && !is_null($this->dbhost)) {

			// DBオブジェクトをインスタンス化
			$this->o_db = new KakikoDb($this->dbhost, $this->dbname, 
											$this->dbuser, $this->dbpass, $this->dbtype);				
		} else {
			// failed to not setDBConnectInfo
			trigger_error($this->o_resource->getValue("S0_002_01"), E_USER_ERROR);
		}	
	}

    /**
     * 関数概要：DBの切断
     * 処理詳細：DBの切断を行う、またクラス変数の解放を行う
     *
     * @引数： 
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function disconnectDB() {

		if (!is_null($this->o_db)) {
			// DB接続の切断
			$this->o_db->disconnect();
		}

		$this->o_db = null;			// DBオブジェクトの初期化(メモリ解放)はこれでいいのか？
		$this->o_resource = null;	// リソースオブジェクトの初期化(メモリ解放)はこれでいいのか？

	}
}

?>