<?php
require_once("class/db/service/ContentsViewService.class.php");
require_once("function/Common.php");
require_once("function/KakikoFile.php");

/**
* RSSController.class.php RSSファイルクラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
* 
* @メソッド一覧
*   RSSController()
* 	writeRssFile()
*   deleteRSSFile()
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
class RSSController {

	var $layerId;
	var $directoryName;
	var $contentsRoot;
	
	var $rssAdminRSSFileName;
	var $layerName;
	
	/**
	* 関数概要：コンストラクタ
	* 処理詳細：コンストラクタ
	* 
	* @引数： (I) $layerId	     - レイヤーID
	*  　　　 (I) $directoryName - ディレクトリ名
	* @戻値： なし
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/    
	function RSSController($layerId, $directoryName) {
    	$this->layerId = $layerId;
    	$this->directoryName = $directoryName;
    	$this->contentsRoot = 
    		getProtocol().$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF']);

		// RSSFileName and LayerName are acquired simultaneously.
		$service = new ContentsViewService($directoryName);
		$layerData = $service->getLayerAdminRSSFileName($layerId);
		$this->rssAdminRSSFileName = $layerData->getRssFileName();
		$this->layerName = $layerData->getLayerName();

    }

	/**
	* 関数概要：RSSファイルを出力する。
	* 処理詳細：レイヤー管理者用RSSとゲスト用RSSを出力する。
	* 　　　　　　※注）相対パス指定しています。カレントからrssフォルダを探し出力
	* @引数： なし
	* @戻値： true/false
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
	function writeRssFile(){
		// rss Directory
		$rssDirectory = "";
		$dirs = split(PATH_SEPARATOR, ini_get('include_path')); 
		foreach ($dirs as $dirpath) {
		    $fpath = $dirpath.DIRECTORY_SEPARATOR."kakikomap".DIRECTORY_SEPARATOR."rss".DIRECTORY_SEPARATOR.$this->getDirectoryName().DIRECTORY_SEPARATOR;
			if(is_dir($fpath)){
				$rssDirectory = $fpath;
				break;
			}
		}

		// outputRSSFile(admin)
		if(!$handle = fopen($rssDirectory.$this->getRssAdminRSSFileName().".rdf", "w")){
			return false;
		}
		if(!fwrite($handle, $this->createRSS(true, $this->getRssAdminRSSFileName().".rdf"))){
			return false;
		}
		fclose($handle);
		
		// outputRSSFile(guest)
		if(!$handle = fopen($rssDirectory.$this->getLayerid().".rdf", "w")){
			return false;
		}
		if(!fwrite($handle, $this->createRSS(false, $this->getLayerid().".rdf"))){
			return false;
		}
		fclose($handle);

		return true;
	}
	
	/**
	* 関数概要：RSSファイル削除。
	* 処理詳細：
	*
	* @引数： なし
	* @戻値： なし
	* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
	* @更新日/更新者：
	* @更新内容：
	*/
	function deleteRSSFile() {
		// rss Directory
		$rssDirectory = "";
		$dirs = split(PATH_SEPARATOR, ini_get('include_path')); 
		foreach ($dirs as $dirpath) {
		    $fpath = $dirpath.DIRECTORY_SEPARATOR."kakikomap".DIRECTORY_SEPARATOR."rss".DIRECTORY_SEPARATOR.$this->getDirectoryName().DIRECTORY_SEPARATOR;
			if(is_dir($fpath)){
				$rssDirectory = $fpath;
				break;
			}
		}

        // RSSFile(admin)
        if (file_exists($rssDirectory.$this->getRssAdminRSSFileName().".rdf")) {
            kakikoDelete($rssDirectory.$this->getRssAdminRSSFileName().".rdf");
        }

        // RSSFile(guest)
        if (file_exists($rssDirectory.$this->getLayerid().".rdf")) {
            kakikoDelete($rssDirectory.$this->getLayerid().".rdf");
        }

	}

	/**
	* 関数概要：RSSファイル内容生成
	* 処理詳細：RSSファイルへ出力する内容を生成します。
	*
	* @引数： (I) $authflag	   - ゲストユーザ制限
	*              　　　　　　　　（true:ゲストユーザのみ, false:制限なし）
	*  　　　 (I) $rssFileName - 出力するRSSファイル名(拡張子含む)
	* @戻値： RSSファイルへの出力内容
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
	function createRSS($authflag, $rssFileName){
		$outString = "";

		// getRSSData
		$service = new ContentsViewService($this->getDirectoryName());
		$dataArrayList = $service->getRSSData($this->getLayerid(), $authflag);
		
		// header
		$outString = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n"
					."<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
					."    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n"
					."    xmlns:sy=\"http://purl.org/rss/1.0/modules/syndication/\"\n"
					."    xmlns=\"http://purl.org/rss/1.0/\">\n";
		
		// channel
		$channel = "<channel rdf:about=\"".htmlspecialchars($this->getContentsRoot()."/rss/".$rssFileName)."\">\n"; 
		$channel = $channel."\t<title>".htmlspecialchars($this->getLayerName())."</title>\n";
		$channel = $channel."\t<link>".htmlspecialchars($this->getContentsRoot()."/")."</link>\n";
		$channel = $channel."\t<description>".htmlspecialchars($this->getLayerName())."のメモ・コメントRSS</description>\n";
		$channel = $channel."\t<dc:language>ja</dc:language>\n";
		$channel = $channel."\t<dc:date>".$this->formatW3CTime(time())."</dc:date>\n";
		$channel = $channel."\t<items>\n";
		$channel = $channel."\t\t<rdf:Seq>\n";

		foreach($dataArrayList as $dataObject){
			if($dataObject->getCommentID() == null){
				// memo
				$channel = $channel."\t\t\t<rdf:li rdf:resource=\"".htmlspecialchars($this->getContentsRoot()."/directmap.php?memoId=".$dataObject->getMemoID())."\"/>\n";
			}else{
				// comemnt
				$channel = $channel."\t\t\t<rdf:li rdf:resource=\"".htmlspecialchars($this->getContentsRoot()."/directmap.php?memoId=".$dataObject->getMemoID()."&commentId=".$dataObject->getCommentID())."\"/>\n";
			}
		}
		$channel = $channel."\t\t</rdf:Seq>\n";
		$channel = $channel."\t</items>\n";
		$channel = $channel."</channel>\n\n";
		
		$outString = $outString.$channel;

		// no Item
		if(count($dataArrayList) == 0){
			return 	 $outString."</rdf:RDF>";
		}

		// item
		$item = "";	
		foreach($dataArrayList as $dataObject){
			if($dataObject->getCommentID() == null){
				// memo
				$item = $item."<item rdf:about=\"".htmlspecialchars($this->getContentsRoot()."/directmap.php?memoId=".$dataObject->getMemoID())."\">\n";
				$item = $item."\t<title>".$dataObject->getMemoTitle()." by ".$dataObject->getUserName_d()."</title>\n";
				$item = $item."\t<link>".htmlspecialchars($this->getContentsRoot()."/directmap.php?memoId=".$dataObject->getMemoID())."</link>\n";
				$item = $item."\t<dc:date>".$this->formatW3CTime(strtotime($dataObject->getUpdateDateTime_d()))."</dc:date>\n";
				$item = $item."<description>";
				if($dataObject->getImageFile_d() != ""){
					$item = $item.htmlspecialchars("<table border=0 cellspacing=2>");
					$item = $item.htmlspecialchars("<tr>");
					$item = $item.htmlspecialchars("<td width=\"100\" align=\"center\">");
					$item = $item.htmlspecialchars("<a href=\"".$this->getContentsRoot()."/img/memo/".$dataObject->getImageFile_d()."\" target=\"_blank\">");
					$item = $item.htmlspecialchars("<img src=\"".$this->getContentsRoot()."/createthumbnail.php?type=s&imgpath=./img/memo/".$dataObject->getImageFile_d()."\" border=1/></a>");
					$item = $item.htmlspecialchars("</td>");
					$item = $item.htmlspecialchars("<td valign=\"top\" align=\"left\">");
					$item = $item.htmlspecialchars($dataObject->getMemoText());
					$item = $item.htmlspecialchars("</td>");
					$item = $item.htmlspecialchars("</tr>");
					$item = $item.htmlspecialchars("</table>");
				}else{
					$item = $item.htmlspecialchars($dataObject->getMemoText());
				}
				$item = $item."</description>\n";
	
				$item = $item."</item>\n";
			}else{
				// comment
				$item = $item."<item rdf:about=\"".htmlspecialchars($this->getContentsRoot()."/directmap.php?memoId=".$dataObject->getMemoID()."&commentId=".$dataObject->getCommentID())."\">\n";
				$item = $item."\t<title>".$dataObject->getCommentTitle()." by ".$dataObject->getUserName_c()."</title>\n";
				$item = $item."\t<link>".htmlspecialchars($this->getContentsRoot()."/directmap.php?memoId=".$dataObject->getMemoID()."&commentId=".$dataObject->getCommentID())."</link>\n";
				$item = $item."\t<dc:date>".$this->formatW3CTime(strtotime($dataObject->getUpdateDateTime_c()))."</dc:date>\n";
				$item = $item."<description>";
				if($dataObject->getImageFile_c() != ""){
					$item = $item.htmlspecialchars("<table border=0 cellspacing=2>");
					$item = $item.htmlspecialchars("<tr>");
					$item = $item.htmlspecialchars("<td width=\"100\" align=\"center\">");
					$item = $item.htmlspecialchars("<a href=\"".$this->getContentsRoot()."/img/memo/".$dataObject->getImageFile_c()."\" target=\"_blank\">");
					$item = $item.htmlspecialchars("<img src=\"".$this->getContentsRoot()."/createthumbnail.php?type=s&imgpath=./img/memo/".$dataObject->getImageFile_c()."\" border=1/></a>");
					$item = $item.htmlspecialchars("</td>");
					$item = $item.htmlspecialchars("<td valign=\"top\" align=\"left\">");
					$item = $item.htmlspecialchars($dataObject->getCommentText());
					$item = $item.htmlspecialchars("</td>");
					$item = $item.htmlspecialchars("</tr>");
					$item = $item.htmlspecialchars("</table>");
				}else{
					$item = $item.htmlspecialchars($dataObject->getCommentText());
				}
				$item = $item."</description>\n";
	
				$item = $item."</item>\n";
			}
		}
		$outString = $outString.$item;
		
		$outString = $outString."</rdf:RDF>";
		
		return $outString;
		
	}
	
	/**
	* 関数概要：タイムスタンプW3Cフォーマット
	* 処理詳細：タイムスタンプをW3Cフォーマットの日時へ変換する。
	*
	* @引数： (I) timestamp	- UNIXタイムスタンプ
	* @戻値： 日時文字列 ※(1997-07-16T19:20:30+01:00)形式
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
	function formatW3CTime($timestamp){
		return date("Y-m-d", $timestamp)
					."T"
					.date("H:i:s", $timestamp)
					.substr(date("O", $timestamp), 0, 3 ).":".substr(date("O", $timestamp), 3, 2 );
	}
	
	// Setter
	/**
	* 関数名：レイヤーID設定
	* @引数：(I) $layerId	- レイヤーID
	* @作成日/作成者：2006/09/01 S.Komukai
	* @更新日/更新者：
	*/
	function setLayerId($layerId){
		$this->layerId = $layerId;
	}

	/**
	* 関数名：ディレクトリ名設定
	* @引数：(I) $directoryName	- ディレクトリ名
	* @作成日/作成者：2006/09/01 S.Komukai
	* @更新日/更新者：
	*/
	function setDirectoryName($directoryName){
		$this->directoryName = $directoryName;
	}

	// No Setter
	// コンテンツルート
	// 管理者用RSSファイル名
	// レイヤー名称


	// Getter
	/**
	* 関数名：レイヤーID取得
	* @引数：なし
	* @作成日/作成者：2006/09/01 S.Komukai
	* @更新日/更新者：
	*/
	function getLayerId(){
		return $this->layerId;
	}
	
	/**
	* 関数名：ディレクトリ名取得
	* @引数：なし
	* @作成日/作成者：2006/09/01 S.Komukai
	* @更新日/更新者：
	*/
	function getDirectoryName(){
		return $this->directoryName;
	}
	
	/**
	* 関数名：コンテンツルート取得
	* @引数：なし
	* @作成日/作成者：2006/09/01 S.Komukai
	* @更新日/更新者：
	*/        
	function getContentsRoot(){
		return $this->contentsRoot;
	}
	
	/**
	* 関数名：管理者用RSSファイル名取得
	* @引数：なし
	* @作成日/作成者：2006/09/01 S.Komukai
	* @更新日/更新者：
	*/        
	function getRssAdminRSSFileName(){
		return $this->rssAdminRSSFileName;
	}		
		
	/**
	* 関数名：レイヤー名称取得
	* @引数：なし
	* @作成日/作成者：2006/09/01 S.Komukai
	* @更新日/更新者：
	*/        
	function getLayerName(){
		return $this->layerName;
	}
}
?>