<?php
/**
* KakikoCheckCallback.php 処理概要：コールバック用チェック機能
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 


/**
* 関数概要：文字列文字数チェック関数
* 処理詳細：渡された文字列の文字数をチェックする(最大長)
*
* @引数： 	(I) str		- string 	文字列
*			(I) length	- integer 	チェック文字数
* @戻値： bool 	: true	チェックOK
*				: false	チェックNG
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function check_maxlength_valid($str, $length) {
	if (mb_strlen($str) > $length) {
		return false;
	}
	return true;
}

/**
* 関数概要：文字列文字数チェック関数
* 処理詳細：渡された文字列の文字数をチェックする(最小長)
*
* @引数： 	(I) str		- string 	文字列
*			(I) length	- integer 	チェック文字数
* @戻値： bool 	: true	チェックOK
*				: false	チェックNG
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function check_minlength_valid($str, $length) {
	if (mbstrlen($str) < $length) {
		return false;
	}
	return true;
}

/**
* 関数概要：数値範囲チェック関数
* 処理詳細：渡された数値が指定された範囲であるかをチェックする
*
* @引数： 	(I) num		- integer 	数値
*			(I) sphere	- array 	チェック範囲
* @戻値： bool 	: true	チェックOK
*				: false	チェックNG
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function check_numeric_sphere_valid($num, $sphere) {
	if ($num < $sphere[0] || $num > $sphere[1]) {
		return false;
	}
	return true;
}

/**
* 関数概要：日付チェック関数
* 処理詳細：日付(Ymd)の妥当性をチェックする
*
* @引数：   (I) value   - array     入力された日付配列
* @戻値： bool 	: true  チェックOK
*               : false	チェックNG
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function check_date_valid($value){
    return checkdate($value['m'], $value['d'], $value['Y']);
}

/**
* 関数概要：同一メールアドレスチェック関数
* 処理詳細：渡された文字列が同一のメールアドレスであるかをチェックする
*
* @引数： 	(I) str1	- string 	文字列１
*			(I) str2	- string 	文字列２
* @戻値： bool 	: true	チェックOK(同一文字列)
*				: false	チェックNG
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function check_reqMailAddress_compare_valid($str1, $str2) {
	if (md5($str1) != $str2) {
		return false;
	}
	return true;
}

?>
