<?php
/**
* KakikoCommon.php 処理概要：セッション関連共通定義
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

session_start();

// 文字コード「UTF-8」を指定
header("Content-Type: text/html; charset=UTF-8");

require_once("function/Common.php");                       // カキコ共通関数
require_once("Pager/Pager.php");                           // PEAR Pager
require_once("Date.php");                                  // PEAR Date
require_once("HTML/QuickForm.php");                        // PEAR QuickForm
require_once("HTML/QuickForm/Renderer/ArraySmarty.php");   // PEAR ArraySmarty
require_once("class/common/KakikoSmarty.class.php");       // カキコまっぷSmartyクラス
require_once("class/common/KakikoTableName.class.php");    // マップ別テーブル名称取得クラス
//require_once("class/db/KakikoDb.class.php");               // カキコまっぷDBクラス
require_once("function/KakikoCheckCallback.php");          // チェックコールバック
require_once("function/KakikoErrorHandler.php");           // エラートラップ
require_once("kakikomap/DBColumnDef.php");                 // カキコまっぷ定数(DB)
require_once("kakikomap/require/common/adminRead.php");    // システム設定ファイル

/**
* 関数概要：HTMLエンティティ変換処理
* 処理詳細：引数のデータをHTMLエンティティ変換して返す
*           引数が配列の場合、配列内の全てのデータを変換する
*
* @引数： (I) data - object 変換対象
* @戻値： object : 変換後
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function htmlspecialchars_ex($data){
    if (is_array($data)==TRUE) {
        foreach ($data as $key => $value) {
            $data[$key] = htmlspecialchars_ex($value);
        }
        return $data;
    } else {
		if (is_object(unserialize($data))==TRUE) {
	        return $data;
		} else {
	        return htmlspecialchars($data);
        }
    }
}

// HTMLエンティティ変換を行う
//$_SESSION = htmlspecialchars_ex($_SESSION);
//$_POST = htmlspecialchars_ex($_POST);

/**
* 関数概要：ページアクセスチェック
* 処理詳細：各ページ毎にアクセスチェックを行い結果を返す
*
* @引数： (I) pagepath - string ページパス
* @戻値： bool  : true(正常) false(異常)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function access_check($pagepath){

    // 『userid』がセットされていない場合はログインページへリダイレクト
    if (empty($_SESSION['_userid'])) { 
        header("location: ../index.php"); 
    }

    // チェック状態(true:正常)
    $check_flg = true;
    // ファイル名を抽出
    $pagename = basename($pagepath, ".php");

    // ページ別にアクセスの状態チェックを行う
    switch ($pagename) {
        // -----------------------------
        // システム管理者メニュー
        // -----------------------------
        // システム管理者メニュー
        case "systemmenu":
        // マップ管理者一覧
        case "mapadminlist":
        // マップ管理者登録
        case "mapadminregist":
        // マップ管理者削除
        case "mapadmindel":
        // コンテンツ状態一覧
        case "contentsstatelist":
            $check_flg = ($_SESSION['_usertype'] != KAKIKOMAP_USERTYPE_SYSTEM) ? false : true;
            break;
        // -----------------------------
        // マップ管理者メニュー
        // -----------------------------
        // マップ管理者メニュー
        case "mapmenu":
        // マップ管理者情報設定
        case "mapadmininfoset":
        // コンテンツ環境設定
        case "contentsenvset":
        // ベースマップ設定
        case "basemapset":
        // レイヤー一覧
        case "layerlist":
        // レイヤー削除
        case "layerinfodel":
        // ユーザ一覧
        case "userlist":
        // ユーザ削除
        case "userdel":
            $check_flg = ($_SESSION['_usertype'] != KAKIKOMAP_USERTYPE_MAP) ? false : true;
            break;
    }

    return $check_flg;
}

?>
