<?php
/**
* KakikoContentsCommon.php 処理概要：セッション関連共通定義
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

session_start();

// 文字コード「UTF-8」を指定
header("Content-Type: text/html; charset=UTF-8");

require_once("function/Common.php");                       // カキコ共通関数
require_once("Pager/Pager.php");                           // PEAR Pager
require_once("Date.php");                                  // PEAR Date
require_once("HTML/QuickForm.php");                        // PEAR QuickForm
require_once("HTML/QuickForm/Renderer/ArraySmarty.php");   // PEAR ArraySmarty
require_once("class/common/KakikoSmarty.class.php");       // カキコまっぷSmartyクラス
require_once("class/common/KakikoTableName.class.php");    // マップ別テーブル名称取得クラス
//require_once("class/db/KakikoDb.class.php");               // カキコまっぷDBクラス
require_once("function/KakikoCheckCallback.php");          // チェックコールバック
require_once("function/KakikoErrorHandler.php");           // エラートラップ
require_once("kakikomap/DBColumnDef.php");                 // カキコまっぷ定数(DB)

/**
* 関数概要：ページアクセスチェック
* 処理詳細：各ページ毎にアクセスチェックを行い結果を返す
*
* @引数： (I) pagepath - string ページパス
* @戻値： bool  : true(正常) false(異常)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function access_check($pagepath){

    // ディレクトリ名が無い場合は無条件で異常とする
    if (!defined("DIRECTORY_NAME")) {
        return false;
    }

    // チェック状態(true:正常)
    $check_flg = true;
    // ファイル名を抽出
    $pagename = basename($pagepath, ".php");
    
    // マップ公開区分が非公開(9)の場合公開停止画面へリダイレクト
    if(MAP_PUBLIC == 9){
		if(substr(dirname($_SERVER['PHP_SELF']), -5) == "layer"){
			// "/"までカット
			header("location: ".substr_replace(dirname($_SERVER['PHP_SELF']), -6)."/mapclosed.html");
		}else{
			header("location: ".dirname($_SERVER['PHP_SELF'])."/mapclosed.html");
		}
		exit(-1);
    }

	// 自動ログイン状態のチェック
	if ($pagename != "userregistreqfix") {
		if (!isset($_SESSION['LOGINMODE'])) {
//		    header("location: ./index.php");
	        return false;
		}
	}

    // ページ別にアクセスの状態チェックを行う
    switch ($pagename) {
        // -----------------------------
        // レイヤー管理
        // -----------------------------
        // レイヤー一覧
        case "layerlist":
        // レイヤー登録
        case "layerregist":
            if (!isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                $check_flg = false;
            }
            break;
        // レイヤー設定
        case "layerset":
            if (!isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                $check_flg = false;
            } elseif (!isset($_POST['h_layerid'])) {
                $check_flg = false;
            }
            break;
        // レイヤー削除
        case "layerdel":
            if (!isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                $check_flg = false;
            } elseif (!isset($_POST['h_layerid']) && !isset($_POST['layerid'])) {
                $check_flg = false;
            }
            break;
        // レイヤーユーザ登録
        case "layeruserlist":
        // レイヤーメモ種類登録
        case "layermemotypelist":
            if (!isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                $check_flg = false;
            } elseif (!isset($_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'])) {
                $check_flg = false;
            }
            break;
        // ユーザ一覧
        case "userlist":
        // メモ種類一覧
        case "memotypelist":
            if (!isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                $check_flg = false;
            } elseif (!isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'])) {
                $check_flg = false;
            }
            break;
        // ユーザ登録
        case "userregist":
        // ユーザ削除
        case "userdel":
        // メモ種類登録
        case "memotyperegist":
        // メモ種類設定
        case "memotypeupd":
        // メモ種類削除
        case "memotypedel":
            if (!isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                $check_flg = false;
            } elseif (!isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']) && !isset($_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'])) {
                $check_flg = false;
            }
            break;
        // -----------------------------
        // レイヤー表示設定
        // -----------------------------
        // レイヤー表示設定
        case "layerindicateset":
            break;
        // レイヤー表示順設定
        case "layerindicateseqset":
            if (!isset($_SESSION[DIRECTORY_NAME.'_layerindicate'])) {
                $check_flg = false;
            } elseif (!isset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_left'])) {
                $check_flg = false;
            } elseif (!isset($_SESSION[DIRECTORY_NAME.'_layerindicateseq_right'])) {
                $check_flg = false;
            }
            break;
        // -----------------------------
        // レイヤー管理系以外
        // -----------------------------
    	default :
            if ($_SESSION['LOGINMODE'] == 1 && !isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                $check_flg = false;
            }
    }

    return $check_flg;
}

/**
* 関数概要：初期座標算出(GIS未使用のみ)
* 処理詳細：指定されたマップNO(スケール)で初期座標を算出する
*
* @引数： (I) mapAdminScale	 - int  デフォルト（マップ管理者指定）の表示マップNO
*         (I) mapDetailData  - マップ情報
* @戻値： array 座標情報
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getChangeInitialCoordinatesFromScaleNoGis($mapAdminScale, $mapDetailData){

	$returnArray = null;
	
	if(MAP_TYPE == 0){
		trigger_error("Call of illegal function!!", E_USER_ERROR);
	    exit(-1);
	}
	
	// 表示対象のマップで生成座標を算出する
	// 中心座標の算出
	$center_X = $mapDetailData->getStartX_BaseMap() + floor((($mapDetailData->getEndX_BaseMap() - $mapDetailData->getStartX_BaseMap()) / 2) * 1000000) / 1000000;
	$center_Y = $mapDetailData->getStartY_BaseMap() + floor((($mapDetailData->getEndY_BaseMap() - $mapDetailData->getStartY_BaseMap()) / 2) * 1000000) / 1000000;
	// スケール計算時に基準となるX方向の距離
    $DistanceX = $center_X - $mapDetailData->getStartX_BaseMap();
    // スケール計算時に基準となるY方向の距離
    $DistanceY = $center_Y - $mapDetailData->getStartY_BaseMap();	

	// １メートルあたりのピクセル数
	$pixpermer = $mapDetailData->getPixel_MapDetail();
	// 倍率１のときの距離算出（現在のスケールの１メートルあたりのピクセル数を使用）
	$kakikoPath = explode(",", KAKIKO_DIR_PATH);
	$kakikoPixcel = explode(",", KAKIKO_MOVE_PIXEL);
	$DistanceX = $DistanceX * $kakikoPixcel[array_search($mapAdminScale, $kakikoPath)];
	$DistanceY = $DistanceY * $kakikoPixcel[array_search($mapAdminScale, $kakikoPath)];

	// 初期座標
	$returnArray = array(
			$center_X - ($DistanceX / $mapDetailData->getPixel_MapDetail()),
			$center_Y - ($DistanceY / $mapDetailData->getPixel_MapDetail()),
			$center_X + ($DistanceX / $mapDetailData->getPixel_MapDetail()),
			$center_Y + ($DistanceY / $mapDetailData->getPixel_MapDetail())
		);

//print("中心X,Y " .$center_X.",".$center_Y."<BR><BR>");
//print("現在のX,Yから中心までの距離 " .$DistanceX.",".$DistanceY."<BR><BR>");
//print("変換後の１メートルあたりのピクセル数". $pixpermer."<BR><BR>");			
//print("現在の１メートルあたりのピクセル数".$kakikoPixcel[array_search($mapAdminScale, $kakikoPath)]."<BR><BR>");
//print("初期座標:<BR>");
//print_r($returnArray);
	
	return $returnArray;
}

?>
