<?php
/**
* KakikoLog.php 処理概要：カキコまっぷログ処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
* 
* @使用方法
* 	$LOG->emerg("Message");		// システム利用不可
* 	$LOG->alert("Message");		// 対応要
* 	$LOG->crit("Message");		// 致命的
* 	$LOG->err("Message");		// エラー
* 	$LOG->warning("Message");	// 警告
* 	$LOG->notice("Message");	// 注意
* 	$LOG->info("Message");		// 情報
* 	$LOG->debug("Message");		// デバッグ情報
* 
* 	※function中では「global  $LOG;」宣言を忘れずに！！
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/
require_once("Log.php");	// PEAR::Log
require_once("Archive/Tar.php");
require_once("kakikomap/require/common/logsettingRead.php");

/**
* 関数概要：カキコまっぷログインスタンスの初期化
* 処理詳細：ログのインスタンスを生成し、初期化します。
*
* @引数： なし
* @戻値： なし
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function &init() {

	// ログハンドラの指定
    $log_handler = strtolower(KAKIKOLOG_HANDLER);
    // ロギングされるリソースの名前（ファイル名、テーブル名、etc...）
    $log_path = KAKIKOLOG_NAME;
    // ログ識別子
    $log_ident = "Kakiko Map";
    // ロギングに際して必要なパラメータの指定。連想配列。(※現在未使用。$log_handlerに左右されることに注意。)
    $log_conf = array(
        "append"=>true,
		"mode"=>0644,
		"timeFormat"=>"%Y/%m/%d %H:%M:%S"
    );
    // ログレベルの設定
    $log_maxlevel = KAKIKOLOG_LEVEL;
    
    // インスタンスの作成
	switch($log_handler){
		case "console":		// コンソール
			// 未実装
//			$conf = array("timeFormat"=>"%Y/%m/%d %H:%M:%S");
//			$log=Log::factory($log_handler, "", $log_ident, $conf, $log_maxlevel);
			break;
		case "display":		// ディスプレイ
		    $log=Log::factory($log_handler, "", $log_ident, "", $log_maxlevel);
			break;
		case "error_log":	// エラーログ)
			// 未実装(文字コード対応必要)
//			$log=Log::factory($log_handler, PEAR_LOG_TYPE_SYSTEM, $log_ident, "", $log_maxlevel);
			break;
		case "file":		// ファイル
		    // ログファイル操作
		    logfileRecycle();
			// ファイル出力
			$conf = array("append"=>true,"mode"=>0644,"timeFormat"=>"%Y/%m/%d %H:%M:%S");
			$log=Log::factory($log_handler, $log_path, $log_ident, $conf, $log_maxlevel);
			break;
		case "mail":		// メール
			// 未実装
			break;
		case "sql":			// データベース出力
			// 未実装
			break;
		case "syslog":		// Syslog(Windows環境ではイベントビューアへ出力)
			// 未実装(文字コード対応必要)
//			$log=Log::factory($log_handler, LOG_LOCAL0, $log_ident, "", $log_maxlevel);
			break;
		
	}

    return $log;
}

/**
* 関数概要：カキコまっぷログファイル操作
* 処理詳細：ファイルへログを出力した場合のファイル操作を行う
*
*           ログファイルがファイルサイズを超えた場合に対象ファイルを圧縮し
*         保存日数分保有する。保存日数を超えた分は削除する。
*
*         ・ログファイル名 : KAKIKOLOG_NAME(INI設定).yyyymmddhhmm
*         ・圧縮ファイル名 : LOGyyyymmddhhmm.tgz
*
* @引数： なし
* @戻値： なし
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function logfileRecycle(){

    // -----------------------------------------------------------------
    //   ログファイルがファイルサイズを超えた場合に対象ファイルを圧縮し
    // 保存日数分保有する。保存日数を超えた分は削除する。
    //   ・ログファイル名 : KAKIKOLOG_NAME(上記設定値).yyyymmddhhmm
    //   ・圧縮ファイル名 : LOGyyyymmddhhmm.tgz
    // -----------------------------------------------------------------
    
    // ファイル出力時のみの処理
    if (KAKIKOLOG_HANDLER == "file") {

        // ディレクトリ名取得
        $dirpath = dirname(KAKIKOLOG_NAME);

        // ファイルの存在確認
        if (file_exists(KAKIKOLOG_NAME)) {
            // ファイルサイズを取得
            $fsize = sprintf("%u", filesize(KAKIKOLOG_NAME));
            // ファイルサイズが設定値を超えているか
            if ($fsize >= KAKIKOLOG_FILESIZE) {
                // リネーム処理("ファイル名.YYYYMMDD")
                $todate = date("YmdHi");
                rename(KAKIKOLOG_NAME, KAKIKOLOG_NAME.".".$todate);
                // リネーム処理したファイルを圧縮("logYYYYMMDD.tgz")
                $tar_object = new Archive_Tar($dirpath."/log".$todate.".tgz", true);
                $tar_object->setErrorHandling(PEAR_ERROR_PRINT);
                $v_list[0] = KAKIKOLOG_NAME.".".$todate;
                $tar_object->createModify($v_list, "", "");
                // 圧縮対象ファイルを削除
                unlink(KAKIKOLOG_NAME.".".$todate);
            }
        }
        
        // 対象ディレクトリのハンドル取得
        if ($dir = opendir($dirpath)) {
            // ディレクトリ内のファイル/フォルダを全て取得
            while ($file = readdir($dir)) {
                // 親フォルダ/自フォルダ以外を処理
                if ($file != "." && $file != "..") {
                    // ファイル/フォルダを判定
                    if (!is_dir($dirpath."/".$file)) {
                        // ファイル判定(先頭:log 末尾:.tgz)
                        if (substr(strtolower($file), 0, 3) == "log" && substr(strtolower($file), -4) == ".tgz") {
                            // ファイルタイムスタンプ取得
                            $filedatetime = date("Ymd", filemtime($dirpath."/".$file));
                            // 保存日数を超えていれば削除
                            if ($filedatetime < date("Ymd", mktime(0, 0, 0, date("m"), date("d") - KAKIKOLOG_SAVEDAY, date("Y")))) {
                                unlink($dirpath."/".$file);
                            }
                        }
                    }
                }
            }
            // ハンドル開放
            closedir($dir);
        }

    }
}

// Pear::Logインスタンスの作成
$LOG = &init();

?>